/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TargetNodeState;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlComponent;
import org.eclipse.ui.IWorkbenchPage;

public class RefreshHandler
extends BaseControlViewHandler {
    private TargetNodeComponent fNode;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fLock.lock();
        try {
            this.fNode.refresh();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TargetNodeComponent node = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                boolean isConnected;
                if (!(element instanceof TraceControlComponent)) continue;
                TraceControlComponent component = (TraceControlComponent)element;
                boolean bl = isConnected = component.getTargetNodeState() == TargetNodeState.CONNECTED;
                if (!isConnected) continue;
                while (component != null && component.getClass() != TargetNodeComponent.class) {
                    component = (TraceControlComponent)component.getParent();
                }
                if (component == null) continue;
                node = (TargetNodeComponent)component;
            }
        }
        boolean isEnabled = node != null;
        this.fLock.lock();
        try {
            this.fNode = null;
            if (isEnabled) {
                this.fNode = node;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

