/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.LinuxtoolsProcessFactory;

public class RuntimeProcessFactory
extends LinuxtoolsProcessFactory {
    private static RuntimeProcessFactory instance = null;
    private static final String WHICH_CMD = "which";

    private String[] tokenizeCommand(String command) {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            cmdarray[i] = tokenizer.nextToken();
            ++i;
        }
        return cmdarray;
    }

    private String[] fillPathCommand(String[] cmdarray, IProject project) throws IOException {
        cmdarray[0] = this.whichCommand(cmdarray[0], project);
        return cmdarray;
    }

    private String[] fillPathSudoCommand(String[] cmdarray, IProject project) throws IOException {
        cmdarray[1] = this.whichCommand(cmdarray[1], project);
        return cmdarray;
    }

    public String whichCommand(String command, IProject project) throws IOException {
        if (project != null) {
            String[] envp = this.updateEnvironment(null, project);
            try {
                IRemoteFileProxy proxy = RemoteProxyManager.getInstance().getFileProxy(project);
                URI whichUri = URI.create(WHICH_CMD);
                Path whichPath = new Path(proxy.toPath(whichUri));
                IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(project);
                Process pProxy = launcher.execute((IPath)whichPath, new String[]{command}, envp, null, (IProgressMonitor)new NullProgressMonitor());
                if (pProxy != null) {
                    BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(pProxy.getInputStream()));
                    String errorLine = error.readLine();
                    if (errorLine != null) {
                        throw new IOException(errorLine);
                    }
                    error.close();
                    String readLine = reader.readLine();
                    ArrayList<String> lines = new ArrayList<String>();
                    while (readLine != null) {
                        lines.add(readLine);
                        readLine = reader.readLine();
                    }
                    reader.close();
                    if (!lines.isEmpty()) {
                        if (project.getLocationURI() != null) {
                            if (project.getLocationURI().toString().startsWith("rse:")) {
                                if (lines.size() > 1) {
                                    command = (String)lines.get(lines.size() - 2);
                                }
                            } else {
                                command = (String)lines.get(0);
                            }
                        } else {
                            command = (String)lines.get(0);
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return command;
    }

    public static RuntimeProcessFactory getFactory() {
        if (instance == null) {
            instance = new RuntimeProcessFactory();
        }
        return instance;
    }

    public Process exec(String cmd, IProject project) throws IOException {
        return this.exec(cmd, null, null, project);
    }

    public Process exec(String[] cmdarray, IProject project) throws IOException {
        return this.exec(cmdarray, null, project);
    }

    public Process exec(String[] cmdarray, String[] envp, IProject project) throws IOException {
        return this.exec(cmdarray, envp, null, project);
    }

    public Process exec(String cmd, String[] envp, IProject project) throws IOException {
        return this.exec(cmd, envp, null, project);
    }

    public Process exec(String cmd, String[] envp, IFileStore dir, IProject project) throws IOException {
        return this.exec(this.tokenizeCommand(cmd), envp, dir, project);
    }

    public Process exec(String[] cmdarray, String[] envp, IFileStore dir, IProject project) throws IOException {
        Process p = null;
        try {
            IRemoteCommandLauncher launcher;
            Path path;
            cmdarray = this.fillPathCommand(cmdarray, project);
            String command = cmdarray[0];
            URI uri = URI.create(command);
            Path changeToDir = null;
            if (project != null) {
                IRemoteFileProxy proxy = RemoteProxyManager.getInstance().getFileProxy(project);
                path = new Path(proxy.toPath(uri));
                launcher = RemoteProxyManager.getInstance().getLauncher(project);
                envp = this.updateEnvironment(envp, project);
                if (dir != null) {
                    changeToDir = new Path(proxy.toPath(dir.toURI()));
                }
            } else {
                path = new Path(uri.getPath());
                launcher = RemoteProxyManager.getInstance().getLauncher(uri);
                if (dir != null) {
                    changeToDir = new Path(dir.toURI().getPath());
                }
            }
            ArrayList<String> cmdlist = new ArrayList<String>(Arrays.asList(cmdarray));
            cmdlist.remove(0);
            cmdlist.toArray(cmdarray);
            cmdarray = cmdlist.toArray(new String[0]);
            p = launcher.execute((IPath)path, cmdarray, envp, (IPath)changeToDir, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return p;
    }

    public Process sudoExec(String cmd, IProject project) throws IOException {
        return this.sudoExec(cmd, null, null, project);
    }

    public Process sudoExec(String cmd, String[] envp, IProject project) throws IOException {
        return this.exec(cmd, envp, null, project);
    }

    public Process sudoExec(String cmd, String[] envp, IFileStore dir, IProject project) throws IOException {
        return this.sudoExec(this.tokenizeCommand(cmd), envp, dir, project);
    }

    public Process sudoExec(String[] cmdarray, IProject project) throws IOException {
        return this.sudoExec(cmdarray, null, project);
    }

    public Process sudoExec(String[] cmdarray, String[] envp, IProject project) throws IOException {
        return this.sudoExec(cmdarray, envp, null, project);
    }

    public Process sudoExec(String[] cmdarray, String[] envp, IFileStore dir, IProject project) throws IOException {
        URI uri = URI.create("sudo");
        List<String> cmdList = Arrays.asList(cmdarray);
        ArrayList<String> cmdArrayList = new ArrayList<String>(cmdList);
        cmdArrayList.add(0, "-n");
        String[] cmdArraySudo = new String[cmdArrayList.size()];
        cmdArrayList.toArray(cmdArraySudo);
        Process p = null;
        try {
            IRemoteCommandLauncher launcher;
            Path path;
            cmdArraySudo = this.fillPathSudoCommand(cmdArraySudo, project);
            Path changeToDir = null;
            if (project != null) {
                IRemoteFileProxy proxy = RemoteProxyManager.getInstance().getFileProxy(project);
                path = new Path(proxy.toPath(uri));
                launcher = RemoteProxyManager.getInstance().getLauncher(project);
                envp = this.updateEnvironment(envp, project);
                if (dir != null) {
                    changeToDir = new Path(proxy.toPath(dir.toURI()));
                }
            } else {
                launcher = RemoteProxyManager.getInstance().getLauncher(uri);
                path = new Path(uri.getPath());
                if (dir != null) {
                    changeToDir = new Path(dir.toURI().getPath());
                }
            }
            ArrayList<String> cmdlist = new ArrayList<String>(Arrays.asList(cmdArraySudo));
            cmdlist.remove(0);
            cmdlist.toArray(cmdArraySudo);
            cmdArraySudo = cmdlist.toArray(new String[0]);
            p = launcher.execute((IPath)path, cmdArraySudo, envp, (IPath)changeToDir, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return p;
    }
}

