/*
 * Decompiled with CFR 0.152.
 */
package oca.ui.view;

import org.eclipse.core.resources.IMarker;

public class OcaProblemDetailsProvider {
    protected IMarker marker;

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    protected String getProblemMessage() {
        String message = String.valueOf(this.marker.getAttribute("message", "")) + "\n\n" + this.marker.getAttribute("OCA_EXTRA_INFO", "");
        return message;
    }

    protected String getProblemId() {
        String id = this.marker.getAttribute("OcaMarkerID", null);
        return id;
    }

    public boolean isApplicable(String id) {
        return id.compareTo("cdt.code.comments.ccMarker") == 0;
    }

    public String getStyledProblemMessage() {
        String message = this.escapeForLink(this.getProblemMessage());
        String href = this.getLocationHRef();
        String link = this.getLocation();
        return "<a href=\"" + href + "\">" + link + "</a> \n" + message + "\n";
    }

    protected String getLocationHRef() {
        return this.getLocationHRef(this.marker);
    }

    protected String getLocationHRef(IMarker marker) {
        String loc = marker.getResource().getLocationURI().toString();
        String loc2 = marker.getAttribute("location", "");
        int line = marker.getAttribute("lineNumber", 0);
        if (loc2.length() > 0) {
            loc = "file:" + loc2.replaceAll("[^:]*: ", "");
        }
        String href = String.valueOf(loc) + "#" + line;
        return href;
    }

    protected String getLocation() {
        return this.getLocation(this.marker);
    }

    protected String getLocation(IMarker marker) {
        String loc = marker.getResource().getFullPath().toPortableString();
        String loc2 = marker.getAttribute("location", "");
        int line = marker.getAttribute("lineNumber", 0);
        if (loc2.length() > 0) {
            loc = loc2.replaceAll("[^:]*: ", "");
        }
        return String.valueOf(loc) + ":" + line;
    }

    public String getStyledProblemDescription() {
        String id = this.getProblemId();
        if (id == null) {
            return "";
        }
        String sFix = this.getMarker().getAttribute("OcaMarkerAdviceFix", null);
        if (sFix == null) {
            return "";
        }
        String sAdvice = "Suggested fix:\n" + sFix;
        return this.escapeForLink(sAdvice);
    }

    protected String escapeForLink(String text) {
        return text.replaceAll("&", "&&");
    }

    protected String getLinkMessage() {
        String message = this.marker.getAttribute("ADD_INFO_LINK", "");
        return message;
    }

    public String getAdditionalInfoLinkMessage() {
        String url = this.escapeForLink(this.getLinkMessage());
        if (!url.isEmpty()) {
            return "For additional information refer to <a href=\"" + url + "\">" + url + "</a>.";
        }
        return url;
    }
}

