/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTAmbiguousStatement
extends ASTAmbiguousNode
implements IASTAmbiguousStatement {
    private IASTStatement[] stmts = new IASTStatement[2];
    private int stmtsPos = -1;
    private IScope fScope;
    private IASTDeclaration fDeclaration;

    public CPPASTAmbiguousStatement(IASTStatement ... statements) {
        IASTStatement[] iASTStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement s = iASTStatementArray[n2];
            this.addStatement(s);
            ++n2;
        }
    }

    @Override
    protected void beforeResolution() {
        this.fScope = CPPVisitor.getContainingScope(this);
        if (this.fScope instanceof ICPPASTInternalScope) {
            ((ICPPASTInternalScope)this.fScope).populateCache();
        }
    }

    @Override
    protected void beforeAlternative(IASTNode alternative) {
        this.cleanupScope();
        if (alternative instanceof IASTDeclarationStatement && this.fScope instanceof ICPPASTInternalScope) {
            this.fDeclaration = ((IASTDeclarationStatement)alternative).getDeclaration();
            CPPSemantics.populateCache((ICPPASTInternalScope)this.fScope, this.fDeclaration);
        }
    }

    private void cleanupScope() {
        if (this.fScope instanceof ICPPASTInternalScope && this.fDeclaration != null) {
            ((ICPPASTInternalScope)this.fScope).removeNestedFromCache(this.fDeclaration);
        }
    }

    @Override
    protected void afterResolution(ASTVisitor resolver, IASTNode best) {
        this.beforeAlternative(best);
        this.fDeclaration = null;
        this.fScope = null;
    }

    @Override
    public IASTStatement copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTStatement copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addStatement(IASTStatement s) {
        this.assertNotFrozen();
        if (s != null) {
            this.stmts = ArrayUtil.appendAt(IASTStatement.class, this.stmts, ++this.stmtsPos, s);
            s.setParent(this);
            s.setPropertyInParent(STATEMENT);
        }
    }

    @Override
    public IASTStatement[] getStatements() {
        this.stmts = ArrayUtil.trimAt(IASTStatement.class, this.stmts, this.stmtsPos);
        return this.stmts;
    }

    @Override
    public IASTNode[] getNodes() {
        return this.getStatements();
    }

    @Override
    public IASTAttribute[] getAttributes() {
        return IASTAttribute.EMPTY_ATTRIBUTE_ARRAY;
    }

    @Override
    public void addAttribute(IASTAttribute attribute) {
        throw new UnsupportedOperationException();
    }
}

