/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalTypeId
extends CPPDependentEvaluation {
    private final IType fInputType;
    private final ICPPEvaluation[] fArguments;
    private IType fOutputType;

    public EvalTypeId(IType type, IASTNode pointOfDefinition, ICPPEvaluation ... arguments) {
        this(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), arguments);
    }

    public EvalTypeId(IType type, IBinding templateDefinition, ICPPEvaluation ... arguments) {
        super(templateDefinition);
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        this.fInputType = type;
        this.fArguments = arguments;
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType;
    }

    private IType computeType() {
        if (CPPTemplates.isDependentType(this.fInputType)) {
            return new TypeOfDependentExpression(this);
        }
        return ExpressionTypes.typeFromReturnType(this.fInputType);
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        if (this.isTypeDependent()) {
            return Value.create(this);
        }
        if (this.fOutputType instanceof ICPPClassType) {
            return Value.UNKNOWN;
        }
        if (this.fArguments.length == 1) {
            return this.fArguments[0].getValue(point);
        }
        return Value.UNKNOWN;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType instanceof TypeOfDependentExpression;
    }

    @Override
    public boolean isValueDependent() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return ExpressionTypes.valueCategoryFromReturnType(this.fInputType);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 14;
        if (includeValue) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fInputType);
        if (includeValue) {
            buffer.putInt(this.fArguments.length);
            ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
            int n = this.fArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPEvaluation arg = iCPPEvaluationArray[n2];
                buffer.marshalEvaluation(arg, includeValue);
                ++n2;
            }
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType type = buffer.unmarshalType();
        ICPPEvaluation[] args = null;
        if ((firstBytes & 0x20) != 0) {
            int len = buffer.getInt();
            args = new ICPPEvaluation[len];
            int i = 0;
            while (i < args.length) {
                args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
                ++i;
            }
        } else {
            args = ICPPEvaluation.EMPTY_ARRAY;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalTypeId(type, templateDefinition, args);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = EvalTypeId.instantiateCommaSeparatedSubexpressions(this.fArguments, tpMap, packOffset, within, maxdepth, point);
        IType type = CPPTemplates.instantiateType(this.fInputType, tpMap, packOffset, within, point);
        if (args == this.fArguments && type == this.fInputType) {
            return this;
        }
        return new EvalTypeId(type, this.getTemplateDefinition(), args);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(parameterMap, maxdepth, point);
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalTypeId(this.fInputType, this.getTemplateDefinition(), args);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = CPPTemplates.determinePackSize(this.fInputType, tpMap);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

