/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view.histogram;

import java.util.LinkedList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gprof.symbolManager.CallGraphArc;
import org.eclipse.linuxtools.internal.gprof.view.histogram.AbstractTreeElement;
import org.eclipse.linuxtools.internal.gprof.view.histogram.CGCategory;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;

public class CGArc
extends AbstractTreeElement {
    public final CallGraphArc arc;

    public CGArc(CGCategory cat, CallGraphArc arc) {
        super(cat);
        this.arc = arc;
    }

    @Override
    public LinkedList<? extends TreeElement> getChildren() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public int getCalls() {
        return this.arc.getCount();
    }

    @Override
    public int getSamples() {
        TreeElement o = this.getParent();
        CGCategory category = (CGCategory)o;
        IBinaryParser.ISymbol symbol = "children".equals(category.category) ? this.arc.child.getSymbol() : this.arc.parent.getSymbol();
        return HistFunction.getSamples(symbol);
    }

    public String getFunctionName() {
        TreeElement o = this.getParent();
        CGCategory category = (CGCategory)o;
        IBinaryParser.ISymbol symbol = "children".equals(category.category) ? this.arc.child.getSymbol() : this.arc.parent.getSymbol();
        String functionName = STSymbolManager.sharedInstance.demangle(symbol, this.arc.getProject());
        return functionName;
    }

    @Override
    public String getName() {
        String functionName = this.getFunctionName();
        Path p = new Path(this.getSourcePath());
        return String.valueOf(functionName) + " (" + p.lastSegment() + ":" + this.getSourceLine() + ")";
    }

    @Override
    public int getSourceLine() {
        TreeElement o = this.getParent();
        CGCategory category = (CGCategory)o;
        if ("children".equals(category.category)) {
            IBinaryParser.ISymbol symbol = this.arc.child.getSymbol();
            return STSymbolManager.sharedInstance.getLineNumber(symbol, this.arc.getProject());
        }
        return this.arc.parentLine;
    }

    @Override
    public String getSourcePath() {
        TreeElement o = this.getParent();
        CGCategory category = (CGCategory)o;
        if ("children".equals(category.category)) {
            IBinaryParser.ISymbol symbol = this.arc.child.getSymbol();
            String fileName = ((HistRoot)this.getRoot()).decoder.getFileName(symbol);
            return fileName;
        }
        if (this.arc.parentPath == null) {
            return "??";
        }
        return this.arc.parentPath;
    }
}

