/*
 * Decompiled with CFR 0.152.
 */
package cdt.code.comments.core;

import cdt.code.comments.core.ConditionResult;
import cdt.code.comments.core.ConstExpression;
import cdt.code.comments.core.Examples;
import cdt.code.comments.core.FunctionDefinitionCollector;
import cdt.code.comments.core.LineNumber;
import cdt.code.comments.core.MarkerInfoConstants;
import cdt.code.comments.handlers.SampleHandler;
import cdt.code.comments.visitors.CommentsVisitor;
import cdt.code.comments.visitors.RawASTVisitor;
import cpd.checkers.core.CheckDependenciesVisitor;
import cpd.checkers.core.CheckExpressions;
import cpd.checkers.core.CheckForVisitor;
import cpd.checkers.core.CheckFuncCall;
import cpd.checkers.core.CheckInitArray;
import cpd.checkers.core.CheckLoopDistribution;
import cpd.checkers.core.CheckLoopExit;
import cpd.checkers.core.CheckPeeling;
import cpd.checkers.core.CheckReductionClause;
import cpd.checkers.core.CheckScalarExpansion;
import cpd.checkers.core.ScalarParallelization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oca.coca.core.AnalysisReporter;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class CommentsFactory {
    private static int NUM_OF_ELL_IN_STRU = 16;
    public static String markerID = "cdt.code.comments.ccMarker";
    private final ITranslationUnit tu;
    private final CommentsVisitor visitor;
    private final Map<Integer, String> pwr2;

    private static String getKey(Map<Integer, String> map, String value) {
        for (int key : map.keySet()) {
            if (!map.get(key).equals(value)) continue;
            return "" + key;
        }
        return "No value found";
    }

    public CommentsFactory(ITranslationUnit tu, boolean verbose, ArrayList<IASTFunctionDefinition> globalFuncDefs, boolean getInfo, boolean[] commands) throws CoreException, InterruptedException, DOMException {
        this.tu = tu;
        this.visitor = new CommentsVisitor();
        this.pwr2 = new HashMap<Integer, String>();
        this.initializePwr2();
        IIndex tmpIndex = CCorePlugin.getIndexManager().getIndex(this.tu.getCProject());
        tmpIndex.acquireReadLock();
        IASTTranslationUnit tmpAST = tu.getAST(tmpIndex, 6);
        tmpIndex.releaseReadLock();
        tmpAST.accept((ASTVisitor)this.visitor);
        RawASTVisitor x = null;
        x = new RawASTVisitor();
        tmpAST.accept((ASTVisitor)x);
        List<IASTForStatement> tmpForStmnts = this.visitor.getForStatements();
        List<IASTFunctionDefinition> tmpFuncDefs = this.visitor.getFunctionDefinitions();
        List<IASTFunctionCallExpression> tmpFuncCalls = this.visitor.getFunctionCalls();
        List<IASTBinaryExpression> tmpBinaryExpression = x.getBinaryExps();
        List<IASTName> assignOperands = x.getAssignmentOperands();
        List<IASTExpression> lockList = x.getLockList();
        if (getInfo) {
            globalFuncDefs.addAll(tmpFuncDefs);
        }
        if (!getInfo) {
            if (commands[SampleHandler.OcaCommand.COMMAND_FUNCTION_SPECIALIZATION.getCommandValue()]) {
                this.generateFunctionSpecialization_TrueFalseCheck(tmpFuncCalls, tmpFuncDefs, assignOperands, tmpBinaryExpression, globalFuncDefs);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_IMPLICIT_CASTING.getCommandValue()]) {
                this.generateImplicitCastComments(tmpFuncDefs, tmpIndex, tmpAST);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_REDUCTION_CLAUSE.getCommandValue()]) {
                this.generateReductionClauseComment(tmpAST);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_LOOP_DISTRIBUTION.getCommandValue()]) {
                this.generateLoopDestributionComment(tmpAST);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_LOOP_PEELING.getCommandValue()]) {
                this.generateLoopPeelingComment(tmpAST);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_DEAD_CODE_ELIMINATION.getCommandValue()]) {
                this.generateDeadCodeElimComment(tmpFuncDefs);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_SIMPLE_PARALLELIZABLE_LOOP.getCommandValue()]) {
                this.generateSimpleParallelzableComment(tmpAST);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_ALGEBRIC_SIMPLIFICATION.getCommandValue()]) {
                this.generateAlgebricSimpComment(x.getBinaryExps());
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_CONSTANT_PROPAGATION.getCommandValue()]) {
                this.generateConstantPropagationComment(x.getAssignmentOperands(), x.getExpsToAssign());
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_CALL_BY_VALUE.getCommandValue()]) {
                this.generateByValueComments(tmpFuncDefs);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_STRUCT_SPLITTING_REORDER.getCommandValue()]) {
                this.generateStructSplittingReorderComment(x.getStructSpecifiers());
            }
            if (commands[SampleHandler.OcaCommand.COMMNAD_LOOP_INVARIANT_CODE.getCommandValue()]) {
                this.generateForCodeInvariantComments(tmpForStmnts);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_COPY_PROPAGATION.getCommandValue()]) {
                this.generateCopyPropagationComment(x.getAssignmentOperands(), x.getExpsToAssign());
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_STRENGTH_REDUCTION.getCommandValue()]) {
                this.generateStrengthReducComment(x.getBinaryExps());
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_CLASS_INLINING.getCommandValue()]) {
                this.generateClassInliningComment(x.getClassSpecifiers());
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_DEPENDENCY_FREE.getCommandValue()]) {
                this.generateDependencyFreeComment(tmpAST);
            }
            if (commands[SampleHandler.OcaCommand.COMMAND_LOCK_INVARIANT.getCommandValue()]) {
                this.generateLockInvariantComments(lockList);
            }
            boolean cfr_ignored_0 = commands[SampleHandler.OcaCommand.COMMAND_WHILE_LOOP_PARALLELIZATION.getCommandValue()];
            if (commands[SampleHandler.OcaCommand.COMMAND_RUN_ALL_PARALLELIZATION_OPTIMIZATIONS.getCommandValue()]) {
                this.generateAllParallelizationComment(tmpAST);
            }
        }
    }

    private void generateFunctionSpecialization_TrueFalseCheck(List<IASTFunctionCallExpression> tmpFuncCalls, List<IASTFunctionDefinition> tmpFuncDefs, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression, ArrayList<IASTFunctionDefinition> globalFuncDefs) throws CoreException, DOMException {
        Vector<String> nonNumberParams = new Vector<String>();
        int i = 0;
        int count = 0;
        String commentInfo = "";
        String functionName = null;
        IASTFunctionCallExpression the_call = null;
        CPPASTFunctionDefinition theFunction = null;
        CASTFunctionDefinition theFunctionC = null;
        IASTDeclaration[] search = null;
        boolean C_lang = false;
        int len = 0;
        boolean on = false;
        boolean breakIT = false;
        for (IASTFunctionCallExpression tmpFunc : tmpFuncCalls) {
            FunctionDefinitionCollector fdc;
            CPPFunction cf;
            if (this.checkIfSystem(tmpFunc.getFunctionNameExpression().getRawSignature())) continue;
            String correctInfo = tmpFunc.getFunctionNameExpression().getRawSignature();
            IASTInitializerClause[] numOfParameters = tmpFunc.getArguments();
            String sQuickFix = "";
            i = 0;
            count = 1;
            int j = 0;
            i = 0;
            while (i < numOfParameters.length) {
                if (numOfParameters[i] instanceof IASTLiteralExpression) {
                    boolean bContinueLoop = false;
                    switch (((IASTLiteralExpression)numOfParameters[i]).getKind()) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            break;
                        }
                        case 3: {
                            bContinueLoop = true;
                        }
                    }
                    if (!bContinueLoop) {
                        j = i + 1;
                        sQuickFix = String.valueOf(sQuickFix) + "(" + count + ")" + " All occurences of \"Param" + j + "\" inside " + tmpFunc.getFunctionNameExpression().getRawSignature() + " should be replaced by " + numOfParameters[i].toString() + "\n";
                        sQuickFix = String.valueOf(sQuickFix) + "(" + ++count + ")" + " Remove \"Param" + j + "\" from " + "'" + tmpFunc.getFunctionNameExpression().getRawSignature() + "'" + " declaration.\n";
                        ++count;
                        correctInfo = String.valueOf(correctInfo) + "_P" + (i + 1) + "_" + numOfParameters[i].toString();
                    }
                } else {
                    nonNumberParams.add(numOfParameters[i].getRawSignature());
                }
                ++i;
            }
            if (1 == count) {
                commentInfo = "";
                correctInfo = "";
                nonNumberParams.clear();
                breakIT = true;
            }
            if (!breakIT) {
                commentInfo = String.valueOf(commentInfo) + "Function Specialization for a call with constant parameters.\nConsider creating a new specialized version for function '" + tmpFunc.getFunctionNameExpression().getRawSignature() + "' " + "to be named:" + " '" + correctInfo + "'\n" + "where some of its parameters are replaced by their constant values within the specialized function body.\n" + "Then, replace this call by a call to the specialized version but without the constant parameters.\n" + "\nSee proposed changes to the specialized function version:\n" + sQuickFix;
            }
            breakIT = false;
            the_call = tmpFunc;
            IASTExpression f = tmpFunc.getFunctionNameExpression();
            IASTInitializerClause[] arguments = tmpFunc.getArguments();
            if (f instanceof CPPASTFieldReference) {
                IASTIdExpression owner;
                functionName = ((CPPASTFieldReference)f).getFieldName().getRawSignature();
                IASTFieldReference fREF = (IASTFieldReference)tmpFunc.getFunctionNameExpression();
                if (!(fREF.getFieldOwner() instanceof IASTIdExpression) || !((owner = (IASTIdExpression)fREF.getFieldOwner()).getName().getBinding() instanceof IVariable) || !(((IVariable)owner.getName().getBinding()).getType() instanceof CPPClassType)) continue;
                search = ((CPPASTCompositeTypeSpecifier)((IASTName)((CPPClassType)((IVariable)owner.getName().getBinding()).getType()).getDefinition()).getParent()).getDeclarations(true);
                len = search.length;
                int index = 0;
                while (index < len) {
                    CPPASTFunctionDefinition func;
                    if (search[index] instanceof CPPASTFunctionDefinition && (func = (CPPASTFunctionDefinition)search[index]).getDeclarator().getName().getRawSignature().equals(functionName)) {
                        theFunction = func;
                        break;
                    }
                    ++index;
                }
            } else if (f instanceof CPPASTIdExpression) {
                cf = null;
                if (((CPPASTIdExpression)f).getName() instanceof CPPASTQualifiedName) {
                    IASTName[] arr1;
                    IASTName[] iASTNameArray = arr1 = ((CPPASTQualifiedName)((CPPASTIdExpression)f).getName()).getNames();
                    int n = arr1.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTName a = iASTNameArray[n2];
                        if (a.getBinding() instanceof CPPMethod && ((CPPMethod)a.getBinding()).getDefinition() != null && ((CPPMethod)a.getBinding()).getDefinition().getParent() instanceof CPPASTFunctionDefinition) {
                            theFunction = (CPPASTFunctionDefinition)((CPPMethod)a.getBinding()).getDefinition().getParent();
                            break;
                        }
                        ++n2;
                    }
                } else if (((CPPASTIdExpression)f).getName().getBinding() instanceof CPPFunction) {
                    cf = (CPPFunction)((CPPASTIdExpression)f).getName().getBinding();
                    if (cf != null && cf.getDefinition() != null) {
                        theFunction = (CPPASTFunctionDefinition)((CPPASTFunctionDeclarator)((CPPFunction)((CPPASTIdExpression)f).getName().getBinding()).getDefinition()).getParent();
                    } else {
                        fdc = this.searchForDefinition(the_call, globalFuncDefs);
                        if (fdc.get_c_lang()) {
                            theFunctionC = fdc.get_FuncC();
                        } else {
                            theFunction = fdc.get_Func();
                        }
                        if (theFunction == null && theFunctionC == null) {
                            continue;
                        }
                    }
                } else {
                    fdc = this.searchForDefinition(the_call, globalFuncDefs);
                    if (fdc.get_c_lang()) {
                        theFunctionC = fdc.get_FuncC();
                    } else {
                        theFunction = fdc.get_Func();
                    }
                    if (theFunction == null && theFunctionC == null) {
                        continue;
                    }
                }
            } else if (f instanceof CASTIdExpression) {
                C_lang = true;
                if (((CASTName)((CASTIdExpression)f).getName()).getBinding() instanceof CFunction) {
                    cf = (CFunction)((CASTName)((CASTIdExpression)f).getName()).getBinding();
                    if (cf.getDefinition() != null) {
                        if (cf.getDefinition() instanceof CASTKnRFunctionDeclarator) {
                            theFunctionC = (CASTFunctionDefinition)((CASTKnRFunctionDeclarator)cf.getDefinition()).getParent();
                        } else if (cf.getDefinition() instanceof CASTFunctionDeclarator) {
                            theFunctionC = (CASTFunctionDefinition)((CASTFunctionDeclarator)cf.getDefinition()).getParent();
                        }
                    } else {
                        fdc = this.searchForDefinition(the_call, globalFuncDefs);
                        if (fdc.get_c_lang()) {
                            theFunctionC = fdc.get_FuncC();
                        } else {
                            theFunction = fdc.get_Func();
                        }
                        if (theFunction == null && theFunctionC == null) {
                            continue;
                        }
                    }
                } else {
                    FunctionDefinitionCollector fdc2 = this.searchForDefinition(the_call, globalFuncDefs);
                    if (fdc2.get_c_lang()) {
                        theFunctionC = fdc2.get_FuncC();
                    } else {
                        theFunction = fdc2.get_Func();
                    }
                    if (theFunction == null && theFunctionC == null) continue;
                }
            }
            ArrayList<ConstExpression> Global_variables = new ArrayList<ConstExpression>();
            ArrayList<ConstExpression> ConstVariablesScope = new ArrayList<ConstExpression>();
            if (!C_lang && theFunction != null) {
                if (!on) {
                    on = true;
                    this.collectGlobalVariables(Global_variables, (IASTFunctionDefinition)theFunction);
                }
                this.collectConstVariableScope(ConstVariablesScope, the_call);
            } else if (C_lang && theFunctionC != null) {
                if (!on) {
                    on = true;
                    this.collectGlobalVariables(Global_variables, (IASTFunctionDefinition)theFunctionC);
                }
                this.collectConstVariableScope(ConstVariablesScope, the_call);
            }
            try {
                if (theFunctionC != null || theFunction != null) {
                    if (ConstVariablesScope.size() != 0) {
                        block10: for (ConstExpression v : ConstVariablesScope) {
                            String name = v.get_name();
                            IASTInitializerClause[] iASTInitializerClauseArray = arguments;
                            int n = arguments.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IASTInitializerClause arg = iASTInitializerClauseArray[n3];
                                if (arg instanceof IASTIdExpression && ((IASTIdExpression)arg).getName().toString().equals(name)) {
                                    arg = v.get_value();
                                    continue block10;
                                }
                                ++n3;
                            }
                        }
                    }
                    this.CheckAndMark(theFunction, theFunctionC, arguments, the_call, commentInfo, C_lang, Global_variables, ConstVariablesScope, assignOperands, tmpBinaryExpression);
                }
                theFunctionC = null;
                theFunction = null;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            commentInfo = "";
        }
    }

    private FunctionDefinitionCollector searchForDefinition(IASTFunctionCallExpression the_call, ArrayList<IASTFunctionDefinition> globalFuncDefs) {
        FunctionDefinitionCollector fdc = new FunctionDefinitionCollector();
        CPPASTFunctionDefinition d1 = null;
        CASTFunctionDefinition d2 = null;
        for (IASTFunctionDefinition d : globalFuncDefs) {
            if (d.getDeclarator().getName().toString().compareTo(the_call.getFunctionNameExpression().getRawSignature()) != 0) continue;
            IASTExpression f = the_call.getFunctionNameExpression();
            if (f instanceof CASTIdExpression) {
                fdc.set_c_lang(true);
                d2 = (CASTFunctionDefinition)d;
                fdc.set_FuncC(d2);
                break;
            }
            if (!(f instanceof CPPASTIdExpression)) continue;
            fdc.set_c_lang(false);
            d1 = (CPPASTFunctionDefinition)d;
            fdc.set_Func(d1);
            break;
        }
        return fdc;
    }

    private void collectConstVariableScope(ArrayList<ConstExpression> constVariablesScope, IASTFunctionCallExpression the_call) {
        IASTCompoundStatement scope = null;
        if (this.ConstAssist1((IASTNode)the_call) != null && this.ConstAssist1((IASTNode)the_call) instanceof IASTExpressionStatement && (scope = (IASTCompoundStatement)this.getParent_func((IASTNode)the_call)) != null && scope instanceof IASTCompoundStatement) {
            IASTStatement[] ScopeStatementsC;
            IASTStatement[] iASTStatementArray = ScopeStatementsC = scope.getStatements();
            int n = ScopeStatementsC.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement s = iASTStatementArray[n2];
                if (s instanceof IASTDeclarationStatement && ((IASTDeclarationStatement)s).getDeclaration() instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)((IASTDeclarationStatement)s).getDeclaration()).getDeclSpecifier().isConst()) {
                    IASTDeclarator[] vars;
                    IASTDeclarator[] iASTDeclaratorArray = vars = ((IASTSimpleDeclaration)((IASTDeclarationStatement)s).getDeclaration()).getDeclarators();
                    int n3 = vars.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclarator v = iASTDeclaratorArray[n4];
                        if (v.getInitializer() != null && s.getFileLocation().getStartingLineNumber() < the_call.getFileLocation().getStartingLineNumber() && v.getInitializer() instanceof IASTEqualsInitializer && ((IASTEqualsInitializer)v.getInitializer()).getInitializerClause() instanceof IASTLiteralExpression) {
                            ConstExpression ce = new ConstExpression();
                            ce.set_name(v.getName().toString());
                            ce.set_value((IASTLiteralExpression)((IASTEqualsInitializer)v.getInitializer()).getChildren()[0]);
                            constVariablesScope.add(ce);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private IASTNode getParent_func(IASTNode x) {
        if (!(x.getParent() instanceof IASTTranslationUnit)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            x = x.getParent();
lbl4:
            // 2 sources

            ** while (x != null && !(x.getParent() instanceof IASTFunctionDefinition))
        }
lbl5:
        // 1 sources

        return x;
    }

    private IASTNode ConstAssist1(IASTNode x) {
        if (x instanceof IASTExpressionStatement) {
            return x;
        }
        if (x instanceof IASTFunctionDefinition) {
            return null;
        }
        return this.ConstAssist1(x.getParent());
    }

    private void collectGlobalVariables(ArrayList<ConstExpression> global_variables, IASTFunctionDefinition theFunction) {
        IASTDeclaration[] Globs;
        IASTFunctionDefinition SearchUnit = null;
        SearchUnit = theFunction;
        while (!(SearchUnit instanceof IASTTranslationUnit)) {
            SearchUnit = SearchUnit.getParent();
        }
        IASTDeclaration[] iASTDeclarationArray = Globs = ((IASTTranslationUnit)SearchUnit).getDeclarations();
        int n = Globs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration d = iASTDeclarationArray[n2];
            if (d instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] vars;
                IASTDeclarator[] iASTDeclaratorArray = vars = ((IASTSimpleDeclaration)d).getDeclarators();
                int n3 = vars.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator v = iASTDeclaratorArray[n4];
                    if (v.getInitializer() != null && v.getInitializer() instanceof IASTEqualsInitializer && ((IASTEqualsInitializer)v.getInitializer()).getChildren()[0] instanceof IASTLiteralExpression) {
                        ConstExpression ce = new ConstExpression();
                        ce.set_name(v.getName().toString());
                        ce.set_value((IASTLiteralExpression)((IASTEqualsInitializer)v.getInitializer()).getChildren()[0]);
                        global_variables.add(ce);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void CheckAndMark(CPPASTFunctionDefinition func, CASTFunctionDefinition funcC, IASTInitializerClause[] arguments, IASTFunctionCallExpression the_call, String commentInfo, boolean c_lang, ArrayList<ConstExpression> global_variables, ArrayList<ConstExpression> constVariablesScope, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression) throws CoreException, DOMException {
        IASTStatement s;
        ICPPASTParameterDeclaration[] parameters = null;
        IASTStatement[] statements = null;
        IASTName[] parametersC = null;
        IASTStatement[] statementsC = null;
        IASTStatement[] statementsG = null;
        if (!c_lang) {
            parameters = ((CPPASTFunctionDeclarator)func.getDeclarator()).getParameters();
            statements = ((CPPASTCompoundStatement)func.getBody()).getStatements();
        } else {
            if (funcC.getDeclarator() instanceof CASTKnRFunctionDeclarator) {
                parametersC = ((CASTKnRFunctionDeclarator)funcC.getDeclarator()).getParameterNames();
            } else if (funcC.getDeclarator() instanceof CASTFunctionDeclarator) {
                parameters = ((CASTFunctionDeclarator)funcC.getDeclarator()).getParameters();
            }
            statementsC = ((CASTCompoundStatement)funcC.getBody()).getStatements();
        }
        statementsG = statements != null ? statements : statementsC;
        ConditionResult result = new ConditionResult();
        ConditionResult always = new ConditionResult();
        ArrayList<ConstExpression> const_vatiables = new ArrayList<ConstExpression>();
        ArrayList<LineNumber> AlwaysTrue = new ArrayList<LineNumber>();
        ArrayList<LineNumber> AlwaysFalse = new ArrayList<LineNumber>();
        ArrayList<LineNumber> Extractable = new ArrayList<LineNumber>();
        ArrayList<IASTName> undefined = new ArrayList<IASTName>();
        IASTStatement[] iASTStatementArray = statementsG;
        int n = statementsG.length;
        int n2 = 0;
        while (n2 < n) {
            s = iASTStatementArray[n2];
            if (s instanceof IASTDeclarationStatement) {
                IASTDeclarator d;
                int n3;
                int n4;
                IASTDeclarator[] iASTDeclaratorArray;
                boolean is_const2 = false;
                IASTDeclarator[] arr = null;
                IASTDeclarationStatement declstatement = (IASTDeclarationStatement)s;
                if (!c_lang) {
                    arr = ((CPPASTSimpleDeclaration)declstatement.getDeclaration()).getDeclarators();
                    if (((CPPASTSimpleDeclaration)declstatement.getDeclaration()).getDeclSpecifier() instanceof CPPASTSimpleDeclSpecifier) {
                        is_const2 = ((CPPASTSimpleDeclSpecifier)((CPPASTSimpleDeclaration)declstatement.getDeclaration()).getDeclSpecifier()).isConst();
                    }
                } else {
                    arr = ((CASTSimpleDeclaration)declstatement.getDeclaration()).getDeclarators();
                    CASTSimpleDeclaration qus = (CASTSimpleDeclaration)declstatement.getDeclaration();
                    is_const2 = qus.getDeclSpecifier().isConst();
                }
                if (is_const2) {
                    iASTDeclaratorArray = arr;
                    n4 = arr.length;
                    n3 = 0;
                    while (n3 < n4) {
                        ConstExpression e;
                        d = iASTDeclaratorArray[n3];
                        if (!c_lang && d.getInitializer() != null) {
                            if (((CPPASTEqualsInitializer)d.getInitializer()).getChildren()[0] instanceof IASTLiteralExpression && d.getName().getBinding() instanceof IVariable && !(((CPPVariable)d.getName().getBinding()).getType() instanceof IPointerType)) {
                                e = new ConstExpression();
                                e.set_name(d.getName().toString());
                                e.set_value((IASTLiteralExpression)((CPPASTEqualsInitializer)d.getInitializer()).getChildren()[0]);
                                const_vatiables.add(e);
                            }
                        } else if (d.getInitializer() != null && ((IASTEqualsInitializer)d.getInitializer()).getChildren()[0] instanceof IASTLiteralExpression && d.getName().getBinding() instanceof IVariable && !(((CVariable)d.getName().getBinding()).getType() instanceof IPointerType)) {
                            e = new ConstExpression();
                            e.set_name(d.getName().toString());
                            e.set_value((IASTLiteralExpression)((IASTEqualsInitializer)d.getInitializer()).getChildren()[0]);
                            const_vatiables.add(e);
                        }
                        ++n3;
                    }
                } else {
                    iASTDeclaratorArray = arr;
                    n4 = arr.length;
                    n3 = 0;
                    while (n3 < n4) {
                        d = iASTDeclaratorArray[n3];
                        undefined.add(d.getName());
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        iASTStatementArray = statementsG;
        n = statementsG.length;
        n2 = 0;
        while (n2 < n) {
            s = iASTStatementArray[n2];
            if (s instanceof IASTIfStatement || s instanceof IASTForStatement || s instanceof IASTWhileStatement || s instanceof IASTSwitchStatement || s instanceof IASTLabelStatement) {
                always.Set_result(true);
                result.Set_result(true);
                if (!c_lang) {
                    this.checkCondition(func.getDeclarator().getName().toString(), s, arguments, const_vatiables, global_variables, (IASTParameterDeclaration[])parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                } else {
                    this.checkCondition(funcC.getDeclarator().getName().toString(), s, arguments, const_vatiables, global_variables, (IASTParameterDeclaration[])parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                }
            }
            ++n2;
        }
        String sFunctionName = "N/A";
        if (func != null) {
            sFunctionName = func.getDeclarator().getName().toString();
        } else if (funcC != null) {
            sFunctionName = funcC.getDeclarator().getName().toString();
        }
        boolean at_leastOneF = false;
        boolean at_leastOneT = false;
        if (AlwaysFalse.size() > 0) {
            at_leastOneF = true;
        }
        if (AlwaysTrue.size() > 0) {
            at_leastOneT = true;
        }
        if (at_leastOneF || at_leastOneT) {
            commentInfo = String.valueOf(commentInfo) + "\nFunction Specialization for possible dead code elimination in callee function:";
            commentInfo = String.valueOf(commentInfo) + "\nCall to a function containing conditional expressions that are always true or are always false: \n";
        }
        if (at_leastOneF) {
            for (LineNumber n5 : AlwaysFalse) {
                if (n5.get_line_number() == -1 || n5 == null) continue;
                commentInfo = String.valueOf(commentInfo) + "In function " + sFunctionName + " (" + n5.get_node().getContainingFilename() + "[" + n5.get_line_number() + "]), ";
                commentInfo = String.valueOf(commentInfo) + "the condition \"" + n5.get_type() + " (" + n5.get_theCondition() + ")\" ";
                commentInfo = String.valueOf(commentInfo) + "is always False\n";
                commentInfo = String.valueOf(commentInfo) + "Recommendation: Condition which is never taken should be deleted.\n\n";
            }
        }
        if (at_leastOneT) {
            for (LineNumber n5 : AlwaysTrue) {
                if (n5.get_line_number() == -1 || n5 == null) continue;
                commentInfo = String.valueOf(commentInfo) + "In function " + sFunctionName + " (" + n5.get_node().getContainingFilename() + "[" + n5.get_line_number() + "]), ";
                commentInfo = String.valueOf(commentInfo) + "the condition \"" + n5.get_type() + " (" + n5.get_theCondition() + ")\" ";
                commentInfo = String.valueOf(commentInfo) + "is always true\n";
                commentInfo = String.valueOf(commentInfo) + "Recommendation: an appropriate 'else' condition in line : x should be deleted. (if exists)\n\n";
            }
        }
        boolean at_leastOneExtractable = false;
        if (Extractable.size() > 0) {
            at_leastOneExtractable = true;
        }
        if (at_leastOneExtractable) {
            commentInfo = String.valueOf(commentInfo) + "Function Specialization:\n";
            for (LineNumber n6 : Extractable) {
                if (n6.get_line_number() == -1 || n6 == null) continue;
                commentInfo = String.valueOf(commentInfo) + "In function " + sFunctionName + " (" + n6.get_node().getContainingFilename() + "[" + n6.get_line_number() + "]), ";
                commentInfo = String.valueOf(commentInfo) + "the condition \"" + n6.get_type() + " (" + n6.get_theCondition() + ")\" " + "may be carefully extracted before the call site, for example:\n";
                commentInfo = String.valueOf(commentInfo) + "(1) Create a specialized function which is the same as \"" + sFunctionName + "\" but declare it with a unique name and consider the relevant parameters in the above condition as constants\n";
                commentInfo = String.valueOf(commentInfo) + "(2) Conditionally invoke the function: \n" + n6.get_type() + " (" + n6.get_theCondition() + ")\n" + "     " + the_call.getRawSignature().toString() + "\n";
                commentInfo = String.valueOf(commentInfo) + "Constraint: it is safe to extract the condition before the call site and no side effect inside " + sFunctionName + " function.\n";
            }
        }
        this.MarkCallToUser(the_call, commentInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ExtractableScopeCheck(IASTStatement thenClause, IASTParameterDeclaration[] parameters, IASTName[] parametersC, ArrayList<ConstExpression> const_vatiables, boolean c_lang) {
        IASTStatement[] condition_Scope = new IASTStatement[1];
        if (thenClause instanceof IASTCompoundStatement) {
            condition_Scope = ((IASTCompoundStatement)thenClause).getStatements();
        } else if (thenClause instanceof IASTExpressionStatement) {
            condition_Scope[0] = thenClause;
        }
        boolean known = false;
        if (condition_Scope == null) {
            return false;
        }
        IASTStatement[] iASTStatementArray = condition_Scope;
        int n = condition_Scope.length;
        int n2 = 0;
        while (n2 < n) {
            IASTExpression condition;
            IASTStatement sc = iASTStatementArray[n2];
            if (sc instanceof IASTExpressionStatement) {
                if (!this.ExtractableMark(((IASTExpressionStatement)sc).getExpression(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                known = true;
            } else if (sc instanceof IASTIfStatement) {
                condition = ((IASTIfStatement)sc).getConditionExpression();
                if (!this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang)) return false;
                if (!this.ExtractableScopeCheck(((IASTIfStatement)sc).getThenClause(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                known = true;
            } else if (sc instanceof IASTForStatement) {
                condition = ((IASTForStatement)sc).getConditionExpression();
                if (!this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang)) return false;
                if (!this.ExtractableScopeCheck(((IASTForStatement)sc).getBody(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                known = true;
            } else if (sc instanceof IASTWhileStatement) {
                condition = ((IASTWhileStatement)sc).getCondition();
                if (!this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang)) return false;
                if (!this.ExtractableScopeCheck(((IASTWhileStatement)sc).getBody(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                known = true;
            } else if (sc instanceof IASTSwitchStatement) {
                condition = ((IASTSwitchStatement)sc).getControllerExpression();
                if (!this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang)) return false;
                if (!this.ExtractableScopeCheck(((IASTSwitchStatement)sc).getBody(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                known = true;
            } else if (sc instanceof IASTReturnStatement) {
                if (!this.ExtractableMark(((IASTReturnStatement)sc).getReturnValue(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                known = true;
            }
            if (!known) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean ExtractableMark(IASTExpression c, IASTParameterDeclaration[] parameters, IASTName[] parametersC, ArrayList<ConstExpression> const_vatiables, boolean c_lang) {
        boolean find = false;
        if (c instanceof IASTFunctionCallExpression) {
            IASTInitializerClause[] arguments = null;
            arguments = ((IASTFunctionCallExpression)c).getArguments();
            if (arguments != null) {
                IASTInitializerClause[] iASTInitializerClauseArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTInitializerClause a = iASTInitializerClauseArray[n2];
                    if (a instanceof IASTUnaryExpression) {
                        return this.ExtractableMark((IASTExpression)((IASTUnaryExpression)a), parameters, parametersC, const_vatiables, c_lang);
                    }
                    if (a instanceof IASTBinaryExpression) {
                        return this.ExtractableMark((IASTExpression)((IASTBinaryExpression)a), parameters, parametersC, const_vatiables, c_lang);
                    }
                    if (a instanceof IASTIdExpression) {
                        return this.ExtractableMark((IASTExpression)((IASTIdExpression)a), parameters, parametersC, const_vatiables, c_lang);
                    }
                    if (a instanceof IASTLiteralExpression) {
                        return true;
                    }
                    if (a instanceof IASTFunctionCallExpression) {
                        return this.ExtractableMark((IASTExpression)((IASTFunctionCallExpression)a), parameters, parametersC, const_vatiables, c_lang);
                    }
                    ++n2;
                }
            }
        } else {
            if (c instanceof IASTLiteralExpression) {
                return true;
            }
            if (c instanceof IASTIdExpression) {
                IASTName var = null;
                var = ((IASTIdExpression)c).getName();
                if (var != null && var.getBinding() instanceof IParameter) {
                    find = true;
                }
                if (const_vatiables != null & !find) {
                    int len = const_vatiables.size();
                    int i = 0;
                    while (i < len) {
                        if (((IASTIdExpression)c).getName().toString().equals(const_vatiables.get(i).get_name())) {
                            find = true;
                            break;
                        }
                        find = false;
                        ++i;
                    }
                }
                if (!find) {
                    if (!c_lang) {
                        IBinding b;
                        CPPVariable cv1 = null;
                        CPPVariable cv2 = null;
                        if (((IASTIdExpression)c).getName() instanceof IASTName && ((IASTIdExpression)c).getName().getBinding() instanceof CPPVariable && ((cv1 = (CPPVariable)(b = ((IASTIdExpression)c).getName().getBinding())).getDefinition() != null || (cv2 = (CPPVariable)b).getDeclarations() != null)) {
                            if (cv2 != null) {
                                cv1 = cv2;
                            }
                            if (cv1.getDeclarations() != null && cv1.getDeclarations()[0].getParent().getParent().getParent() instanceof CPPASTTranslationUnit) {
                                find = true;
                            }
                            if (cv1.getDefinition() != null && cv1.getDefinition().getParent() != null && cv1.getDefinition().getParent().getParent() != null && cv1.getDefinition().getParent().getParent().getParent() != null) {
                                find = cv1.getDefinition().getParent().getParent().getParent() instanceof CPPASTTranslationUnit;
                            }
                        }
                    } else {
                        IBinding b;
                        CVariable cv1 = null;
                        CVariable cv2 = null;
                        if (((IASTIdExpression)c).getName() instanceof IASTName && ((IASTIdExpression)c).getName().getBinding() instanceof CVariable && ((cv1 = (CVariable)(b = ((IASTIdExpression)c).getName().getBinding())).getDefinition() != null || (cv2 = (CVariable)b).getDeclarations() != null)) {
                            if (cv2 != null) {
                                cv1 = cv2;
                            }
                            if (cv1.getDeclarations() != null && cv1.getDeclarations()[0].getParent().getParent().getParent() instanceof IASTTranslationUnit) {
                                find = true;
                            }
                            find = cv1.getDefinition().getParent().getParent().getParent() instanceof IASTTranslationUnit;
                        }
                    }
                }
                return find;
            }
            if (c instanceof IASTUnaryExpression) {
                if (((IASTUnaryExpression)c).getOperand() instanceof IASTIdExpression || ((IASTUnaryExpression)c).getOperand() instanceof IASTLiteralExpression) {
                    return this.ExtractableMark(((IASTUnaryExpression)c).getOperand(), parameters, parametersC, const_vatiables, c_lang);
                }
                if (((IASTUnaryExpression)c).getOperand() instanceof IASTUnaryExpression) {
                    return this.ExtractableMark(((IASTUnaryExpression)c).getOperand(), parameters, parametersC, const_vatiables, c_lang);
                }
                if (((IASTUnaryExpression)c).getOperand() instanceof IASTBinaryExpression) {
                    return this.ExtractableMark(((IASTUnaryExpression)c).getOperand(), parameters, parametersC, const_vatiables, c_lang);
                }
                return false;
            }
            if (c instanceof IASTBinaryExpression) {
                if (!this.ExtractableMark(((IASTBinaryExpression)c).getOperand1(), parameters, parametersC, const_vatiables, c_lang)) {
                    return false;
                }
                return this.ExtractableMark(((IASTBinaryExpression)c).getOperand2(), parameters, parametersC, const_vatiables, c_lang);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkCondition(String funcName, IASTStatement s, IASTInitializerClause[] arguments, ArrayList<ConstExpression> const_vatiables, ArrayList<ConstExpression> global_variables, IASTParameterDeclaration[] parameters, ConditionResult result, ConditionResult always, IASTName[] parametersC, boolean c_lang, ArrayList<ConstExpression> constVariablesScope, ArrayList<LineNumber> AlwaysFalse, ArrayList<LineNumber> AlwaysTrue, ArrayList<LineNumber> Extractable, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression) {
        IASTStatement contain;
        block45: {
            LineNumber n2;
            LineNumber n22;
            LineNumber n;
            IASTExpression condition;
            boolean stopper = false;
            if (s instanceof IASTIfStatement) {
                while ((IASTIfStatement)s != null) {
                    LineNumber sn;
                    condition = ((IASTIfStatement)s).getConditionExpression();
                    if (!stopper) {
                        this.check_true_OR_false(funcName, condition, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, assignOperands, AlwaysFalse, tmpBinaryExpression);
                    }
                    if (stopper) {
                        sn = new LineNumber();
                        sn.set_line_number(((IASTIfStatement)s).getFileLocation().getStartingLineNumber());
                        sn.set_type("if");
                        sn.set_theCondition(((IASTIfStatement)s).getConditionExpression().getRawSignature().toString());
                        sn.set_node((IASTNode)s);
                        AlwaysFalse.add(sn);
                    }
                    if (always.get_result() && !stopper) {
                        n = new LineNumber();
                        n.set_line_number(s.getFileLocation().getStartingLineNumber());
                        if (!result.get_result()) {
                            n.set_type("if");
                            n.set_theCondition(((IASTIfStatement)s).getConditionExpression().getRawSignature().toString());
                            n.set_node((IASTNode)s);
                            AlwaysFalse.add(n);
                        } else {
                            if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTIfStatement)s).getThenClause(), parameters, parametersC, const_vatiables, c_lang) && this.checkParentTruthness(AlwaysTrue, s.getParent()) == 1) {
                                n22 = new LineNumber();
                                n22.set_line_number(s.getFileLocation().getStartingLineNumber());
                                n22.set_type("if");
                                n.set_theCondition(((IASTIfStatement)s).getConditionExpression().getRawSignature().toString());
                                n22.set_node((IASTNode)s);
                                Extractable.add(n22);
                            }
                            n.set_type("if");
                            n.set_theCondition(((IASTIfStatement)s).getConditionExpression().getRawSignature().toString());
                            n.set_node((IASTNode)s);
                            AlwaysTrue.add(n);
                            stopper = true;
                            this.updateListsIf(s, funcName, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                        }
                    } else {
                        if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTIfStatement)s).getThenClause(), parameters, parametersC, const_vatiables, c_lang) && this.checkParentTruthness(AlwaysTrue, s.getParent()) == 1) {
                            n2 = new LineNumber();
                            n2.set_line_number(s.getFileLocation().getStartingLineNumber());
                            n2.set_type("if");
                            n2.set_theCondition(((IASTIfStatement)s).getConditionExpression().getRawSignature().toString());
                            n2.set_node((IASTNode)s);
                            Extractable.add(n2);
                        }
                        this.updateListsIf(s, funcName, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                    }
                    if (((IASTIfStatement)s).getElseClause() instanceof IASTCompoundStatement || ((IASTIfStatement)s).getElseClause() instanceof IASTExpressionStatement || ((IASTIfStatement)s).getElseClause() instanceof IASTReturnStatement) {
                        if (!stopper) break;
                        sn = new LineNumber();
                        sn.set_line_number(((IASTIfStatement)s).getElseClause().getFileLocation().getStartingLineNumber());
                        sn.set_type("if");
                        sn.set_theCondition(((IASTIfStatement)s).getConditionExpression().getRawSignature().toString());
                        sn.set_node((IASTNode)s);
                        AlwaysFalse.add(sn);
                        break;
                    }
                    if (!((s = ((IASTIfStatement)s).getElseClause()) instanceof IASTIfStatement)) break;
                }
            }
            if (s instanceof IASTForStatement) {
                condition = ((IASTForStatement)s).getConditionExpression();
                if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTForStatement)s).getBody(), parameters, parametersC, const_vatiables, c_lang)) {
                    n = new LineNumber();
                    n.set_line_number(s.getFileLocation().getStartingLineNumber());
                    n.set_type("for");
                    n.set_theCondition(((IASTForStatement)s).getConditionExpression().getRawSignature().toString());
                    n.set_node((IASTNode)s);
                    Extractable.add(n);
                }
                this.check_true_OR_false(funcName, condition, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, assignOperands, AlwaysFalse, tmpBinaryExpression);
                if (always.get_result()) {
                    n = new LineNumber();
                    n.set_line_number(s.getFileLocation().getStartingLineNumber());
                    if (!result.get_result()) {
                        n.set_type("for");
                        n.set_theCondition(((IASTForStatement)s).getConditionExpression().getRawSignature().toString());
                        n.set_node((IASTNode)s);
                        AlwaysFalse.add(n);
                    } else {
                        if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTForStatement)s).getBody(), parameters, parametersC, const_vatiables, c_lang) && this.checkParentTruthness(AlwaysTrue, s.getParent()) == 1) {
                            n22 = new LineNumber();
                            n22.set_type("for");
                            n22.set_line_number(s.getFileLocation().getStartingLineNumber());
                            n22.set_theCondition(((IASTForStatement)s).getConditionExpression().getRawSignature().toString());
                            n22.set_node((IASTNode)s);
                            Extractable.add(n22);
                        }
                        n.set_type("for");
                        n.set_theCondition(((IASTForStatement)s).getConditionExpression().getRawSignature().toString());
                        n.set_node((IASTNode)s);
                        AlwaysTrue.add(n);
                        stopper = true;
                        this.updateListsFor(s, funcName, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                    }
                } else {
                    if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTForStatement)s).getBody(), parameters, parametersC, const_vatiables, c_lang) && this.checkParentTruthness(AlwaysTrue, s.getParent()) == 1) {
                        n2 = new LineNumber();
                        n2.set_type("for");
                        n2.set_line_number(s.getFileLocation().getStartingLineNumber());
                        n2.set_theCondition(((IASTForStatement)s).getConditionExpression().getRawSignature().toString());
                        n2.set_node((IASTNode)s);
                        Extractable.add(n2);
                    }
                    this.updateListsFor(s, funcName, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                }
            }
            if (s instanceof IASTWhileStatement) {
                condition = ((IASTWhileStatement)s).getCondition();
                this.check_true_OR_false(funcName, condition, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, assignOperands, AlwaysFalse, tmpBinaryExpression);
                if (always.get_result()) {
                    n = new LineNumber();
                    n.set_line_number(s.getFileLocation().getStartingLineNumber());
                    if (!result.get_result()) {
                        n.set_type("while");
                        n.set_theCondition(((IASTWhileStatement)s).getCondition().getRawSignature().toString());
                        n.set_node((IASTNode)s);
                        AlwaysFalse.add(n);
                    } else {
                        if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTWhileStatement)s).getBody(), parameters, parametersC, const_vatiables, c_lang) && this.checkParentTruthness(AlwaysTrue, s.getParent()) == 1) {
                            n22 = new LineNumber();
                            n22.set_line_number(s.getFileLocation().getStartingLineNumber());
                            n22.set_type("while");
                            n22.set_theCondition(((IASTWhileStatement)s).getCondition().getRawSignature().toString());
                            n22.set_node((IASTNode)s);
                            Extractable.add(n22);
                        }
                        n.set_type("while");
                        n.set_theCondition(((IASTWhileStatement)s).getCondition().getRawSignature().toString());
                        n.set_node((IASTNode)s);
                        AlwaysTrue.add(n);
                        stopper = true;
                        this.updateListsWhile(s, funcName, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                    }
                } else {
                    if (this.ExtractableMark(condition, parameters, parametersC, const_vatiables, c_lang) && this.ExtractableScopeCheck(((IASTWhileStatement)s).getBody(), parameters, parametersC, const_vatiables, c_lang) && this.checkParentTruthness(AlwaysTrue, s.getParent()) == 1) {
                        n2 = new LineNumber();
                        n2.set_line_number(s.getFileLocation().getStartingLineNumber());
                        n2.set_type("while");
                        n2.set_theCondition(((IASTWhileStatement)s).getCondition().getRawSignature().toString());
                        n2.set_node((IASTNode)s);
                        Extractable.add(n2);
                    }
                    this.updateListsWhile(s, funcName, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                }
            }
            if (!(s instanceof IASTSwitchStatement)) break block45;
            condition = ((IASTSwitchStatement)s).getControllerExpression();
            IASTCompoundStatement SwitchBody = (IASTCompoundStatement)((IASTSwitchStatement)s).getBody();
            IASTStatement[] stmts = SwitchBody.getStatements();
            boolean True = false;
            boolean waitNextCase = false;
            boolean breakCheck = false;
            boolean wasTrue = false;
            int FalseCounter = 0;
            int CaseCounter = 0;
            IASTStatement[] iASTStatementArray = stmts;
            int n3 = stmts.length;
            int n4 = 0;
            while (n4 < n3) {
                block44: {
                    IASTStatement st;
                    block48: {
                        int SwitchCaseLength;
                        LineNumber n5;
                        block49: {
                            block46: {
                                block47: {
                                    st = iASTStatementArray[n4];
                                    if (waitNextCase && !(st instanceof IASTCaseStatement)) break block44;
                                    if (st instanceof IASTBreakStatement) {
                                        breakCheck = true;
                                    }
                                    if (!(st instanceof IASTDefaultStatement)) break block46;
                                    if (!breakCheck || !wasTrue) break block47;
                                    n5 = new LineNumber();
                                    n5.set_line_number(st.getFileLocation().getStartingLineNumber());
                                    n5.set_type("switch");
                                    waitNextCase = true;
                                    SwitchCaseLength = st.getRawSignature().length();
                                    if (SwitchCaseLength >= 20) {
                                        n5.set_theCondition((String)st.getRawSignature().subSequence(0, 20));
                                    } else {
                                        n5.set_theCondition((String)st.getRawSignature().subSequence(0, SwitchCaseLength));
                                    }
                                    n5.set_node((IASTNode)st);
                                    AlwaysFalse.add(n5);
                                    break block44;
                                }
                                if (CaseCounter != FalseCounter) break block46;
                                n5 = new LineNumber();
                                n5.set_line_number(st.getFileLocation().getStartingLineNumber());
                                n5.set_type("switch");
                                waitNextCase = false;
                                SwitchCaseLength = st.getRawSignature().length();
                                if (SwitchCaseLength >= 20) {
                                    n5.set_theCondition((String)st.getRawSignature().subSequence(0, 20));
                                } else {
                                    n5.set_theCondition((String)st.getRawSignature().subSequence(0, SwitchCaseLength));
                                }
                                n5.set_node((IASTNode)st);
                                AlwaysTrue.add(n5);
                                break block44;
                            }
                            if (!(st instanceof IASTCaseStatement)) break block48;
                            ++CaseCounter;
                            if (!breakCheck || !wasTrue) break block49;
                            n5 = new LineNumber();
                            n5.set_line_number(st.getFileLocation().getStartingLineNumber());
                            n5.set_type("switch");
                            waitNextCase = true;
                            n5.set_theCondition(((IASTCaseStatement)st).getExpression().getRawSignature().toString());
                            n5.set_node((IASTNode)st);
                            AlwaysFalse.add(n5);
                            ++FalseCounter;
                            break block44;
                        }
                        True = this.checkCaseStatement(funcName, st, condition, const_vatiables, global_variables, parameters, parametersC, constVariablesScope, ((IASTCaseStatement)st).getExpression(), always, arguments, assignOperands, tmpBinaryExpression, c_lang, AlwaysFalse);
                        if (always.get_result()) {
                            n5 = new LineNumber();
                            n5.set_line_number(st.getFileLocation().getStartingLineNumber());
                            n5.set_type("switch");
                            SwitchCaseLength = st.getRawSignature().length();
                            if (True) {
                                waitNextCase = false;
                                if (SwitchCaseLength >= 20) {
                                    n5.set_theCondition((String)st.getRawSignature().subSequence(0, 20));
                                } else {
                                    n5.set_theCondition((String)st.getRawSignature().subSequence(0, SwitchCaseLength));
                                }
                                wasTrue = true;
                                n5.set_node((IASTNode)st);
                                AlwaysTrue.add(n5);
                                break block44;
                            } else {
                                waitNextCase = true;
                                if (SwitchCaseLength >= 20) {
                                    n5.set_theCondition((String)st.getRawSignature().subSequence(0, 20));
                                } else {
                                    n5.set_theCondition((String)st.getRawSignature().subSequence(0, SwitchCaseLength));
                                }
                                n5.set_node((IASTNode)st);
                                AlwaysFalse.add(n5);
                                ++FalseCounter;
                            }
                        }
                        break block44;
                    }
                    if (!breakCheck) {
                        always.Set_result(true);
                        this.checkCondition(funcName, st, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
                    }
                }
                ++n4;
            }
        }
        if (s instanceof IASTLabelStatement && ((contain = ((IASTLabelStatement)s).getNestedStatement()) instanceof IASTIfStatement || contain instanceof IASTForStatement || contain instanceof IASTWhileStatement || contain instanceof IASTSwitchStatement || contain instanceof IASTLabelStatement)) {
            this.checkCondition(funcName, contain, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, AlwaysFalse, AlwaysTrue, Extractable, assignOperands, tmpBinaryExpression);
        }
    }

    private boolean checkCaseStatement(String funcName, IASTStatement st, IASTExpression c, ArrayList<ConstExpression> const_vatiables, ArrayList<ConstExpression> global_variables, IASTParameterDeclaration[] parameters, IASTName[] parametersC, ArrayList<ConstExpression> constVariablesScope, IASTExpression SwitchCase, ConditionResult always, IASTInitializerClause[] arguments, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression, boolean c_lang, ArrayList<LineNumber> alwaysFalse) {
        always.Set_result(true);
        boolean found = false;
        if (c instanceof IASTIdExpression) {
            int int_op1;
            int i;
            int int_op2;
            int int_op12;
            int num1;
            int num2;
            int num22;
            int num12;
            String s2;
            String s1;
            boolean IfTwo;
            boolean IfOne;
            int parsed2;
            int parsed1;
            IASTParameterDeclaration p;
            int n;
            int n2;
            IASTParameterDeclaration[] iASTParameterDeclarationArray;
            int conditionLine = -1;
            conditionLine = c.getFileLocation().getStartingLineNumber();
            if (!this.checkValidate2(conditionLine, ((IASTIdExpression)c).getName().toString(), funcName, alwaysFalse)) {
                always.Set_result(false);
            }
            if (this.checkPointer(conditionLine, ((IASTIdExpression)c).getName().toString(), funcName, alwaysFalse, tmpBinaryExpression)) {
                always.Set_result(false);
            }
            if (this.checkDeclar(conditionLine, ((IASTIdExpression)c).getName().toString(), c, alwaysFalse, c_lang)) {
                always.Set_result(false);
            }
            if (this.checkRef(assignOperands, conditionLine, funcName, ((IASTIdExpression)c).getName().toString(), alwaysFalse, c_lang)) {
                always.Set_result(false);
            }
            if (this.paraChange(funcName, conditionLine, ((IASTIdExpression)c).getName().toString(), c, alwaysFalse, assignOperands)) {
                always.Set_result(false);
            }
            int index = 0;
            IASTName var = null;
            var = ((IASTIdExpression)c).getName();
            if (!c_lang) {
                if (var != null && var.getBinding() instanceof IParameter && parameters != null && parameters.length != 0) {
                    iASTParameterDeclarationArray = parameters;
                    n2 = parameters.length;
                    n = 0;
                    while (n < n2) {
                        p = iASTParameterDeclarationArray[n];
                        if (((IASTIdExpression)c).getName().toString().equals(((CPPASTDeclarator)p.getDeclarator()).getName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            if (((IASTLiteralExpression)arguments[index]).getKind() == 2 || ((IASTLiteralExpression)arguments[index]).getKind() == 3) {
                                String string_op2;
                                String string_op1 = new String(((IASTLiteralExpression)arguments[index]).getValue());
                                return string_op1.equals(string_op2 = new String(((IASTLiteralExpression)SwitchCase).getValue()));
                            }
                            if (((IASTLiteralExpression)arguments[index]).getKind() == 1 || ((IASTLiteralExpression)arguments[index]).getKind() == 0) {
                                parsed1 = -1;
                                parsed2 = -1;
                                IfOne = false;
                                IfTwo = false;
                                s1 = new String(((IASTLiteralExpression)arguments[index]).getValue());
                                s2 = new String(((IASTLiteralExpression)SwitchCase).getValue());
                                if (s1.startsWith("0x")) {
                                    if (s1.endsWith("L")) {
                                        s1 = s1.substring(0, s1.length() - 1);
                                    }
                                    s1 = s1.substring(2);
                                    parsed1 = Integer.parseInt(s1, 16);
                                    IfOne = true;
                                }
                                if (s2.startsWith("0x")) {
                                    if (s2.endsWith("L")) {
                                        s2 = s2.substring(0, s2.length() - 1);
                                    }
                                    s2 = s2.substring(2);
                                    parsed2 = Integer.parseInt(s1, 16);
                                    IfTwo = true;
                                }
                                if (IfOne && IfTwo) {
                                    num12 = parsed1;
                                    num22 = parsed2;
                                    return num12 == num22;
                                }
                                if (IfOne) {
                                    num12 = parsed1;
                                    num22 = Integer.parseInt(s2);
                                    return num12 == num22;
                                }
                                if (IfTwo) {
                                    num2 = parsed2;
                                    num1 = Integer.parseInt(s1);
                                    return num1 == num2;
                                }
                                if (((IASTLiteralExpression)arguments[index]).getKind() == 0) {
                                    found = true;
                                    int_op12 = Integer.parseInt(new String(((IASTLiteralExpression)arguments[index]).getValue()));
                                    int_op2 = Integer.parseInt(new String(((IASTLiteralExpression)SwitchCase).getValue()));
                                    if (int_op2 == int_op12) {
                                        return true;
                                    }
                                }
                            }
                        }
                        ++index;
                        ++n;
                    }
                }
            } else if (var != null) {
                if (var.getBinding() instanceof IParameter && parameters != null) {
                    if (parameters != null && parameters.length != 0) {
                        iASTParameterDeclarationArray = parameters;
                        n2 = parameters.length;
                        n = 0;
                        while (n < n2) {
                            p = iASTParameterDeclarationArray[n];
                            if (((CASTIdExpression)c).getName().toString().equals(p.getDeclarator().getName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                                parsed1 = -1;
                                parsed2 = -1;
                                IfOne = false;
                                IfTwo = false;
                                s1 = new String(((IASTLiteralExpression)arguments[index]).getValue());
                                s2 = new String(((IASTLiteralExpression)SwitchCase).getValue());
                                if (s1.startsWith("0x")) {
                                    if (s1.endsWith("L")) {
                                        s1 = s1.substring(0, s1.length() - 1);
                                    }
                                    s1 = s1.substring(2);
                                    parsed1 = Integer.parseInt(s1, 16);
                                    IfOne = true;
                                }
                                if (s2.startsWith("0x")) {
                                    if (s2.endsWith("L")) {
                                        s2 = s2.substring(0, s2.length() - 1);
                                    }
                                    s2 = s2.substring(2);
                                    parsed2 = Integer.parseInt(s1, 16);
                                    IfTwo = true;
                                }
                                if (IfOne && IfTwo) {
                                    num12 = parsed1;
                                    num22 = parsed2;
                                    return num12 == num22;
                                }
                                if (IfOne) {
                                    num12 = parsed1;
                                    num22 = Integer.parseInt(s2);
                                    return num12 == num22;
                                }
                                if (IfTwo) {
                                    num2 = parsed2;
                                    num1 = Integer.parseInt(s1);
                                    return num1 == num2;
                                }
                                if (((IASTLiteralExpression)arguments[index]).getKind() == 0) {
                                    found = true;
                                    int_op12 = Integer.parseInt(new String(((IASTLiteralExpression)arguments[index]).getValue()));
                                    int_op2 = Integer.parseInt(new String(((IASTLiteralExpression)SwitchCase).getValue()));
                                    if (int_op2 == int_op12) {
                                        return true;
                                    }
                                } else if (((IASTLiteralExpression)arguments[index]).getKind() == 5 || ((IASTLiteralExpression)arguments[index]).getKind() == 6) {
                                    String string_op2;
                                    String string_op1 = new String(((IASTLiteralExpression)arguments[index]).getValue());
                                    return string_op1.equals(string_op2 = new String(((IASTLiteralExpression)SwitchCase).getValue()));
                                }
                            }
                            ++index;
                            ++n;
                        }
                    }
                } else if (var != null && var.getBinding() instanceof IParameter && parametersC != null && parametersC.length != 0) {
                    iASTParameterDeclarationArray = parametersC;
                    n2 = parametersC.length;
                    n = 0;
                    while (n < n2) {
                        p = iASTParameterDeclarationArray[n];
                        if (!(((CParameter)p.getBinding()).getType() instanceof IPointerType) && ((CASTName)((CASTIdExpression)c).getName()).getLastName().toString().equals(p.getLastName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            found = true;
                            int int_op13 = Integer.parseInt(new String(((IASTLiteralExpression)arguments[index]).getValue()));
                            int int_op22 = Integer.parseInt(new String(((IASTLiteralExpression)SwitchCase).getValue()));
                            if (int_op22 == int_op13) {
                                return true;
                            }
                        }
                        ++index;
                        ++n;
                    }
                }
            }
            if (const_vatiables != null) {
                int len = const_vatiables.size();
                i = 0;
                while (i < len) {
                    if (c.getRawSignature().equals(const_vatiables.get(i).get_name())) {
                        found = true;
                        int_op1 = Integer.parseInt(new String(const_vatiables.get(i).get_value().getValue()));
                        int int_op23 = Integer.parseInt(new String(((IASTLiteralExpression)SwitchCase).getValue()));
                        if (int_op23 == int_op1) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            if (global_variables != null) {
                int len = global_variables.size();
                i = 0;
                while (i < len) {
                    if (c.getRawSignature().equals(global_variables.get(i).get_name())) {
                        found = true;
                        int_op1 = Integer.parseInt(new String(global_variables.get(i).get_value().getValue()));
                        int int_op24 = Integer.parseInt(new String(((IASTLiteralExpression)SwitchCase).getValue()));
                        if (int_op24 == int_op1) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            if (!found) {
                always.Set_result(false);
            }
            return false;
        }
        always.Set_result(false);
        return false;
    }

    private void updateListsIf(IASTStatement s, String funcName, IASTInitializerClause[] arguments, ArrayList<ConstExpression> const_vatiables, ArrayList<ConstExpression> global_variables, IASTParameterDeclaration[] parameters, ConditionResult result, ConditionResult always, IASTName[] parametersC, boolean c_lang, ArrayList<ConstExpression> constVariablesScope, ArrayList<LineNumber> alwaysFalse, ArrayList<LineNumber> alwaysTrue, ArrayList<LineNumber> extractable, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression) {
        IASTStatement[] condition_Scope = new IASTStatement[1];
        if (((IASTIfStatement)s).getThenClause() instanceof IASTCompoundStatement) {
            condition_Scope = ((IASTCompoundStatement)((IASTIfStatement)s).getThenClause()).getStatements();
        } else if (((IASTIfStatement)s).getThenClause() instanceof IASTExpressionStatement) {
            condition_Scope[0] = ((IASTIfStatement)s).getThenClause();
        }
        if (condition_Scope != null) {
            IASTStatement[] iASTStatementArray = condition_Scope;
            int n = condition_Scope.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement sc = iASTStatementArray[n2];
                if (sc instanceof IASTIfStatement || sc instanceof IASTForStatement || sc instanceof IASTWhileStatement || sc instanceof IASTSwitchStatement || sc instanceof IASTLabelStatement) {
                    result.Set_result(true);
                    always.Set_result(true);
                    this.checkCondition(funcName, sc, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, alwaysFalse, alwaysTrue, extractable, assignOperands, tmpBinaryExpression);
                }
                ++n2;
            }
        }
    }

    private void updateListsFor(IASTStatement s, String funcName, IASTInitializerClause[] arguments, ArrayList<ConstExpression> const_vatiables, ArrayList<ConstExpression> global_variables, IASTParameterDeclaration[] parameters, ConditionResult result, ConditionResult always, IASTName[] parametersC, boolean c_lang, ArrayList<ConstExpression> constVariablesScope, ArrayList<LineNumber> alwaysFalse, ArrayList<LineNumber> alwaysTrue, ArrayList<LineNumber> extractable, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression) {
        IASTStatement[] condition_Scope = new IASTStatement[1];
        if (((IASTForStatement)s).getBody() instanceof IASTCompoundStatement) {
            condition_Scope = ((IASTCompoundStatement)((IASTForStatement)s).getBody()).getStatements();
        } else if (((IASTForStatement)s).getBody() instanceof IASTExpressionStatement) {
            condition_Scope[0] = ((IASTForStatement)s).getBody();
        }
        if (condition_Scope != null) {
            IASTStatement[] iASTStatementArray = condition_Scope;
            int n = condition_Scope.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement sc = iASTStatementArray[n2];
                if (sc instanceof IASTIfStatement || sc instanceof IASTForStatement || sc instanceof IASTWhileStatement || sc instanceof IASTSwitchStatement || sc instanceof IASTLabelStatement) {
                    result.Set_result(true);
                    always.Set_result(true);
                    this.checkCondition(funcName, sc, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, alwaysFalse, alwaysTrue, extractable, assignOperands, tmpBinaryExpression);
                }
                ++n2;
            }
        }
    }

    private void updateListsWhile(IASTStatement s, String funcName, IASTInitializerClause[] arguments, ArrayList<ConstExpression> const_vatiables, ArrayList<ConstExpression> global_variables, IASTParameterDeclaration[] parameters, ConditionResult result, ConditionResult always, IASTName[] parametersC, boolean c_lang, ArrayList<ConstExpression> constVariablesScope, ArrayList<LineNumber> alwaysFalse, ArrayList<LineNumber> alwaysTrue, ArrayList<LineNumber> extractable, List<IASTName> assignOperands, List<IASTBinaryExpression> tmpBinaryExpression) {
        IASTStatement[] condition_Scope = new IASTStatement[1];
        if (((IASTWhileStatement)s).getBody() instanceof IASTCompoundStatement) {
            condition_Scope = ((IASTCompoundStatement)((IASTWhileStatement)s).getBody()).getStatements();
        } else if (((IASTWhileStatement)s).getBody() instanceof IASTExpressionStatement) {
            condition_Scope[0] = ((IASTWhileStatement)s).getBody();
        }
        if (condition_Scope != null) {
            IASTStatement[] iASTStatementArray = condition_Scope;
            int n = condition_Scope.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement sc = iASTStatementArray[n2];
                if (sc instanceof IASTIfStatement || sc instanceof IASTForStatement || sc instanceof IASTWhileStatement || sc instanceof IASTSwitchStatement || sc instanceof IASTLabelStatement) {
                    result.Set_result(true);
                    always.Set_result(true);
                    this.checkCondition(funcName, sc, arguments, const_vatiables, global_variables, parameters, result, always, parametersC, c_lang, constVariablesScope, alwaysFalse, alwaysTrue, extractable, assignOperands, tmpBinaryExpression);
                }
                ++n2;
            }
        }
    }

    public IASTLiteralExpression check_true_OR_false(String funcName, IASTExpression c, IASTInitializerClause[] arguments, ArrayList<ConstExpression> const_vatiables, ArrayList<ConstExpression> global_variables, IASTParameterDeclaration[] parameters, ConditionResult result2, ConditionResult always, IASTName[] parametersC, boolean c_lang, ArrayList<ConstExpression> constVariablesScope, List<IASTName> assignOperands, ArrayList<LineNumber> alwaysFalse, List<IASTBinaryExpression> tmpBinaryExpression) {
        IASTLiteralExpression operand1 = null;
        IASTLiteralExpression operand2 = null;
        IASTLiteralExpression operand = null;
        boolean always_op1 = false;
        boolean always_op2 = false;
        boolean result_op1 = false;
        boolean result_op2 = false;
        boolean result = false;
        if (c instanceof IASTIdExpression && c.getParent() instanceof IASTIfStatement) {
            int i;
            IASTParameterDeclaration p;
            int n;
            int n2;
            IASTParameterDeclaration[] iASTParameterDeclarationArray;
            IASTLiteralExpression res = null;
            int conditionLine = -1;
            conditionLine = c.getFileLocation().getStartingLineNumber();
            if (!this.checkValidate2(conditionLine, ((IASTIdExpression)c).getName().toString(), funcName, alwaysFalse)) {
                always.Set_result(false);
                return null;
            }
            if (this.checkPointer(conditionLine, ((IASTIdExpression)c).getName().toString(), funcName, alwaysFalse, tmpBinaryExpression)) {
                always.Set_result(false);
                return null;
            }
            if (this.checkDeclar(conditionLine, ((IASTIdExpression)c).getName().toString(), c, alwaysFalse, c_lang)) {
                always.Set_result(false);
                return null;
            }
            if (this.checkRef(assignOperands, conditionLine, funcName, ((IASTIdExpression)c).getName().toString(), alwaysFalse, c_lang)) {
                always.Set_result(false);
                return null;
            }
            if (this.paraChange(funcName, conditionLine, ((IASTIdExpression)c).getName().toString(), c, alwaysFalse, assignOperands)) {
                always.Set_result(false);
                return null;
            }
            int index = 0;
            IASTName var = null;
            var = ((IASTIdExpression)c).getName();
            if (!c_lang) {
                if (var != null && var.getBinding() instanceof IParameter && parameters != null && parameters.length != 0) {
                    iASTParameterDeclarationArray = parameters;
                    n2 = parameters.length;
                    n = 0;
                    while (n < n2) {
                        p = iASTParameterDeclarationArray[n];
                        if (((IASTIdExpression)c).getName().toString().equals(((CPPASTDeclarator)p.getDeclarator()).getName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            res = (IASTLiteralExpression)arguments[index];
                        }
                        ++index;
                        ++n;
                    }
                }
            } else {
                if (var != null && var.getBinding() instanceof IParameter && parameters != null && parameters != null && parameters.length != 0) {
                    iASTParameterDeclarationArray = parameters;
                    n2 = parameters.length;
                    n = 0;
                    while (n < n2) {
                        p = iASTParameterDeclarationArray[n];
                        if (((CASTIdExpression)c).getName().toString().equals(p.getDeclarator().getName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            res = (IASTLiteralExpression)arguments[index];
                        }
                        ++index;
                        ++n;
                    }
                }
                if (var != null && var.getBinding() instanceof IParameter && parametersC != null && parametersC.length != 0) {
                    iASTParameterDeclarationArray = parametersC;
                    n2 = parametersC.length;
                    n = 0;
                    while (n < n2) {
                        p = iASTParameterDeclarationArray[n];
                        if (!(((CParameter)p.getBinding()).getType() instanceof IPointerType) && ((CASTIdExpression)c).getName().toString().equals(p.getLastName()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            res = (IASTLiteralExpression)arguments[index];
                        }
                        ++index;
                        ++n;
                    }
                }
            }
            if (const_vatiables != null) {
                int len = const_vatiables.size();
                i = 0;
                while (i < len) {
                    if (((IASTIdExpression)c).getName().toString().equals(const_vatiables.get(i).get_name())) {
                        res = const_vatiables.get(i).get_value();
                    }
                    ++i;
                }
            }
            if (global_variables != null) {
                int len = global_variables.size();
                i = 0;
                while (i < len) {
                    if (((IASTIdExpression)c).getName().toString().equals(global_variables.get(i).get_name())) {
                        res = global_variables.get(i).get_value();
                    }
                    ++i;
                }
            }
            if (res != null) {
                boolean bResult = false;
                switch (res.getKind()) {
                    case 0: {
                        int int_op = Integer.parseInt(new String(res.getValue()));
                        bResult = int_op != 0;
                        break;
                    }
                    case 1: {
                        float float_op = Float.parseFloat(new String(res.getValue()));
                        bResult = float_op != 0.0f;
                        break;
                    }
                    case 2: {
                        String string_op = new String(res.getValue());
                        bResult = string_op != null;
                        break;
                    }
                    case 3: {
                        bResult = res.getValue().equals(Character.valueOf('\u0000'));
                        break;
                    }
                    case 5: {
                        bResult = true;
                        break;
                    }
                    case 6: {
                        bResult = false;
                    }
                }
                always.Set_result(bResult);
            } else {
                always.Set_result(false);
            }
            return null;
        }
        if (c instanceof IASTIdExpression) {
            int i;
            IASTParameterDeclaration p;
            int bResult;
            int n;
            IASTParameterDeclaration[] iASTParameterDeclarationArray;
            int conditionLine = -1;
            conditionLine = c.getFileLocation().getStartingLineNumber();
            if (!this.checkValidate2(conditionLine, ((IASTIdExpression)c).getName().toString(), funcName, alwaysFalse)) {
                always.Set_result(false);
                return null;
            }
            if (this.checkPointer(conditionLine, ((IASTIdExpression)c).getName().toString(), funcName, alwaysFalse, tmpBinaryExpression)) {
                always.Set_result(false);
                return null;
            }
            if (this.checkDeclar(conditionLine, ((IASTIdExpression)c).getName().toString(), c, alwaysFalse, c_lang)) {
                always.Set_result(false);
                return null;
            }
            if (this.checkRef(assignOperands, conditionLine, funcName, ((IASTIdExpression)c).getName().toString(), alwaysFalse, c_lang)) {
                always.Set_result(false);
                return null;
            }
            if (this.paraChange(funcName, conditionLine, ((IASTIdExpression)c).getName().toString(), c, alwaysFalse, assignOperands)) {
                always.Set_result(false);
                return null;
            }
            int index = 0;
            IASTName var = null;
            var = ((IASTIdExpression)c).getName();
            if (!c_lang) {
                if (var != null && var.getBinding() instanceof IParameter && parameters != null && parameters.length != 0) {
                    iASTParameterDeclarationArray = parameters;
                    n = parameters.length;
                    bResult = 0;
                    while (bResult < n) {
                        p = iASTParameterDeclarationArray[bResult];
                        if (((IASTIdExpression)c).getName().toString().equals(((CPPASTDeclarator)p.getDeclarator()).getName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            return (IASTLiteralExpression)arguments[index];
                        }
                        ++index;
                        ++bResult;
                    }
                }
            } else if (var != null) {
                if (var.getBinding() instanceof IParameter && parameters != null) {
                    if (parameters != null && parameters.length != 0) {
                        iASTParameterDeclarationArray = parameters;
                        n = parameters.length;
                        bResult = 0;
                        while (bResult < n) {
                            p = iASTParameterDeclarationArray[bResult];
                            if (((CASTIdExpression)c).getName().toString().equals(p.getDeclarator().getName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                                return (IASTLiteralExpression)arguments[index];
                            }
                            ++index;
                            ++bResult;
                        }
                    }
                } else if (var != null && var.getBinding() instanceof IParameter && parametersC != null && parametersC.length != 0) {
                    iASTParameterDeclarationArray = parametersC;
                    n = parametersC.length;
                    bResult = 0;
                    while (bResult < n) {
                        p = iASTParameterDeclarationArray[bResult];
                        if (!(((CParameter)p.getBinding()).getType() instanceof IPointerType) && ((CASTName)((CASTIdExpression)c).getName()).getLastName().toString().equals(p.getLastName().toString()) && index + 1 <= arguments.length && arguments[index] instanceof IASTLiteralExpression) {
                            return (IASTLiteralExpression)arguments[index];
                        }
                        ++index;
                        ++bResult;
                    }
                }
            }
            if (const_vatiables != null) {
                int len = const_vatiables.size();
                i = 0;
                while (i < len) {
                    if (c.getRawSignature().equals(const_vatiables.get(i).get_name())) {
                        return const_vatiables.get(i).get_value();
                    }
                    ++i;
                }
            }
            if (global_variables != null) {
                int len = global_variables.size();
                i = 0;
                while (i < len) {
                    if (c.getRawSignature().equals(global_variables.get(i).get_name())) {
                        return global_variables.get(i).get_value();
                    }
                    ++i;
                }
            }
            always.Set_result(false);
            return null;
        }
        if (c instanceof IASTLiteralExpression) {
            IASTLiteralExpression opr = (IASTLiteralExpression)c;
            String one = "1";
            String zero = "0";
            char[] oneArray = one.toCharArray();
            char[] zeroArray = zero.toCharArray();
            if ((c.getParent() instanceof IASTIfStatement || c.getParent() instanceof IASTWhileStatement || c.getParent() instanceof IASTForStatement || c.getParent() instanceof IASTSwitchStatement) && opr.getValue().length == 1) {
                if (opr.getValue()[0] == zeroArray[0]) {
                    result2.Set_result(false);
                } else if (opr.getValue()[0] == oneArray[0]) {
                    result2.Set_result(true);
                }
            }
            return (IASTLiteralExpression)c;
        }
        if (c instanceof IASTUnaryExpression) {
            if (((IASTUnaryExpression)c).getOperand() instanceof IASTIdExpression || ((IASTUnaryExpression)c).getOperand() instanceof IASTLiteralExpression) {
                operand = this.check_true_OR_false(funcName, ((IASTUnaryExpression)c).getOperand(), arguments, const_vatiables, global_variables, parameters, result2, always, parametersC, c_lang, constVariablesScope, assignOperands, alwaysFalse, tmpBinaryExpression);
                if (((IASTUnaryExpression)c).getOperator() == 7 && operand != null) {
                    String one = "1";
                    String zero = "0";
                    char[] oneArray = one.toCharArray();
                    char[] zeroArray = zero.toCharArray();
                    if (operand.getValue().length == 1) {
                        if (operand.getValue()[0] == zeroArray[0]) {
                            result2.Set_result(true);
                        } else if (operand.getValue()[0] == oneArray[0]) {
                            result2.Set_result(false);
                        }
                    }
                }
                return null;
            }
            if (((IASTUnaryExpression)c).getOperand() instanceof IASTUnaryExpression) {
                this.check_true_OR_false(funcName, ((IASTUnaryExpression)c).getOperand(), arguments, const_vatiables, global_variables, parameters, result2, always, parametersC, c_lang, constVariablesScope, assignOperands, alwaysFalse, tmpBinaryExpression);
                return null;
            }
            if (((IASTUnaryExpression)c).getOperand() instanceof IASTBinaryExpression) {
                this.check_true_OR_false(funcName, ((IASTUnaryExpression)c).getOperand(), arguments, const_vatiables, global_variables, parameters, result2, always, parametersC, c_lang, constVariablesScope, assignOperands, alwaysFalse, tmpBinaryExpression);
                return null;
            }
        } else if (c instanceof IASTBinaryExpression) {
            boolean notZero1 = false;
            boolean notZero2 = false;
            int operator = ((IASTBinaryExpression)c).getOperator();
            operand1 = this.check_true_OR_false(funcName, ((IASTBinaryExpression)c).getOperand1(), arguments, const_vatiables, global_variables, parameters, result2, always, parametersC, c_lang, constVariablesScope, assignOperands, alwaysFalse, tmpBinaryExpression);
            result_op1 = result2.get_result();
            always_op1 = always.get_result();
            always.Set_result(true);
            result2.Set_result(true);
            operand2 = this.check_true_OR_false(funcName, ((IASTBinaryExpression)c).getOperand2(), arguments, const_vatiables, global_variables, parameters, result2, always, parametersC, c_lang, constVariablesScope, assignOperands, alwaysFalse, tmpBinaryExpression);
            result_op2 = result2.get_result();
            always_op2 = always.get_result();
            if (operator == 16) {
                if (operand1 instanceof IASTLiteralExpression) {
                    if (operand1.toString().compareTo("0") != 0) {
                        notZero1 = true;
                    } else {
                        result_op1 = false;
                    }
                }
                if (operand2 instanceof IASTLiteralExpression) {
                    if (operand2.toString().compareTo("0") != 0) {
                        notZero2 = true;
                    } else {
                        result_op2 = false;
                    }
                }
                if (notZero1) {
                    result_op1 = true;
                    result2.Set_result(true);
                }
                if (notZero2) {
                    result_op2 = true;
                    result2.Set_result(true);
                }
                if (!always_op1 && !always_op2) {
                    always.Set_result(false);
                }
                if (always_op1 && !always_op2) {
                    if (!result_op1) {
                        always.Set_result(false);
                    } else {
                        always.Set_result(true);
                    }
                } else if (!always_op1 && always_op2) {
                    if (!result_op2) {
                        always.Set_result(false);
                    } else {
                        always.Set_result(true);
                    }
                } else if (result_op1 || result_op2) {
                    result2.Set_result(true);
                } else {
                    result2.Set_result(false);
                }
            } else if (!(operator == 16 || operator == 15 || always_op1 && always_op2)) {
                always.Set_result(false);
            } else if (operator == 15) {
                if (always_op1 && always_op2) {
                    if (!result_op1 || !result_op2) {
                        result2.Set_result(false);
                    } else if (result_op1 && result_op2) {
                        result2.Set_result(true);
                    }
                } else if (always_op1) {
                    if (!result_op1) {
                        result2.Set_result(false);
                        always.Set_result(true);
                    }
                } else if (always_op2 && !result_op2) {
                    result2.Set_result(false);
                    always.Set_result(true);
                }
                if (operand1 instanceof IASTLiteralExpression || operand2 instanceof IASTLiteralExpression) {
                    if (operand1 instanceof IASTLiteralExpression) {
                        if (operand1.toString().compareTo("0") != 0) {
                            notZero1 = true;
                        } else {
                            result_op1 = false;
                        }
                    }
                    if (operand2 instanceof IASTLiteralExpression) {
                        if (operand2.toString().compareTo("0") != 0) {
                            notZero2 = true;
                        } else {
                            result_op2 = false;
                        }
                    }
                    if (notZero1) {
                        result_op1 = true;
                    }
                    if (notZero2) {
                        result_op2 = true;
                    }
                    if (result_op1 && result_op2) {
                        result2.Set_result(true);
                    } else {
                        if (operand1 instanceof IASTLiteralExpression && !result_op1) {
                            always.Set_result(true);
                            result2.Set_result(false);
                        }
                        if (operand2 instanceof IASTLiteralExpression && !result_op2) {
                            always.Set_result(true);
                            result2.Set_result(false);
                        }
                    }
                }
            }
            if (always.get_result()) {
                if (operator == 15 || operator == 16) {
                    return null;
                }
                result = this.checkResult(operand1, operand2, operator, always);
            }
            result2.Set_result(result);
            return null;
        }
        always.Set_result(false);
        return null;
    }

    private boolean checkRef(List<IASTName> assignOperands, int conditionLine, String funcName, String paraName, ArrayList<LineNumber> alwaysFalse, boolean c_lang) {
        for (IASTName a : assignOperands) {
            IASTIdExpression e;
            IASTDeclarator c;
            if (!this.checkValidate4(a.getParent(), conditionLine, funcName)) continue;
            if (!c_lang) {
                if (!(a.getBinding() instanceof CPPVariable) || !(((CPPVariable)a.getBinding()).getType() instanceof CPPReferenceType)) continue;
                c = null;
                if (!(((CPPVariable)a.getBinding()).getDefinition().getParent() instanceof IASTDeclarator) || !((c = (IASTDeclarator)((CPPVariable)a.getBinding()).getDefinition().getParent()).getInitializer() instanceof IASTEqualsInitializer) || c.getInitializer() == null || !(((IASTEqualsInitializer)c.getInitializer()).getInitializerClause() instanceof IASTIdExpression) || !((e = (IASTIdExpression)((IASTEqualsInitializer)c.getInitializer()).getInitializerClause()).getName().getBinding() instanceof CPPParameter) || e.getName().toString().compareTo(paraName) != 0 || this.checkParent(alwaysFalse, a.getParent(), a.getParent()) == 1) continue;
                return true;
            }
            if (!(a.getBinding() instanceof CVariable) || !(((CVariable)a.getBinding()).getType() instanceof ICPPReferenceType)) continue;
            c = null;
            if (!(((CVariable)a.getBinding()).getDefinition().getParent() instanceof IASTDeclarator) || !((c = (IASTDeclarator)((CVariable)a.getBinding()).getDefinition().getParent()).getInitializer() instanceof IASTEqualsInitializer) || c.getInitializer() == null || !(((IASTEqualsInitializer)c.getInitializer()).getInitializerClause() instanceof IASTIdExpression) || !((e = (IASTIdExpression)((IASTEqualsInitializer)c.getInitializer()).getInitializerClause()).getName().getBinding() instanceof IParameter) || e.getName().toString().compareTo(paraName) != 0 || this.checkParent(alwaysFalse, a.getParent(), a.getParent()) == 1) continue;
            return true;
        }
        return false;
    }

    private boolean checkDeclar(int conditionLine, String paraName, IASTExpression c, ArrayList<LineNumber> alwaysFalse, boolean c_lang) {
        IASTStatement exp = this.getCondition((IASTNode)c);
        return this.checkPrevScope((IASTNode)exp, conditionLine, paraName, alwaysFalse, c_lang);
    }

    private boolean checkPrevScope(IASTNode exp, int conditionLine, String paraName, ArrayList<LineNumber> alwaysFalse, boolean c_lang) {
        if (exp instanceof IASTTranslationUnit) {
            return false;
        }
        if (exp instanceof IASTFunctionDefinition) {
            return false;
        }
        if (exp instanceof IASTCompoundStatement) {
            IASTStatement[] arr;
            IASTStatement[] iASTStatementArray = arr = ((IASTCompoundStatement)exp).getStatements();
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement t = iASTStatementArray[n2];
                if (t instanceof IASTDeclarationStatement && this.check1(t, paraName, alwaysFalse, c_lang, conditionLine)) {
                    return true;
                }
                ++n2;
            }
            return this.checkPrevScope(exp.getParent(), conditionLine, paraName, alwaysFalse, c_lang);
        }
        return this.checkPrevScope(exp.getParent(), conditionLine, paraName, alwaysFalse, c_lang);
    }

    private boolean check1(IASTStatement t, String paraName, ArrayList<LineNumber> alwaysFalse, boolean c_lang, int conditionLine) {
        if (((IASTDeclarationStatement)t).getDeclaration() instanceof IASTSimpleDeclaration) {
            IASTDeclarator[] arr;
            IASTDeclarator[] iASTDeclaratorArray = arr = ((IASTSimpleDeclaration)((IASTDeclarationStatement)t).getDeclaration()).getDeclarators();
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName var;
                IASTUnaryExpression e;
                IASTDeclarator d = iASTDeclaratorArray[n2];
                if (!c_lang ? d.getFileLocation().getEndingLineNumber() <= conditionLine && d.getName().getBinding() != null && d.getName().getBinding() instanceof CPPVariable && ((CPPVariable)d.getName().getBinding()).getType() != null && ((CPPVariable)d.getName().getBinding()).getType() instanceof IPointerType && d.getInitializer() != null && d.getInitializer() instanceof IASTEqualsInitializer && ((IASTEqualsInitializer)d.getInitializer()).getInitializerClause() instanceof IASTUnaryExpression && (e = (IASTUnaryExpression)((IASTEqualsInitializer)d.getInitializer()).getInitializerClause()).getOperator() == 5 && e.getOperand() instanceof IASTIdExpression && (var = ((IASTIdExpression)e.getOperand()).getName()).getBinding() instanceof CPPParameter && var.toString().compareTo(paraName) == 0 && this.checkParent(alwaysFalse, (IASTNode)t, (IASTNode)t) != 1 : d.getFileLocation().getEndingLineNumber() <= conditionLine && !(d.getName().getBinding() instanceof ProblemBinding) && d.getName().getBinding() instanceof CVariable && (CVariable)d.getName().getBinding() != null && ((CVariable)d.getName().getBinding()).getType() instanceof IPointerType && d.getInitializer() != null && d.getInitializer() instanceof IASTEqualsInitializer && ((IASTEqualsInitializer)d.getInitializer()).getInitializerClause() instanceof IASTUnaryExpression && (e = (IASTUnaryExpression)((IASTEqualsInitializer)d.getInitializer()).getInitializerClause()).getOperator() == 5 && e.getOperand() instanceof IASTIdExpression && (var = ((IASTIdExpression)e.getOperand()).getName()).getBinding() instanceof IParameter && var.toString().compareTo(paraName) == 0 && this.checkParent(alwaysFalse, (IASTNode)t, (IASTNode)t) != 1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private IASTStatement getCondition(IASTNode s) {
        if (s instanceof IASTIfStatement || s instanceof IASTForStatement || s instanceof IASTWhileStatement || s instanceof IASTSwitchStatement || s instanceof IASTLabelStatement) {
            return (IASTStatement)s;
        }
        return this.getCondition(s.getParent());
    }

    private boolean checkPointer(int conditionLine, String paraName, String funcName, ArrayList<LineNumber> alwaysFalse, List<IASTBinaryExpression> tmpBinaryExpression) {
        for (IASTBinaryExpression t : tmpBinaryExpression) {
            if (!this.checkPointerValidate(conditionLine, paraName, t, funcName, alwaysFalse)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPointerValidate(int conditionLine, String paraName, IASTBinaryExpression t, String funcName, ArrayList<LineNumber> alwaysFalse) {
        if (this.checkValidate4((IASTNode)t, conditionLine, funcName)) {
            ConditionResult res = new ConditionResult();
            res.Set_result(false);
            this.checkPointerValidate2((IASTExpression)t, paraName, res);
            if (res.get_result()) {
                return this.checkParent(alwaysFalse, (IASTNode)t, (IASTNode)t) != 1;
            }
            return false;
        }
        return false;
    }

    private void checkPointerValidate2(IASTExpression c, String paraName, ConditionResult res) {
        if (res.get_result()) {
            return;
        }
        if (c instanceof IASTUnaryExpression) {
            if (((IASTUnaryExpression)c).getOperand() instanceof IASTIdExpression) {
                if (((IASTUnaryExpression)c).getOperator() == 5) {
                    IASTIdExpression a = (IASTIdExpression)((IASTUnaryExpression)c).getOperand();
                    if (a.getName().toString().equals(paraName) && a.getName().getBinding() instanceof IParameter) {
                        res.Set_result(true);
                        return;
                    }
                } else if (((IASTUnaryExpression)c).getOperand() instanceof IASTUnaryExpression) {
                    this.checkPointerValidate2(((IASTUnaryExpression)c).getOperand(), paraName, res);
                } else if (((IASTUnaryExpression)c).getOperand() instanceof IASTBinaryExpression) {
                    this.checkPointerValidate2(((IASTUnaryExpression)c).getOperand(), paraName, res);
                }
            }
        } else if (c instanceof IASTBinaryExpression) {
            if (((IASTBinaryExpression)c).getOperand1() instanceof IASTUnaryExpression) {
                this.checkPointerValidate2(((IASTBinaryExpression)c).getOperand1(), paraName, res);
            }
            if (res.get_result()) {
                return;
            }
            if (((IASTBinaryExpression)c).getOperand2() instanceof IASTUnaryExpression) {
                this.checkPointerValidate2(((IASTBinaryExpression)c).getOperand2(), paraName, res);
            }
        }
        if (res.get_result()) {
            return;
        }
    }

    private boolean paraChange(String funcName, int conditionLine, String paraName, IASTExpression c, ArrayList<LineNumber> alwaysFalse, List<IASTName> assignOperands) {
        return this.paraChangeCheck(funcName, conditionLine, paraName, assignOperands, alwaysFalse);
    }

    private boolean paraChangeCheck(String funcName, int conditionLine, String paraName, List<IASTName> assignOperands, ArrayList<LineNumber> alwaysFalse) {
        for (IASTName n : assignOperands) {
            if (!this.changeCheck1(conditionLine, paraName, n, funcName) || this.checkParent(alwaysFalse, n.getParent(), n.getParent()) == 1) continue;
            return true;
        }
        return false;
    }

    private boolean changeCheck1(int conditionLine, String paraName, IASTName n, String funcName) {
        return n.getBinding() instanceof IParameter && n.toString().compareTo(paraName) == 0 && this.checkValidate4(n.getParent(), conditionLine, funcName);
    }

    private boolean checkValidate2(int conditionLine, String paraName, String funcName, ArrayList<LineNumber> alwaysFalse) {
        List<IASTFunctionCallExpression> tmpFuncCalls = this.visitor.getFunctionCalls();
        for (IASTFunctionCallExpression t : tmpFuncCalls) {
            if (!this.checkValidate3(conditionLine, paraName, t, funcName, alwaysFalse)) continue;
            return false;
        }
        return true;
    }

    private boolean checkValidate3(int conditionLine, String paraName, IASTFunctionCallExpression t, String funcName, ArrayList<LineNumber> alwaysFalse) {
        if (this.checkValidate4((IASTNode)t, conditionLine, funcName)) {
            IASTInitializerClause[] arg;
            IASTInitializerClause[] iASTInitializerClauseArray = arg = t.getArguments();
            int n = arg.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause a = iASTInitializerClauseArray[n2];
                if (a instanceof IASTUnaryExpression && ((IASTUnaryExpression)a).getOperator() == 5 && ((IASTUnaryExpression)a).getOperand() instanceof IASTIdExpression && ((IASTIdExpression)((IASTUnaryExpression)a).getOperand()).getName().toString().equals(paraName) && ((IASTIdExpression)((IASTUnaryExpression)a).getOperand()).getName().getBinding() instanceof IParameter && this.checkParent(alwaysFalse, (IASTNode)t, (IASTNode)t) != 1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkValidate4(IASTNode t, int conditionLine, String funcName) {
        if (t instanceof IASTTranslationUnit) {
            return false;
        }
        if (t.getFileLocation().getStartingLineNumber() >= conditionLine) {
            return false;
        }
        if (t instanceof IASTFunctionDefinition) {
            return ((IASTFunctionDefinition)t).getDeclarator().getName().toString().equals(funcName);
        }
        return this.checkValidate4(t.getParent(), conditionLine, funcName);
    }

    private int checkParent(ArrayList<LineNumber> list, IASTNode s, IASTNode sExist) {
        block9: {
            if (s instanceof IASTFunctionDefinition) {
                return -1;
            }
            if (!(s instanceof IASTIfStatement) && !(s instanceof IASTForStatement) && !(s instanceof IASTWhileStatement) && !(s instanceof IASTSwitchStatement) && !(s instanceof IASTCaseStatement) && !(s instanceof IASTLabelStatement)) break block9;
            if (s instanceof IASTSwitchStatement) {
                IASTStatement[] stmts;
                IASTCompoundStatement SwitchBody = (IASTCompoundStatement)((IASTSwitchStatement)s).getBody();
                IASTStatement[] iASTStatementArray = stmts = SwitchBody.getStatements();
                int n = stmts.length;
                int n2 = 0;
                while (n2 < n) {
                    double line1;
                    double line2;
                    IASTStatement st = iASTStatementArray[n2];
                    if (st instanceof IASTCaseStatement && (line2 = this.getNextCaseLine(line1 = (double)st.getFileLocation().getStartingLineNumber(), stmts)) != -1.0 && (double)sExist.getFileLocation().getStartingLineNumber() >= line1 && (double)sExist.getFileLocation().getStartingLineNumber() <= line2) {
                        for (LineNumber n3 : list) {
                            if (line1 != (double)n3.get_line_number()) continue;
                            return 1;
                        }
                    }
                    if (st instanceof IASTDefaultStatement) {
                        for (LineNumber n4 : list) {
                            if (st.getFileLocation().getStartingLineNumber() != n4.get_line_number()) continue;
                            return 1;
                        }
                    }
                    ++n2;
                }
            } else {
                for (LineNumber n : list) {
                    if (s.getFileLocation().getStartingLineNumber() != n.get_line_number()) continue;
                    return 1;
                }
            }
        }
        return this.checkParent(list, s.getParent(), sExist);
    }

    private double getNextCaseLine(double line1, IASTStatement[] stmts) {
        IASTStatement[] iASTStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement st = iASTStatementArray[n2];
            if ((st instanceof IASTCaseStatement || st instanceof IASTDefaultStatement) && (double)st.getFileLocation().getStartingLineNumber() > line1) {
                return st.getFileLocation().getStartingLineNumber();
            }
            ++n2;
        }
        return -1.0;
    }

    private int checkParentTruthness(ArrayList<LineNumber> list, IASTNode s) {
        if (s instanceof IASTTranslationUnit) {
            return -1;
        }
        if (s instanceof IASTFunctionDefinition) {
            return 1;
        }
        if (s instanceof IASTIfStatement) {
            for (LineNumber n : list) {
                if (s.getFileLocation().getStartingLineNumber() != n.get_line_number()) continue;
                return 1;
            }
            return -1;
        }
        return this.checkParentTruthness(list, s.getParent());
    }

    private boolean checkResult(IASTLiteralExpression operand1, IASTLiteralExpression operand2, int operator, ConditionResult always) {
        boolean bRetVal = false;
        if (operand1 != null && operand2 != null && always.get_result()) {
            int int_op1 = 0;
            int int_op2 = 0;
            float float_op1 = 0.0f;
            float float_op2 = 0.0f;
            switch (operand1.getKind()) {
                case 0: {
                    String sOperand1 = new String(operand1.getValue());
                    if (sOperand1.startsWith("0x")) {
                        sOperand1 = sOperand1.substring(2);
                        int_op1 = Integer.parseInt(sOperand1, 16);
                        break;
                    }
                    if (sOperand1.startsWith("0") && sOperand1.length() > 1) {
                        sOperand1 = sOperand1.substring(1);
                        int_op1 = Integer.parseInt(sOperand1, 8);
                        break;
                    }
                    int_op1 = Integer.parseInt(sOperand1, 10);
                    break;
                }
                case 1: {
                    float_op1 = Float.parseFloat(new String(operand1.getValue()));
                }
            }
            switch (operand2.getKind()) {
                case 0: {
                    String sOperand2 = new String(operand2.getValue());
                    if (sOperand2.startsWith("0x")) {
                        sOperand2 = sOperand2.substring(2);
                        int_op2 = Integer.parseInt(sOperand2, 16);
                        break;
                    }
                    if (sOperand2.startsWith("0") && sOperand2.length() > 1) {
                        sOperand2 = sOperand2.substring(1);
                        int_op2 = Integer.parseInt(sOperand2, 8);
                        break;
                    }
                    int_op2 = Integer.parseInt(sOperand2, 10);
                    break;
                }
                case 1: {
                    float_op2 = Float.parseFloat(new String(operand2.getValue()));
                }
            }
            switch (operator) {
                case 1: 
                case 18: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 * int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 * float_op1 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() != 1) break;
                    bRetVal = float_op1 * float_op2 != 0.0f;
                    break;
                }
                case 2: 
                case 19: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 / int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 / float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() != 1) break;
                    bRetVal = float_op1 / float_op2 != 0.0f;
                    break;
                }
                case 3: 
                case 20: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 % int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 % float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() != 1) break;
                    bRetVal = float_op1 % float_op2 != 0.0f;
                    break;
                }
                case 4: 
                case 21: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 + int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 - float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() != 1) break;
                    bRetVal = float_op1 + float_op2 != 0.0f;
                    break;
                }
                case 5: 
                case 22: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 - int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 - float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() != 1) break;
                    bRetVal = float_op1 - float_op2 != 0.0f;
                    break;
                }
                case 6: 
                case 23: {
                    if (operand1.getKind() != 0 || operand2.getKind() != 0) break;
                    bRetVal = int_op1 << int_op2 != 0;
                    break;
                }
                case 7: 
                case 24: {
                    if (operand1.getKind() != 0 || operand2.getKind() != 0) break;
                    bRetVal = int_op1 >> int_op2 != 0;
                    break;
                }
                case 8: {
                    String string_op2;
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 < int_op2;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 < float_op2;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 < float_op2;
                        break;
                    }
                    if (operand1.getKind() == 2) {
                        String string_op22;
                        String string_op1 = new String(operand1.getValue());
                        return string_op1.compareTo(string_op22 = new String(operand2.getValue())) < 0;
                    }
                    if (operand1.getKind() != 3) break;
                    String string_op1 = new String(operand1.getValue());
                    return string_op1.compareTo(string_op2 = new String(operand2.getValue())) < 0;
                }
                case 9: {
                    String string_op2;
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            if (operand2.getKind() == 0) {
                                bRetVal = int_op1 > int_op2;
                                break;
                            }
                            if (operand2.getKind() != 1) break;
                            bRetVal = float_op1 > float_op2;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 > float_op2;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 > float_op2;
                        break;
                    }
                    if (operand1.getKind() == 2) {
                        String string_op23;
                        String string_op1 = new String(operand1.getValue());
                        return string_op1.compareTo(string_op23 = new String(operand2.getValue())) > 0;
                    }
                    if (operand1.getKind() != 3) break;
                    String string_op1 = new String(operand1.getValue());
                    return string_op1.compareTo(string_op2 = new String(operand2.getValue())) > 0;
                }
                case 10: {
                    String string_op2;
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 <= int_op2;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 <= float_op2;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 <= float_op2;
                        break;
                    }
                    if (operand1.getKind() == 2) {
                        String string_op24;
                        String string_op1 = new String(operand1.getValue());
                        return string_op1.compareTo(string_op24 = new String(operand2.getValue())) < 0 || string_op1.equals(string_op24);
                    }
                    if (operand1.getKind() != 3) break;
                    String string_op1 = new String(operand1.getValue());
                    return string_op1.compareTo(string_op2 = new String(operand2.getValue())) < 0 || string_op1.equals(string_op2);
                }
                case 11: {
                    String string_op2;
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 >= int_op2;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 >= float_op2;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 >= float_op2;
                        break;
                    }
                    if (operand1.getKind() == 2) {
                        String string_op25;
                        String string_op1 = new String(operand1.getValue());
                        return string_op1.compareTo(string_op25 = new String(operand2.getValue())) > 0 || string_op1.equals(string_op25);
                    }
                    if (operand1.getKind() != 3) break;
                    String string_op1 = new String(operand1.getValue());
                    return string_op1.compareTo(string_op2 = new String(operand2.getValue())) > 0 || string_op1.equals(string_op2);
                }
                case 12: 
                case 25: {
                    if (operand1.getKind() != 0 || operand2.getKind() != 0) break;
                    bRetVal = (int_op1 & int_op2) != 0;
                    break;
                }
                case 13: 
                case 26: {
                    if (operand1.getKind() != 0 || operand2.getKind() != 0) break;
                    bRetVal = (int_op1 ^ int_op2) != 0;
                    break;
                }
                case 14: {
                    if (operand1.getKind() != 0 || operand2.getKind() != 0) break;
                    bRetVal = (int_op1 | int_op2) != 0;
                    break;
                }
                case 15: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 != 0 && int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 != 0.0f && float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 != 0.0f && float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() == 2) {
                        String string_op1 = new String(operand1.getValue());
                        String string_op2 = new String(operand2.getValue());
                        return !string_op1.equals(null) && !string_op2.equals(null);
                    }
                    if (operand1.getKind() == 3) {
                        return !operand1.getValue().equals(Character.valueOf('\u0000')) && !operand2.getValue().equals(Character.valueOf('\u0000'));
                    }
                    if (operand1.getKind() == 5 && operand2.getKind() == 5) {
                        return true;
                    }
                    if (operand1.getKind() != 6 && operand2.getKind() != 6) break;
                    return false;
                }
                case 16: 
                case 27: {
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 != 0 || int_op2 != 0;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 != 0.0f || float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 != 0.0f || float_op2 != 0.0f;
                        break;
                    }
                    if (operand1.getKind() == 2) {
                        String string_op1 = new String(operand1.getValue());
                        String string_op2 = new String(operand2.getValue());
                        return !string_op1.equals(null) || !string_op2.equals(null);
                    }
                    if (operand1.getKind() == 3) {
                        return !operand1.getValue().equals(Character.valueOf('\u0000')) || !operand2.getValue().equals(Character.valueOf('\u0000'));
                    }
                    if (operand1.getKind() == 5 || operand2.getKind() == 5) {
                        return true;
                    }
                    if (operand1.getKind() != 6 || operand2.getKind() != 6) break;
                    return false;
                }
                case 17: {
                    switch (operand2.getKind()) {
                        case 0: {
                            bRetVal = int_op2 != 0;
                            break;
                        }
                        case 1: {
                            bRetVal = float_op2 != 0.0f;
                        }
                    }
                    break;
                }
                case 28: {
                    String string_op2;
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 == int_op2;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 == float_op2;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 == float_op2;
                        break;
                    }
                    if (operand1.getKind() != 5 && operand1.getKind() != 6) break;
                    String string_op1 = new String(operand1.getValue());
                    return string_op1.equals(string_op2 = new String(operand2.getValue()));
                }
                case 29: {
                    String string_op2;
                    if (operand1.getKind() == 0) {
                        if (operand2.getKind() == 0) {
                            bRetVal = int_op1 != int_op2;
                            break;
                        }
                        if (operand2.getKind() != 1) break;
                        bRetVal = float_op1 != float_op2;
                        break;
                    }
                    if (operand1.getKind() == 1) {
                        bRetVal = float_op1 != float_op2;
                        break;
                    }
                    if (operand1.getKind() != 5 && operand1.getKind() != 6) break;
                    String string_op1 = new String(operand1.getValue());
                    return !string_op1.equals(string_op2 = new String(operand2.getValue()));
                }
            }
        }
        return bRetVal;
    }

    public void MarkCallToUser(IASTFunctionCallExpression tmpFunc, String commentInfo) throws CoreException, DOMException {
        if (commentInfo.trim().compareTo("") != 0) {
            this.markComment(tmpFunc, commentInfo, tmpFunc.getFileLocation().getEndingLineNumber(), MarkerInfoConstants.FunctionSpecializationComment.getType());
        }
        commentInfo = "";
    }

    private boolean checkIfSystem(String functionName) {
        if (functionName.equals("fscanf")) {
            return true;
        }
        if (functionName.equals("main()")) {
            return true;
        }
        if (functionName.equals("exit")) {
            return true;
        }
        if (functionName.equals("strcmp")) {
            return true;
        }
        if (functionName.equals("open")) {
            return true;
        }
        if (functionName.equals("close")) {
            return true;
        }
        if (functionName.equals("fopen")) {
            return true;
        }
        if (functionName.equals("fclose")) {
            return true;
        }
        if (functionName.equals("fprintf")) {
            return true;
        }
        if (functionName.equals("printf")) {
            return true;
        }
        if (functionName.equals("scanf")) {
            return true;
        }
        if (functionName.equals("srand")) {
            return true;
        }
        return functionName.equals("read");
    }

    private boolean areBig(IASTDeclaration[] decs) {
        long size = 0L;
        IASTDeclaration[] iASTDeclarationArray = decs;
        int n = decs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration dec = iASTDeclarationArray[n2];
            if (dec instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] declarators;
                IASTSimpleDeclaration simpleDec = (IASTSimpleDeclaration)dec;
                IASTDeclarator[] iASTDeclaratorArray = declarators = simpleDec.getDeclarators();
                int n3 = declarators.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator declarator = iASTDeclaratorArray[n4];
                    IASTName name = declarator.getName();
                    IBinding binding = name.resolveBinding();
                    if (binding instanceof IField) {
                        IField field = (IField)binding;
                        IType type = field.getType();
                        if (type instanceof IArrayType) {
                            if (((IArrayType)type).getSize().numericalValue() != null) {
                                size += ((IArrayType)type).getSize().numericalValue().longValue();
                            }
                        } else {
                            ++size;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return size >= (long)NUM_OF_ELL_IN_STRU;
    }

    private boolean assignmentIsConstant(IASTExpression expression) {
        if (expression instanceof IASTLiteralExpression) {
            return true;
        }
        if (expression instanceof IASTBinaryExpression) {
            while (expression instanceof IASTBinaryExpression) {
                IASTBinaryExpression binExp = (IASTBinaryExpression)expression;
                if (binExp.getOperator() != 17) break;
                expression = binExp.getOperand2();
            }
            if (expression instanceof IASTLiteralExpression) {
                return true;
            }
        }
        return false;
    }

    private boolean couldChange(IASTName name, IASTExpression expression) {
        IASTName tmpName;
        if (expression instanceof IASTUnaryExpression) {
            IASTExpression tmpExp;
            IASTUnaryExpression unExp = (IASTUnaryExpression)expression;
            if ((unExp.getOperator() == 5 || unExp.getOperator() == 10 || unExp.getOperator() == 9 || unExp.getOperator() == 1 || unExp.getOperator() == 0) && (tmpExp = unExp.getOperand()) instanceof IASTIdExpression) {
                tmpName = ((IASTIdExpression)tmpExp).getName();
                if (name.resolveBinding().equals(tmpName.resolveBinding()) && name.getRawSignature().equals(tmpName.getRawSignature())) {
                    return true;
                }
            }
            if (unExp.getOperator() == 7) {
                return this.couldChange(name, unExp.getOperand());
            }
        }
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)expression;
            if (binExp.isLValue()) {
                IASTExpression operand1 = binExp.getOperand1();
                if (operand1 instanceof IASTIdExpression) {
                    tmpName = ((IASTIdExpression)operand1).getName();
                    if (name.resolveBinding().equals(tmpName.resolveBinding()) && name.getRawSignature().equals(tmpName.getRawSignature())) {
                        return true;
                    }
                } else if (operand1 instanceof IASTArraySubscriptExpression) {
                    IASTExpression arrayExp = ((IASTArraySubscriptExpression)operand1).getArrayExpression();
                    if (arrayExp instanceof IASTIdExpression) {
                        IASTName tmpName2 = ((IASTIdExpression)arrayExp).getName();
                        if (name.resolveBinding().equals(tmpName2.resolveBinding()) && name.getRawSignature().equals(tmpName2.getRawSignature())) {
                            return true;
                        }
                    }
                } else {
                    return this.couldChange(name, binExp.getOperand2());
                }
            }
            return this.couldChange(name, binExp.getOperand1()) | this.couldChange(name, binExp.getOperand2());
        }
        if (expression instanceof IASTFunctionCallExpression) {
            IASTInitializerClause[] args;
            IASTInitializerClause[] iASTInitializerClauseArray = args = ((IASTFunctionCallExpression)expression).getArguments();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                if (arg instanceof IASTExpression && this.couldChange(name, (IASTExpression)arg)) {
                    return true;
                }
                if (arg instanceof IASTCastExpression && this.couldChange(name, ((IASTCastExpression)arg).getOperand())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void generateAlgebricSimpComment(List<IASTBinaryExpression> binExps) {
        HashMap<IASTLiteralExpression, IASTBinaryExpression> litExps = new HashMap<IASTLiteralExpression, IASTBinaryExpression>();
        for (IASTBinaryExpression binExp : binExps) {
            boolean mark = false;
            litExps.clear();
            if (binExp.getOperator() == 5 || binExp.getOperator() == 4) {
                if (binExp.getOperand1() instanceof IASTLiteralExpression && binExp.getOperand1().getRawSignature().equals("0")) {
                    litExps.put((IASTLiteralExpression)binExp.getOperand1(), binExp);
                    mark = true;
                }
                if (binExp.getOperand2() instanceof IASTLiteralExpression && binExp.getOperand2().getRawSignature().equals("0")) {
                    litExps.put((IASTLiteralExpression)binExp.getOperand2(), binExp);
                    mark = true;
                }
            }
            if (binExp.getOperator() == 1) {
                if (binExp.getOperand1() instanceof IASTLiteralExpression && (binExp.getOperand1().getRawSignature().equals("0") || binExp.getOperand1().getRawSignature().equals("1"))) {
                    litExps.put((IASTLiteralExpression)binExp.getOperand1(), binExp);
                    mark = true;
                }
                if (binExp.getOperand2() instanceof IASTLiteralExpression && (binExp.getOperand2().getRawSignature().equals("0") || binExp.getOperand2().getRawSignature().equals("1"))) {
                    litExps.put((IASTLiteralExpression)binExp.getOperand2(), binExp);
                    mark = true;
                }
            }
            if ((binExp.getOperator() == 2 || binExp.getOperator() == 3) && binExp.getOperand2() instanceof IASTLiteralExpression && binExp.getOperand2().getRawSignature().equals("1")) {
                litExps.put((IASTLiteralExpression)binExp.getOperand2(), binExp);
                mark = true;
            }
            if (binExp.getOperator() == 12 || binExp.getOperator() == 14) {
                if (binExp.getOperand1() instanceof IASTLiteralExpression && (binExp.getOperand1().getRawSignature().equals("true") || binExp.getOperand1().getRawSignature().equals("false"))) {
                    litExps.put((IASTLiteralExpression)binExp.getOperand1(), binExp);
                    mark = true;
                }
                if (binExp.getOperand2() instanceof IASTLiteralExpression && (binExp.getOperand2().getRawSignature().equals("true") || binExp.getOperand2().getRawSignature().equals("false"))) {
                    litExps.put((IASTLiteralExpression)binExp.getOperand2(), binExp);
                    mark = true;
                }
            }
            if (!mark) continue;
            for (Map.Entry litExp : litExps.entrySet()) {
                try {
                    this.markComment(litExp.getKey(), litExp.getValue(), ((IASTLiteralExpression)litExp.getKey()).getFileLocation().getEndingLineNumber(), MarkerInfoConstants.algebricSimpComment.getType());
                }
                catch (DOMException ex) {
                    ex.printStackTrace();
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void generateByValueComments(List<IASTFunctionDefinition> funcDecs) throws DOMException, CoreException {
        if (funcDecs != null) {
            for (IASTFunctionDefinition tmpFunc : funcDecs) {
                tmpFunc.accept((ASTVisitor)new VisitNames1());
            }
        }
    }

    private void generateClassInliningComment(List<IASTCompositeTypeSpecifier> classSpecs) {
        for (IASTCompositeTypeSpecifier classSpec : classSpecs) {
            IASTDeclaration[] decs;
            IASTDeclaration[] iASTDeclarationArray = decs = classSpec.getMembers();
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration dec = iASTDeclarationArray[n2];
                if (dec instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] declarators;
                    IASTSimpleDeclaration simpleDec = (IASTSimpleDeclaration)dec;
                    IASTDeclarator[] iASTDeclaratorArray = declarators = simpleDec.getDeclarators();
                    int n3 = declarators.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclarator declarator = iASTDeclaratorArray[n4];
                        IASTName name = declarator.getName();
                        IBinding binding = name.resolveBinding();
                        if (binding instanceof IVariable) {
                            IVariable var = (IVariable)binding;
                            try {
                                if (!(var.getType() instanceof IArrayType || var.getType() instanceof IPointerType || var.getType() instanceof IBasicType || var.getType().toString().equalsIgnoreCase("Attempt to use symbol failed: string"))) {
                                    for (IASTCompositeTypeSpecifier classSpecifierElement : classSpecs) {
                                        if (classSpecifierElement.getName().equals(classSpec.getName())) continue;
                                        this.markComment(simpleDec.getDeclSpecifier(), new Object[]{declarator, new IASTCompositeTypeSpecifier[]{classSpec, classSpecifierElement}}, simpleDec.getFileLocation().getStartingLineNumber(), MarkerInfoConstants.classInliningComment.getType());
                                    }
                                }
                            }
                            catch (DOMException ex) {
                                ex.printStackTrace();
                            }
                            catch (CoreException ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void generateConstantPropagationComment(List<IASTName> names, List<IASTExpression> expressions) {
        int i = 0;
        for (IASTExpression expression : expressions) {
            IASTName name = names.get(i);
            ++i;
            if (!this.assignmentIsConstant(expression)) continue;
            IASTStatement inLoop = this.inLoop(expression);
            ConstPropCheckVisitor cPCVisitor = new ConstPropCheckVisitor(name, expression, inLoop);
            if (inLoop == null) {
                if (this.whereToStart(expression) != null) {
                    this.whereToStart(expression).accept((ASTVisitor)cPCVisitor);
                }
            } else if (inLoop instanceof IASTForStatement) {
                if (!(((IASTForStatement)inLoop).getInitializerStatement() == null || ((IASTForStatement)inLoop).getInitializerStatement().getRawSignature() == null || expression.getRawSignature() == null || ((IASTForStatement)inLoop).getIterationExpression() == null || ((IASTForStatement)inLoop).getIterationExpression().getFileLocation() == null || ((IASTForStatement)inLoop).getInitializerStatement().getRawSignature().contains(expression.getRawSignature()) && ((IASTForStatement)inLoop).getIterationExpression().getFileLocation().getEndingLineNumber() >= expression.getFileLocation().getEndingLineNumber() || this.whereToStart(expression) == null)) {
                    this.whereToStart(expression).accept((ASTVisitor)cPCVisitor);
                }
            } else if (this.whereToStart(expression) != null) {
                this.whereToStart(expression).accept((ASTVisitor)cPCVisitor);
            }
            if (!cPCVisitor.getCouldPropagate()) continue;
            try {
                this.markComment(name, new Object[]{cPCVisitor.expression, cPCVisitor.getExpressions()}, name.getFileLocation().getEndingLineNumber(), MarkerInfoConstants.constantPropagationComment.getType());
            }
            catch (DOMException ex) {
                ex.printStackTrace();
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void generateCopyPropagationComment(List<IASTName> names, List<IASTExpression> expressions) {
        int i = 0;
        for (IASTExpression expression : expressions) {
            ArrayList<IASTExpression> expressionsToChange = new ArrayList<IASTExpression>();
            IASTName name1 = names.get(i);
            ++i;
            IASTName name2 = this.isCopy(expression);
            if (name2 == null) continue;
            if (name1.getRawSignature().equals(name2.getRawSignature()) && name1.resolveBinding().equals(name2.resolveBinding())) {
                expressionsToChange.add(expression);
            }
            IASTStatement inLoop = this.inLoop(expression);
            CopyPropCheckVisitor cPCVisitor = new CopyPropCheckVisitor(name1, name2, expression, inLoop);
            if (inLoop == null) {
                if (this.whereToStart(expression) != null) {
                    this.whereToStart(expression).accept((ASTVisitor)cPCVisitor);
                }
            } else if (inLoop instanceof IASTForStatement) {
                if (!(((IASTForStatement)inLoop).getInitializerStatement() == null || ((IASTForStatement)inLoop).getIterationExpression() == null || expression.getFileLocation() == null || ((IASTForStatement)inLoop).getInitializerStatement().getRawSignature().contains(expression.getRawSignature()) && ((IASTForStatement)inLoop).getIterationExpression().getFileLocation().getEndingLineNumber() >= expression.getFileLocation().getEndingLineNumber() || this.whereToStart(expression) == null)) {
                    this.whereToStart(expression).accept((ASTVisitor)cPCVisitor);
                }
            } else if (this.whereToStart(expression) != null) {
                this.whereToStart(expression).accept((ASTVisitor)cPCVisitor);
            }
            if (cPCVisitor.getCouldPropagate()) {
                expressionsToChange.addAll(cPCVisitor.getExpressions());
            }
            if (expressionsToChange.size() <= 0) continue;
            try {
                this.markComment(name1, new Object[]{expression, expressionsToChange}, name1.getFileLocation().getEndingLineNumber(), MarkerInfoConstants.copyPropagationComment.getType());
            }
            catch (DOMException ex) {
                ex.printStackTrace();
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void generateDeadCodeElimComment(List<IASTFunctionDefinition> funcDefs) {
        for (IASTFunctionDefinition funcDef : funcDefs) {
            GetDeclaredVarsVisitor gDVVisitor = new GetDeclaredVarsVisitor();
            IASTStatement body = funcDef.getBody();
            body.accept((ASTVisitor)gDVVisitor);
            HashMap<IASTName, IASTDeclarationStatement> names = gDVVisitor.getDeclaredVars();
            for (Map.Entry<IASTName, IASTDeclarationStatement> entry : names.entrySet()) {
                DeadCodeCheckVisitor dCCVisitor = new DeadCodeCheckVisitor(entry.getKey());
                body.accept((ASTVisitor)dCCVisitor);
                if (!dCCVisitor.getCouldEliminate()) continue;
                try {
                    if (entry.getKey().getFileLocation() == null) continue;
                    this.markComment(entry.getKey(), entry.getValue(), entry.getKey().getFileLocation().getEndingLineNumber(), MarkerInfoConstants.deadCodeEliminationComment.getType());
                }
                catch (DOMException ex) {
                    ex.printStackTrace();
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void generateForCodeInvariantComments(List<IASTForStatement> forStmnts) throws CoreException, DOMException {
        if (forStmnts != null) {
            for (IASTForStatement forStmnt : forStmnts) {
                IASTStatement tmpExp = forStmnt.getBody();
                if (tmpExp instanceof IASTCompoundStatement) {
                    IASTStatement[] tmpStmnts;
                    IASTCompoundStatement tmpComStmnt = (IASTCompoundStatement)tmpExp;
                    IASTStatement[] iASTStatementArray = tmpStmnts = tmpComStmnt.getStatements();
                    int n = tmpStmnts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTStatement stmnt = iASTStatementArray[n2];
                        boolean cfr_ignored_0 = stmnt instanceof IASTDeclarationStatement;
                        ++n2;
                    }
                    continue;
                }
                if (!(tmpExp instanceof IASTDeclarationStatement)) continue;
                IASTDeclarationStatement tmpDec = (IASTDeclarationStatement)tmpExp;
                tmpDec.accept((ASTVisitor)new VisitDeclerators());
            }
        }
    }

    private void generateImplicitCastComments(List<IASTFunctionDefinition> funcDecs, IIndex index, IASTTranslationUnit ast) throws DOMException, InterruptedException, CoreException {
        block8: {
            if (funcDecs == null) break block8;
            Iterator<IASTFunctionDefinition> itr = funcDecs.iterator();
            while (itr.hasNext()) {
                IFunction tmpFuncBind = null;
                IASTFunctionDefinition tmpFunc = itr.next();
                IASTName tmpFuncDeclName = tmpFunc.getDeclarator().getName();
                if (!(tmpFuncDeclName.getParent().getParent() instanceof IASTFunctionDefinition) || !(tmpFuncDeclName.resolveBinding() instanceof IFunction)) continue;
                tmpFuncBind = (IFunction)tmpFuncDeclName.resolveBinding();
                IParameter[] tmpFuncDecParams = tmpFuncBind.getParameters();
                index.acquireReadLock();
                IIndexName[] tmpINames = index.findReferences((IBinding)tmpFuncBind);
                index.releaseReadLock();
                IASTNodeSelector tmpSelector = ast.getNodeSelector(ast.getFileLocation().getFileName());
                IIndexName[] iIndexNameArray = tmpINames;
                int n = tmpINames.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        IASTExpression tmpFuncArg;
                        int tmpLineNum;
                        IASTFunctionCallExpression tmpFuncCallExp;
                        block10: {
                            IASTName tmpFuncCallName;
                            IIndexName name = iIndexNameArray[n2];
                            if (!(tmpSelector.findNode(name.getNodeOffset(), name.getNodeLength()) instanceof IASTName) || (tmpFuncCallName = (IASTName)tmpSelector.findNode(name.getNodeOffset(), name.getNodeLength())) == null || tmpFuncCallName.getParent() == null || tmpFuncCallName.getParent().getParent() == null || !(tmpFuncCallName.getParent().getParent() instanceof IASTFunctionCallExpression) || (tmpFuncCallExp = (IASTFunctionCallExpression)tmpFuncCallName.getParent().getParent()) == null) break block9;
                            tmpLineNum = tmpFuncCallExp.getFileLocation().getStartingLineNumber();
                            if (!(tmpFuncCallExp.getParameterExpression() instanceof IASTExpressionList)) break block10;
                            IASTExpressionList tmpFuncArgsList = (IASTExpressionList)tmpFuncCallExp.getParameterExpression();
                            IASTExpression[] tmpFuncArgs = tmpFuncArgsList.getExpressions();
                            if (tmpFuncArgs.length != tmpFuncDecParams.length) break block9;
                            int i = 0;
                            while (i < tmpFuncArgs.length) {
                                block11: {
                                    block12: {
                                        String[] parts;
                                        if (ASTTypeUtil.getType((IType)tmpFuncArgs[i].getExpressionType(), (boolean)true).equals(ASTTypeUtil.getType((IType)tmpFuncDecParams[i].getType(), (boolean)true))) break block11;
                                        String str = ASTTypeUtil.getType((IType)tmpFuncArgs[i].getExpressionType(), (boolean)true);
                                        if (str == null || (parts = str.split(" ")).length <= 1) break block12;
                                        String part1 = parts[1];
                                        String TypeFunc = ASTTypeUtil.getType((IType)tmpFuncDecParams[i].getType(), (boolean)true);
                                        if (TypeFunc.equals(part1)) break block11;
                                    }
                                    this.markComment(tmpFuncArgs[i], tmpFuncDecParams[i], tmpLineNum, MarkerInfoConstants.implicitCastingComment.getType());
                                }
                                ++i;
                            }
                            break block9;
                        }
                        if (tmpFuncDecParams.length == 1 && (tmpFuncArg = tmpFuncCallExp.getParameterExpression()) != null && !ASTTypeUtil.getType((IType)tmpFuncArg.getExpressionType(), (boolean)true).equals(ASTTypeUtil.getType((IType)tmpFuncDecParams[0].getType(), (boolean)true))) {
                            this.markComment(tmpFuncArg, tmpFuncDecParams[0], tmpLineNum, MarkerInfoConstants.implicitCastingComment.getType());
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private void generateLockInvariantComments(List<IASTExpression> lockList) throws DOMException, CoreException {
        if (lockList != null) {
            for (IASTExpression tmpExp : lockList) {
                int tmpLineNum = tmpExp.getFileLocation().getStartingLineNumber();
                this.markComment(tmpExp, null, tmpLineNum, MarkerInfoConstants.insideCriticalSectionComment.getType());
            }
        }
    }

    private void generateStrengthReducComment(List<IASTBinaryExpression> binExps) {
        for (IASTBinaryExpression binExp : binExps) {
            IASTExpression op1;
            IASTExpression op2;
            boolean mark = false;
            String shift = "";
            boolean multiplication = false;
            int exponent = 0;
            boolean firstOperandIsPow2 = false;
            if ((binExp.getOperator() == 1 || binExp.getOperator() == 18 || binExp.getOperator() == 2 || binExp.getOperator() == 19) && (op2 = binExp.getOperand2()) instanceof IASTLiteralExpression && this.pwr2.containsValue(binExp.getOperand2().getRawSignature())) {
                exponent = Integer.parseInt(CommentsFactory.getKey(this.pwr2, op2.getRawSignature()).trim());
                if (binExp.getOperator() == 1 || binExp.getOperator() == 18) {
                    shift = "left " + exponent;
                    multiplication = true;
                } else {
                    shift = "right " + exponent;
                }
                mark = true;
            }
            if (binExp.getOperator() == 1 && (op1 = binExp.getOperand1()) instanceof IASTLiteralExpression && this.pwr2.containsValue(binExp.getOperand1().getRawSignature())) {
                firstOperandIsPow2 = true;
                exponent = Integer.parseInt(CommentsFactory.getKey(this.pwr2, op1.getRawSignature()).trim());
                shift = "left " + exponent;
                multiplication = true;
                mark = true;
            }
            if (!mark) continue;
            try {
                this.markComment(binExp, new Object[]{shift, multiplication, exponent, firstOperandIsPow2}, binExp.getFileLocation().getEndingLineNumber(), MarkerInfoConstants.strengthReducComment.getType());
            }
            catch (DOMException ex) {
                ex.printStackTrace();
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void generateStructSplittingReorderComment(List<IASTCompositeTypeSpecifier> structSpecs) {
        for (IASTCompositeTypeSpecifier structSpec : structSpecs) {
            IASTDeclaration[] decs = structSpec.getMembers();
            if (decs.length <= 1 || !this.areBig(decs)) continue;
            try {
                this.markComment(structSpec, null, structSpec.getFileLocation().getStartingLineNumber(), MarkerInfoConstants.structSplittingOrReorderComment.getType());
            }
            catch (DOMException ex) {
                ex.printStackTrace();
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    private IASTName getAssignmentOperand(IASTExpression expression) {
        IASTBinaryExpression tmp;
        IASTExpression exp = null;
        IASTName ret = null;
        if (expression instanceof IASTBinaryExpression) {
            tmp = (IASTBinaryExpression)expression;
            if (tmp.getOperator() == 17 || tmp.getOperator() == 25 || tmp.getOperator() == 27 || tmp.getOperator() == 26 || tmp.getOperator() == 19 || tmp.getOperator() == 22 || tmp.getOperator() == 20 || tmp.getOperator() == 18 || tmp.getOperator() == 21 || tmp.getOperator() == 23 || tmp.getOperator() == 24) {
                exp = tmp.getOperand1();
            }
        } else if (expression instanceof IASTUnaryExpression && ((tmp = (IASTUnaryExpression)expression).getOperator() == 10 || tmp.getOperator() == 9 || tmp.getOperator() == 1 || tmp.getOperator() == 10 || tmp.getOperator() == 0)) {
            exp = tmp.getOperand();
        }
        if (exp != null) {
            VisitNames2 vn = new VisitNames2();
            exp.accept((ASTVisitor)vn);
            ret = vn.getName();
        }
        return ret;
    }

    private void initializePwr2() {
        this.pwr2.put(1, "2");
        this.pwr2.put(2, "4");
        this.pwr2.put(3, "8");
        this.pwr2.put(4, "16");
        this.pwr2.put(5, "32");
        this.pwr2.put(6, "64");
        this.pwr2.put(7, "128");
        this.pwr2.put(8, "256");
        this.pwr2.put(9, "512");
        this.pwr2.put(10, "1024");
        this.pwr2.put(11, "2048");
        this.pwr2.put(12, "4096");
    }

    private IASTStatement inLoop(IASTExpression expression) {
        IASTNode parent = expression.getParent();
        while (!(parent instanceof IASTFunctionDefinition)) {
            if (parent instanceof IASTForStatement || parent instanceof IASTWhileStatement || parent instanceof IASTDoStatement) {
                return (IASTStatement)parent;
            }
            if (parent.getParent() == null) break;
            parent = parent.getParent();
        }
        return null;
    }

    private IASTName isCopy(IASTExpression expression) {
        IASTBinaryExpression binExp;
        if (expression instanceof IASTIdExpression) {
            return ((IASTIdExpression)expression).getName();
        }
        if (expression instanceof IASTBinaryExpression && (binExp = (IASTBinaryExpression)expression).getOperator() == 17) {
            return this.isCopy(binExp.getOperand2());
        }
        return null;
    }

    private boolean isUsed(IASTName name, IASTExpression expression) {
        IASTUnaryExpression unExp;
        if (expression instanceof IASTIdExpression) {
            IASTName tmpName = ((IASTIdExpression)expression).getName();
            if (name.resolveBinding().equals(tmpName.resolveBinding()) && name.getRawSignature().equals(tmpName.getRawSignature())) {
                return true;
            }
        }
        if (expression instanceof IASTUnaryExpression && (unExp = (IASTUnaryExpression)expression).getOperator() != 5 && unExp.getOperator() != 10 && unExp.getOperator() != 9 && unExp.getOperator() != 1 && unExp.getOperator() != 0 && unExp.getOperator() != 7) {
            return this.isUsed(name, unExp.getOperand());
        }
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)expression;
            if (binExp.isLValue()) {
                return this.isUsed(name, binExp.getOperand2());
            }
            return this.isUsed(name, binExp.getOperand1()) | this.isUsed(name, binExp.getOperand2());
        }
        if (expression instanceof IASTFunctionCallExpression) {
            IASTInitializerClause[] args;
            IASTInitializerClause[] iASTInitializerClauseArray = args = ((IASTFunctionCallExpression)expression).getArguments();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                if (arg instanceof IASTExpression && this.isUsed(name, (IASTExpression)arg)) {
                    return true;
                }
                if (arg instanceof IASTCastExpression && this.isUsed(name, ((IASTCastExpression)arg).getOperand())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void setMarkCommentData(IMarker Marker, String sAdvice, String sAdviceFix) {
        try {
            Marker.setAttribute("message", (Object)sAdvice);
            Marker.setAttribute("OcaMarkerAdviceFix", (Object)sAdviceFix);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void markComment(Object obj1, Object obj2, int lineNum, String commentType) throws CoreException, DOMException {
        if (obj1 != null) {
            final class CustomAnalysisReporter
            extends AnalysisReporter {
                CustomAnalysisReporter() {
                }

                public void reportProblem(ITranslationUnit TrUnit, IASTNode stmt, String extrainfo) {
                    super.reportProblem(TrUnit, stmt, extrainfo, extrainfo, extrainfo);
                    IMarker tmpMarker = this.getMarker();
                    try {
                        tmpMarker.setAttribute("message", (Object)extrainfo);
                        tmpMarker.setAttribute("OcaMarkerID", (Object)"cdt.code.comments.ccMarker");
                        tmpMarker.setAttribute("markerTranslationUnit", (Object)TrUnit);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            CustomAnalysisReporter AnalysisReporter2 = new CustomAnalysisReporter();
            String sMessage = "";
            if (commentType == MarkerInfoConstants.byValParamComment.getType() && obj1 instanceof IASTName && obj2 instanceof IASTParameterDeclaration) {
                IASTName tmpName = (IASTName)obj1;
                IParameter tmpParam = (IParameter)tmpName.resolveBinding();
                if (!(ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("int") || ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("unsigned int") || ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("long") || ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("unsigned long") || ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("char") || ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("unsigned char"))) {
                    sMessage = "Parameter '" + tmpParam.getName() + "' of type: '" + ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true) + "' is passed By-Value.";
                    AnalysisReporter2.reportProblem(this.tu, (IASTNode)tmpName, sMessage);
                    AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)MarkerInfoConstants.byValParamComment.getActionText());
                    AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.byValParamComment.getType());
                    AnalysisReporter2.getMarker().setAttribute("markerParameterDeclaration", obj2);
                }
            } else if (commentType == MarkerInfoConstants.FunctionSpecializationComment.getType() && obj1 instanceof IASTFunctionCallExpression && obj2 instanceof String) {
                IASTFunctionCallExpression tmpName = (IASTFunctionCallExpression)obj1;
                String commentText = (String)obj2;
                System.out.println("commentInfo: " + (String)obj2);
                sMessage = ((String)obj2).compareTo("") == 0 ? "Function invocation with constant parameters.\nConsider creating a new specialized version for this function in which the constant parameters\nare replaced by their constant values within the function body.\nThen, replace this call by a call to the specialized version without the constant parameters.\n\n Example before: \nint foo(int x,int y){\n if (y > MaxInt/2)\n  return x;\n else\n  return y;\n}\n...\n\n s=foo(x,5);\n\n Example after: \nint foo_y_5(int x){\n\treturn 5;\n}\n...\n s=foo_y_5(x);" : (String)obj2;
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)tmpName, sMessage);
                this.setMarkCommentData(AnalysisReporter2.getMarker(), MarkerInfoConstants.FunctionSpecializationComment.getType(), Examples.getFunctionSpecializationExample(commentText));
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)(String.valueOf(MarkerInfoConstants.FunctionSpecializationComment.getActionText()) + " : " + tmpName.getRawSignature()));
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.FunctionSpecializationComment.getType());
            } else if (commentType == MarkerInfoConstants.implicitCastingComment.getType() && obj1 instanceof IASTExpression && obj2 instanceof IParameter) {
                IASTExpression exp = (IASTExpression)obj1;
                IParameter tmpParam = (IParameter)obj2;
                if (!(ASTTypeUtil.getType((IType)exp.getExpressionType(), (boolean)true).equals("?") || ASTTypeUtil.getType((IType)exp.getExpressionType(), (boolean)true).equals("const char *") && ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true).equals("char *"))) {
                    sMessage = "'" + exp.getRawSignature() + "', of type: '" + ASTTypeUtil.getType((IType)exp.getExpressionType(), (boolean)true) + "', might be implicitly casted to type: '" + ASTTypeUtil.getType((IType)tmpParam.getType(), (boolean)true) + "'.";
                    AnalysisReporter2.reportProblem(this.tu, (IASTNode)exp, sMessage);
                    AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)MarkerInfoConstants.implicitCastingComment.getActionText());
                    AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.implicitCastingComment.getType());
                    AnalysisReporter2.getMarker().setAttribute("markerImplicitCastingExpression", (Object)exp);
                    AnalysisReporter2.getMarker().setAttribute("markerExplicitCastingType", (Object)tmpParam.getType());
                }
            } else if (commentType == MarkerInfoConstants.invariantCodeComment.getType() && obj1 instanceof IASTName && obj2 instanceof Object[]) {
                IASTName name = (IASTName)obj1;
                sMessage = "'" + name.getRawSignature() + "' possible Invariant Code.";
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)name, sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)MarkerInfoConstants.invariantCodeComment.getActionText());
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.invariantCodeComment.getType());
                AnalysisReporter2.getMarker().setAttribute("markerSimpleDeclaration", ((Object[])obj2)[1]);
                AnalysisReporter2.getMarker().setAttribute("markerForStatement", ((Object[])obj2)[0]);
            } else if (commentType == MarkerInfoConstants.insideCriticalSectionComment.getType()) {
                sMessage = "Global member idunces a synchronization barrier";
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)this.tu.getAST(), sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)MarkerInfoConstants.insideCriticalSectionComment.getActionText());
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.insideCriticalSectionComment.getType());
            } else if (commentType == MarkerInfoConstants.classInliningComment.getType() && obj1 instanceof IASTDeclSpecifier) {
                IASTDeclSpecifier declarationSpecifier = (IASTDeclSpecifier)obj1;
                sMessage = "'" + declarationSpecifier.getRawSignature() + "' " + MarkerInfoConstants.classInliningComment.getType() + "." + Examples.getClassInliningExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)declarationSpecifier, sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)MarkerInfoConstants.classInliningComment.getActionText());
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.classInliningComment.getType());
                IASTCompositeTypeSpecifier[] classSpecifiers = (IASTCompositeTypeSpecifier[])((Object[])obj2)[1];
                AnalysisReporter2.getMarker().setAttribute("markerClassSpec1", (Object)classSpecifiers[0]);
                AnalysisReporter2.getMarker().setAttribute("markerClassSpec2", (Object)classSpecifiers[1]);
                AnalysisReporter2.getMarker().setAttribute("markerDeclarator", ((Object[])obj2)[0]);
            } else if (commentType == MarkerInfoConstants.structSplittingOrReorderComment.getType() && obj1 instanceof IASTCompositeTypeSpecifier) {
                IASTCompositeTypeSpecifier structSpec = (IASTCompositeTypeSpecifier)obj1;
                sMessage = String.valueOf(MarkerInfoConstants.structSplittingOrReorderComment.getType()) + ". " + Examples.getStructureSplittingExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)structSpec, sMessage);
                AnalysisReporter2.getMarker().setAttribute("charStart", structSpec.getFileLocation().getNodeOffset());
                if (structSpec.getRawSignature().substring(0, 6).equalsIgnoreCase("struct")) {
                    AnalysisReporter2.getMarker().setAttribute("charEnd", structSpec.getFileLocation().getNodeOffset() + 6);
                } else if (structSpec.getRawSignature().substring(0, 7).equalsIgnoreCase("typedef")) {
                    AnalysisReporter2.getMarker().setAttribute("charEnd", structSpec.getFileLocation().getNodeOffset() + 7);
                }
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)MarkerInfoConstants.structSplittingOrReorderComment.getActionText());
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.structSplittingOrReorderComment.getType());
            } else if (commentType == MarkerInfoConstants.algebricSimpComment.getType() && obj1 instanceof IASTLiteralExpression && obj2 instanceof IASTBinaryExpression) {
                IASTLiteralExpression litExp = (IASTLiteralExpression)obj1;
                sMessage = String.valueOf(MarkerInfoConstants.algebricSimpComment.getType()) + ". " + Examples.getAlgebricSimpExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)litExp, sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)(String.valueOf(MarkerInfoConstants.algebricSimpComment.getActionText()) + " : " + "(" + litExp.getParent().getRawSignature() + ")"));
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.algebricSimpComment.getType());
                AnalysisReporter2.getMarker().setAttribute("markerLiteralExpression", obj1);
                AnalysisReporter2.getMarker().setAttribute("markerBinaryExpression", obj2);
            } else if (commentType == MarkerInfoConstants.strengthReducComment.getType() && obj1 instanceof IASTBinaryExpression) {
                IASTBinaryExpression binExp = (IASTBinaryExpression)obj1;
                Object[] object2Values = (Object[])obj2;
                sMessage = "Strength Reduction via Shifting " + (String)object2Values[0] + " Should be Considered. " + Examples.getStrengthReducExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)binExp, sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)(String.valueOf(MarkerInfoConstants.strengthReducComment.getActionText()) + " : " + binExp.getRawSignature()));
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.strengthReducComment.getType());
                AnalysisReporter2.getMarker().setAttribute("markerBinaryExpression", (Object)binExp);
                AnalysisReporter2.getMarker().setAttribute("markerIsMultiplication", object2Values[1]);
                AnalysisReporter2.getMarker().setAttribute("markerExponent", object2Values[2]);
                AnalysisReporter2.getMarker().setAttribute("firstOperandIsPow2", object2Values[3]);
            } else if (commentType == MarkerInfoConstants.constantPropagationComment.getType() && obj1 instanceof IASTName && obj2 instanceof Object[]) {
                IASTName name = (IASTName)obj1;
                Object[] experssionsInfo = (Object[])obj2;
                IASTExpression expression = (IASTExpression)experssionsInfo[0];
                ArrayList expressionsToChange = (ArrayList)experssionsInfo[1];
                sMessage = String.valueOf(MarkerInfoConstants.constantPropagationComment.getType()) + ". " + Examples.getConstantPropExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)name, sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)(String.valueOf(MarkerInfoConstants.constantPropagationComment.getActionText()) + " : " + name.getRawSignature()));
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.constantPropagationComment.getType());
                AnalysisReporter2.getMarker().setAttribute("markerExpression", (Object)expression);
                AnalysisReporter2.getMarker().setAttribute("markerExpressionsToChange", (Object)expressionsToChange);
                AnalysisReporter2.getMarker().setAttribute("markerIASTName", (Object)name);
            } else if (commentType == MarkerInfoConstants.copyPropagationComment.getType() && obj1 instanceof IASTName) {
                IASTName name = (IASTName)obj1;
                Object[] experssionsInfo = (Object[])obj2;
                IASTExpression expression = (IASTExpression)experssionsInfo[0];
                ArrayList expressionsToChange = (ArrayList)experssionsInfo[1];
                sMessage = String.valueOf(MarkerInfoConstants.copyPropagationComment.getType()) + ". " + Examples.getCopyPropExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)name, sMessage);
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)(String.valueOf(MarkerInfoConstants.copyPropagationComment.getActionText()) + " : " + name.getRawSignature()));
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.copyPropagationComment.getType());
                AnalysisReporter2.getMarker().setAttribute("markerExpression", (Object)expression);
                AnalysisReporter2.getMarker().setAttribute("markerExpressionsToChange", (Object)expressionsToChange);
                AnalysisReporter2.getMarker().setAttribute("markerIASTName", (Object)name);
            } else if (commentType == MarkerInfoConstants.deadCodeEliminationComment.getType() && obj1 instanceof IASTName) {
                IASTName name = (IASTName)obj1;
                IASTDeclarationStatement statement = (IASTDeclarationStatement)obj2;
                sMessage = String.valueOf(MarkerInfoConstants.deadCodeEliminationComment.getType()) + ". " + Examples.getDeadCodeEliminationExample();
                AnalysisReporter2.reportProblem(this.tu, (IASTNode)name, sMessage);
                AnalysisReporter2.getMarker().setAttribute("CDT.Code.Comments.Fix", (Object)"");
                AnalysisReporter2.getMarker().setAttribute("markerActionText", (Object)(String.valueOf(MarkerInfoConstants.deadCodeEliminationComment.getActionText()) + " : " + name.getRawSignature()));
                AnalysisReporter2.getMarker().setAttribute("markerType", (Object)MarkerInfoConstants.deadCodeEliminationComment.getType());
                AnalysisReporter2.getMarker().setAttribute("declarationStatementToFix", (Object)statement);
                AnalysisReporter2.getMarker().setAttribute("variableName", (Object)name);
            }
        }
    }

    private IASTStatement whereToStart(IASTExpression expression) {
        IASTNode parent = expression.getParent();
        while (!(parent instanceof IASTFunctionDefinition)) {
            if (parent instanceof IASTIfStatement) {
                if (((IASTIfStatement)parent).getThenClause().getFileLocation().getEndingLineNumber() < expression.getFileLocation().getStartingLineNumber()) {
                    return ((IASTIfStatement)parent).getElseClause();
                }
                return ((IASTIfStatement)parent).getThenClause();
            }
            if (parent instanceof IASTSwitchStatement) {
                IASTStatement[] statements;
                IASTStatement body = ((IASTSwitchStatement)parent).getBody();
                if (!(body instanceof IASTCompoundStatement)) {
                    return body;
                }
                IASTStatement[] iASTStatementArray = statements = ((IASTCompoundStatement)body).getStatements();
                int n = statements.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTStatement statement = iASTStatementArray[n2];
                    if (statement.getFileLocation().getEndingLineNumber() >= expression.getFileLocation().getEndingLineNumber()) {
                        return statement;
                    }
                    ++n2;
                }
            }
            if (parent instanceof IASTForStatement || parent instanceof IASTWhileStatement || parent instanceof IASTDoStatement) {
                return (IASTStatement)parent;
            }
            if (parent.getParent() == null) {
                return null;
            }
            parent = parent.getParent();
        }
        return ((IASTFunctionDefinition)parent).getBody();
    }

    private void generateLoopPeelingComment(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckForVisitor(this.tu, new CheckPeeling(true)));
    }

    private void generateDependencyFreeComment(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckForVisitor(this.tu, new CheckDependenciesVisitor(true), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false)));
    }

    private void generateSimpleParallelzableComment(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckForVisitor(this.tu, new CheckDependenciesVisitor(true, false), new CheckExpressions(true, true)));
    }

    private void generateLoopDestributionComment(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckForVisitor(this.tu, new CheckLoopDistribution(true), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false), new CheckInitArray(false)));
    }

    private void generateScalarExpansionComment(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckForVisitor(this.tu, new CheckScalarExpansion(true), new CheckLoopDistribution(false), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false), new CheckInitArray(false)));
    }

    private void generateReductionClauseComment(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckForVisitor(this.tu, new CheckReductionClause(true)));
    }

    private void generateAllParallelizationComment(IASTTranslationUnit ast) {
        CheckForVisitor ParallelizationVisitor = new CheckForVisitor(this.tu, new CheckDependenciesVisitor(true), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false), new CheckExpressions(true), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false), new CheckLoopDistribution(true), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false), new CheckInitArray(false), new CheckScalarExpansion(false), new CheckReductionClause(true), new ScalarParallelization(false), new CheckLoopExit(false), new CheckFuncCall(false), new CheckInitArray(false));
        ast.accept((ASTVisitor)ParallelizationVisitor);
    }

    class ConstPropCheckVisitor
    extends ASTVisitor {
        private final IASTName name;
        private final IASTExpression expression;
        private final IASTStatement loop;
        private boolean couldPropagate;
        private final ArrayList<IASTExpression> expressions = new ArrayList();

        public ConstPropCheckVisitor(IASTName name, IASTExpression expression, IASTStatement loop) {
            this.shouldVisitStatements = true;
            this.shouldVisitInitializers = true;
            this.name = name;
            this.expression = expression;
            this.loop = loop;
            this.couldPropagate = false;
        }

        public boolean getCouldPropagate() {
            return this.couldPropagate;
        }

        public ArrayList<IASTExpression> getExpressions() {
            return this.expressions;
        }

        public int visit(IASTInitializer initializer) {
            IASTEqualsInitializer equalsInit;
            if (initializer instanceof IASTEqualsInitializer && (equalsInit = (IASTEqualsInitializer)initializer).getInitializerClause() instanceof IASTExpression) {
                IASTExpression initExp = (IASTExpression)equalsInit.getInitializerClause();
                if (CommentsFactory.this.isUsed(this.name, initExp)) {
                    this.couldPropagate = true;
                    this.expressions.add(initExp);
                    return 3;
                }
                if (CommentsFactory.this.couldChange(this.name, initExp)) {
                    return 2;
                }
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            IASTExpression condition;
            if (statement instanceof IASTExpressionStatement && statement.getFileLocation().getStartingLineNumber() > this.expression.getFileLocation().getEndingLineNumber()) {
                IASTExpression tmpExp = ((IASTExpressionStatement)statement).getExpression();
                if (CommentsFactory.this.isUsed(this.name, tmpExp)) {
                    this.expressions.add(tmpExp);
                    this.couldPropagate = true;
                    return 3;
                }
                if (CommentsFactory.this.couldChange(this.name, tmpExp)) {
                    return 2;
                }
            }
            if ((statement instanceof IASTForStatement || statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement) && !statement.equals(this.loop)) {
                ConstPropLoopVisitor cplVisitor = new ConstPropLoopVisitor(this.name);
                statement.accept((ASTVisitor)cplVisitor);
                if (cplVisitor.getChangesInLoop()) {
                    return 2;
                }
                if (cplVisitor.getIsUsedInLoop()) {
                    this.expressions.addAll(cplVisitor.getExpressions());
                    this.couldPropagate = true;
                    return 1;
                }
                return 1;
            }
            if (statement instanceof IASTIfStatement) {
                condition = ((IASTIfStatement)statement).getConditionExpression();
                if (CommentsFactory.this.isUsed(this.name, condition)) {
                    this.couldPropagate = true;
                    this.expressions.add(condition);
                    return 3;
                }
                if (CommentsFactory.this.couldChange(this.name, condition)) {
                    return 2;
                }
            }
            if (statement instanceof IASTSwitchStatement) {
                condition = ((IASTSwitchStatement)statement).getControllerExpression();
                if (CommentsFactory.this.isUsed(this.name, condition)) {
                    this.expressions.add(condition);
                    this.couldPropagate = true;
                    return 1;
                }
                if (CommentsFactory.this.couldChange(this.name, condition)) {
                    return 2;
                }
            }
            if (statement instanceof IASTReturnStatement) {
                IASTExpression retVal = ((IASTReturnStatement)statement).getReturnValue();
                if (CommentsFactory.this.isUsed(this.name, retVal)) {
                    this.expressions.add(retVal);
                    this.couldPropagate = true;
                    return 1;
                }
                if (CommentsFactory.this.couldChange(this.name, retVal)) {
                    return 2;
                }
            }
            return 3;
        }
    }

    class ConstPropLoopVisitor
    extends ASTVisitor {
        private final IASTName name;
        private boolean isUsedInLoop;
        private boolean changesInLoop;
        private final ArrayList<IASTExpression> expressions = new ArrayList();

        public ConstPropLoopVisitor(IASTName name) {
            this.shouldVisitStatements = true;
            this.shouldVisitInitializers = true;
            this.name = name;
            this.isUsedInLoop = false;
            this.changesInLoop = false;
        }

        public boolean getChangesInLoop() {
            return this.changesInLoop;
        }

        public ArrayList<IASTExpression> getExpressions() {
            return this.expressions;
        }

        public boolean getIsUsedInLoop() {
            return this.isUsedInLoop;
        }

        public int visit(IASTInitializer initializer) {
            IASTEqualsInitializer equalsInit;
            if (initializer instanceof IASTEqualsInitializer && (equalsInit = (IASTEqualsInitializer)initializer).getInitializerClause() instanceof IASTExpression) {
                IASTExpression initExp = (IASTExpression)equalsInit.getInitializerClause();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, initExp);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, initExp);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(initExp);
                }
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            IASTExpression condition;
            if (statement instanceof IASTExpressionStatement) {
                IASTExpression expression = ((IASTExpressionStatement)statement).getExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, expression);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, expression);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(expression);
                }
            }
            if (statement instanceof IASTForStatement) {
                condition = ((IASTForStatement)statement).getConditionExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(condition);
                }
            }
            if (statement instanceof IASTWhileStatement) {
                condition = ((IASTWhileStatement)statement).getCondition();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(condition);
                }
            }
            if (statement instanceof IASTDoStatement) {
                condition = ((IASTDoStatement)statement).getCondition();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(condition);
                }
            }
            if (statement instanceof IASTIfStatement) {
                condition = ((IASTIfStatement)statement).getConditionExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(condition);
                }
            }
            if (statement instanceof IASTSwitchStatement) {
                condition = ((IASTSwitchStatement)statement).getControllerExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(condition);
                }
            }
            if (statement instanceof IASTReturnStatement) {
                IASTExpression retVal = ((IASTReturnStatement)statement).getReturnValue();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, retVal);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, retVal);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(retVal);
                }
            }
            return 3;
        }
    }

    class CopyPropCheckVisitor
    extends ASTVisitor {
        private final IASTName name;
        private final IASTName name2;
        private final IASTExpression expression;
        private final IASTStatement loop;
        private boolean couldPropagate;
        private final ArrayList<IASTExpression> expressions = new ArrayList();

        public CopyPropCheckVisitor(IASTName name, IASTName name2, IASTExpression expression, IASTStatement loop) {
            this.shouldVisitStatements = true;
            this.shouldVisitInitializers = true;
            this.name = name;
            this.name2 = name2;
            this.expression = expression;
            this.loop = loop;
            this.couldPropagate = false;
        }

        public boolean getCouldPropagate() {
            return this.couldPropagate;
        }

        public IASTExpression getExpression() {
            return this.expression;
        }

        public ArrayList<IASTExpression> getExpressions() {
            return this.expressions;
        }

        public int visit(IASTInitializer initializer) {
            IASTEqualsInitializer equalsInit;
            if (initializer instanceof IASTEqualsInitializer && (equalsInit = (IASTEqualsInitializer)initializer).getInitializerClause() instanceof IASTExpression) {
                IASTExpression initExp = (IASTExpression)equalsInit.getInitializerClause();
                if (CommentsFactory.this.isUsed(this.name, initExp)) {
                    this.couldPropagate = true;
                    this.expressions.add(initExp);
                    return 3;
                }
                if (CommentsFactory.this.couldChange(this.name, initExp) || CommentsFactory.this.couldChange(this.name2, initExp)) {
                    return 2;
                }
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            IASTExpression condition;
            if (statement instanceof IASTExpressionStatement && statement.getFileLocation().getStartingLineNumber() > this.expression.getFileLocation().getEndingLineNumber()) {
                IASTExpression tmpExp = ((IASTExpressionStatement)statement).getExpression();
                if (CommentsFactory.this.isUsed(this.name, tmpExp)) {
                    this.couldPropagate = true;
                    this.expressions.add(tmpExp);
                    return 3;
                }
                if (CommentsFactory.this.couldChange(this.name, tmpExp) || CommentsFactory.this.couldChange(this.name2, tmpExp)) {
                    return 2;
                }
            }
            if ((statement instanceof IASTForStatement || statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement) && !statement.equals(this.loop)) {
                CopyPropLoopVisitor cplVisitor = new CopyPropLoopVisitor(this.name);
                CopyPropLoopVisitor cplVisitor2 = new CopyPropLoopVisitor(this.name2);
                statement.accept((ASTVisitor)cplVisitor);
                if (cplVisitor.getChangesInLoop()) {
                    return 2;
                }
                if (cplVisitor2.getChangesInLoop()) {
                    return 2;
                }
                if (cplVisitor.getIsUsedInLoop()) {
                    this.expressions.addAll(cplVisitor.getExpressions());
                    this.couldPropagate = true;
                    return 3;
                }
                return 1;
            }
            if (statement instanceof IASTIfStatement) {
                condition = ((IASTIfStatement)statement).getConditionExpression();
                if (CommentsFactory.this.isUsed(this.name, condition)) {
                    this.couldPropagate = true;
                    this.expressions.add(condition);
                    return 3;
                }
                if (CommentsFactory.this.couldChange(this.name, condition)) {
                    return 2;
                }
                if (CommentsFactory.this.couldChange(this.name2, condition)) {
                    return 2;
                }
            }
            if (statement instanceof IASTSwitchStatement) {
                condition = ((IASTSwitchStatement)statement).getControllerExpression();
                if (CommentsFactory.this.isUsed(this.name, condition)) {
                    this.couldPropagate = true;
                    this.expressions.add(condition);
                    return 1;
                }
                if (CommentsFactory.this.couldChange(this.name, condition)) {
                    return 2;
                }
                if (CommentsFactory.this.couldChange(this.name2, condition)) {
                    return 2;
                }
            }
            if (statement instanceof IASTReturnStatement) {
                IASTExpression retVal = ((IASTReturnStatement)statement).getReturnValue();
                if (CommentsFactory.this.isUsed(this.name, retVal)) {
                    this.couldPropagate = true;
                    this.expressions.add(retVal);
                    return 1;
                }
                if (CommentsFactory.this.couldChange(this.name, retVal)) {
                    return 2;
                }
            }
            return 3;
        }
    }

    class CopyPropLoopVisitor
    extends ASTVisitor {
        private final IASTName name;
        private boolean isUsedInLoop;
        private boolean changesInLoop;
        private final ArrayList<IASTExpression> expressions = new ArrayList();

        public CopyPropLoopVisitor(IASTName name) {
            this.shouldVisitStatements = true;
            this.shouldVisitInitializers = true;
            this.name = name;
            this.isUsedInLoop = false;
            this.changesInLoop = false;
        }

        public boolean getChangesInLoop() {
            return this.changesInLoop;
        }

        public ArrayList<IASTExpression> getExpressions() {
            return this.expressions;
        }

        public boolean getIsUsedInLoop() {
            return this.isUsedInLoop;
        }

        public int visit(IASTInitializer initializer) {
            IASTEqualsInitializer equalsInit;
            if (initializer instanceof IASTEqualsInitializer && (equalsInit = (IASTEqualsInitializer)initializer).getInitializerClause() instanceof IASTExpression) {
                IASTExpression initExp = (IASTExpression)equalsInit.getInitializerClause();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, initExp);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, initExp);
                if (this.isUsedInLoop && !this.changesInLoop) {
                    this.expressions.add(initExp);
                }
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            IASTExpression condition;
            if (statement instanceof IASTExpressionStatement) {
                IASTExpression expression = ((IASTExpressionStatement)statement).getExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, expression);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, expression);
            }
            if (statement instanceof IASTForStatement) {
                condition = ((IASTForStatement)statement).getConditionExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
            }
            if (statement instanceof IASTWhileStatement) {
                condition = ((IASTWhileStatement)statement).getCondition();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
            }
            if (statement instanceof IASTDoStatement) {
                condition = ((IASTDoStatement)statement).getCondition();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
            }
            if (statement instanceof IASTIfStatement) {
                condition = ((IASTIfStatement)statement).getConditionExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
            }
            if (statement instanceof IASTSwitchStatement) {
                condition = ((IASTSwitchStatement)statement).getControllerExpression();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, condition);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, condition);
            }
            if (statement instanceof IASTReturnStatement) {
                IASTExpression retVal = ((IASTReturnStatement)statement).getReturnValue();
                this.changesInLoop |= CommentsFactory.this.couldChange(this.name, retVal);
                this.isUsedInLoop |= CommentsFactory.this.isUsed(this.name, retVal);
            }
            return 3;
        }
    }

    class DeadCodeCheckVisitor
    extends ASTVisitor {
        private final IASTName name;
        private boolean couldEliminate;

        public DeadCodeCheckVisitor(IASTName name) {
            this.shouldVisitStatements = true;
            this.shouldVisitInitializers = true;
            this.name = name;
            this.couldEliminate = false;
        }

        public boolean getCouldEliminate() {
            return this.couldEliminate;
        }

        public int visit(IASTInitializer initializer) {
            IASTExpression initExp;
            IASTEqualsInitializer equalsInit;
            if (initializer instanceof IASTEqualsInitializer && (equalsInit = (IASTEqualsInitializer)initializer).getInitializerClause() instanceof IASTExpression && (CommentsFactory.this.isUsed(this.name, initExp = (IASTExpression)equalsInit.getInitializerClause()) || CommentsFactory.this.couldChange(this.name, initExp))) {
                this.couldEliminate = false;
                return 2;
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            IASTExpression retVal;
            IASTExpression condition;
            IASTExpression tmpExp;
            if (statement instanceof IASTExpressionStatement && (CommentsFactory.this.isUsed(this.name, tmpExp = ((IASTExpressionStatement)statement).getExpression()) || CommentsFactory.this.couldChange(this.name, tmpExp))) {
                this.couldEliminate = false;
                return 2;
            }
            if (statement instanceof IASTForStatement && (CommentsFactory.this.couldChange(this.name, condition = ((IASTForStatement)statement).getConditionExpression()) || CommentsFactory.this.isUsed(this.name, condition))) {
                this.couldEliminate = false;
                return 2;
            }
            if (statement instanceof IASTWhileStatement && (CommentsFactory.this.couldChange(this.name, condition = ((IASTWhileStatement)statement).getCondition()) || CommentsFactory.this.isUsed(this.name, condition))) {
                this.couldEliminate = false;
                return 2;
            }
            if (statement instanceof IASTDoStatement && (CommentsFactory.this.couldChange(this.name, condition = ((IASTDoStatement)statement).getCondition()) || CommentsFactory.this.isUsed(this.name, condition))) {
                this.couldEliminate = false;
                return 2;
            }
            if (statement instanceof IASTIfStatement && (CommentsFactory.this.couldChange(this.name, condition = ((IASTIfStatement)statement).getConditionExpression()) || CommentsFactory.this.isUsed(this.name, condition))) {
                this.couldEliminate = false;
                return 2;
            }
            if (statement instanceof IASTSwitchStatement && (CommentsFactory.this.couldChange(this.name, condition = ((IASTSwitchStatement)statement).getControllerExpression()) || CommentsFactory.this.isUsed(this.name, condition))) {
                this.couldEliminate = false;
                return 2;
            }
            if (statement instanceof IASTReturnStatement && (CommentsFactory.this.couldChange(this.name, retVal = ((IASTReturnStatement)statement).getReturnValue()) || CommentsFactory.this.isUsed(this.name, retVal))) {
                this.couldEliminate = false;
                return 2;
            }
            return 3;
        }
    }

    class GetDeclaredVarsVisitor
    extends ASTVisitor {
        private final HashMap<IASTName, IASTDeclarationStatement> names;

        public GetDeclaredVarsVisitor() {
            this.shouldVisitStatements = true;
            this.names = new HashMap();
        }

        public HashMap<IASTName, IASTDeclarationStatement> getDeclaredVars() {
            return this.names;
        }

        public int visit(IASTStatement statement) {
            IASTDeclaration declaration;
            if (statement instanceof IASTDeclarationStatement && (declaration = ((IASTDeclarationStatement)statement).getDeclaration()) instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] declarators;
                IASTDeclarator[] iASTDeclaratorArray = declarators = ((IASTSimpleDeclaration)declaration).getDeclarators();
                int n = declarators.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTDeclarator dec = iASTDeclaratorArray[n2];
                    this.names.put(dec.getName(), (IASTDeclarationStatement)statement);
                    ++n2;
                }
            }
            return 3;
        }
    }

    class VisitDeclerators
    extends ASTVisitor {
        public VisitDeclerators() {
            this.shouldVisitDeclarators = true;
        }

        private boolean nameReDefInLoop(IASTForStatement forStmt, IASTName name) {
            VisitForLoops vf = new VisitForLoops(name);
            forStmt.accept((ASTVisitor)vf);
            return vf.found();
        }

        public int visit(IASTDeclarator declarator) {
            IASTName name = declarator.getName();
            IASTNode forStmt = name.getParent();
            while (!(forStmt instanceof IASTForStatement)) {
                forStmt = forStmt.getParent();
            }
            if (!this.nameReDefInLoop((IASTForStatement)forStmt, name) && name.getFileLocation() != null) {
                int tmpLineNum = name.getFileLocation().getStartingLineNumber();
                try {
                    if (declarator.getParent() instanceof IASTSimpleDeclaration) {
                        CommentsFactory.this.markComment(name, new Object[]{forStmt, (IASTSimpleDeclaration)declarator.getParent()}, tmpLineNum, MarkerInfoConstants.invariantCodeComment.getType());
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (DOMException e) {
                    e.printStackTrace();
                }
            }
            return 3;
        }
    }

    class VisitForLoops
    extends ASTVisitor {
        private final IASTName nameToLookFor;
        private boolean def = false;

        public VisitForLoops(IASTName name) {
            this.nameToLookFor = name;
            this.shouldVisitExpressions = true;
        }

        public boolean found() {
            return this.def;
        }

        public int visit(IASTExpression expression) {
            IASTName lhs = null;
            lhs = CommentsFactory.this.getAssignmentOperand(expression);
            if (lhs != null && !lhs.equals(this.nameToLookFor) && lhs.resolveBinding().equals(this.nameToLookFor.resolveBinding())) {
                this.def = true;
                return 2;
            }
            return 3;
        }
    }

    class VisitFunctionCalls
    extends ASTVisitor {
        public VisitFunctionCalls(IASTName name) {
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            IASTNode parent = name.getParent();
            while (parent != null) {
                if (parent instanceof IASTFunctionCallExpression) break;
            }
            return 3;
        }
    }

    class VisitNames1
    extends ASTVisitor {
        public VisitNames1() {
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            IASTNode parent = name.getParent();
            while (parent != null && !(parent instanceof IASTFunctionDefinition)) {
                if (parent instanceof IASTParameterDeclaration) {
                    IBinding binding = name.resolveBinding();
                    if (!(binding instanceof IParameter)) break;
                    IParameter param = (IParameter)binding;
                    try {
                        if (param.getType() instanceof IArrayType || param.getType() instanceof IPointerType || param.getType() instanceof IBasicType || param.getType() instanceof ICPPReferenceType) break;
                        int tmpLineNum = -1;
                        if (name.getFileLocation() == null) continue;
                        tmpLineNum = name.getFileLocation().getStartingLineNumber();
                        CommentsFactory.this.markComment(name, parent, tmpLineNum, MarkerInfoConstants.byValParamComment.getType());
                    }
                    catch (DOMException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                parent = parent.getParent();
            }
            return 3;
        }
    }

    class VisitNames2
    extends ASTVisitor {
        private IASTName name_ = null;

        public VisitNames2() {
            this.shouldVisitNames = true;
        }

        public IASTName getName() {
            return this.name_;
        }

        public int visit(IASTName name) {
            this.name_ = name;
            return 2;
        }
    }
}

