/*
 * Decompiled with CFR 0.152.
 */
package cdt.code.comments.refactoring;

import cdt.code.comments.core.CommentsFactory;
import cdt.code.comments.refactoring.RefactoringFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class MarkerMenuContribution
extends ContributionItem {
    private final ITextEditor editor;
    private final IVerticalRulerInfo rulerInfo;
    private List<IMarker> clickedMarkers;

    public MarkerMenuContribution(ITextEditor editor) {
        this.editor = editor;
        this.rulerInfo = this.getRulerInfo();
        try {
            this.clickedMarkers = this.getClickedMarkers();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private SelectionAdapter createDynamicSelectionListener(IMarker marker) {
        return new RefactoringFactory(marker);
    }

    public void fill(Menu menu, int index) {
        for (IMarker marker : this.clickedMarkers) {
            MenuItem menuItem = new MenuItem(menu, 32, index);
            menuItem.setText(marker.getAttribute("markerActionText", ""));
            menuItem.addSelectionListener((SelectionListener)this.createDynamicSelectionListener(marker));
        }
    }

    private IMarker[] getAllMarkers() throws CoreException {
        IFileEditorInput fileEditorInput = (IFileEditorInput)this.editor.getEditorInput();
        IFile file = fileEditorInput.getFile();
        IMarker[] allMarkers = file.findMarkers(CommentsFactory.markerID, true, 0);
        return allMarkers;
    }

    private List<IMarker> getClickedMarkers() throws CoreException {
        ArrayList<IMarker> clickedOnMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = this.getAllMarkers();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (this.markerHasBeenClicked(marker)) {
                clickedOnMarkers.add(marker);
            }
            ++n2;
        }
        return clickedOnMarkers;
    }

    private IVerticalRulerInfo getRulerInfo() {
        return (IVerticalRulerInfo)this.editor.getAdapter(IVerticalRulerInfo.class);
    }

    private boolean markerHasBeenClicked(IMarker marker) {
        return marker.getAttribute("lineNumber", 0) == this.rulerInfo.getLineOfLastMouseButtonActivity() + 1;
    }
}

