/*
 * Decompiled with CFR 0.152.
 */
package cdt.code.comments.refactoring;

import cdt.code.comments.core.CommentsFactory;
import cdt.code.comments.core.MarkerInfoConstants;
import cdt.code.comments.handlers.SampleHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTVisibilityLabel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.commands.ICommandService;

public class RefactoringFactory
extends SelectionAdapter {
    private final IMarker marker;

    public RefactoringFactory(IMarker marker) {
        this.marker = marker;
    }

    /*
     * WARNING - void declaration
     */
    private int addMemebers(IDocument document, IASTCompositeTypeSpecifier classSpecifier1, HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> variableMemberDeclarations, HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> existingCPPASTVisibilityLabels, HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> functionMemberDeclarations) throws BadLocationException {
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> membersToAdd = this.getMembersToAdd(variableMemberDeclarations, functionMemberDeclarations);
        int offsetDelta = 0;
        ArrayList<CPPASTVisibilityLabel> sortedExistingVisibilityLabel = new ArrayList<CPPASTVisibilityLabel>();
        sortedExistingVisibilityLabel.addAll(existingCPPASTVisibilityLabels.keySet());
        Collections.sort(sortedExistingVisibilityLabel, new Comparator<CPPASTVisibilityLabel>(){

            @Override
            public int compare(CPPASTVisibilityLabel o1, CPPASTVisibilityLabel o2) {
                return Integer.valueOf(o1.getFileLocation().getNodeOffset()).compareTo(o2.getFileLocation().getNodeOffset());
            }
        });
        for (CPPASTVisibilityLabel cppastVisibilityLabel : sortedExistingVisibilityLabel) {
            for (Map.Entry<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> mapEntry : membersToAdd.entrySet()) {
                void var13_17;
                if (!mapEntry.getKey().getRawSignature().equals(cppastVisibilityLabel.getRawSignature()) || mapEntry.getValue().size() <= 0) continue;
                String string = String.valueOf(cppastVisibilityLabel.getRawSignature()) + "\n";
                for (IASTDeclaration iastDeclaration : mapEntry.getValue()) {
                    String string2 = String.valueOf(var13_17) + iastDeclaration.getRawSignature() + "\n";
                }
                document.replace(cppastVisibilityLabel.getFileLocation().getNodeOffset() + offsetDelta, cppastVisibilityLabel.getFileLocation().getNodeLength(), (String)var13_17);
                offsetDelta = offsetDelta + var13_17.length() - cppastVisibilityLabel.getFileLocation().getNodeLength();
            }
        }
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> notFound = new HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>>();
        block3: for (Map.Entry<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> entry : membersToAdd.entrySet()) {
            for (CPPASTVisibilityLabel cppastVisibilityLabel : sortedExistingVisibilityLabel) {
                if (entry.getKey().getRawSignature().equals(cppastVisibilityLabel.getRawSignature()) && entry.getValue().size() > 0) continue block3;
            }
            notFound.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, ArrayList<Object>> entry : notFound.entrySet()) {
            String replacement = "\n" + ((CPPASTVisibilityLabel)entry.getKey()).getRawSignature() + "\n";
            for (IASTDeclaration iASTDeclaration : entry.getValue()) {
                replacement = String.valueOf(replacement) + iASTDeclaration.getRawSignature() + "\n";
            }
            document.replace(classSpecifier1.getFileLocation().getNodeOffset() + offsetDelta + classSpecifier1.getFileLocation().getNodeLength() - 2, 1, replacement);
            offsetDelta = offsetDelta + replacement.length() - 1;
        }
        return offsetDelta;
    }

    private IASTNode getClassSpecifierObjectDeclaration(IASTDeclaration classSpecifier2Objectdeclaration) {
        IASTNode class2variable = null;
        IASTNode[] iASTNodeArray = classSpecifier2Objectdeclaration.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof CPPASTDeclarator) {
                class2variable = ((CPPASTDeclarator)child).getChildren()[0];
            }
            ++n2;
        }
        return class2variable;
    }

    private HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> getExistingCPPASTVisibilityLabels(IASTCompositeTypeSpecifier classSpecifier) {
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> labels = new HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>>();
        IASTDeclaration[] decs = classSpecifier.getMembers();
        ArrayList<CPPASTVisibilityLabel> temp = new ArrayList<CPPASTVisibilityLabel>();
        IASTDeclaration[] iASTDeclarationArray = decs;
        int n = decs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration dec = iASTDeclarationArray[n2];
            if (dec instanceof CPPASTVisibilityLabel) {
                labels.put((CPPASTVisibilityLabel)dec, new ArrayList());
                temp.add((CPPASTVisibilityLabel)dec);
            } else if (temp.size() > 0) {
                CPPASTVisibilityLabel last = (CPPASTVisibilityLabel)temp.get(temp.size() - 1);
                labels.get(last).add(dec);
            }
            ++n2;
        }
        return labels;
    }

    private HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> getFunctionMemberDeclarations(IASTCompositeTypeSpecifier classSpecifier2) {
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> functionMemberDeclarations = new HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>>();
        IASTDeclaration[] decs = classSpecifier2.getMembers();
        CPPASTVisibilityLabel cppAstVisibilityLabel = null;
        IASTDeclaration[] iASTDeclarationArray = decs;
        int n = decs.length;
        int n2 = 0;
        while (n2 < n) {
            CPPASTFunctionDefinition functionDeclaration;
            IASTDeclaration dec = iASTDeclarationArray[n2];
            if (dec instanceof CPPASTVisibilityLabel) {
                cppAstVisibilityLabel = (CPPASTVisibilityLabel)dec;
                if (functionMemberDeclarations.get(cppAstVisibilityLabel) == null) {
                    functionMemberDeclarations.put(cppAstVisibilityLabel, new ArrayList());
                }
            } else if (dec instanceof CPPASTFunctionDefinition && !(functionDeclaration = (CPPASTFunctionDefinition)dec).getDeclarator().getName().getRawSignature().equals(classSpecifier2.getName().getRawSignature())) {
                functionMemberDeclarations.get(cppAstVisibilityLabel).add(dec);
            }
            ++n2;
        }
        return functionMemberDeclarations;
    }

    private int getLength(IASTBinaryExpression binaryExpression, boolean deleteFirstOperand) {
        int length = 0;
        length = deleteFirstOperand ? binaryExpression.getOperand2().getFileLocation().getNodeOffset() - this.getOffset(binaryExpression, deleteFirstOperand) : binaryExpression.getFileLocation().getNodeLength() - (this.getOffset(binaryExpression, deleteFirstOperand) - binaryExpression.getFileLocation().getNodeOffset());
        return length;
    }

    private HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> getMembersToAdd(HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> variableMemberDeclarations, HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> functionMemberDeclarations) {
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> membersToAdd = new HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>>();
        for (Map.Entry<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> mapEntry : variableMemberDeclarations.entrySet()) {
            if (membersToAdd.get(mapEntry.getKey()) == null) {
                membersToAdd.put(mapEntry.getKey(), new ArrayList());
            }
            membersToAdd.get(mapEntry.getKey()).addAll((Collection<IASTDeclaration>)mapEntry.getValue());
        }
        for (Map.Entry<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> mapEntry : functionMemberDeclarations.entrySet()) {
            if (membersToAdd.get(mapEntry.getKey()) == null) {
                membersToAdd.put(mapEntry.getKey(), new ArrayList());
            }
            membersToAdd.get(mapEntry.getKey()).addAll((Collection<IASTDeclaration>)mapEntry.getValue());
        }
        return membersToAdd;
    }

    private ArrayList<IASTNode> getObjectReferences(IASTNode node, IASTNode class2variable) {
        int n;
        ArrayList<IASTNode> cppASTIdExpressions = new ArrayList<IASTNode>();
        if (node instanceof CPPASTExpressionStatement) {
            CPPASTExpressionStatement cppastExpressionStatement = (CPPASTExpressionStatement)node;
            IASTNode[] iASTNodeArray = cppastExpressionStatement.getExpression().getChildren();
            int n2 = iASTNodeArray.length;
            n = 0;
            while (n < n2) {
                IASTNode cppastExpressionStatementChild = iASTNodeArray[n];
                if (cppastExpressionStatementChild instanceof CPPASTFieldReference) {
                    CPPASTFieldReference cppastFieldReference = (CPPASTFieldReference)cppastExpressionStatementChild;
                    IASTNode[] iASTNodeArray2 = cppastFieldReference.getChildren();
                    int n3 = iASTNodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTNode cppastFieldReferenceChild = iASTNodeArray2[n4];
                        if (cppastFieldReferenceChild instanceof CPPASTIdExpression && class2variable.getRawSignature().equals(cppastFieldReferenceChild.getRawSignature())) {
                            cppASTIdExpressions.add(cppastFieldReferenceChild);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        IASTNode[] iASTNodeArray = node.getChildren();
        n = iASTNodeArray.length;
        int n5 = 0;
        while (n5 < n) {
            IASTNode child = iASTNodeArray[n5];
            cppASTIdExpressions.addAll(this.getObjectReferences(child, class2variable));
            ++n5;
        }
        return cppASTIdExpressions;
    }

    private int getOffset(IASTBinaryExpression binaryExpression, boolean deleteFirstOperand) {
        int offset = 0;
        offset = deleteFirstOperand ? binaryExpression.getFileLocation().getNodeOffset() : binaryExpression.getFileLocation().getNodeOffset() + binaryExpression.getOperand1().getFileLocation().getNodeLength();
        return offset;
    }

    private HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> getVariableMemberDeclarations(IASTCompositeTypeSpecifier classSpecifier2) {
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> variableMemberDeclarations = new HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>>();
        IASTDeclaration[] decs = classSpecifier2.getMembers();
        CPPASTVisibilityLabel cppAstVisibilityLabel = null;
        IASTDeclaration[] iASTDeclarationArray = decs;
        int n = decs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration dec = iASTDeclarationArray[n2];
            if (dec instanceof CPPASTVisibilityLabel) {
                cppAstVisibilityLabel = (CPPASTVisibilityLabel)dec;
                if (variableMemberDeclarations.get(cppAstVisibilityLabel) == null) {
                    variableMemberDeclarations.put(cppAstVisibilityLabel, new ArrayList());
                }
            } else if (dec instanceof IASTSimpleDeclaration && !variableMemberDeclarations.isEmpty()) {
                variableMemberDeclarations.get(cppAstVisibilityLabel).add(dec);
            }
            ++n2;
        }
        return variableMemberDeclarations;
    }

    private void processAlgebricSimpCommentAction(IMarker marker, IDocument document) throws CoreException, BadLocationException {
        IASTBinaryExpression binaryExpression = (IASTBinaryExpression)marker.getAttribute("markerBinaryExpression");
        int offset = 0;
        int length = 0;
        String replacement = "";
        boolean replace = false;
        if (binaryExpression.getOperator() == 4) {
            if (binaryExpression.getOperand1() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand1().getRawSignature().equals("0")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                } else if (binaryExpression.getOperand2() instanceof IASTLiteralExpression && binaryExpression.getOperand2().getRawSignature().equals("0")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                }
            } else if (binaryExpression.getOperand2() instanceof IASTLiteralExpression && binaryExpression.getOperand2().getRawSignature().equals("0")) {
                offset = this.getOffset(binaryExpression, false);
                length = this.getLength(binaryExpression, false);
                replace = true;
            }
        } else if (binaryExpression.getOperator() == 5) {
            if (binaryExpression.getOperand2() instanceof IASTLiteralExpression && binaryExpression.getOperand2().getRawSignature().equals("0")) {
                offset = this.getOffset(binaryExpression, false);
                length = this.getLength(binaryExpression, false);
                replace = true;
            }
        } else if (binaryExpression.getOperator() == 1) {
            if (binaryExpression.getOperand1() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand1().getRawSignature().equals("0")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                } else if (binaryExpression.getOperand1().getRawSignature().equals("1")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                } else if (binaryExpression.getOperand2().getRawSignature().equals("0")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                }
            } else if (binaryExpression.getOperand2() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand2().getRawSignature().equals("0")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                } else if (binaryExpression.getOperand2().getRawSignature().equals("1")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                }
            }
        } else if (binaryExpression.getOperator() == 2 || binaryExpression.getOperator() == 3) {
            if (binaryExpression.getOperand2() instanceof IASTLiteralExpression && binaryExpression.getOperand2().getRawSignature().equals("1")) {
                offset = this.getOffset(binaryExpression, false);
                length = this.getLength(binaryExpression, false);
                replace = true;
            }
        } else if (binaryExpression.getOperator() == 12) {
            if (binaryExpression.getOperand1() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand1().getRawSignature().equals("true")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                } else if (binaryExpression.getOperand1().getRawSignature().equals("false")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                }
            } else if (binaryExpression.getOperand2() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand2().getRawSignature().equals("true")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                } else if (binaryExpression.getOperand2().getRawSignature().equals("false")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                }
            }
        } else if (binaryExpression.getOperator() == 14) {
            if (binaryExpression.getOperand1() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand1().getRawSignature().equals("true")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                } else if (binaryExpression.getOperand1().getRawSignature().equals("false")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                }
            } else if (binaryExpression.getOperand2() instanceof IASTLiteralExpression) {
                if (binaryExpression.getOperand2().getRawSignature().equals("true")) {
                    offset = this.getOffset(binaryExpression, true);
                    length = this.getLength(binaryExpression, true);
                    replace = true;
                } else if (binaryExpression.getOperand2().getRawSignature().equals("false")) {
                    offset = this.getOffset(binaryExpression, false);
                    length = this.getLength(binaryExpression, false);
                    replace = true;
                }
            }
        }
        if (replace) {
            document.replace(offset, length, replacement);
        }
    }

    private void processByValParamCommentAction(IMarker marker, IDocument document) throws CoreException, BadLocationException {
        IASTParameterDeclaration parameterDeclaration = (IASTParameterDeclaration)marker.getAttribute("markerParameterDeclaration");
        int offset = parameterDeclaration.getDeclSpecifier().getFileLocation().getNodeOffset();
        int length = parameterDeclaration.getDeclSpecifier().getFileLocation().getNodeLength();
        document.replace(offset, length, String.valueOf(document.get(offset, length)) + "*");
    }

    private int processChildNodeForConstantPropagation(IDocument document, String variableName, String replacement, int lengthDifference, int counter, IASTNode childNode) throws BadLocationException {
        if (childNode.getRawSignature().trim().equals(variableName)) {
            document.replace(childNode.getFileLocation().getNodeOffset() + counter * lengthDifference, childNode.getFileLocation().getNodeLength(), replacement);
            ++counter;
        } else if (childNode.getChildren().length > 0) {
            IASTNode[] iASTNodeArray = childNode.getChildren();
            int n = iASTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode childChildNode = iASTNodeArray[n2];
                counter = this.processChildNodeForConstantPropagation(document, variableName, replacement, lengthDifference, counter, childChildNode);
                ++n2;
            }
        }
        return counter;
    }

    private void processClassInliningCommentAction(IMarker marker, IDocument document) throws CoreException, BadLocationException {
        IASTCompositeTypeSpecifier classSpecifier1 = (IASTCompositeTypeSpecifier)marker.getAttribute("markerClassSpec1");
        IASTCompositeTypeSpecifier classSpecifier2 = (IASTCompositeTypeSpecifier)marker.getAttribute("markerClassSpec2");
        IASTDeclarator declarator = (IASTDeclarator)marker.getAttribute("markerDeclarator");
        IASTDeclaration classSpecifier2Objectdeclaration = (IASTDeclaration)declarator.getParent();
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> variableMemberDeclarations = this.getVariableMemberDeclarations(classSpecifier2);
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> existingCPPASTVisibilityLabels = this.getExistingCPPASTVisibilityLabels(classSpecifier1);
        HashMap<CPPASTVisibilityLabel, ArrayList<IASTDeclaration>> functionMemberDeclarations = this.getFunctionMemberDeclarations(classSpecifier2);
        this.replaceObjectReferences(document, classSpecifier1, classSpecifier2Objectdeclaration);
        String replacement = new String(classSpecifier2Objectdeclaration.getRawSignature().replaceAll(".", " ").toCharArray());
        document.replace(classSpecifier2Objectdeclaration.getFileLocation().getNodeOffset(), classSpecifier2Objectdeclaration.getFileLocation().getNodeLength(), replacement);
        this.addMemebers(document, classSpecifier1, variableMemberDeclarations, existingCPPASTVisibilityLabels, functionMemberDeclarations);
    }

    private void processConstantPropagationCommentAction(IMarker marker, IDocument document) throws CoreException, BadLocationException {
        String variableName = ((IASTName)marker.getAttribute("markerIASTName")).getRawSignature().trim();
        String replacement = ((IASTExpression)marker.getAttribute("markerExpression")).getRawSignature().trim();
        ArrayList expressionsToChange = (ArrayList)marker.getAttribute("markerExpressionsToChange");
        int lengthDifference = replacement.length() - variableName.length();
        int counter = 0;
        for (IASTExpression iastExpression : expressionsToChange) {
            IASTNode[] iASTNodeArray = iastExpression.getChildren();
            int n = iASTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode childNode = iASTNodeArray[n2];
                counter = this.processChildNodeForConstantPropagation(document, variableName, replacement, lengthDifference, counter, childNode);
                ++n2;
            }
        }
    }

    private void processCopyPropagationCommentAction(IMarker marker, IDocument document) throws CoreException, BadLocationException {
        String variableName = ((IASTName)marker.getAttribute("markerIASTName")).getRawSignature().trim();
        String replacement = ((IASTExpression)marker.getAttribute("markerExpression")).getRawSignature().trim();
        ArrayList expressionsToChange = (ArrayList)marker.getAttribute("markerExpressionsToChange");
        int lengthDifference = replacement.length() - variableName.length();
        int counter = 0;
        for (IASTExpression iastExpression : expressionsToChange) {
            IASTNode[] iASTNodeArray = iastExpression.getChildren();
            int n = iASTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode childNode = iASTNodeArray[n2];
                counter = this.processChildNodeForConstantPropagation(document, variableName, replacement, lengthDifference, counter, childNode);
                ++n2;
            }
        }
    }

    private void processDeadCodeEliminationCommentAction(IMarker marker, IDocument document) throws Exception {
        IASTDeclarationStatement simpleDeclaration = (IASTDeclarationStatement)marker.getAttribute("declarationStatementToFix");
        int offset = Integer.MAX_VALUE;
        int length = 0;
        IASTDeclSpecifier declSpecifier = null;
        IASTNode[] iASTNodeArray = simpleDeclaration.getDeclaration().getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof IASTDeclSpecifier) {
                declSpecifier = (IASTDeclSpecifier)child;
                break;
            }
            ++n2;
        }
        if (declSpecifier != null) {
            iASTNodeArray = simpleDeclaration.getNodeLocations();
            n = iASTNodeArray.length;
            n2 = 0;
            while (n2 < n) {
                IASTNode nodeLocation = iASTNodeArray[n2];
                if (nodeLocation.getNodeOffset() < offset) {
                    offset = nodeLocation.getNodeOffset();
                }
                length += simpleDeclaration.getFileLocation().getNodeLength();
                ++n2;
            }
            String statementText = document.get(offset, length);
            String[] parts = statementText.split(declSpecifier.getRawSignature());
            parts = parts[1].split(",");
            String replacement = "";
            IASTName variable = (IASTName)marker.getAttribute("variableName");
            int variableOffset = variable.getFileLocation().getNodeOffset();
            int variableLength = variable.getFileLocation().getNodeLength();
            String variableText = document.get(variableOffset, variableLength);
            if (parts.length > 1) {
                parts = (statementText = statementText.replace(declSpecifier.getRawSignature(), "")).split(variableText);
                if (parts[0].trim().endsWith(",")) {
                    replacement = parts[0].substring(0, parts[0].lastIndexOf(44));
                    replacement = String.valueOf(replacement) + parts[1];
                } else if (parts[1].trim().startsWith(",")) {
                    replacement = parts[1].substring(parts[1].indexOf(44) + 1, parts[1].length());
                    replacement = " " + replacement;
                }
                replacement = String.valueOf(declSpecifier.getRawSignature()) + replacement;
            }
            document.replace(offset, length, replacement);
        }
    }

    private void processImplicitCastingCommentAction(IMarker marker, IDocument document) throws Exception {
        IASTExpression exp = (IASTExpression)marker.getAttribute("markerImplicitCastingExpression");
        IType explicitType = (IType)marker.getAttribute("markerExplicitCastingType");
        int offset = exp.getFileLocation().getNodeOffset();
        int length = exp.getFileLocation().getNodeLength();
        document.replace(offset, length, "(" + ASTTypeUtil.getType((IType)explicitType) + ")" + document.get(offset, length));
    }

    private void processInsideCriticalSectionCommentAction(IMarker marker, IDocument document) {
    }

    private void processInvariantCodeCommentAction(IMarker marker, IDocument document) throws BadLocationException, CoreException {
        IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)marker.getAttribute("markerSimpleDeclaration");
        IASTForStatement forStatement = (IASTForStatement)marker.getAttribute("markerForStatement");
        int forStatementOffset = forStatement.getFileLocation().getNodeOffset();
        int forStatementLength = forStatement.getFileLocation().getNodeLength();
        String tabSpace = "\t";
        String remaining = document.get(forStatementOffset + forStatementLength, document.getLength() - forStatementOffset - forStatementLength);
        String prefix = document.get(0, forStatementOffset - 1);
        String oldFor = document.get(forStatementOffset, forStatementLength);
        String newFor = String.valueOf(tabSpace) + simpleDeclaration.getRawSignature() + "\n" + tabSpace + oldFor.replace(simpleDeclaration.getRawSignature(), "");
        document.set(String.valueOf(prefix) + newFor + remaining);
    }

    private void processStrengthReducCommentAction(IMarker marker, IDocument document) throws CoreException, BadLocationException {
        IASTBinaryExpression binExp = (IASTBinaryExpression)marker.getAttribute("markerBinaryExpression");
        boolean isMultiplication = binExp.getOperator() == 1 || binExp.getOperator() == 18;
        int exponent = (Integer)marker.getAttribute("markerExponent");
        boolean firstOperandIsPow2 = (Boolean)marker.getAttribute("firstOperandIsPow2");
        String replacement = "";
        replacement = firstOperandIsPow2 ? String.valueOf(binExp.getOperand2().getRawSignature().trim()) + (isMultiplication ? " << " : " >> ") + exponent : String.valueOf(binExp.getOperand1().getRawSignature().trim()) + (isMultiplication ? " << " : " >> ") + exponent;
        document.replace(binExp.getFileLocation().getNodeOffset(), binExp.getFileLocation().getNodeLength(), replacement);
    }

    private void processStructSplittingOrReorderCommentAction(IMarker marker, IDocument document) {
    }

    private void refresh(ITranslationUnit markerTranslationUnit, ICommandService service, String commandId) throws CoreException, InterruptedException, DOMException, ExecutionException {
        this.marker.delete();
        markerTranslationUnit.getResource().deleteMarkers(SampleHandler.markerID, true, 2);
        new CommentsFactory(markerTranslationUnit, true, null, false, null);
        service.refreshElements(commandId, null);
    }

    private void replaceObjectReferences(IDocument document, IASTCompositeTypeSpecifier classSpecifier1, IASTDeclaration objectdeclaration) throws BadLocationException {
        IASTNode class2variable = this.getClassSpecifierObjectDeclaration(objectdeclaration);
        String replacement = "";
        int i = 0;
        while (i <= class2variable.getRawSignature().length()) {
            replacement = String.valueOf(replacement) + " ";
            ++i;
        }
        ArrayList<IASTNode> objectReferences = this.getObjectReferences((IASTNode)classSpecifier1, class2variable);
        for (IASTNode iastNode : objectReferences) {
            document.replace(iastNode.getFileLocation().getNodeOffset(), iastNode.getFileLocation().getNodeLength() + 1, replacement);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        block28: {
            try {
                if (this.marker.getAttribute("markerType") == null || !this.marker.exists() || this.marker.getAttribute("CDT.Code.Comments.Fix", "") == null) break block28;
                ITranslationUnit markerTranslationUnit = (ITranslationUnit)this.marker.getAttribute("markerTranslationUnit");
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                IPath path = markerTranslationUnit.getPath();
                try {
                    bufferManager.connect(path, null);
                    ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path);
                    IDocument document = textFileBuffer.getDocument();
                    try {
                        if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.deadCodeEliminationComment.getType())) {
                            this.processDeadCodeEliminationCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.implicitCastingComment.getType())) {
                            this.processImplicitCastingCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.invariantCodeComment.getType())) {
                            this.processInvariantCodeCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.byValParamComment.getType())) {
                            this.processByValParamCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.strengthReducComment.getType())) {
                            this.processStrengthReducCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.algebricSimpComment.getType())) {
                            this.processAlgebricSimpCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.constantPropagationComment.getType())) {
                            this.processConstantPropagationCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.copyPropagationComment.getType())) {
                            this.processCopyPropagationCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.structSplittingOrReorderComment.getType())) {
                            this.processStructSplittingOrReorderCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.classInliningComment.getType())) {
                            this.processClassInliningCommentAction(this.marker, document);
                        } else if (this.marker.getAttribute("markerType").equals(MarkerInfoConstants.insideCriticalSectionComment.getType())) {
                            this.processInsideCriticalSectionCommentAction(this.marker, document);
                        }
                    }
                    catch (Exception markerProcessingException) {
                        markerProcessingException.printStackTrace();
                    }
                    textFileBuffer.commit(null, false);
                    this.refresh(markerTranslationUnit, (ICommandService)this.marker.getAttribute("ICommandService"), (String)this.marker.getAttribute("commandId"));
                }
                finally {
                    bufferManager.disconnect(path, null);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

