/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.COperatorGroup;
import cpd.checkers.core.CheckVisitor;
import cpd.checkers.core.ExpressionExtractor;
import cpd.checkers.core.OperandsSet;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class CheckDependenciesVisitor
extends CheckVisitor {
    OperandsSet m_lValues;
    OperandsSet m_rValues;
    Boolean m_bCompoundAssignmentUsed;
    Boolean m_bUnaryExpressionUsed;
    Boolean Left_index = true;
    int m_nExpressionCounter;
    private Boolean m_bFirstTimeVisiting = false;

    public CheckDependenciesVisitor(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_bCompoundAssignmentUsed = false;
        this.m_bUnaryExpressionUsed = false;
        this.m_lValues = new OperandsSet();
        this.m_rValues = new OperandsSet();
        this.m_bExitPoint = IsExitPoint;
        this.m_bReportComment = IsReportComment;
    }

    public CheckDependenciesVisitor(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public boolean isAdditionalInfoLink() {
        return true;
    }

    private boolean IndexChecking(IASTExpression left, IASTExpression right) {
        return left.getChildren().length <= 0 || right.getChildren().length <= 0 || !left.getChildren()[0].getRawSignature().equals(right.getChildren()[0].getRawSignature());
    }

    public int visit(IASTExpression stmt) {
        IASTUnaryExpression UnaryStmt;
        int nOperType;
        if (stmt instanceof IASTBinaryExpression) {
            IASTBinaryExpression BinaryExp = (IASTBinaryExpression)stmt;
            int nOperatorType = ((IASTBinaryExpression)stmt).getOperator();
            if (COperatorGroup.IsAssignmentOperator(BinaryExp.getOperator()).booleanValue() || COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue()) {
                ++this.m_nExpressionCounter;
                this.m_lValues.add(BinaryExp.getOperand1().getRawSignature());
                if (!this.IndexChecking(BinaryExp.getOperand1(), BinaryExp.getOperand2())) {
                    this.Left_index = false;
                }
                if (BinaryExp.getOperand2().getChildren().length == 1 || BinaryExp.getOperand2() instanceof IASTArraySubscriptExpression) {
                    this.m_rValues.add(BinaryExp.getOperand2().getRawSignature());
                } else {
                    ExpressionExtractor ExtracorVisitor = new ExpressionExtractor(this.m_rValues);
                    BinaryExp.getOperand2().accept((ASTVisitor)ExtracorVisitor);
                }
            }
            if ((COperatorGroup.IsCompoundAssignmentOperator(BinaryExp.getOperator()).booleanValue() || COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue()) && BinaryExp.getOperand1().getChildren().length == 1) {
                this.m_bCompoundAssignmentUsed = true;
                return 1;
            }
        } else if (stmt instanceof IASTUnaryExpression && COperatorGroup.IsUnaryModifier(nOperType = (UnaryStmt = (IASTUnaryExpression)stmt).getOperator()).booleanValue()) {
            this.m_bUnaryExpressionUsed = true;
            return 1;
        }
        return 3;
    }

    public int visit(IASTStatement stmt) {
        if (!this.m_bFirstTimeVisiting.booleanValue()) {
            this.RootNode = stmt.getParent();
            this.m_bFirstTimeVisiting = true;
        }
        return 3;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckDependenciesVisitor(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckDependenciesVisitor(IsExitPoint, IsReportComment);
    }

    private Boolean IsDependencyFree() {
        OperandsSet intersection = OperandsSet.intersection(this.m_lValues, this.m_rValues);
        if (intersection.isEmpty() && !this.m_bCompoundAssignmentUsed.booleanValue() && this.Left_index.booleanValue() && !this.m_bUnaryExpressionUsed.booleanValue() && this.m_nExpressionCounter > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.IsDependencyFree().booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public String MsgInfo() {
        return "No loop dependency";
    }

    @Override
    public String HoverInfo() {
        String sHoverInfo = "/*\tC-OCA: No cross-iteration dependencies\n\tCan be parallelized by adding the OpenMp statement as follows: */ \n ";
        m_sHoverString.insertCommentBeforNode(this.RootNode, sHoverInfo);
        m_sHoverString.setRecomandtion(this.createRecommendCode());
        return this.MsgInfo();
    }

    @Override
    public String ExtraInfo() {
        return "Potentially no cross-iterations' dependencies in the loop:\nIf loop does not contain 'return' or 'break' statements then one can simply add the OpenMP pragma for parallelication before the loop as follows:\n#pragma omp parallel for private(<list all loop's local variables separated by a comma>)\n\nOriginal loop example:\nfor (int i=0; i<100; i++)\n{ \n\tAarray[i] += i; \n\tBarray[i] = 0; \n} \n \nParallelized loop example using OpenMP pragma\n#pragma omp parallel for private(i)\nfor (int i=0; i<100; i++)\n{ \n\tAarray[i] += i; \n\tBarray[i] = 0; \n}\n\nHandling loops containing break statements:\nOpenMP does not support loops containing 'break' or 'return' statements such as the following loop:\n\n#pragma omp parallel for private(i)\nfor (i=0; i<N; i++)\n\t// loop body (1st part)\n\tif (cond(i))\n\t{\t\tbreak;\t// -> this break statement produces a compilation error\t}\t// loop body (2nd part)\n}\n\nThe above loop can be enabled in OpenMP by emulating the break statement as follows:\n\n#define CHUNK_I\t\t (omp_get_thread_num()*N / omp_get_num_threads())\n#define CHUNK_I_PLUS_1((omp_get_thread_num()+1)*N / omp_get_num_threads())\nint iCond = -1;\n#pragma omp parallel private(i)\n{\n\tint i;\n\tint stop;\n\tfor (i=CHUNK_I; i < CHUNK_I_PLUS_1 && iCond < 0; i++)\n\t{\n\t\t// loop body (1st part)\n\t\tif (cond(i))\n\t\t{\n\t\t\tiCond = i;\n\t\t}\n// loop body (2nd part)\n\t}\n}";
    }

    private String createRecommendCode() {
        String index = this.getCondtionExp((IASTForStatement)this.RootNode);
        String ret = "\n\n===========Recommended parallel code============\n#pragma omp parallel for";
        if (index != "") {
            ret = String.valueOf(ret) + " private (" + index + ")";
        }
        ret = String.valueOf(ret) + "\n" + this.RootNode.getRawSignature() + "\n";
        return ret;
    }
}

