/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class CheckFuncCall
extends CheckVisitor {
    private boolean m_bIsHaving;
    private String m_sHoverInfo;
    private Stack<IASTNode> m_stackInsideLoop;

    public CheckFuncCall(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitStatements = true;
        this.shouldVisitExpressions = true;
        this.m_bIsHaving = false;
        this.m_sHoverInfo = "";
        this.m_stackInsideLoop = new Stack();
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckFuncCall(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckFuncCall(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckFuncCall(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Function call inside a loop";
    }

    @Override
    public String HoverInfo() {
        return this.m_sHoverInfo;
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.push((IASTNode)stmt);
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }

    public int visit(IASTExpression expr) {
        if (expr instanceof IASTFunctionCallExpression && this.m_stackInsideLoop.size() == 1) {
            m_sHoverString.insertCommentBeforNode((IASTNode)expr, "/*\tC-OCA: Function call from within the loop. Make sure function does not contain side effects in order for the loop to be parallelized. */\n");
            this.m_bIsHaving = true;
        }
        return 3;
    }
}

