/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.COperatorGroup;
import cpd.checkers.core.CheckVisitor;
import cpd.checkers.core.ExpressionExtractor;
import cpd.checkers.core.OperandsDependencyHash;
import cpd.checkers.core.OperandsSet;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class CheckLoopDistribution
extends CheckVisitor {
    OperandsSet m_lValues;
    OperandsSet m_rValues;
    OperandsDependencyHash m_OperandsHashMap;
    Boolean m_bIsTransitivityFound;
    Boolean m_bCompoundAssignmentUsed;
    Boolean m_bUnaryExpressionUsed;
    Boolean already_exist = false;
    Boolean m_lValues_size = false;
    OperandsSet m_setDiscarded;
    private Boolean m_bFirstTimeVisiting = false;

    public CheckLoopDistribution(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_lValues = new OperandsSet();
        this.m_rValues = new OperandsSet();
        this.m_OperandsHashMap = new OperandsDependencyHash();
        this.m_bIsTransitivityFound = false;
        this.m_bCompoundAssignmentUsed = false;
        this.m_bUnaryExpressionUsed = false;
        this.m_setDiscarded = new OperandsSet();
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckLoopDistribution(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    public int visit(IASTExpression stmt) {
        IASTUnaryExpression UnaryStmt;
        int nOperType;
        String operand1 = new String();
        String operand2 = new String();
        OperandsSet operand2set = new OperandsSet();
        if (stmt instanceof IASTBinaryExpression) {
            IASTBinaryExpression BinaryExp = (IASTBinaryExpression)stmt;
            int nOperatorType = BinaryExp.getOperator();
            if (BinaryExp.getOperand1().getChildren().length > 0 && (COperatorGroup.IsAssignmentOperator(nOperatorType).booleanValue() || COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue())) {
                operand1 = BinaryExp.getOperand1().getChildren()[0].getRawSignature();
                if (this.m_lValues.contains(operand1)) {
                    this.already_exist = true;
                }
                this.m_lValues.add(operand1);
                if (BinaryExp.getOperand2().getChildren().length == 1 || BinaryExp.getOperand2() instanceof IASTArraySubscriptExpression) {
                    operand2 = BinaryExp.getOperand2().getRawSignature();
                    operand2set.add(operand2);
                } else {
                    ExpressionExtractor ExtracorVisitor = new ExpressionExtractor(operand2set);
                    BinaryExp.getOperand2().accept((ASTVisitor)ExtracorVisitor);
                }
                OperandsSet it = (OperandsSet)operand2set.clone();
                for (String str : it) {
                    if (this.m_OperandsHashMap.get(str) == null) continue;
                    operand2set.remove(str);
                    operand2set.addAll((Collection)this.m_OperandsHashMap.get(str));
                    this.m_bIsTransitivityFound = true;
                    this.m_setDiscarded.add(str);
                }
                this.m_rValues.addAll(operand2set);
                this.m_OperandsHashMap.put(operand1, operand2set);
            } else if (COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue()) {
                this.m_bCompoundAssignmentUsed = true;
                return 1;
            }
        } else if (stmt instanceof IASTUnaryExpression && COperatorGroup.IsUnaryModifier(nOperType = (UnaryStmt = (IASTUnaryExpression)stmt).getOperator()).booleanValue()) {
            this.m_bUnaryExpressionUsed = true;
            return 1;
        }
        return 3;
    }

    public int visit(IASTStatement stmt) {
        if (!this.m_bFirstTimeVisiting.booleanValue()) {
            this.RootNode = stmt.getParent();
            this.m_bFirstTimeVisiting = true;
        }
        return 3;
    }

    Boolean IsDistributional() {
        OperandsSet intersection = OperandsSet.intersection(this.m_lValues, this.m_rValues);
        if (this.m_lValues.size() <= 1) {
            this.m_lValues_size = true;
        }
        if (!this.m_lValues_size.booleanValue() && !this.already_exist.booleanValue()) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckLoopDistribution(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckLoopDistribution(IsExitPoint, IsReportComment);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.IsDistributional().booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public String MsgInfo() {
        return "Loop distribution";
    }

    @Override
    public String HoverInfo() {
        String recommand = null;
        String sHoverInfo = "";
        if (this.m_bIsTransitivityFound.booleanValue()) {
            sHoverInfo = "/*\tC-OCA: Loop distribution\n\tFollowing to a dependency between the vaiables, an ERROR occured\n\n\t*** IN CASE OF JUST A LOOP DISTRIBUTION RECOMMENDATION ***\n\t      ***PLEASE IGNORE THE RECOMENDATION BELOW ***\n\n\tHINT: m_bIsTransitivityFound */\n";
        } else if (this.m_bUnaryExpressionUsed.booleanValue()) {
            sHoverInfo = "/*\tC-OCA: Loop distribution\n\tFollowing to a dependency between the vaiables, an ERROR occured\n\n\t*** IN CASE OF JUST A LOOP DISTRIBUTION RECOMMENDATION ***\n\t      ***PLEASE IGNORE THE RECOMENDATION BELOW ***\n\n\tHINT: m_bUnaryExpressionUsed */\n";
        } else if (this.m_bCompoundAssignmentUsed.booleanValue()) {
            sHoverInfo = "/*\tC-OCA: Loop distribution\n\tFollowing to a dependency between the vaiables, an ERROR occured\n\n\t*** IN CASE OF JUST A LOOP DISTRIBUTION RECOMMENDATION ***\n\t      ***PLEASE IGNORE THE RECOMENDATION BELOW ***\n\n\tHINT: m_bCompoundAssignmentUsed */\n";
        } else {
            sHoverInfo = "/*\tC-OCA: Loop distribution\n\tLoop may be split into several loops to be parallelized separately. \n\tSplit the loop and re-apply C-OCA comments to try and parallelize each loop separately. \n\t(see more details at: http://www.optca.org/omp-transformations.html#_Toc461635028) */\n";
            if (this.RootNode instanceof IASTForStatement) {
                recommand = String.format("\n\n===========Recommended parallel code============\n%s", this.createRecommendCode());
                m_sHoverString.setRecomandtion(recommand);
            }
        }
        m_sHoverString.insertCommentBeforNode(this.RootNode, sHoverInfo);
        return this.MsgInfo();
    }

    private String String(int i) {
        return null;
    }

    @Override
    public String ExtraInfo() {
        String strMsg = new String();
        strMsg = "\nIn this case you can discard ";
        return String.valueOf(strMsg) + this.m_setDiscarded.toString() + "\nOne can split the loop into multiple smaller loops and then add the OpenMP pragma directive to Parallelize them. \n" + "See the following example\n  " + "\n For the given loop below: \n" + "for (i=0; i<100; i++) " + "{ \n " + "  A[i] = i; \n " + "  B[i] = A[i] \n " + "}   \n \n" + " We can transform it into the following two loops: \n" + "for (i=0; i<100; i++) " + "{ \n " + "  A[i] = i; \n " + "}   \n " + "for (i=0; i<100; i++) " + "{ \n " + "  B[i] = A[i] \n " + "}   \n \n" + " And now, we can parallelize them using the OpenMP pragma as follows: \n\n" + "#pragma omp parallel for \n" + "for (i=0; i<100; i++) " + "{ \n " + "  A[i] = i; \n " + "}   \n " + "\n #pragma omp parallel for \n" + "for (i=0; i<100; i++) " + "{ \n " + "  B[i] = A[i] \n " + "}   \n \n";
    }

    private String createRecommendCode() {
        String ret = "";
        String loop = "for (";
        int i = 0;
        while (i < 3) {
            if (i == 2) {
                loop = String.valueOf(loop) + ";";
            }
            loop = String.valueOf(loop) + this.RootNode.getChildren()[i].getRawSignature();
            ++i;
        }
        IASTNode forcompund = this.RootNode.getChildren()[this.RootNode.getChildren().length - 1];
        IASTNode[] iASTNodeArray = forcompund.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode line = iASTNodeArray[n2];
            ret = String.valueOf(ret) + "#pragma omp parallel for \n" + loop + ") {\n\t" + line.getRawSignature() + "\n}\n\n";
            ++n2;
        }
        return ret;
    }
}

