/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class CheckLoopExit
extends CheckVisitor {
    private boolean m_bIsHaving;
    private String m_sHoverInfo;
    private boolean m_bInsideSwitch;
    private Stack<IASTNode> m_stackInsideLoop;
    private IASTForStatement m_nodePrant;

    public CheckLoopExit(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitStatements = true;
        this.m_bIsHaving = false;
        this.m_sHoverInfo = "";
        this.m_bInsideSwitch = false;
        this.m_stackInsideLoop = new Stack();
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckLoopExit(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckLoopExit(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckLoopExit(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Loop execution break";
    }

    @Override
    public String HoverInfo() {
        return this.m_sHoverInfo;
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTSwitchStatement) {
            this.m_bInsideSwitch = true;
        } else if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_nodePrant = (IASTForStatement)stmt;
            this.m_stackInsideLoop.push((IASTNode)stmt);
        } else if (this.m_stackInsideLoop.size() == 1) {
            if (stmt instanceof IASTBreakStatement) {
                if (!this.m_bInsideSwitch) {
                    m_sHoverString.insertCommentBeforNode((IASTNode)stmt, "/*\tC-OCA: Consider applying 'break' statement emulation for parallelization.\n\t\t\t (see details at: http://www.optca.org/omp-transformations.html#_Toc461635026 ) */\n");
                    if (!this.m_bIsHaving) {
                        this.m_bIsHaving = true;
                        if (stmt.getParent().getParent() instanceof IASTIfStatement) {
                            IASTIfStatement ifnode = (IASTIfStatement)stmt.getParent().getParent();
                            m_sHoverString.setRecomandtion(this.braekRecomandtion(ifnode));
                        } else {
                            this.m_bIsHaving = true;
                            m_sHoverString.setRecomandtion("\n\n===========Recommended parallel code============\n//This code can't be parallel");
                        }
                    }
                }
            } else if (stmt instanceof IASTReturnStatement) {
                m_sHoverString.insertCommentBeforNode((IASTNode)stmt, "/*\tC-OCA: Consider applying 'return' statement emulation for parallelization. */\n");
                this.m_bIsHaving = true;
            }
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTSwitchStatement) {
            this.m_bInsideSwitch = false;
        } else if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }

    private String braekRecomandtion(IASTIfStatement ifNode) {
        String rec = new String("");
        IASTForStatement stmt = this.m_nodePrant;
        String bouder = this.getLoopBounde(stmt);
        String index = this.getCondtionExp(stmt);
        String Condtion = ifNode.getRawSignature();
        Condtion = Condtion.replaceAll("break;", "icond = " + index + ";");
        rec = "\n\n===========Recommended parallel code============\n#define MAX_P\t\t(omp_get_max_threads())\n#define P\t\t\t(omp_get_num_threads())\n#define CHUNK_SIZE\t4\n\nint k;\nint icond =" + bouder + ";\n" + "for(k=0; k<" + bouder + "; k += P*CHUNK_SIZE){\n" + "\tint " + index + ";\n\ticond = " + bouder + ";\n" + "\t#pragma omp parallel for private(" + index + ") reduction(min:icond)\n" + "\tfor(" + index + " = k; " + index + " < k+P*CHUNK_SIZE; " + index + "++){\n" + "\t\t" + Condtion + "\n\t}\n" + "\tif(icond < " + bouder + ")\n" + "\t\tbreak;\n" + "}";
        return rec;
    }
}

