/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class CheckPeeling
extends CheckVisitor {
    private int numofif;
    private String first_or_last;
    private String numofiterations;
    private String iterator;
    private int iterationcounter;
    private Boolean trueiter = false;
    private Boolean m_bFirstStatement = true;
    private int m_iStatementCounter = 0;
    private boolean depenencyFree = true;

    public CheckPeeling(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckPeeling(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    public int visit(IASTExpression stmt) {
        return 3;
    }

    public int visit(IASTStatement stmt) {
        this.inciStatementCounter();
        IASTStatement papa = (IASTStatement)stmt.getParent();
        if (papa instanceof IASTForStatement && ((IASTForStatement)papa).getIterationExpression() instanceof IASTUnaryExpression && ((IASTForStatement)papa).getConditionExpression() instanceof IASTBinaryExpression) {
            IASTUnaryExpression iter = (IASTUnaryExpression)((IASTForStatement)papa).getIterationExpression();
            this.setIterator(iter.getOperand().getRawSignature());
            IASTBinaryExpression numofit = (IASTBinaryExpression)((IASTForStatement)papa).getConditionExpression();
            String cnt = numofit.getOperand2().getRawSignature();
            try {
                this.setIterationcounter(Integer.parseInt(cnt));
            }
            catch (Exception e) {
                this.setIterationcounter(1000);
            }
        }
        if (stmt instanceof IASTIfStatement) {
            if (this.getM_iStatementCounter() > 2) {
                this.m_bFirstStatement = false;
            }
            this.IncIfStatments();
            IASTIfStatement ifstmt = (IASTIfStatement)stmt;
            IASTExpression ifexp = ifstmt.getConditionExpression();
            if (ifexp instanceof IASTBinaryExpression) {
                IASTBinaryExpression BinaryExp = (IASTBinaryExpression)ifexp;
                this.SetMessage(BinaryExp);
            }
        }
        return 3;
    }

    private void SetMessage(IASTBinaryExpression BinaryExp) {
        if (this.getIterator() != null && this.getIterator().equals(BinaryExp.getOperand1().getRawSignature())) {
            this.trueiter = true;
        }
        if (9 == BinaryExp.getOperator()) {
            this.setFirst_or_last("last");
        }
        if (11 == BinaryExp.getOperator()) {
            this.setFirst_or_last("last");
        }
        if (8 == BinaryExp.getOperator()) {
            this.setFirst_or_last("first");
        }
        if (10 == BinaryExp.getOperator()) {
            this.setFirst_or_last("first");
        }
        this.setNumofiterations(BinaryExp.getOperand2().getRawSignature());
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckPeeling(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckPeeling(IsExitPoint, IsReportComment);
    }

    private Boolean IsPeeling() {
        if (this.numofif == 1 && this.trueiter.booleanValue() && this.m_bFirstStatement.booleanValue() && this.depenencyFree) {
            return true;
        }
        return false;
    }

    private int IncIfStatments() {
        return ++this.numofif;
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.IsPeeling().booleanValue()) {
            return true;
        }
        return false;
    }

    private void setFirst_or_last(String first_or_last) {
        this.first_or_last = first_or_last;
    }

    public String getFirst_or_last() {
        return this.first_or_last;
    }

    private void setNumofiterations(String numofiterations) {
        this.numofiterations = numofiterations;
    }

    public String getNumofiterations() {
        return this.numofiterations;
    }

    private void setIterator(String iterator) {
        this.iterator = iterator;
    }

    public String getIterator() {
        return this.iterator;
    }

    private int getM_iStatementCounter() {
        return this.m_iStatementCounter;
    }

    private int inciStatementCounter() {
        return ++this.m_iStatementCounter;
    }

    private void setIterationcounter(int iterationcounter) {
        this.iterationcounter = iterationcounter;
    }

    private int getIterationcounter() {
        return this.iterationcounter;
    }

    @Override
    public String MsgInfo() {
        return "This loop needs some peeling";
    }

    @Override
    public String HoverInfo() {
        return String.valueOf(this.ExtraInfo()) + "#pragma omp parallel for \n" + "Example: Before \n" + "for (i=0; i<100; i++)  { \n " + "{ \n " + "    if (i<3) \n" + "     { \n " + "        printf(\"Why not take this out?\"); \n" + "     } \n" + " counter+=a[i]; \n" + "}   \n  \n" + "Example After \n" + "for (i=0; i<3; i++) \n" + "{ \n " + "printf(\"Why not take this out?\"); \n" + "} \n" + "#pragma omp parallel for" + "for (i=0; i<100; i++) \n" + "{ \n      " + "   counter+=a[i]; \n" + "}   \n              ";
    }

    @Override
    public String ExtraInfo() {
        String str = null;
        if (this.getFirst_or_last() == "first") {
            str = "In this case you can take out " + this.getNumofiterations() + " first itereation.  the iterator is " + this.getIterator();
        } else if (this.getFirst_or_last() == "last") {
            str = "In this case you can take out " + (this.getIterationcounter() - Integer.parseInt(this.getNumofiterations())) + " last itereation.  the iterator is " + this.getIterator();
        }
        return str;
    }
}

