/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import cpd.checkers.core.OperandsSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTUnaryExpression;

public class CheckScalarExpansion
extends CheckVisitor {
    private boolean m_bIsHaving;
    private String m_sHoverInfo;
    private Stack<IASTNode> m_stackInsideLoop;
    private HashMap<String, Integer> mapLValue = new HashMap();
    private HashMap<String, Integer> mapRValue = new HashMap();
    private OperandsSet condSet;
    private ArrayList<String> m_var_literal = new ArrayList();
    private String index;
    private String limit;
    private String compSign;
    private String iterat;

    public CheckScalarExpansion(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_bIsHaving = false;
        this.m_sHoverInfo = "";
        this.m_bExitPoint = IsExitPoint;
        this.m_stackInsideLoop = new Stack();
        this.mapLValue = new HashMap();
        this.mapRValue = new HashMap();
        this.condSet = new OperandsSet();
    }

    public CheckScalarExpansion(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckScalarExpansion(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckScalarExpansion(IsExitPoint, IsReportComment);
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            if (stmt instanceof IASTForStatement) {
                IASTExpression conditionExp = ((IASTForStatement)stmt).getConditionExpression();
                String strChild1 = conditionExp.getChildren()[0].getRawSignature();
                String strChild2 = conditionExp.getChildren()[1].getRawSignature();
                this.condSet.add(strChild1);
                this.condSet.add(strChild2);
            }
            if (this.m_stackInsideLoop.empty()) {
                this.RootNode = stmt;
            }
            this.m_stackInsideLoop.push((IASTNode)stmt);
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            if (this.m_stackInsideLoop.size() == 1) {
                LinkedList<String> listLiteralExpansion = new LinkedList<String>();
                for (Map.Entry<String, Integer> entry : this.mapLValue.entrySet()) {
                    if (this.mapRValue.containsKey(entry.getKey())) {
                        if (entry.getValue() >= this.mapRValue.get(entry.getKey())) continue;
                        listLiteralExpansion.addLast(entry.getKey());
                        continue;
                    }
                    listLiteralExpansion.addLast(entry.getKey());
                }
                if (listLiteralExpansion.size() > 0) {
                    this.m_bIsHaving = true;
                    this.m_sHoverInfo = "/*\tC-OCA: Scalar expansion may need to be considered for the following scalar variables:\n";
                    for (String Literal : listLiteralExpansion) {
                        this.m_var_literal.add(Literal);
                        this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "\t\t" + Literal + "\n";
                    }
                    this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "*/\n";
                    m_sHoverString.insertCommentBeforNode(this.RootNode, this.m_sHoverInfo);
                }
            }
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }

    private IASTStatement getEnclosingStatement(IASTNode expr) {
        IASTNode EnclosingNode = expr.getParent();
        while (!(EnclosingNode instanceof IASTStatement)) {
            EnclosingNode = EnclosingNode.getParent();
        }
        return (IASTStatement)EnclosingNode;
    }

    private IASTNode getEnclosingExpression(IASTNode expr) {
        IASTNode EnclosingNode = expr.getParent();
        while (!(EnclosingNode instanceof IASTExpression) && !(EnclosingNode instanceof IASTDeclarator) && EnclosingNode != null) {
            EnclosingNode = EnclosingNode.getParent();
        }
        return EnclosingNode;
    }

    public int visit(IASTExpression expr) {
        boolean bLValue = false;
        boolean bRValue = false;
        if (expr instanceof IASTIdExpression) {
            IASTNode EnclosingExpression = this.getEnclosingExpression((IASTNode)expr);
            if (EnclosingExpression instanceof IASTBinaryExpression) {
                IASTBinaryExpression BinaryExpression = (IASTBinaryExpression)EnclosingExpression;
                if (BinaryExpression.isLValue() && BinaryExpression.getOperand1().getRawSignature().contains(expr.getRawSignature())) {
                    bLValue = true;
                }
                if (BinaryExpression.getOperand2().getRawSignature().contains(expr.getRawSignature())) {
                    bRValue = true;
                }
            } else if (EnclosingExpression instanceof IASTUnaryExpression) {
                bLValue = true;
            } else if (EnclosingExpression instanceof IASTDeclarator) {
                bLValue = true;
            } else if (EnclosingExpression == null) {
                bRValue = true;
            }
            if (bLValue) {
                for (String co : this.condSet) {
                    if (!expr.getRawSignature().equals(co)) continue;
                    bLValue = false;
                    break;
                }
            }
            IASTStatement EnclosingStatement = this.getEnclosingStatement((IASTNode)expr);
            int iStatementLocation = EnclosingStatement.getNodeLocations()[0].getNodeOffset();
            if (bLValue) {
                this.mapLValue.put(expr.getRawSignature(), iStatementLocation);
            }
        }
        return 3;
    }

    @Override
    public String MsgInfo() {
        return "Scalar expansion";
    }

    @Override
    public String HoverInfo() {
        IASTForStatement stmt = (IASTForStatement)this.RootNode;
        IASTStatement ForStemant = stmt.getBody();
        IASTNode[] lines = ForStemant.getChildren();
        String bounder = this.getLoopBounde(stmt);
        String init = this.getInitExp(stmt);
        String add1 = "";
        boolean notInitilized = false;
        boolean addOne = false;
        boolean upToDown = false;
        boolean noRec = false;
        String RecomandtionString = "\n\n===========Recommended parallel code============\n";
        this.index = this.getCondtionExp(stmt);
        this.limit = bounder;
        this.compSign = this.getCompSign(stmt);
        this.iterat = this.getIterat(stmt);
        if (init == "") {
            notInitilized = true;
            init = this.index;
        }
        if (this.iterat == "-") {
            upToDown = true;
            bounder = init;
        }
        if (this.compSign == "<=" || this.compSign == ">=") {
            addOne = true;
            add1 = " + 1";
        }
        for (String literal : this.m_var_literal) {
            RecomandtionString = String.valueOf(RecomandtionString) + "int Arr" + literal.toUpperCase() + "[" + bounder + add1 + "]" + ";\n";
        }
        for (String literal : this.m_var_literal) {
            String dec1 = "";
            if (upToDown) {
                if (!addOne) {
                    dec1 = " - 1";
                }
                RecomandtionString = String.valueOf(RecomandtionString) + "Arr" + literal.toUpperCase() + "[" + bounder + dec1 + "] = " + literal + ";\n";
                continue;
            }
            RecomandtionString = String.valueOf(RecomandtionString) + "Arr" + literal.toUpperCase() + "[" + init + "] = " + literal + ";\n";
        }
        if (notInitilized) {
            RecomandtionString = String.valueOf(RecomandtionString) + "int iterator = " + this.index + ";\n";
        }
        RecomandtionString = String.valueOf(RecomandtionString) + "\n";
        String loop = "for (";
        int i = 0;
        while (i < 3) {
            if (i == 2) {
                loop = String.valueOf(loop) + ";";
            }
            loop = i == 0 && notInitilized ? String.valueOf(loop) + this.index + " = iterator;" : String.valueOf(loop) + this.RootNode.getChildren()[i].getRawSignature();
            ++i;
        }
        IASTNode[] iASTNodeArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode line = iASTNodeArray[n2];
            if (line.getChildren().length > 1) {
                noRec = true;
                break;
            }
            boolean noParallel = false;
            String new_line = line.getRawSignature();
            String before = "";
            if (line instanceof CASTExpressionStatement) {
                IASTBinaryExpression lineComp;
                CASTExpressionStatement es = (CASTExpressionStatement)line;
                IASTExpression exp = es.getExpression();
                if (exp instanceof CASTBinaryExpression) {
                    lineComp = (IASTBinaryExpression)exp;
                    String part1 = lineComp.getOperand1().getRawSignature();
                    String part2 = lineComp.getOperand2().getRawSignature();
                    for (String literal : this.m_var_literal) {
                        if (!part1.contains(literal) || !part2.contains(literal)) continue;
                        noParallel = true;
                        break;
                    }
                    for (String literal : this.m_var_literal) {
                        boolean isDepend = part1.contains(literal);
                        if (part1.contains(literal) && part2.contains(literal)) {
                            new_line = this.addLine(new_line, literal, isDepend);
                            continue;
                        }
                        if (lineComp.getOperator() <= 28 && lineComp.getOperator() >= 18) {
                            new_line = this.addLine(new_line, literal, isDepend);
                            continue;
                        }
                        if (!noParallel) {
                            before = "#pragma omp parallel for \n";
                        }
                        new_line = new_line.replaceAll(literal, "Arr" + literal.toUpperCase() + "[" + this.index + "]");
                    }
                } else if (exp instanceof CASTUnaryExpression) {
                    lineComp = (CASTUnaryExpression)exp;
                    IASTNode[] line_comp = lineComp.getOperand().getChildren();
                    for (String literal : this.m_var_literal) {
                        if (lineComp.getOperand().getRawSignature().equals(literal)) {
                            new_line = this.addLine(new_line, literal, true);
                            continue;
                        }
                        if (line_comp.length <= 1) continue;
                        IASTNode[] iASTNodeArray2 = line_comp;
                        int n3 = line_comp.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTNode comp = iASTNodeArray2[n4];
                            if (comp.getRawSignature().equals(literal)) {
                                before = "#pragma omp parallel for \n";
                                new_line = new_line.replaceAll(literal, "Arr" + literal.toUpperCase() + "[" + this.index + "]");
                            }
                            ++n4;
                        }
                    }
                } else {
                    noRec = true;
                    break;
                }
                RecomandtionString = String.valueOf(RecomandtionString) + before + loop + ")  {\n\t" + new_line + "\n}\n\n";
            }
            if (noRec) break;
            ++n2;
        }
        if (noRec) {
            RecomandtionString = "\n\n===========Recommended parallel code============\n\t/*No Recommendation for this code, \n\t\tfor more details see: http://www.optca.org/omp-transformations.html#_Toc461635029) */\n";
        } else {
            for (String literal : this.m_var_literal) {
                String dec1 = "";
                if (upToDown) {
                    RecomandtionString = String.valueOf(RecomandtionString) + literal + " = Arr" + literal.toUpperCase() + "[" + this.limit + "];\n";
                    continue;
                }
                if (!addOne) {
                    dec1 = " - 1";
                }
                RecomandtionString = String.valueOf(RecomandtionString) + literal + " = Arr" + literal.toUpperCase() + "[" + bounder + dec1 + "];\n";
            }
        }
        m_sHoverString.setRecomandtion(RecomandtionString);
        return this.m_sHoverInfo;
    }

    public String addLine(String new_line, String literal, boolean isDepend) {
        String add = "";
        new_line = new_line.replaceAll(literal, "Arr" + literal.toUpperCase() + "[" + this.index + "]");
        if (isDepend) {
            if (this.iterat == "-") {
                add = this.compSign == ">=" ? "if(" + this.index + " > " + this.limit + " ){\n\t\t" : "if(" + this.index + " > " + this.limit + " + 1 ){\n\t\t";
                add = String.valueOf(add) + "Arr" + literal.toUpperCase() + "[" + this.index + "-1] = Arr" + literal.toUpperCase() + "[" + this.index + "];\n\t}\n";
            } else if (this.iterat == "+") {
                add = this.compSign == "<=" ? "if(" + this.index + " < " + this.limit + " ){\n\t\t" : "if(" + this.index + " < " + this.limit + " - 1 ){\n\t\t";
                add = String.valueOf(add) + "Arr" + literal.toUpperCase() + "[" + this.index + "+1] = Arr" + literal.toUpperCase() + "[" + this.index + "];\n\t}\n";
            }
        }
        new_line = String.valueOf(new_line) + "\n\t" + add;
        return new_line;
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }
}

