/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.actions;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STAnnotatedSourceEditorActivator;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.actions.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public abstract class AbstractOpenSourceFileAction
extends Action {
    public static final String EDITOR_ID = "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.editor";
    private long ts;

    public AbstractOpenSourceFileAction(String filepath, long ts) {
        super.setText(NLS.bind((String)Messages.OpenSourceFileAction_open_src_action_text, (Object)filepath));
        this.ts = ts;
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IFileStore fileStore = this.getFileStore();
        if (fileStore != null && !fileStore.fetchInfo().isDirectory()) {
            if (fileStore.fetchInfo().exists()) {
                long timeStamp = fileStore.fetchInfo().getLastModified();
                if (timeStamp > this.ts) {
                    MessageBox msg = new MessageBox(window.getShell(), 65736);
                    msg.setText(fileStore.toString());
                    msg.setMessage(NLS.bind((String)Messages.OpenSourceFileAction_warning_inconsistency, (Object)fileStore));
                }
                try {
                    IWorkbenchPage page = window.getActivePage();
                    if (page != null) {
                        IFileStore fs = EFS.getStore((URI)fileStore.toURI());
                        FileStoreEditorInput input = this.getInput(fs);
                        page.openEditor((IEditorInput)input, EDITOR_ID, false);
                    }
                }
                catch (Exception e) {
                    Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor", 4, Messages.OpenSourceFileAction_view_error, (Throwable)e);
                    STAnnotatedSourceEditorActivator.getDefault().getLog().log((IStatus)s);
                }
            } else {
                this.showMessage(NLS.bind((String)Messages.OpenSourceFileAction_file_dne, (Object)fileStore), window.getShell());
            }
        }
    }

    private void showMessage(String message, Shell shell) {
        MessageBox msgBox = new MessageBox(shell, 1);
        msgBox.setText(Messages.OpenSourceFileAction_Error);
        msgBox.setMessage(message);
        msgBox.open();
    }

    public abstract FileStoreEditorInput getInput(IFileStore var1);

    public abstract IFileStore getFileStore();
}

