/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.dom.StatementRewrite;
import org.eclipse.jdt.internal.corext.fix.ExpressionsFix;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.OperatorPrecedence;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.ExpressionsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.GetterSetterCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedQuickAssistProcessor
implements IQuickAssistProcessor {
    @Override
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            return AdvancedQuickAssistProcessor.getConvertToIfReturnProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseIfProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getIfReturnIntoIfElseAtEndOfVoidMethodProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseIfContinueIntoIfThenInLoopsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseIfIntoContinueInLoopsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseConditionProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getRemoveExtraParenthesesProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getAddParanoidalParenthesesProposals(context, coveredNodes, null) || AdvancedQuickAssistProcessor.getAddParenthesesForExpressionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getJoinAndIfStatementsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getSplitAndConditionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getJoinOrIfStatementsProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getSplitOrConditionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseConditionalExpressionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getExchangeInnerAndOuterIfConditionsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getExchangeOperandsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getCastAndAssignIfStatementProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getCombineStringProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getPickOutStringProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getReplaceIfElseWithConditionalProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getReplaceConditionalWithIfElseProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseLocalVariableProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getPushNegationDownProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getPullNegationUpProposals(context, coveredNodes, null) || AdvancedQuickAssistProcessor.getJoinIfListInIfElseIfProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getConvertSwitchToIfProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getConvertIfElseToSwitchProposals(context, coveringNode, null) || GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, coveringNode, null, null);
        }
        return false;
    }

    @Override
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            ArrayList<ICommandAccess> resultingCollections = new ArrayList<ICommandAccess>();
            AdvancedQuickAssistProcessor.getReplaceConditionalWithIfElseProposals(context, coveringNode, resultingCollections);
            if (QuickAssistProcessor.noErrorsAtLocation(locations)) {
                AdvancedQuickAssistProcessor.getConvertToIfReturnProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseIfProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getIfReturnIntoIfElseAtEndOfVoidMethodProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseIfContinueIntoIfThenInLoopsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseIfIntoContinueInLoopsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseConditionProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getRemoveExtraParenthesesProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getAddParanoidalParenthesesProposals(context, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getAddParenthesesForExpressionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getJoinAndIfStatementsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getSplitAndConditionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getJoinOrIfStatementsProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getSplitOrConditionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseConditionalExpressionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getExchangeInnerAndOuterIfConditionsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getExchangeOperandsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getCastAndAssignIfStatementProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getCombineStringProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getPickOutStringProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getReplaceIfElseWithConditionalProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseLocalVariableProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getPushNegationDownProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getPullNegationUpProposals(context, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getJoinIfListInIfElseIfProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getConvertSwitchToIfProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getConvertIfElseToSwitchProposals(context, coveringNode, resultingCollections);
                GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, coveringNode, locations, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private static boolean getConvertToIfReturnProposals(IInvocationContext context, ASTNode coveringNode, ArrayList<ICommandAccess> resultingCollections) {
        List thenStatements;
        if (!(coveringNode instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)coveringNode;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        MethodDeclaration coveringMetod = ASTResolving.findParentMethodDeclaration((ASTNode)ifStatement);
        if (coveringMetod == null) {
            return false;
        }
        Type returnType = coveringMetod.getReturnType2();
        if (!AdvancedQuickAssistProcessor.isVoid(returnType)) {
            return false;
        }
        if (!(ifStatement.getParent() instanceof Block)) {
            return false;
        }
        Statement thenStatement = ifStatement.getThenStatement();
        if (thenStatement instanceof ReturnStatement) {
            return false;
        }
        if (thenStatement instanceof Block && ((thenStatements = ((Block)thenStatement).statements()).isEmpty() || thenStatements.size() == 1 && thenStatements.get(0) instanceof ReturnStatement)) {
            return false;
        }
        if (!AdvancedQuickAssistProcessor.isLastExecutableStatementInMethod((Statement)ifStatement)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = coveringNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, ifStatement.getExpression());
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(inversedExpression);
        newIf.setThenStatement((Statement)ast.newReturnStatement());
        ListRewrite listRewriter = rewrite.getListRewrite(ifStatement.getParent(), (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
        listRewriter.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
        ArrayList<Statement> statements = AdvancedQuickAssistProcessor.getUnwrappedStatements(ifStatement.getThenStatement());
        Statement lastStatement = statements.get(statements.size() - 1);
        if (lastStatement instanceof ReturnStatement) {
            statements.remove(lastStatement);
        }
        for (Statement statement : statements) {
            listRewriter.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_convertToIfReturn;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isVoid(Type type) {
        return type instanceof PrimitiveType && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID;
    }

    private static boolean isLastExecutableStatementInMethod(Statement statement) {
        Statement currentStructure = statement;
        ASTNode currentParent = statement.getParent();
        while (!(currentParent instanceof MethodDeclaration)) {
            Block parentBlock;
            if (currentParent instanceof ForStatement || currentParent instanceof EnhancedForStatement || currentParent instanceof WhileStatement || currentParent instanceof DoStatement) {
                return false;
            }
            if (currentParent instanceof Block && (parentBlock = (Block)currentParent).statements().indexOf(currentStructure) != parentBlock.statements().size() - 1) {
                return false;
            }
            currentStructure = currentParent;
            currentParent = currentParent.getParent();
        }
        return true;
    }

    private static boolean getIfReturnIntoIfElseAtEndOfVoidMethodProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        if (!(covering instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)covering;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        Statement thenStatement = ifStatement.getThenStatement();
        if (!(thenStatement instanceof Block)) {
            return false;
        }
        Block thenBlock = (Block)thenStatement;
        List thenStatements = thenBlock.statements();
        if (thenStatements.isEmpty() || !(thenStatements.get(thenStatements.size() - 1) instanceof ReturnStatement)) {
            return false;
        }
        MethodDeclaration coveringMetod = ASTResolving.findParentMethodDeclaration(covering);
        if (coveringMetod == null) {
            return false;
        }
        Type returnType = coveringMetod.getReturnType2();
        if (!AdvancedQuickAssistProcessor.isVoid(returnType)) {
            return false;
        }
        List statements = coveringMetod.getBody().statements();
        int ifIndex = statements.indexOf(ifStatement);
        if (ifIndex == -1) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)thenBlock, (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
        listRewriter.remove((ASTNode)thenStatements.get(thenStatements.size() - 1), null);
        Expression conditionPlaceholder = (Expression)rewrite.createMoveTarget((ASTNode)ifStatement.getExpression());
        Statement thenPlaceholder = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement());
        Block elseBlock = ast.newBlock();
        int i = ifIndex + 1;
        while (i < statements.size()) {
            Statement statement = (Statement)statements.get(i);
            elseBlock.statements().add(rewrite.createMoveTarget((ASTNode)statement));
            ++i;
        }
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(conditionPlaceholder);
        newIf.setThenStatement(thenPlaceholder);
        newIf.setElseStatement((Statement)elseBlock);
        rewrite.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_convertToIfElse_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseIfProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        if (!(covering instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)covering;
        if (ifStatement.getElseStatement() == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Statement thenStatement = ifStatement.getThenStatement();
        Statement elseStatement = ifStatement.getElseStatement();
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, ifStatement.getExpression());
        Statement newElseStatement = (Statement)rewrite.createMoveTarget((ASTNode)thenStatement);
        Statement newThenStatement = (Statement)rewrite.createMoveTarget((ASTNode)elseStatement);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)inversedExpression, null);
        if (elseStatement instanceof IfStatement) {
            Block elseBlock = ast.newBlock();
            elseBlock.statements().add(newThenStatement);
            newThenStatement = elseBlock;
        }
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.THEN_STATEMENT_PROPERTY, (Object)newThenStatement, null);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newElseStatement, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseIf_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseIfContinueIntoIfThenInLoopsProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        if (!(covering instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)covering;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        if (!(ifStatement.getThenStatement() instanceof ContinueStatement)) {
            return false;
        }
        Block loopBlock = null;
        if (ifStatement.getParent() instanceof Block && ifStatement.getParent().getParent() instanceof ForStatement) {
            loopBlock = (Block)ifStatement.getParent();
        } else if (ifStatement.getParent() instanceof Block && ifStatement.getParent().getParent() instanceof WhileStatement) {
            loopBlock = (Block)ifStatement.getParent();
        } else {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, ifStatement.getExpression());
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(inversedExpression);
        Block thenBlock = ast.newBlock();
        int ifIndex = loopBlock.statements().indexOf(ifStatement);
        int i = ifIndex + 1;
        while (i < loopBlock.statements().size()) {
            Statement statement = (Statement)loopBlock.statements().get(i);
            thenBlock.statements().add(rewrite.createMoveTarget((ASTNode)statement));
            ++i;
        }
        newIf.setThenStatement((Statement)thenBlock);
        rewrite.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseIfContinue_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseIfIntoContinueInLoopsProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        ASTRewrite rewrite;
        block10: {
            IfStatement newIf;
            Block ifParentBlock;
            IfStatement ifStatement;
            block8: {
                ASTNode ifParentStructure;
                block9: {
                    if (!(covering instanceof IfStatement)) {
                        return false;
                    }
                    ifStatement = (IfStatement)covering;
                    if (ifStatement.getElseStatement() != null) {
                        return false;
                    }
                    ASTNode ifParent = ifStatement.getParent();
                    ifParentBlock = null;
                    ifParentStructure = ifParent;
                    if (ifParentStructure instanceof Block) {
                        ifParentBlock = (Block)ifParent;
                        ifParentStructure = ifParentStructure.getParent();
                    }
                    if (!(ifParentStructure instanceof ForStatement) && !(ifParentStructure instanceof WhileStatement)) {
                        return false;
                    }
                    if (ifParentBlock != null && ifParentBlock.statements().indexOf(ifStatement) != ifParentBlock.statements().size() - 1) {
                        return false;
                    }
                    if (resultingCollections == null) {
                        return true;
                    }
                    AST ast = covering.getAST();
                    rewrite = ASTRewrite.create((AST)ast);
                    Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, ifStatement.getExpression());
                    newIf = ast.newIfStatement();
                    newIf.setExpression(inversedExpression);
                    newIf.setThenStatement((Statement)ast.newContinueStatement());
                    if (ifParentBlock != null) break block8;
                    ifParentBlock = ast.newBlock();
                    ifParentBlock.statements().add(newIf);
                    for (Statement statement : AdvancedQuickAssistProcessor.getUnwrappedStatements(ifStatement.getThenStatement())) {
                        ifParentBlock.statements().add(rewrite.createMoveTarget((ASTNode)statement));
                    }
                    if (!(ifParentStructure instanceof ForStatement)) break block9;
                    rewrite.set(ifParentStructure, (StructuralPropertyDescriptor)ForStatement.BODY_PROPERTY, (Object)ifParentBlock, null);
                    break block10;
                }
                if (!(ifParentStructure instanceof WhileStatement)) break block10;
                rewrite.set(ifParentStructure, (StructuralPropertyDescriptor)WhileStatement.BODY_PROPERTY, (Object)ifParentBlock, null);
                break block10;
            }
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)ifParentBlock, (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
            listRewriter.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
            for (Statement statement : AdvancedQuickAssistProcessor.getUnwrappedStatements(ifStatement.getThenStatement())) {
                listRewriter.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
            }
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseIfToContinue_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static ArrayList<Statement> getUnwrappedStatements(Statement body) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (body instanceof Block) {
            for (Statement statement : ((Block)body).statements()) {
                statements.add(statement);
            }
        } else {
            statements.add(body);
        }
        return statements;
    }

    private static boolean getInverseConditionProposals(IInvocationContext context, ASTNode covering, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        if (coveredNodes.isEmpty()) {
            return false;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        boolean hasChanges = false;
        for (ASTNode covered : coveredNodes) {
            Expression coveredExpression = AdvancedQuickAssistProcessor.getBooleanExpression(covered);
            if (coveredExpression == null) continue;
            Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, coveredExpression);
            rewrite.replace((ASTNode)coveredExpression, (ASTNode)inversedExpression, null);
            hasChanges = true;
        }
        if (!hasChanges) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseConditions_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getInversedExpression(ASTRewrite rewrite, Expression expression) {
        return AdvancedQuickAssistProcessor.getInversedExpression(rewrite, expression, null);
    }

    private static Expression getRenamedNameCopy(SimpleNameRenameProvider provider, ASTRewrite rewrite, Expression expression) {
        SimpleName name;
        SimpleName newName;
        if (provider != null && expression instanceof SimpleName && (newName = provider.getRenamed(name = (SimpleName)expression)) != null) {
            return newName;
        }
        return (Expression)rewrite.createCopyTarget((ASTNode)expression);
    }

    private static Expression getInversedExpression(ASTRewrite rewrite, Expression expression, SimpleNameRenameProvider provider) {
        PrefixExpression prefixExpression;
        AST ast = rewrite.getAST();
        if (expression instanceof BooleanLiteral) {
            return ast.newBooleanLiteral(!((BooleanLiteral)expression).booleanValue());
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            InfixExpression.Operator operator = infixExpression.getOperator();
            if (operator == InfixExpression.Operator.LESS) {
                return AdvancedQuickAssistProcessor.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.GREATER_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.GREATER) {
                return AdvancedQuickAssistProcessor.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.LESS_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.LESS_EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.GREATER, provider);
            }
            if (operator == InfixExpression.Operator.GREATER_EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.LESS, provider);
            }
            if (operator == InfixExpression.Operator.EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.NOT_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.NOT_EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.CONDITIONAL_OR, provider);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.CONDITIONAL_AND, provider);
            }
            if (operator == InfixExpression.Operator.AND) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.OR, provider);
            }
            if (operator == InfixExpression.Operator.OR) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.AND, provider);
            }
            if (operator == InfixExpression.Operator.XOR) {
                return AdvancedQuickAssistProcessor.getInversedNotExpression(rewrite, expression, ast);
            }
        }
        if (expression instanceof PrefixExpression && (prefixExpression = (PrefixExpression)expression).getOperator() == PrefixExpression.Operator.NOT) {
            Expression renamedNameCopy;
            Expression operand = prefixExpression.getOperand();
            if (operand instanceof ParenthesizedExpression && NecessaryParenthesesChecker.canRemoveParentheses(operand, expression.getParent(), expression.getLocationInParent())) {
                operand = ((ParenthesizedExpression)operand).getExpression();
            }
            if ((renamedNameCopy = AdvancedQuickAssistProcessor.getRenamedNameCopy(provider, rewrite, operand)) instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)renamedNameCopy;
                infixExpression.setOperator(((InfixExpression)operand).getOperator());
            }
            return renamedNameCopy;
        }
        if (expression instanceof InstanceofExpression) {
            return AdvancedQuickAssistProcessor.getInversedNotExpression(rewrite, expression, ast);
        }
        if (expression instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
            Expression innerExpression = parenthesizedExpression.getExpression();
            while (innerExpression instanceof ParenthesizedExpression) {
                innerExpression = ((ParenthesizedExpression)innerExpression).getExpression();
            }
            if (innerExpression instanceof InstanceofExpression) {
                return AdvancedQuickAssistProcessor.getInversedExpression(rewrite, innerExpression, provider);
            }
            parenthesizedExpression = AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, AdvancedQuickAssistProcessor.getInversedExpression(rewrite, innerExpression, provider));
            return parenthesizedExpression;
        }
        if (expression instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            ConditionalExpression newExpression = ast.newConditionalExpression();
            newExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)conditionalExpression.getExpression()));
            newExpression.setThenExpression(AdvancedQuickAssistProcessor.getInversedExpression(rewrite, conditionalExpression.getThenExpression()));
            newExpression.setElseExpression(AdvancedQuickAssistProcessor.getInversedExpression(rewrite, conditionalExpression.getElseExpression()));
            return newExpression;
        }
        prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        Expression renamedNameCopy = AdvancedQuickAssistProcessor.getRenamedNameCopy(provider, rewrite, expression);
        if (NecessaryParenthesesChecker.needsParentheses(renamedNameCopy, (ASTNode)prefixExpression, (StructuralPropertyDescriptor)PrefixExpression.OPERAND_PROPERTY)) {
            renamedNameCopy = AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, renamedNameCopy);
        }
        prefixExpression.setOperand(renamedNameCopy);
        return prefixExpression;
    }

    private static Expression getInversedNotExpression(ASTRewrite rewrite, Expression expression, AST ast) {
        PrefixExpression prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        ParenthesizedExpression parenthesizedExpression = AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, (Expression)rewrite.createCopyTarget((ASTNode)expression));
        prefixExpression.setOperand((Expression)parenthesizedExpression);
        return prefixExpression;
    }

    private static boolean isBoolean(Expression expression) {
        AST ast;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        return typeBinding == (ast = expression.getAST()).resolveWellKnownType("boolean") || typeBinding == ast.resolveWellKnownType("java.lang.Boolean");
    }

    private static Expression getInversedInfixExpression(ASTRewrite rewrite, InfixExpression expression, InfixExpression.Operator newOperator, SimpleNameRenameProvider provider) {
        InfixExpression newExpression = rewrite.getAST().newInfixExpression();
        newExpression.setOperator(newOperator);
        newExpression.setLeftOperand(AdvancedQuickAssistProcessor.getRenamedNameCopy(provider, rewrite, expression.getLeftOperand()));
        newExpression.setRightOperand(AdvancedQuickAssistProcessor.getRenamedNameCopy(provider, rewrite, expression.getRightOperand()));
        return newExpression;
    }

    private static Expression parenthesizeIfRequired(Expression operand, int newOperatorPrecedence) {
        if (newOperatorPrecedence > OperatorPrecedence.getExpressionPrecedence(operand)) {
            return AdvancedQuickAssistProcessor.getParenthesizedExpression(operand.getAST(), operand);
        }
        return operand;
    }

    private static Expression getInversedAndOrExpression(ASTRewrite rewrite, InfixExpression infixExpression, InfixExpression.Operator newOperator, SimpleNameRenameProvider provider) {
        InfixExpression newExpression = rewrite.getAST().newInfixExpression();
        newExpression.setOperator(newOperator);
        int newOperatorPrecedence = OperatorPrecedence.getOperatorPrecedence(newOperator);
        Expression leftOperand = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, infixExpression.getLeftOperand(), provider);
        newExpression.setLeftOperand(AdvancedQuickAssistProcessor.parenthesizeIfRequired(leftOperand, newOperatorPrecedence));
        Expression rightOperand = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, infixExpression.getRightOperand(), provider);
        newExpression.setRightOperand(AdvancedQuickAssistProcessor.parenthesizeIfRequired(rightOperand, newOperatorPrecedence));
        List extraOperands = infixExpression.extendedOperands();
        List newExtraOperands = newExpression.extendedOperands();
        int i = 0;
        while (i < extraOperands.size()) {
            Expression extraOperand = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, (Expression)extraOperands.get(i), provider);
            newExtraOperands.add(AdvancedQuickAssistProcessor.parenthesizeIfRequired(extraOperand, newOperatorPrecedence));
            ++i;
        }
        return newExpression;
    }

    private static boolean getRemoveExtraParenthesesProposals(IInvocationContext context, ASTNode covering, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        ArrayList<Object> nodes;
        if (context.getSelectionLength() == 0 && covering instanceof ParenthesizedExpression) {
            nodes = new ArrayList();
            nodes.add(covering);
        } else {
            nodes = coveredNodes;
        }
        if (nodes.isEmpty()) {
            return false;
        }
        ExpressionsFix fix = ExpressionsFix.createRemoveUnnecessaryParenthesisFix(context.getASTRoot(), nodes.toArray(new ASTNode[nodes.size()]));
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.remove_correction.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.use_parentheses_in_expressions", "true");
        options.put("cleanup.never_use_parentheses_in_expressions", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new ExpressionsCleanUp(options), 1, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getAddParanoidalParenthesesProposals(IInvocationContext context, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        ExpressionsFix fix = ExpressionsFix.createAddParanoidalParenthesisFix(context.getASTRoot(), coveredNodes.toArray(new ASTNode[coveredNodes.size()]));
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_cast.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.use_parentheses_in_expressions", "true");
        options.put("cleanup.always_use_parentheses_in_expressions", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new ExpressionsCleanUp(options), -9, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getAddParenthesesForExpressionProposals(IInvocationContext context, ASTNode coveringNode, Collection<ICommandAccess> resultingCollections) {
        ASTNode node;
        if (context.getSelectionLength() == 0) {
            node = coveringNode;
            while (!(node == null || node instanceof CastExpression || node instanceof InfixExpression || node instanceof InstanceofExpression || node instanceof ConditionalExpression)) {
                node = node.getParent();
            }
        } else {
            node = context.getCoveredNode();
        }
        String label = null;
        if (node instanceof CastExpression) {
            label = CorrectionMessages.UnresolvedElementsSubProcessor_missingcastbrackets_description;
        } else if (node instanceof InstanceofExpression) {
            label = CorrectionMessages.LocalCorrectionsSubProcessor_setparenteses_instanceof_description;
        } else if (node instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)node;
            label = Messages.format(CorrectionMessages.LocalCorrectionsSubProcessor_setparenteses_description, infixExpression.getOperator().toString());
        } else if (node instanceof ConditionalExpression) {
            label = CorrectionMessages.AdvancedQuickAssistProcessor_putConditionalExpressionInParentheses;
        } else {
            return false;
        }
        if (node.getParent() instanceof ParenthesizedExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
        parenthesizedExpression.setExpression((Expression)rewrite.createCopyTarget(node));
        rewrite.replace(node, (ASTNode)parenthesizedExpression, null);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_cast.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, -10, image);
        resultingCollections.add(proposal);
        return true;
    }

    static ArrayList<ASTNode> getFullyCoveredNodes(IInvocationContext context, ASTNode coveringNode) {
        final ArrayList<ASTNode> coveredNodes = new ArrayList<ASTNode>();
        final int selectionBegin = context.getSelectionOffset();
        final int selectionEnd = selectionBegin + context.getSelectionLength();
        coveringNode.accept((ASTVisitor)new GenericVisitor(){

            protected boolean visitNode(ASTNode node) {
                ASTNode parent;
                int nodeStart = node.getStartPosition();
                int nodeEnd = nodeStart + node.getLength();
                if (nodeEnd < selectionBegin || selectionEnd < nodeStart) {
                    return false;
                }
                if (this.isCovered(node) && ((parent = node.getParent()) == null || !this.isCovered(parent))) {
                    coveredNodes.add(node);
                    return false;
                }
                return true;
            }

            private boolean isCovered(ASTNode node) {
                int begin = node.getStartPosition();
                int end = begin + node.getLength();
                return begin >= selectionBegin && end <= selectionEnd;
            }
        });
        return coveredNodes;
    }

    private static boolean getJoinAndIfStatementsProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        Image image;
        String label;
        Statement bodyPlaceholder;
        IfStatement newIf;
        Expression innerCondition;
        Expression outerCondition;
        InfixExpression condition;
        ASTRewrite rewrite;
        AST ast;
        Block block;
        if (!(node instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)node;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        IfStatement outerIf = null;
        if (ifStatement.getParent() instanceof IfStatement) {
            outerIf = (IfStatement)ifStatement.getParent();
        } else if (ifStatement.getParent() instanceof Block && (block = (Block)ifStatement.getParent()).getParent() instanceof IfStatement && block.statements().size() == 1) {
            outerIf = (IfStatement)block.getParent();
        }
        if (outerIf != null && outerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = node.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            condition = ast.newInfixExpression();
            condition.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
            outerCondition = AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, outerIf.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.LEFT_OPERAND_PROPERTY);
            innerCondition = AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, ifStatement.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY);
            condition.setLeftOperand(outerCondition);
            condition.setRightOperand(innerCondition);
            newIf = ast.newIfStatement();
            newIf.setExpression((Expression)condition);
            bodyPlaceholder = (Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement());
            newIf.setThenStatement(bodyPlaceholder);
            rewrite.replace((ASTNode)outerIf, (ASTNode)newIf, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_joinWithOuter_description;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
        }
        IfStatement innerIf = null;
        if (ifStatement.getThenStatement() instanceof IfStatement) {
            innerIf = (IfStatement)ifStatement.getThenStatement();
        } else if (ifStatement.getThenStatement() instanceof Block && (block = (Block)ifStatement.getThenStatement()).statements().size() == 1 && block.statements().get(0) instanceof IfStatement) {
            innerIf = (IfStatement)block.statements().get(0);
        }
        if (innerIf != null && innerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = node.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            condition = ast.newInfixExpression();
            condition.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
            outerCondition = AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, ifStatement.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.LEFT_OPERAND_PROPERTY);
            innerCondition = AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, innerIf.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY);
            condition.setLeftOperand(outerCondition);
            condition.setRightOperand(innerCondition);
            newIf = ast.newIfStatement();
            newIf.setExpression((Expression)condition);
            bodyPlaceholder = (Statement)rewrite.createCopyTarget((ASTNode)innerIf.getThenStatement());
            newIf.setThenStatement(bodyPlaceholder);
            rewrite.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_joinWithInner_description;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static Expression getParenthesizedExpressionIfNeeded(AST ast, ASTRewrite rewrite, Expression expression, ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        boolean addParentheses = NecessaryParenthesesChecker.needsParentheses(expression, parent, locationInParent);
        expression = (Expression)rewrite.createCopyTarget((ASTNode)expression);
        if (addParentheses) {
            return AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, expression);
        }
        return expression;
    }

    private static ParenthesizedExpression getParenthesizedExpression(AST ast, Expression expression) {
        ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
        parenthesizedExpression.setExpression(expression);
        return parenthesizedExpression;
    }

    public static boolean getSplitAndConditionProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        InfixExpression.Operator andOperator = InfixExpression.Operator.CONDITIONAL_AND;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != andOperator) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == andOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, andOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)leftCondition, null);
        IfStatement innerIf = ast.newIfStatement();
        innerIf.setExpression(rightCondition);
        innerIf.setThenStatement((Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement()));
        Block innerBlock = ast.newBlock();
        innerBlock.statements().add(innerIf);
        Statement elseStatement = ifStatement.getElseStatement();
        if (elseStatement != null) {
            innerIf.setElseStatement((Statement)rewrite.createCopyTarget((ASTNode)elseStatement));
        }
        rewrite.replace((ASTNode)ifStatement.getThenStatement(), (ASTNode)innerBlock, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitAndCondition_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isSelectingOperator(ASTNode n1, ASTNode n2, int offset, int length) {
        if (offset + length <= n2.getStartPosition() && offset >= ASTNodes.getExclusiveEnd(n1)) {
            return true;
        }
        if (n1.getStartPosition() == offset && ASTNodes.getExclusiveEnd(n2) == offset + length) {
            return !(n1 instanceof InfixExpression) && !(n2 instanceof InfixExpression);
        }
        return false;
    }

    private static int isOperatorSelected(InfixExpression infixExpression, int offset, int length) {
        Expression right;
        Expression left = infixExpression.getLeftOperand();
        if (AdvancedQuickAssistProcessor.isSelectingOperator((ASTNode)left, (ASTNode)(right = infixExpression.getRightOperand()), offset, length)) {
            return ASTNodes.getExclusiveEnd((ASTNode)left);
        }
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            left = right;
            if (AdvancedQuickAssistProcessor.isSelectingOperator((ASTNode)left, (ASTNode)(right = (ASTNode)extended.get(i)), offset, length)) {
                return ASTNodes.getExclusiveEnd((ASTNode)left);
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getJoinOrIfStatementsProposals(IInvocationContext context, ASTNode covering, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        InfixExpression.Operator orOperator = InfixExpression.Operator.CONDITIONAL_OR;
        if (coveredNodes.size() < 2) {
            return false;
        }
        String commonThenSource = null;
        for (ASTNode node : coveredNodes) {
            if (!(node instanceof IfStatement)) {
                return false;
            }
            IfStatement ifStatement = (IfStatement)node;
            if (ifStatement.getElseStatement() != null) {
                return false;
            }
            Statement thenStatement = ifStatement.getThenStatement();
            try {
                String thenSource = context.getCompilationUnit().getBuffer().getText(thenStatement.getStartPosition(), thenStatement.getLength());
                if (commonThenSource == null) {
                    commonThenSource = thenSource;
                    continue;
                }
                if (commonThenSource.equals(thenSource)) continue;
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        InfixExpression condition = null;
        boolean hasRightOperand = false;
        Statement thenStatement = null;
        for (IfStatement ifStatement : coveredNodes) {
            if (thenStatement == null) {
                thenStatement = (Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement());
            }
            if (condition == null) {
                condition = ast.newInfixExpression();
                condition.setOperator(orOperator);
                condition.setLeftOperand(AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, ifStatement.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.LEFT_OPERAND_PROPERTY));
                continue;
            }
            if (!hasRightOperand) {
                condition.setRightOperand(AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, ifStatement.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY));
                hasRightOperand = true;
                continue;
            }
            InfixExpression newCondition = ast.newInfixExpression();
            newCondition.setOperator(orOperator);
            newCondition.setLeftOperand((Expression)condition);
            newCondition.setRightOperand(AdvancedQuickAssistProcessor.getParenthesizedExpressionIfNeeded(ast, rewrite, ifStatement.getExpression(), (ASTNode)condition, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY));
            condition = newCondition;
        }
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(condition);
        newIf.setThenStatement(thenStatement);
        Object var12_14 = null;
        for (IfStatement ifStatement : coveredNodes) {
            void var12_15;
            if (var12_15 == null) {
                Block sourceBlock = (Block)ifStatement.getParent();
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)sourceBlock, (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
            }
            if (newIf != null) {
                var12_15.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
                newIf = null;
                continue;
            }
            var12_15.remove((ASTNode)ifStatement, null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_joinWithOr_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getSplitOrConditionProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        InfixExpression.Operator orOperator = InfixExpression.Operator.CONDITIONAL_OR;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != orOperator) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == orOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, orOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)leftCondition, null);
        IfStatement secondIf = ast.newIfStatement();
        secondIf.setExpression(rightCondition);
        secondIf.setThenStatement((Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement()));
        Statement elseStatement = ifStatement.getElseStatement();
        if (elseStatement == null) {
            rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)secondIf, null);
        } else {
            rewrite.replace((ASTNode)elseStatement, (ASTNode)secondIf, null);
            secondIf.setElseStatement((Statement)rewrite.createMoveTarget((ASTNode)elseStatement));
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitOrCondition_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseConditionalExpressionProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        while (covering instanceof Expression) {
            if (covering instanceof ConditionalExpression) break;
            covering = covering.getParent();
        }
        if (!(covering instanceof ConditionalExpression)) {
            return false;
        }
        ConditionalExpression expression = (ConditionalExpression)covering;
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ConditionalExpression newExpression = ast.newConditionalExpression();
        newExpression.setExpression(AdvancedQuickAssistProcessor.getInversedExpression(rewrite, expression.getExpression()));
        newExpression.setThenExpression((Expression)rewrite.createCopyTarget((ASTNode)expression.getElseExpression()));
        newExpression.setElseExpression((Expression)rewrite.createCopyTarget((ASTNode)expression.getThenExpression()));
        rewrite.replace((ASTNode)expression, (ASTNode)newExpression, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseConditionalExpression_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getExchangeInnerAndOuterIfConditionsProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        Image image;
        String label;
        ASTRewrite rewrite;
        AST ast;
        Block block;
        boolean result = false;
        if (!(node instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)node;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        IfStatement outerIf = null;
        if (ifStatement.getParent() instanceof IfStatement) {
            outerIf = (IfStatement)ifStatement.getParent();
        } else if (ifStatement.getParent() instanceof Block && (block = (Block)ifStatement.getParent()).getParent() instanceof IfStatement && block.statements().size() == 1) {
            outerIf = (IfStatement)block.getParent();
        }
        if (outerIf != null && outerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = node.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            Expression outerCondition = (Expression)rewrite.createCopyTarget((ASTNode)outerIf.getExpression());
            Expression innerCondition = (Expression)rewrite.createCopyTarget((ASTNode)ifStatement.getExpression());
            rewrite.replace((ASTNode)outerIf.getExpression(), (ASTNode)innerCondition, null);
            rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)outerCondition, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_exchangeInnerAndOuterIfConditions_description;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
            result = true;
        }
        IfStatement innerIf = null;
        if (ifStatement.getThenStatement() instanceof IfStatement) {
            innerIf = (IfStatement)ifStatement.getThenStatement();
        } else if (ifStatement.getThenStatement() instanceof Block && (block = (Block)ifStatement.getThenStatement()).statements().size() == 1 && block.statements().get(0) instanceof IfStatement) {
            innerIf = (IfStatement)block.statements().get(0);
        }
        if (innerIf != null && innerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = node.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            Expression innerCondition = (Expression)rewrite.createCopyTarget((ASTNode)innerIf.getExpression());
            Expression outerCondition = (Expression)rewrite.createCopyTarget((ASTNode)ifStatement.getExpression());
            rewrite.replace((ASTNode)innerIf.getExpression(), (ASTNode)outerCondition, null);
            rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)innerCondition, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_exchangeInnerAndOuterIfConditions_description;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
            result = true;
        }
        return result;
    }

    private static boolean getExchangeOperandsProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        InfixExpression.Operator operator = infixExpression.getOperator();
        if (operator != InfixExpression.Operator.CONDITIONAL_AND && operator != InfixExpression.Operator.AND && operator != InfixExpression.Operator.CONDITIONAL_OR && operator != InfixExpression.Operator.OR && operator != InfixExpression.Operator.EQUALS && operator != InfixExpression.Operator.NOT_EQUALS && operator != InfixExpression.Operator.LESS && operator != InfixExpression.Operator.LESS_EQUALS && operator != InfixExpression.Operator.GREATER && operator != InfixExpression.Operator.GREATER_EQUALS && operator != InfixExpression.Operator.PLUS && operator != InfixExpression.Operator.TIMES && operator != InfixExpression.Operator.XOR) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = infixExpression.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression leftExpression = null;
        Expression rightExpression = null;
        InfixExpression currentExpression = infixExpression;
        leftExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, leftExpression, infixExpression.getLeftOperand(), false, operator);
        if (infixExpression.getRightOperand().getStartPosition() <= context.getSelectionOffset()) {
            leftExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, leftExpression, infixExpression.getRightOperand(), false, operator);
        } else {
            rightExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, rightExpression, infixExpression.getRightOperand(), false, operator);
        }
        for (Expression extendedOperand : currentExpression.extendedOperands()) {
            if (extendedOperand.getStartPosition() <= context.getSelectionOffset()) {
                leftExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, leftExpression, extendedOperand, false, operator);
                continue;
            }
            rightExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, rightExpression, extendedOperand, false, operator);
        }
        if (NecessaryParenthesesChecker.needsParentheses(leftExpression, (ASTNode)infixExpression, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY)) {
            leftExpression = AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, leftExpression);
        }
        if (NecessaryParenthesesChecker.needsParentheses(rightExpression, (ASTNode)infixExpression, (StructuralPropertyDescriptor)InfixExpression.LEFT_OPERAND_PROPERTY)) {
            rightExpression = AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, rightExpression);
        }
        if (operator == InfixExpression.Operator.LESS) {
            operator = InfixExpression.Operator.GREATER;
        } else if (operator == InfixExpression.Operator.LESS_EQUALS) {
            operator = InfixExpression.Operator.GREATER_EQUALS;
        } else if (operator == InfixExpression.Operator.GREATER) {
            operator = InfixExpression.Operator.LESS;
        } else if (operator == InfixExpression.Operator.GREATER_EQUALS) {
            operator = InfixExpression.Operator.LESS_EQUALS;
        }
        InfixExpression newInfix = ast.newInfixExpression();
        newInfix.setOperator(operator);
        newInfix.setLeftOperand(rightExpression);
        newInfix.setRightOperand(leftExpression);
        rewrite.replace((ASTNode)infixExpression, (ASTNode)newInfix, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_exchangeOperands_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static void breakInfixOperationAtOperation(ASTRewrite rewrite, Expression expression, InfixExpression.Operator operator, int operatorOffset, boolean removeParentheses, Expression[] res) {
        if (expression.getStartPosition() + expression.getLength() <= operatorOffset) {
            res[0] = AdvancedQuickAssistProcessor.combineOperands(rewrite, res[0], expression, removeParentheses, operator);
            return;
        }
        if (operatorOffset <= expression.getStartPosition()) {
            res[1] = AdvancedQuickAssistProcessor.combineOperands(rewrite, res[1], expression, removeParentheses, operator);
            return;
        }
        if (!(expression instanceof InfixExpression)) {
            throw new IllegalArgumentException("Cannot break up non-infix expression");
        }
        InfixExpression infixExpression = (InfixExpression)expression;
        if (infixExpression.getOperator() != operator) {
            throw new IllegalArgumentException("Incompatible operator");
        }
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, infixExpression.getLeftOperand(), operator, operatorOffset, removeParentheses, res);
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, infixExpression.getRightOperand(), operator, operatorOffset, removeParentheses, res);
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)extended.get(i), operator, operatorOffset, removeParentheses, res);
            ++i;
        }
    }

    private static Expression combineOperands(ASTRewrite rewrite, Expression existing, Expression originalNode, boolean removeParentheses, InfixExpression.Operator operator) {
        if (existing == null && removeParentheses) {
            while (originalNode instanceof ParenthesizedExpression) {
                originalNode = ((ParenthesizedExpression)originalNode).getExpression();
            }
        }
        Expression newRight = (Expression)rewrite.createMoveTarget((ASTNode)originalNode);
        if (originalNode instanceof InfixExpression) {
            ((InfixExpression)newRight).setOperator(((InfixExpression)originalNode).getOperator());
        }
        if (existing == null) {
            return newRight;
        }
        AST ast = rewrite.getAST();
        InfixExpression infix = ast.newInfixExpression();
        infix.setOperator(operator);
        infix.setLeftOperand(existing);
        infix.setRightOperand(newRight);
        return infix;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean getCastAndAssignIfStatementProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        block27: {
            block28: {
                block26: {
                    if (!(node instanceof IfStatement)) break block26;
                    node = ((IfStatement)node).getExpression();
                    break block27;
                }
                if (!(node instanceof WhileStatement)) break block28;
                node = ((WhileStatement)node).getExpression();
                break block27;
            }
            if (!(node instanceof Block)) ** GOTO lbl32
            statements = ((Block)node).statements();
            if (statements.size() > 0 && context.getSelectionOffset() > ((Statement)statements.get(0)).getStartPosition()) {
                return false;
            }
            parent = node.getParent();
            expression = null;
            if (parent instanceof IfStatement) {
                expression = ((IfStatement)parent).getExpression();
            } else if (parent instanceof WhileStatement) {
                expression = ((WhileStatement)parent).getExpression();
            } else {
                return false;
            }
            if (expression instanceof InstanceofExpression) {
                node = expression;
            } else {
                nodes = new ArrayList<E>();
                expression.accept(new ASTVisitor(){

                    public boolean visit(InstanceofExpression instanceofExpression) {
                        nodes.add(instanceofExpression);
                        return false;
                    }
                });
                if (nodes.size() != 1) {
                    return false;
                }
                node = (ASTNode)nodes.get(0);
            }
            break block27;
lbl-1000:
            // 1 sources

            {
                node = node.getParent();
lbl32:
                // 2 sources

                ** while (node != null && !(node instanceof InstanceofExpression) && !(node instanceof Statement))
            }
        }
        if (!(node instanceof InstanceofExpression)) {
            return false;
        }
        expression = (InstanceofExpression)node;
        while (node.getParent() instanceof Expression) {
            node = node.getParent();
        }
        locationInParent = node.getLocationInParent();
        negated = AdvancedQuickAssistProcessor.isNegated((Expression)expression);
        body = null;
        insertionPosition = null;
        if (negated) {
            insertionPosition = node.getParent();
            if (locationInParent == IfStatement.EXPRESSION_PROPERTY && (body = ((IfStatement)node.getParent()).getElseStatement()) != null) {
                negated = false;
            }
            if (body == null && insertionPosition.getParent() instanceof Block) {
                body = (Statement)insertionPosition.getParent();
            }
        } else if (locationInParent == IfStatement.EXPRESSION_PROPERTY) {
            body = ((IfStatement)node.getParent()).getThenStatement();
        } else if (locationInParent == WhileStatement.EXPRESSION_PROPERTY) {
            body = ((WhileStatement)node.getParent()).getBody();
        }
        if (body == null) {
            return false;
        }
        originalType = expression.getRightOperand();
        if (originalType.resolveBinding() == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ast = expression.getAST();
        rewrite = ASTRewrite.create((AST)ast);
        cu = context.getCompilationUnit();
        label = CorrectionMessages.AdvancedQuickAssistProcessor_castAndAssign;
        image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        proposal = new LinkedCorrectionProposal(label, cu, rewrite, 7, image);
        excludedNames = Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)body));
        varNames = AdvancedQuickAssistProcessor.suggestLocalVariableNames(cu, originalType.resolveBinding(), excludedNames);
        i = 0;
        while (i < varNames.length) {
            proposal.addLinkedPositionProposal("name", varNames[i], null);
            ++i;
        }
        castExpression = ast.newCastExpression();
        castExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression.getLeftOperand()));
        castExpression.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)originalType));
        vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName(varNames[0]));
        vdf.setInitializer((Expression)castExpression);
        vds = ast.newVariableDeclarationStatement(vdf);
        vds.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)originalType));
        if (negated) {
            listRewriter = rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
            listRewriter.insertAfter((ASTNode)vds, insertionPosition, null);
        } else if (body instanceof Block) {
            listRewriter = rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
            listRewriter.insertAt((ASTNode)vds, 0, null);
        } else {
            newBlock = ast.newBlock();
            statements = newBlock.statements();
            statements.add(vds);
            statements.add((Statement)rewrite.createMoveTarget((ASTNode)body));
            rewrite.replace((ASTNode)body, (ASTNode)newBlock, null);
        }
        proposal.addLinkedPosition(rewrite.track((ASTNode)vdf.getName()), true, "name");
        proposal.addLinkedPosition(rewrite.track((ASTNode)vds.getType()), false, "type");
        proposal.addLinkedPosition(rewrite.track((ASTNode)castExpression.getType()), false, "type");
        proposal.setEndPosition(rewrite.track((ASTNode)vds));
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isNegated(Expression expression) {
        if (!(expression.getParent() instanceof ParenthesizedExpression)) {
            return false;
        }
        ParenthesizedExpression parenthesis = (ParenthesizedExpression)expression.getParent();
        if (!(parenthesis.getParent() instanceof PrefixExpression)) {
            return false;
        }
        PrefixExpression prefix = (PrefixExpression)parenthesis.getParent();
        return prefix.getOperator() == PrefixExpression.Operator.NOT;
    }

    private static String[] suggestLocalVariableNames(ICompilationUnit cu, ITypeBinding binding, List<String> excluded) {
        return StubUtility.getVariableNameSuggestions(5, cu.getJavaProject(), binding, null, excluded);
    }

    private static boolean getCombineStringProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        InfixExpression infixExpression;
        if (node instanceof InfixExpression) {
            infixExpression = (InfixExpression)node;
        } else if (node.getParent() instanceof InfixExpression) {
            infixExpression = (InfixExpression)node.getParent();
        } else {
            return false;
        }
        if (!infixExpression.getOperator().equals(InfixExpression.Operator.PLUS)) {
            return false;
        }
        Expression leftOperand = infixExpression.getLeftOperand();
        Expression rightOperand = infixExpression.getRightOperand();
        if (!(leftOperand instanceof StringLiteral) || !(rightOperand instanceof StringLiteral)) {
            return false;
        }
        StringLiteral leftString = (StringLiteral)leftOperand;
        StringLiteral rightString = (StringLiteral)rightOperand;
        if (resultingCollections == null) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder(leftString.getLiteralValue());
        stringBuilder.append(rightString.getLiteralValue());
        for (Object operand : infixExpression.extendedOperands()) {
            if (!(operand instanceof StringLiteral)) {
                return false;
            }
            StringLiteral stringLiteral = (StringLiteral)operand;
            stringBuilder.append(stringLiteral.getLiteralValue());
        }
        AST ast = node.getAST();
        StringLiteral combinedStringLiteral = ast.newStringLiteral();
        combinedStringLiteral.setLiteralValue(stringBuilder.toString());
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.replace((ASTNode)infixExpression, (ASTNode)combinedStringLiteral, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_combineSelectedStrings;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getPickOutStringProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof StringLiteral)) {
            return false;
        }
        int selectionPos = context.getSelectionOffset();
        int selectionLen = context.getSelectionLength();
        if (selectionLen == 0) {
            return false;
        }
        int valueStart = node.getStartPosition() + 1;
        int valueEnd = node.getStartPosition() + node.getLength() - 1;
        if (selectionPos < valueStart || selectionPos + selectionLen > valueEnd || valueEnd - valueStart == selectionLen) {
            return false;
        }
        StringLiteral stringLiteral = (StringLiteral)node;
        String stringValue = stringLiteral.getEscapedValue();
        int firstPos = selectionPos - node.getStartPosition();
        int secondPos = firstPos + selectionLen;
        AST ast = node.getAST();
        StringLiteral leftLiteral = ast.newStringLiteral();
        StringLiteral centerLiteral = ast.newStringLiteral();
        StringLiteral rightLiteral = ast.newStringLiteral();
        try {
            leftLiteral.setEscapedValue(String.valueOf('\"') + stringValue.substring(1, firstPos) + '\"');
            centerLiteral.setEscapedValue(String.valueOf('\"') + stringValue.substring(firstPos, secondPos) + '\"');
            rightLiteral.setEscapedValue(String.valueOf('\"') + stringValue.substring(secondPos, stringValue.length() - 1) + '\"');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        InfixExpression expression = ast.newInfixExpression();
        expression.setOperator(InfixExpression.Operator.PLUS);
        if (firstPos != 1) {
            expression.setLeftOperand((Expression)leftLiteral);
        }
        if (firstPos == 1) {
            expression.setLeftOperand((Expression)centerLiteral);
        } else {
            expression.setRightOperand((Expression)centerLiteral);
        }
        if (secondPos < stringValue.length() - 1) {
            if (firstPos == 1) {
                expression.setRightOperand((Expression)rightLiteral);
            } else {
                expression.extendedOperands().add(rightLiteral);
            }
        }
        rewrite.replace((ASTNode)stringLiteral, (ASTNode)expression, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_pickSelectedString;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.addLinkedPosition(rewrite.track((ASTNode)centerLiteral), true, "CENTER_STRING");
        resultingCollections.add(proposal);
        return true;
    }

    private static Statement getSingleStatement(Statement statement) {
        if (statement instanceof Block) {
            List blockStatements = ((Block)statement).statements();
            if (blockStatements.size() != 1) {
                return null;
            }
            return (Statement)blockStatements.get(0);
        }
        return statement;
    }

    private static boolean getReplaceIfElseWithConditionalProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)node;
        Statement thenStatement = AdvancedQuickAssistProcessor.getSingleStatement(ifStatement.getThenStatement());
        Statement elseStatement = AdvancedQuickAssistProcessor.getSingleStatement(ifStatement.getElseStatement());
        if (thenStatement == null || elseStatement == null) {
            return false;
        }
        Expression assigned = null;
        Expression thenExpression = null;
        Expression elseExpression = null;
        ITypeBinding exprBinding = null;
        if (thenStatement instanceof ReturnStatement && elseStatement instanceof ReturnStatement) {
            thenExpression = ((ReturnStatement)thenStatement).getExpression();
            elseExpression = ((ReturnStatement)elseStatement).getExpression();
            MethodDeclaration declaration = ASTResolving.findParentMethodDeclaration(node);
            if (declaration == null || declaration.isConstructor()) {
                return false;
            }
            exprBinding = declaration.getReturnType2().resolveBinding();
        } else if (thenStatement instanceof ExpressionStatement && elseStatement instanceof ExpressionStatement) {
            Expression inner1 = ((ExpressionStatement)thenStatement).getExpression();
            Expression inner2 = ((ExpressionStatement)elseStatement).getExpression();
            if (inner1 instanceof Assignment && inner2 instanceof Assignment) {
                IBinding bind2;
                IBinding bind1;
                Assignment assign1 = (Assignment)inner1;
                Assignment assign2 = (Assignment)inner2;
                Expression left1 = assign1.getLeftHandSide();
                Expression left2 = assign2.getLeftHandSide();
                if (left1 instanceof Name && left2 instanceof Name && assign1.getOperator() == assign2.getOperator() && (bind1 = ((Name)left1).resolveBinding()) == (bind2 = ((Name)left2).resolveBinding()) && bind1 instanceof IVariableBinding) {
                    assigned = left1;
                    exprBinding = ((IVariableBinding)bind1).getType();
                    thenExpression = assign1.getRightHandSide();
                    elseExpression = assign2.getRightHandSide();
                }
            }
        }
        if (thenExpression == null || elseExpression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        TightSourceRangeComputer sourceRangeComputer = new TightSourceRangeComputer();
        sourceRangeComputer.addTightSourceNode((ASTNode)ifStatement);
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)sourceRangeComputer);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_replaceIfWithConditional;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        ConditionalExpression conditionalExpression = ast.newConditionalExpression();
        Expression conditionCopy = (Expression)rewrite.createCopyTarget((ASTNode)ifStatement.getExpression());
        conditionalExpression.setExpression(conditionCopy);
        Expression thenCopy = (Expression)rewrite.createCopyTarget((ASTNode)thenExpression);
        Expression elseCopy = (Expression)rewrite.createCopyTarget((ASTNode)elseExpression);
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        if (!JavaModelUtil.is50OrHigher(project)) {
            ITypeBinding thenBinding = thenExpression.resolveTypeBinding();
            ITypeBinding elseBinding = elseExpression.resolveTypeBinding();
            if (thenBinding != null && elseBinding != null && exprBinding != null && !elseBinding.isAssignmentCompatible(thenBinding)) {
                CastExpression castException = ast.newCastExpression();
                ImportRewrite importRewrite = proposal.createImportRewrite(context.getASTRoot());
                ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, importRewrite);
                castException.setType(importRewrite.addImport(exprBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext));
                castException.setExpression(elseCopy);
                elseCopy = castException;
            }
        } else if (JavaModelUtil.is17OrHigher(project)) {
            AdvancedQuickAssistProcessor.addExplicitTypeArgumentsIfNecessary(rewrite, proposal, thenExpression);
            AdvancedQuickAssistProcessor.addExplicitTypeArgumentsIfNecessary(rewrite, proposal, elseExpression);
        }
        conditionalExpression.setThenExpression(thenCopy);
        conditionalExpression.setElseExpression(elseCopy);
        if (assigned == null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)conditionalExpression);
            rewrite.replace((ASTNode)ifStatement, (ASTNode)returnStatement, null);
        } else {
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)rewrite.createCopyTarget((ASTNode)assigned));
            assignment.setRightHandSide((Expression)conditionalExpression);
            assignment.setOperator(((Assignment)assigned.getParent()).getOperator());
            ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)assignment);
            rewrite.replace((ASTNode)ifStatement, (ASTNode)expressionStatement, null);
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static void addExplicitTypeArgumentsIfNecessary(ASTRewrite rewrite, ASTRewriteCorrectionProposal proposal, Expression invocation) {
        if (Invocations.isResolvedTypeInferredFromExpectedType(invocation)) {
            MethodInvocation methodInvocation;
            Object expression;
            ITypeBinding[] typeArguments = Invocations.getInferredTypeArguments(invocation);
            if (typeArguments == null) {
                return;
            }
            ImportRewrite importRewrite = proposal.getImportRewrite();
            if (importRewrite == null) {
                importRewrite = proposal.createImportRewrite((CompilationUnit)invocation.getRoot());
            }
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)invocation, importRewrite);
            AST ast = invocation.getAST();
            ListRewrite typeArgsRewrite = Invocations.getInferredTypeArgumentsRewrite(rewrite, invocation);
            int i = 0;
            while (i < typeArguments.length) {
                Type typeArgumentNode = importRewrite.addImport(typeArguments[i], ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
                typeArgsRewrite.insertLast((ASTNode)typeArgumentNode, null);
                ++i;
            }
            if (invocation instanceof MethodInvocation && (expression = (methodInvocation = (MethodInvocation)invocation).getExpression()) == null) {
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                expression = methodBinding != null && Modifier.isStatic((int)methodBinding.getModifiers()) ? ast.newName(importRewrite.addImport(methodBinding.getDeclaringClass().getTypeDeclaration(), (ImportRewrite.ImportRewriteContext)importRewriteContext)) : ast.newThisExpression();
                rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, expression, null);
            }
        }
    }

    private static ReturnStatement createReturnExpression(ASTRewrite rewrite, Expression expression) {
        AST ast = rewrite.getAST();
        ReturnStatement thenReturn = ast.newReturnStatement();
        thenReturn.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
        return thenReturn;
    }

    private static Statement createAssignmentStatement(ASTRewrite rewrite, Assignment.Operator assignmentOperator, Expression origAssignee, Expression origAssigned) {
        AST ast = rewrite.getAST();
        Assignment elseAssignment = ast.newAssignment();
        elseAssignment.setOperator(assignmentOperator);
        elseAssignment.setLeftHandSide((Expression)rewrite.createCopyTarget((ASTNode)origAssignee));
        elseAssignment.setRightHandSide((Expression)rewrite.createCopyTarget((ASTNode)origAssigned));
        ExpressionStatement statement = ast.newExpressionStatement((Expression)elseAssignment);
        return statement;
    }

    private static boolean getReplaceConditionalWithIfElseProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        ASTNode statement;
        ASTNode node = covering;
        while (!(node instanceof ConditionalExpression) && node instanceof Expression) {
            node = node.getParent();
        }
        if (!(node instanceof ConditionalExpression)) {
            node = covering;
            while (node != null && !(node instanceof Statement)) {
                node = node.getParent();
            }
            if (node instanceof VariableDeclarationStatement) {
                node = (ASTNode)((VariableDeclarationStatement)node).fragments().get(0);
                node = ((VariableDeclarationFragment)node).getInitializer();
            }
            if (node instanceof ExpressionStatement && (node = ((ExpressionStatement)node).getExpression()) instanceof Assignment) {
                node = ((Assignment)node).getRightHandSide();
            }
            if (node instanceof ReturnStatement) {
                node = ((ReturnStatement)node).getExpression();
            }
        }
        if (!(node instanceof ConditionalExpression)) {
            return false;
        }
        covering = node;
        StructuralPropertyDescriptor locationInParent = covering.getLocationInParent();
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY ? covering.getParent().getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY : (locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY ? !((statement = covering.getParent().getParent()) instanceof VariableDeclarationStatement) || statement.getLocationInParent() != Block.STATEMENTS_PROPERTY : locationInParent != ReturnStatement.EXPRESSION_PROPERTY)) {
            return false;
        }
        ConditionalExpression conditional = (ConditionalExpression)covering;
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression expression = conditional.getExpression();
        while (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        IfStatement ifStatement = ast.newIfStatement();
        ifStatement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY) {
            Assignment assignment = (Assignment)covering.getParent();
            Expression assignee = assignment.getLeftHandSide();
            Assignment.Operator op = assignment.getOperator();
            ifStatement.setThenStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, assignee, conditional.getThenExpression()));
            ifStatement.setElseStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, assignee, conditional.getElseExpression()));
            rewrite.replace(covering.getParent().getParent(), (ASTNode)ifStatement, null);
        } else if (locationInParent == ReturnStatement.EXPRESSION_PROPERTY) {
            ifStatement.setThenStatement((Statement)AdvancedQuickAssistProcessor.createReturnExpression(rewrite, conditional.getThenExpression()));
            ifStatement.setElseStatement((Statement)AdvancedQuickAssistProcessor.createReturnExpression(rewrite, conditional.getElseExpression()));
            rewrite.replace(conditional.getParent(), (ASTNode)ifStatement, null);
        } else if (locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)covering.getParent();
            Assignment.Operator op = Assignment.Operator.ASSIGN;
            SimpleName assignee = frag.getName();
            ifStatement.setThenStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, (Expression)assignee, conditional.getThenExpression()));
            ifStatement.setElseStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, (Expression)assignee, conditional.getElseExpression()));
            rewrite.set((ASTNode)frag, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, null, null);
            ASTNode statement2 = frag.getParent();
            rewrite.getListRewrite(statement2.getParent(), Block.STATEMENTS_PROPERTY).insertAfter((ASTNode)ifStatement, statement2, null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_replaceConditionalWithIf;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseLocalVariableProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        String newIdentifier;
        String notString;
        final AST ast = covering.getAST();
        if (!(covering instanceof SimpleName)) {
            return false;
        }
        SimpleName coveringName = (SimpleName)covering;
        if (!coveringName.isDeclaration()) {
            return false;
        }
        final IBinding variableBinding = coveringName.resolveBinding();
        if (!(variableBinding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding binding = (IVariableBinding)variableBinding;
        if (binding.isField()) {
            return false;
        }
        if (!AdvancedQuickAssistProcessor.isBoolean((Expression)coveringName)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        MethodDeclaration method = ASTResolving.findParentMethodDeclaration(covering);
        SimpleName[] linkedNodes = LinkedNodeFinder.findByBinding((ASTNode)method, variableBinding);
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseBooleanVariable;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        String oldIdentifier = coveringName.getIdentifier();
        if (oldIdentifier.startsWith(notString = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_negatedVariableName, ""))) {
            int notLength = notString.length();
            newIdentifier = oldIdentifier.length() > notLength ? String.valueOf(Character.toLowerCase(oldIdentifier.charAt(notLength))) + oldIdentifier.substring(notLength + 1) : oldIdentifier;
        } else {
            newIdentifier = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_negatedVariableName, String.valueOf(Character.toUpperCase(oldIdentifier.charAt(0))) + oldIdentifier.substring(1));
        }
        proposal.addLinkedPositionProposal("name", newIdentifier, null);
        proposal.addLinkedPositionProposal("name", oldIdentifier, null);
        final HashSet renamedNames = new HashSet();
        int i = 0;
        while (i < linkedNodes.length) {
            SimpleName name = linkedNodes[i];
            if (!renamedNames.contains(name)) {
                Expression expression;
                SimpleName newName = ast.newSimpleName(newIdentifier);
                proposal.addLinkedPosition(rewrite.track((ASTNode)newName), name == coveringName, "name");
                StructuralPropertyDescriptor location = name.getLocationInParent();
                if (location == SingleVariableDeclaration.NAME_PROPERTY) {
                    rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                } else if (location == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                    Assignment assignment = (Assignment)name.getParent();
                    expression = assignment.getRightHandSide();
                    int exStart = expression.getStartPosition();
                    int exEnd = exStart + expression.getLength();
                    HashSet<SimpleName> overlapNames = new HashSet<SimpleName>();
                    int j = 0;
                    while (j < linkedNodes.length) {
                        int name2Start;
                        SimpleName name2 = linkedNodes[j];
                        if (name2 != null && exStart <= (name2Start = name2.getStartPosition()) && name2Start < exEnd) {
                            overlapNames.add(name2);
                        }
                        ++j;
                    }
                    SimpleNameRenameProvider provider = new SimpleNameRenameProvider(){

                        public SimpleName getRenamed(SimpleName simpleName) {
                            if (simpleName.resolveBinding() == variableBinding) {
                                renamedNames.add(simpleName);
                                return ast.newSimpleName(newIdentifier);
                            }
                            return null;
                        }
                    };
                    Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, expression, provider);
                    for (Object e : overlapNames) {
                        if (renamedNames.contains(e)) continue;
                        return false;
                    }
                    Assignment.Operator operator = assignment.getOperator();
                    if (operator == Assignment.Operator.BIT_AND_ASSIGN) {
                        Assignment assignment2 = ast.newAssignment();
                        assignment2.setLeftHandSide((Expression)newName);
                        assignment2.setRightHandSide(inversedExpression);
                        assignment2.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                        rewrite.replace((ASTNode)assignment, (ASTNode)assignment2, null);
                    } else if (operator == Assignment.Operator.BIT_OR_ASSIGN) {
                        Assignment assignment3 = ast.newAssignment();
                        assignment3.setLeftHandSide((Expression)newName);
                        assignment3.setRightHandSide(inversedExpression);
                        assignment3.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                        rewrite.replace((ASTNode)assignment, (ASTNode)assignment3, null);
                    } else {
                        rewrite.replace((ASTNode)expression, (ASTNode)inversedExpression, null);
                        rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                    }
                } else if (location == VariableDeclarationFragment.NAME_PROPERTY) {
                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)name.getParent();
                    expression = vdf.getInitializer();
                    if (expression != null) {
                        rewrite.replace((ASTNode)expression, (ASTNode)AdvancedQuickAssistProcessor.getInversedExpression(rewrite, expression), null);
                    }
                    rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                } else if (name.getParent() instanceof PrefixExpression && ((PrefixExpression)name.getParent()).getOperator() == PrefixExpression.Operator.NOT) {
                    rewrite.replace(name.getParent(), (ASTNode)newName, null);
                } else {
                    PrefixExpression expression2 = ast.newPrefixExpression();
                    expression2.setOperator(PrefixExpression.Operator.NOT);
                    expression2.setOperand((Expression)newName);
                    rewrite.replace((ASTNode)name, (ASTNode)expression2, null);
                }
            }
            ++i;
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getPushNegationDownProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        PrefixExpression prefixExpression;
        PrefixExpression negationExpression = null;
        ParenthesizedExpression parenthesizedExpression = null;
        if (covering instanceof PrefixExpression && (prefixExpression = (PrefixExpression)covering).getOperator() == PrefixExpression.Operator.NOT && prefixExpression.getOperand() instanceof ParenthesizedExpression) {
            negationExpression = prefixExpression;
            parenthesizedExpression = (ParenthesizedExpression)prefixExpression.getOperand();
        }
        if (covering instanceof ParenthesizedExpression && covering.getParent() instanceof PrefixExpression && ((PrefixExpression)covering.getParent()).getOperator() == PrefixExpression.Operator.NOT) {
            negationExpression = (PrefixExpression)covering.getParent();
            parenthesizedExpression = (ParenthesizedExpression)covering;
        }
        if (negationExpression == null || !(parenthesizedExpression.getExpression() instanceof InfixExpression) && !(parenthesizedExpression.getExpression() instanceof ConditionalExpression)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, parenthesizedExpression.getExpression());
        boolean keepParentheses = false;
        if (negationExpression.getParent() instanceof Expression) {
            int inversedExpressionPrecedence;
            int parentPrecedence = OperatorPrecedence.getExpressionPrecedence((Expression)negationExpression.getParent());
            boolean bl = keepParentheses = parentPrecedence > (inversedExpressionPrecedence = OperatorPrecedence.getExpressionPrecedence(inversedExpression));
        }
        if (keepParentheses) {
            ParenthesizedExpression pe = ast.newParenthesizedExpression();
            pe.setExpression(inversedExpression);
            rewrite.replace((ASTNode)negationExpression, (ASTNode)pe, null);
        } else {
            rewrite.replace((ASTNode)negationExpression, (ASTNode)inversedExpression, null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_pushNegationDown;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getBooleanExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return null;
        }
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == QualifiedName.NAME_PROPERTY) {
            node = node.getParent();
            locationInParent = node.getLocationInParent();
        }
        while (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
            node = node.getParent();
            locationInParent = node.getLocationInParent();
        }
        Expression expression = (Expression)node;
        if (!AdvancedQuickAssistProcessor.isBoolean(expression)) {
            return null;
        }
        if (expression.getParent() instanceof InfixExpression) {
            return expression;
        }
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY || locationInParent == IfStatement.EXPRESSION_PROPERTY || locationInParent == WhileStatement.EXPRESSION_PROPERTY || locationInParent == DoStatement.EXPRESSION_PROPERTY || locationInParent == ReturnStatement.EXPRESSION_PROPERTY || locationInParent == ForStatement.EXPRESSION_PROPERTY || locationInParent == AssertStatement.EXPRESSION_PROPERTY || locationInParent == MethodInvocation.ARGUMENTS_PROPERTY || locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY || locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY || locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY || locationInParent == ConditionalExpression.EXPRESSION_PROPERTY || locationInParent == PrefixExpression.OPERAND_PROPERTY) {
            return expression;
        }
        return null;
    }

    private static boolean getPullNegationUpProposals(IInvocationContext context, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        if (coveredNodes.size() != 1) {
            return false;
        }
        ASTNode fullyCoveredNode = coveredNodes.get(0);
        Expression expression = AdvancedQuickAssistProcessor.getBooleanExpression(fullyCoveredNode);
        if (expression == null || !(expression instanceof InfixExpression) && !(expression instanceof ConditionalExpression)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = expression.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedExpression(rewrite, expression);
        ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
        parenthesizedExpression.setExpression(inversedExpression);
        PrefixExpression prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand((Expression)parenthesizedExpression);
        rewrite.replace((ASTNode)expression, (ASTNode)prefixExpression, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_pullNegationUp;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getJoinIfListInIfElseIfProposals(IInvocationContext context, ASTNode covering, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        if (coveredNodes.isEmpty()) {
            return false;
        }
        if (coveredNodes.size() < 2) {
            return false;
        }
        for (ASTNode node : coveredNodes) {
            if (!(node instanceof IfStatement)) {
                return false;
            }
            IfStatement ifStatement = (IfStatement)node;
            if (ifStatement.getElseStatement() == null) continue;
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        IfStatement firstIfStatement = (IfStatement)coveredNodes.get(0);
        IfStatement firstNewIfStatement = null;
        IfStatement prevIfStatement = null;
        for (IfStatement ifStatement : coveredNodes) {
            IfStatement ifBodyStatement;
            IfStatement newIfStatement = ast.newIfStatement();
            newIfStatement.setExpression((Expression)rewrite.createMoveTarget((ASTNode)ifStatement.getExpression()));
            Statement thenStatement = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement());
            if (ifStatement.getThenStatement() instanceof IfStatement && (ifBodyStatement = (IfStatement)ifStatement.getThenStatement()).getElseStatement() == null) {
                Block thenBlock = ast.newBlock();
                thenBlock.statements().add(thenStatement);
                thenStatement = thenBlock;
            }
            newIfStatement.setThenStatement(thenStatement);
            if (prevIfStatement != null) {
                prevIfStatement.setElseStatement((Statement)newIfStatement);
                rewrite.remove((ASTNode)ifStatement, null);
            } else {
                firstNewIfStatement = newIfStatement;
            }
            prevIfStatement = newIfStatement;
        }
        rewrite.replace((ASTNode)firstIfStatement, firstNewIfStatement, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_joinIfSequence;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertSwitchToIfProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        if (!(covering instanceof SwitchStatement)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        if (!AdvancedQuickAssistProcessor.getConvertSwitchToIfProposals(context, covering, resultingCollections, false)) {
            return false;
        }
        return AdvancedQuickAssistProcessor.getConvertSwitchToIfProposals(context, covering, resultingCollections, true);
    }

    private static boolean getConvertSwitchToIfProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections, boolean preserveNPE) {
        Name varName;
        boolean isStringsInSwitch;
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = StubUtility.createImportRewrite(context.getASTRoot(), true);
        SwitchStatement switchStatement = (SwitchStatement)covering;
        ITypeBinding expressionType = switchStatement.getExpression().resolveTypeBinding();
        boolean bl = isStringsInSwitch = expressionType != null && "java.lang.String".equals(expressionType.getQualifiedName());
        if (!isStringsInSwitch && preserveNPE) {
            return false;
        }
        IfStatement firstIfStatement = null;
        IfStatement currentIfStatement = null;
        Block currentBlock = null;
        boolean hasStopAsLastExecutableStatement = false;
        Block defaultBlock = null;
        Expression currentCondition = null;
        boolean defaultFound = false;
        ArrayList<Block> allBlocks = new ArrayList<Block>();
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)ASTResolving.findParentBodyDeclaration(covering), importRewrite);
        Expression switchExpression = switchStatement.getExpression();
        VariableDeclarationStatement variableDeclarationStatement = null;
        if (switchExpression instanceof Name) {
            varName = (Name)switchExpression;
        } else {
            VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
            String[] varNames = StubUtility.getVariableNameSuggestions(5, context.getCompilationUnit().getJavaProject(), expressionType, switchExpression, null);
            varName = ast.newSimpleName(varNames[0]);
            variableDeclarationFragment.setName((SimpleName)varName);
            variableDeclarationFragment.setStructuralProperty((StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)rewrite.createCopyTarget((ASTNode)switchExpression));
            variableDeclarationStatement = ast.newVariableDeclarationStatement(variableDeclarationFragment);
            Type type = importRewrite.addImport(expressionType, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
            variableDeclarationStatement.setType(type);
        }
        for (Statement statement : switchStatement.statements()) {
            if (statement instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)statement;
                if (currentBlock != null) {
                    if (!hasStopAsLastExecutableStatement) {
                        return false;
                    }
                    currentBlock = null;
                }
                if (defaultFound) {
                    return false;
                }
                if (switchCase.isDefault()) {
                    defaultFound = true;
                }
                Expression switchCaseCondition = AdvancedQuickAssistProcessor.createSwitchCaseCondition(ast, rewrite, importRewrite, importRewriteContext, varName, switchCase, isStringsInSwitch, preserveNPE);
                if (currentCondition == null) {
                    currentCondition = switchCaseCondition;
                    continue;
                }
                InfixExpression condition = ast.newInfixExpression();
                condition.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
                condition.setLeftOperand(currentCondition);
                if (switchCaseCondition == null) {
                    switchCaseCondition = ast.newBooleanLiteral(true);
                }
                condition.setRightOperand(switchCaseCondition);
                currentCondition = condition;
                continue;
            }
            if (currentBlock == null) {
                if (currentCondition != null) {
                    IfStatement ifStatement;
                    if (firstIfStatement == null) {
                        ifStatement = firstIfStatement = ast.newIfStatement();
                    } else {
                        ifStatement = ast.newIfStatement();
                        currentIfStatement.setElseStatement((Statement)ifStatement);
                    }
                    currentIfStatement = ifStatement;
                    ifStatement.setExpression(currentCondition);
                    currentCondition = null;
                    currentBlock = ast.newBlock();
                    ifStatement.setThenStatement((Statement)currentBlock);
                    allBlocks.add(currentBlock);
                } else {
                    currentBlock = defaultBlock = ast.newBlock();
                    allBlocks.add(currentBlock);
                }
            }
            if (statement instanceof BreakStatement) {
                currentBlock = null;
                continue;
            }
            hasStopAsLastExecutableStatement = AdvancedQuickAssistProcessor.hasStopAsLastExecutableStatement(statement);
            Statement copyStatement = AdvancedQuickAssistProcessor.copyStatementExceptBreak(ast, rewrite, statement);
            currentBlock.statements().add(copyStatement);
        }
        if (defaultBlock != null) {
            currentIfStatement.setElseStatement(defaultBlock);
        }
        int i = 0;
        while (i < allBlocks.size()) {
            Block block = (Block)allBlocks.get(i);
            List statements = block.statements();
            if (statements.size() == 1 && statements.get(0) instanceof Block) {
                Block innerBlock = (Block)statements.remove(0);
                block.getParent().setStructuralProperty(block.getLocationInParent(), (Object)innerBlock);
            }
            ++i;
        }
        if (variableDeclarationStatement == null) {
            rewrite.replace((ASTNode)switchStatement, firstIfStatement, null);
        } else {
            new StatementRewrite(rewrite, new ASTNode[]{switchStatement}).replace(new ASTNode[]{variableDeclarationStatement, firstIfStatement}, null);
        }
        String source = ASTNodes.asString((ASTNode)switchExpression).replaceAll("\r\n?|\n", " ");
        String label = preserveNPE ? Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_convertSwitchToIf_preserveNPE, source) : CorrectionMessages.AdvancedQuickAssistProcessor_convertSwitchToIf;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
        proposal.setImportRewrite(importRewrite);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression createSwitchCaseCondition(AST ast, ASTRewrite rewrite, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext importRewriteContext, Name switchExpression, SwitchCase switchCase, boolean isStringsInSwitch, boolean preserveNPE) {
        IVariableBinding binding;
        Expression expression = switchCase.getExpression();
        if (expression == null) {
            return null;
        }
        if (isStringsInSwitch) {
            MethodInvocation methodInvocation = ast.newMethodInvocation();
            methodInvocation.setName(ast.newSimpleName("equals"));
            if (preserveNPE) {
                methodInvocation.setExpression((Expression)rewrite.createStringPlaceholder(switchExpression.getFullyQualifiedName(), 40));
                methodInvocation.arguments().add(rewrite.createCopyTarget((ASTNode)expression));
            } else {
                methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
                methodInvocation.arguments().add(rewrite.createStringPlaceholder(switchExpression.getFullyQualifiedName(), 40));
            }
            return methodInvocation;
        }
        InfixExpression condition = ast.newInfixExpression();
        condition.setOperator(InfixExpression.Operator.EQUALS);
        condition.setLeftOperand((Expression)rewrite.createStringPlaceholder(switchExpression.getFullyQualifiedName(), 40));
        Expression rightExpression = null;
        if (expression instanceof SimpleName && ((SimpleName)expression).resolveBinding() instanceof IVariableBinding && (binding = (IVariableBinding)((SimpleName)expression).resolveBinding()).isEnumConstant()) {
            String qualifiedName = String.valueOf(importRewrite.addImport(binding.getDeclaringClass(), importRewriteContext)) + '.' + binding.getName();
            rightExpression = ast.newName(qualifiedName);
        }
        if (rightExpression == null) {
            rightExpression = (Expression)rewrite.createCopyTarget((ASTNode)expression);
        }
        condition.setRightOperand(rightExpression);
        return condition;
    }

    private static boolean hasStopAsLastExecutableStatement(Statement lastStatement) {
        if (lastStatement instanceof ReturnStatement || lastStatement instanceof BreakStatement) {
            return true;
        }
        if (lastStatement instanceof Block) {
            Block block = (Block)lastStatement;
            lastStatement = (Statement)block.statements().get(block.statements().size() - 1);
            return AdvancedQuickAssistProcessor.hasStopAsLastExecutableStatement(lastStatement);
        }
        return false;
    }

    private static Statement copyStatementExceptBreak(AST ast, ASTRewrite rewrite, Statement source) {
        if (source instanceof Block) {
            Block block = (Block)source;
            Block newBlock = ast.newBlock();
            for (Statement statement : block.statements()) {
                if (statement instanceof BreakStatement) continue;
                newBlock.statements().add(AdvancedQuickAssistProcessor.copyStatementExceptBreak(ast, rewrite, statement));
            }
            return newBlock;
        }
        return (Statement)rewrite.createMoveTarget((ASTNode)source);
    }

    private static boolean getConvertIfElseToSwitchProposals(IInvocationContext context, ASTNode coveringNode, ArrayList<ICommandAccess> resultingCollections) {
        if (!(coveringNode instanceof IfStatement)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        if (!AdvancedQuickAssistProcessor.getConvertIfElseToSwitchProposals(context, coveringNode, resultingCollections, true)) {
            return false;
        }
        return AdvancedQuickAssistProcessor.getConvertIfElseToSwitchProposals(context, coveringNode, resultingCollections, false);
    }

    private static boolean getConvertIfElseToSwitchProposals(IInvocationContext context, ASTNode coveringNode, ArrayList<ICommandAccess> resultingCollections, boolean handleNullArg) {
        IfStatement ifStatement;
        AST ast = coveringNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = StubUtility.createImportRewrite(context.getASTRoot(), true);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)ASTResolving.findParentBodyDeclaration(coveringNode), importRewrite);
        IfStatement currentIf = ifStatement = (IfStatement)coveringNode;
        IfStatement currentStatement = ifStatement;
        Object currentExpression = currentIf.getExpression();
        SwitchStatement switchStatement = ast.newSwitchStatement();
        Expression switchExpression = null;
        boolean executeDefaultOnNullExpression = false;
        IfStatement defaultStatement = null;
        while (currentStatement != null) {
            IfStatement thenStatement;
            Expression expression = null;
            ArrayList<Expression> caseExpressions = new ArrayList<Expression>();
            if (currentIf != null) {
                while (currentExpression != null) {
                    IVariableBinding binding;
                    QualifiedName qualifiedName;
                    Expression rightOperand;
                    Expression leftOperand;
                    boolean isMethodInvocationCase = false;
                    if (currentExpression instanceof MethodInvocation) {
                        isMethodInvocationCase = true;
                        if (!((MethodInvocation)currentExpression).getName().getIdentifier().equals("equals")) {
                            return false;
                        }
                        MethodInvocation invocation = (MethodInvocation)currentExpression;
                        leftOperand = invocation.getExpression();
                        if (leftOperand == null) {
                            return false;
                        }
                        ITypeBinding leftBinding = leftOperand.resolveTypeBinding();
                        if (leftBinding != null && (leftBinding.getQualifiedName().equals("java.lang.String") ? !JavaModelUtil.is17OrHigher(context.getCompilationUnit().getJavaProject()) : !leftBinding.isEnum())) {
                            return false;
                        }
                        List arguments = invocation.arguments();
                        if (arguments.size() != 1) {
                            return false;
                        }
                        rightOperand = (Expression)arguments.get(0);
                        ITypeBinding rightBinding = leftOperand.resolveTypeBinding();
                        if (rightBinding != null && (rightBinding.getQualifiedName().equals("java.lang.String") ? !JavaModelUtil.is17OrHigher(context.getCompilationUnit().getJavaProject()) : !rightBinding.isEnum())) {
                            return false;
                        }
                    } else if (currentExpression instanceof InfixExpression) {
                        InfixExpression infixExpression = (InfixExpression)currentExpression;
                        InfixExpression.Operator operator = infixExpression.getOperator();
                        if (!operator.equals(InfixExpression.Operator.CONDITIONAL_OR) && !operator.equals(InfixExpression.Operator.EQUALS)) {
                            return false;
                        }
                        leftOperand = infixExpression.getLeftOperand();
                        rightOperand = infixExpression.getRightOperand();
                        if (operator.equals(InfixExpression.Operator.EQUALS)) {
                            ITypeBinding typeBinding = leftOperand.resolveTypeBinding();
                            if (typeBinding != null && typeBinding.getQualifiedName().equals("java.lang.String")) {
                                return false;
                            }
                        } else if (operator.equals(InfixExpression.Operator.CONDITIONAL_OR)) {
                            currentExpression = leftOperand;
                            continue;
                        }
                    } else {
                        return false;
                    }
                    if (leftOperand.resolveConstantExpressionValue() != null) {
                        caseExpressions.add(leftOperand);
                        expression = rightOperand;
                        executeDefaultOnNullExpression |= isMethodInvocationCase;
                    } else if (rightOperand.resolveConstantExpressionValue() != null) {
                        caseExpressions.add(rightOperand);
                        expression = leftOperand;
                    } else if (leftOperand instanceof QualifiedName) {
                        qualifiedName = (QualifiedName)leftOperand;
                        binding = (IVariableBinding)qualifiedName.resolveBinding();
                        if (binding == null || !binding.isEnumConstant()) {
                            return false;
                        }
                        importRewrite.addImport(binding.getDeclaringClass(), (ImportRewrite.ImportRewriteContext)importRewriteContext);
                        caseExpressions.add((Expression)qualifiedName.getName());
                        expression = rightOperand;
                        executeDefaultOnNullExpression |= isMethodInvocationCase;
                    } else if (rightOperand instanceof QualifiedName) {
                        qualifiedName = (QualifiedName)rightOperand;
                        binding = (IVariableBinding)qualifiedName.resolveBinding();
                        if (binding == null || !binding.isEnumConstant()) {
                            return false;
                        }
                        importRewrite.addImport(binding.getDeclaringClass(), (ImportRewrite.ImportRewriteContext)importRewriteContext);
                        caseExpressions.add((Expression)qualifiedName.getName());
                        expression = leftOperand;
                    } else {
                        return false;
                    }
                    if (expression == null) {
                        return false;
                    }
                    currentExpression = currentExpression.getParent() instanceof InfixExpression ? AdvancedQuickAssistProcessor.getNextSiblingExpression(currentExpression) : null;
                    if (switchExpression == null) {
                        switchExpression = expression;
                    }
                    if (switchExpression.subtreeMatch(new ASTMatcher(), (Object)expression)) continue;
                    return false;
                }
            }
            if (currentIf == null) {
                thenStatement = currentStatement;
                defaultStatement = currentStatement;
            } else {
                thenStatement = currentIf.getThenStatement();
            }
            SwitchCase[] switchCaseStatements = AdvancedQuickAssistProcessor.createSwitchCaseStatements(ast, rewrite, caseExpressions);
            int i = 0;
            while (i < switchCaseStatements.length) {
                switchStatement.statements().add(switchCaseStatements[i]);
                ++i;
            }
            boolean isBreakRequired = true;
            if (thenStatement instanceof Block) {
                Statement statement2 = null;
                for (Statement statement2 : ((Block)thenStatement).statements()) {
                    switchStatement.statements().add(rewrite.createCopyTarget((ASTNode)statement2));
                }
                if (statement2 instanceof ReturnStatement || statement2 instanceof ThrowStatement) {
                    isBreakRequired = false;
                }
            } else {
                if (thenStatement instanceof ReturnStatement || thenStatement instanceof ThrowStatement) {
                    isBreakRequired = false;
                }
                switchStatement.statements().add(rewrite.createCopyTarget((ASTNode)thenStatement));
            }
            if (isBreakRequired) {
                switchStatement.statements().add(ast.newBreakStatement());
            }
            if (currentIf != null && currentIf.getElseStatement() != null) {
                Statement elseStatement = currentIf.getElseStatement();
                if (elseStatement instanceof IfStatement) {
                    currentStatement = currentIf = (IfStatement)elseStatement;
                    currentExpression = currentIf.getExpression();
                    continue;
                }
                currentIf = null;
                currentStatement = elseStatement;
                currentExpression = null;
                continue;
            }
            currentStatement = null;
        }
        if (switchExpression == null) {
            return false;
        }
        switchStatement.setExpression((Expression)rewrite.createCopyTarget(switchExpression));
        if (handleNullArg) {
            if (executeDefaultOnNullExpression) {
                Block block;
                IfStatement newIfStatement = ast.newIfStatement();
                InfixExpression infixExpression = ast.newInfixExpression();
                infixExpression.setLeftOperand((Expression)rewrite.createCopyTarget(switchExpression));
                infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                newIfStatement.setExpression((Expression)infixExpression);
                if (defaultStatement == null) {
                    block = ast.newBlock();
                    newIfStatement.setThenStatement((Statement)block);
                } else if (defaultStatement instanceof Block) {
                    block = ast.newBlock();
                    Iterator iter = ((Block)defaultStatement).statements().iterator();
                    while (iter.hasNext()) {
                        block.statements().add(rewrite.createCopyTarget((ASTNode)iter.next()));
                    }
                    newIfStatement.setThenStatement((Statement)block);
                } else {
                    newIfStatement.setThenStatement((Statement)rewrite.createCopyTarget((ASTNode)defaultStatement));
                }
                block = ast.newBlock();
                block.statements().add(switchStatement);
                newIfStatement.setElseStatement((Statement)block);
                rewrite.replace((ASTNode)ifStatement, (ASTNode)newIfStatement, null);
                String source = ASTNodes.asString(switchExpression).replaceAll("\r\n?|\n", " ");
                String label = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_convertIfElseToSwitch_handleNullArg, source);
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
                proposal.setImportRewrite(importRewrite);
                resultingCollections.add(proposal);
            }
        } else {
            rewrite.replace((ASTNode)ifStatement, (ASTNode)switchStatement, null);
            String label = CorrectionMessages.AdvancedQuickAssistProcessor_convertIfElseToSwitch;
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
            proposal.setImportRewrite(importRewrite);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static Expression getNextSiblingExpression(Expression expression) {
        InfixExpression parentInfixExpression = (InfixExpression)expression.getParent();
        Object sibiling = expression.equals((Object)parentInfixExpression.getLeftOperand()) ? parentInfixExpression.getRightOperand() : (expression.equals((Object)parentInfixExpression.getRightOperand()) ? (parentInfixExpression.getParent() instanceof InfixExpression ? AdvancedQuickAssistProcessor.getNextSiblingExpression((Expression)parentInfixExpression) : null) : null);
        return sibiling;
    }

    private static SwitchCase[] createSwitchCaseStatements(AST ast, ASTRewrite rewrite, List<Expression> caseExpressions) {
        int len = caseExpressions.size() == 0 ? 1 : caseExpressions.size();
        SwitchCase[] switchCaseStatements = new SwitchCase[len];
        if (caseExpressions.size() == 0) {
            switchCaseStatements[0] = ast.newSwitchCase();
            switchCaseStatements[0].setExpression(null);
        } else {
            int i = 0;
            while (i < caseExpressions.size()) {
                ASTNode astNode = (ASTNode)caseExpressions.get(i);
                switchCaseStatements[i] = ast.newSwitchCase();
                switchCaseStatements[i].setExpression((Expression)rewrite.createCopyTarget(astNode));
                ++i;
            }
        }
        return switchCaseStatements;
    }

    private static interface SimpleNameRenameProvider {
        public SimpleName getRenamed(SimpleName var1);
    }
}

