/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.IdentifiablePluginObject;
import org.eclipse.pde.internal.core.plugin.PluginObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginParent
extends IdentifiablePluginObject
implements IPluginParent {
    private static final long serialVersionUID = 1L;
    protected ArrayList<IPluginObject> fChildren = null;

    @Override
    public void add(int index, IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.getChildrenList().add(index, child);
        this.postAdd(child);
    }

    @Override
    public void add(IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.getChildrenList().add(child);
        this.postAdd(child);
    }

    void appendChild(IPluginElement child) {
        this.getChildrenList().add(child);
    }

    protected void postAdd(IPluginObject child) {
        ((PluginObject)child).setInTheModel(true);
        ((PluginObject)child).setParent(this);
        this.fireStructureChanged(child, 1);
    }

    @Override
    public int getChildCount() {
        return this.getChildrenList().size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginParent) {
            IPluginParent target = (IPluginParent)obj;
            if (target.getChildCount() != this.getChildCount()) {
                return false;
            }
            IPluginObject[] tchildren = target.getChildren();
            int i = 0;
            while (i < tchildren.length) {
                IPluginObject tchild = tchildren[i];
                IPluginObject child = this.getChildrenList().get(i);
                if (child == null || !child.equals(tchild)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getIndexOf(IPluginObject child) {
        return this.getChildrenList().indexOf(child);
    }

    @Override
    public void swap(IPluginObject child1, IPluginObject child2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.getChildrenList().indexOf(child1);
        int index2 = this.getChildrenList().indexOf(child2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECoreMessages.PluginParent_siblingsNotFoundException);
        }
        this.getChildrenList().set(index2, child1);
        this.getChildrenList().set(index1, child2);
        this.firePropertyChanged(this, "sibling_order", child1, child2);
    }

    @Override
    public IPluginObject[] getChildren() {
        return this.getChildrenList().toArray(new IPluginObject[this.getChildrenList().size()]);
    }

    @Override
    public void remove(IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.getChildrenList().remove(child);
        ((PluginObject)child).setInTheModel(false);
        this.fireStructureChanged(child, 2);
    }

    protected ArrayList<IPluginObject> getChildrenList() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(1);
        }
        return this.fChildren;
    }
}

