/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionPointDetails;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionPointsSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestSourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ExtensionPointsPage
extends PDEFormPage {
    public static final String PAGE_ID = "ex-points";
    private ExtensionPointsSection fExtensionPointsSection;
    private ExtensionPointsBlock fBlock = new ExtensionPointsBlock();

    public ExtensionPointsPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.ExtensionPointsPage_tabName);
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.manifest_plugin_ext_points";
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINTS_OBJ));
        form.setText(PDEUIMessages.ExtensionPointsPage_title);
        this.fBlock.createContent(managedForm);
        this.fExtensionPointsSection.fireSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_plugin_ext_points");
    }

    public void updateFormSelection() {
        super.updateFormSelection();
        IFormPage page = this.getPDEEditor().findPage("plugin-context");
        if (page instanceof ManifestSourcePage) {
            ISourceViewer viewer = ((ManifestSourcePage)page).getViewer();
            if (viewer == null) {
                return;
            }
            StyledText text = viewer.getTextWidget();
            if (text == null) {
                return;
            }
            int offset = text.getCaretOffset();
            if (offset < 0) {
                return;
            }
            IDocumentRange range = ((ManifestSourcePage)page).getRangeElement(offset, true);
            if (range instanceof IDocumentAttributeNode) {
                range = ((IDocumentAttributeNode)range).getEnclosingElement();
            }
            if (range instanceof IPluginExtensionPoint) {
                this.fExtensionPointsSection.selectExtensionPoint((ISelection)new StructuredSelection((Object)range));
            }
        }
    }

    public class ExtensionPointsBlock
    extends PDEMasterDetailsBlock {
        public ExtensionPointsBlock() {
            super(ExtensionPointsPage.this);
        }

        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            ExtensionPointsPage.this.fExtensionPointsSection = new ExtensionPointsSection(this.getPage(), parent);
            return ExtensionPointsPage.this.fExtensionPointsSection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            detailsPart.setPageProvider(new IDetailsPageProvider(){

                public Object getPageKey(Object object) {
                    if (object instanceof IPluginExtensionPoint) {
                        return IPluginExtensionPoint.class;
                    }
                    return object.getClass();
                }

                public IDetailsPage getPage(Object key) {
                    if (key.equals(IPluginExtensionPoint.class)) {
                        return new ExtensionPointDetails();
                    }
                    return null;
                }
            });
        }
    }
}

