/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePreferenceConstants;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ScalabilityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor fLinesToTrigger;
    private Button fEnableAll;
    private Button fReconciler;
    private Button fSyntaxColor;
    private Button fSemanticHighlighting;
    private Button fContentAssist;
    private Button fContentAssistAutoActivation;
    private BooleanFieldEditor fSkipTrivialExpressions;
    private IntegerFieldEditor fMaximumTrivialExpressions;
    private Composite fParserSettingsComposite;
    private final Map<Object, String> fCheckBoxes = new HashMap<Object, String>();
    private final ArrayList<Object> fMasterSlaveListeners = new ArrayList();

    public ScalabilityPreferencePage() {
        this.setPreferenceStore(PreferenceConstants.getPreferenceStore());
        this.setDescription(PreferencesMessages.ScalabilityPreferencePage_description);
    }

    private Button createCheckButton(Composite parent, String label, String key) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        this.fCheckBoxes.put(button, key);
        return button;
    }

    private void initFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        for (Button button : this.fCheckBoxes.keySet()) {
            String key = this.fCheckBoxes.get(button);
            button.setSelection(prefs.getBoolean(key));
        }
        for (SelectionListener selectionListener : this.fMasterSlaveListeners) {
            selectionListener.widgetSelected(null);
        }
        this.fLinesToTrigger.setStringValue(Integer.toString(prefs.getInt("scalability.numberOfLines")));
        this.fSkipTrivialExpressions.load();
        this.fMaximumTrivialExpressions.load();
        this.updateEnable();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.scalability_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 1;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createDetectionSettings(composite);
        new Separator().doFillIntoGrid(composite, nColumns);
        this.createScalabilityModeSettings(composite);
        new Separator().doFillIntoGrid(composite, nColumns);
        this.createParserSettings(composite);
        new Separator().doFillIntoGrid(composite, nColumns);
        String noteTitle = PreferencesMessages.ScalabilityPreferencePage_note;
        String noteMessage = PreferencesMessages.ScalabilityPreferencePage_preferenceOnlyForNewEditors;
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), composite, noteTitle, noteMessage);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        noteControl.setLayoutData((Object)gd);
        this.initFields();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        return ControlFactory.createGroup(parent, labelText, numColumns);
    }

    private void createDetectionSettings(Composite parent) {
        Composite group = this.createGroupComposite(parent, 1, PreferencesMessages.ScalabilityPreferencePage_detection_group_label);
        this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_detection_label, "scalability.detect");
        Composite comp = new Composite(group, 0);
        this.fLinesToTrigger = this.createIntegerField(comp, "scalability.numberOfLines", PreferencesMessages.ScalabilityPreferencePage_trigger_lines_label, 1, Integer.MAX_VALUE);
    }

    private void createScalabilityModeSettings(Composite parent) {
        Composite group = this.createGroupComposite(parent, 1, PreferencesMessages.ScalabilityPreferencePage_scalabilityMode_group_label);
        this.fEnableAll = this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_scalabilityMode_label, "scalability.enableAll");
        this.fReconciler = this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_reconciler_label, "scalability.reconciler");
        this.createDependency(this.fEnableAll, "scalability.enableAll", (Control)this.fReconciler, true);
        this.fSemanticHighlighting = this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_semanticHighlighting_label, "scalability.semanticHighlight");
        this.createDependency(this.fEnableAll, "scalability.enableAll", (Control)this.fSemanticHighlighting, true);
        this.fSyntaxColor = this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_syntaxColor_label, "scalability.syntaxColor");
        this.createDependency(this.fEnableAll, "scalability.enableAll", (Control)this.fSyntaxColor, true);
        this.fContentAssist = this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_contentAssist_label, "scalability.parserBasedContentAssist");
        this.createDependency(this.fEnableAll, "scalability.enableAll", (Control)this.fContentAssist, true);
        this.fContentAssistAutoActivation = this.createCheckButton(group, PreferencesMessages.ScalabilityPreferencePage_contentAssist_autoActivation, "scalability.contentAssistAutoActivation");
        this.createDependency(this.fContentAssist, "scalability.parserBasedContentAssist", (Control)this.fContentAssistAutoActivation, true);
        this.createDependency(this.fEnableAll, "scalability.enableAll", (Control)this.fContentAssistAutoActivation, false);
    }

    private void createParserSettings(Composite parent) {
        Composite parserSettingsGroup = this.createGroupComposite(parent, 1, PreferencesMessages.ScalabilityPreferencePage_parserSettings_group_label);
        Composite skipTrivialComposite = new Composite(parserSettingsGroup, 0);
        this.fSkipTrivialExpressions = new BooleanFieldEditor(CCorePreferenceConstants.SCALABILITY_SKIP_TRIVIAL_EXPRESSIONS, PreferencesMessages.ScalabilityPreferencePage_skipTrivialExpressions_label, skipTrivialComposite);
        this.fSkipTrivialExpressions.setPreferenceStore(CUIPlugin.getDefault().getCorePreferenceStore());
        this.fParserSettingsComposite = new Composite(parserSettingsGroup, 0);
        this.fMaximumTrivialExpressions = this.createIntegerField(this.fParserSettingsComposite, "scalability.maximumTrivialExpressions", PreferencesMessages.ScalabilityPreferencePage_maximumTrivialExpressions_label, 0, Integer.MAX_VALUE);
        this.fMaximumTrivialExpressions.setPreferenceStore(CUIPlugin.getDefault().getCorePreferenceStore());
        this.fSkipTrivialExpressions.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ScalabilityPreferencePage.this.updateEnable();
            }
        });
    }

    private void updateEnable() {
        this.fMaximumTrivialExpressions.setEnabled(this.fSkipTrivialExpressions.getBooleanValue(), this.fParserSettingsComposite);
    }

    private IntegerFieldEditor createIntegerField(Composite parent, String name, String labelText, int rangeMinimum, int rangeMaximum) {
        final IntegerFieldEditor integerField = new IntegerFieldEditor(name, labelText, parent);
        GridData data = (GridData)integerField.getTextControl(parent).getLayoutData();
        data.horizontalAlignment = 1;
        data.widthHint = this.convertWidthInCharsToPixels(11);
        integerField.setPage((DialogPage)this);
        integerField.setValidateStrategy(0);
        integerField.setValidRange(rangeMinimum, rangeMaximum);
        integerField.setErrorMessage(NLS.bind((String)PreferencesMessages.ScalabilityPreferencePage_error, (Object[])new Object[]{rangeMinimum, rangeMaximum}));
        integerField.load();
        integerField.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    ScalabilityPreferencePage.this.setValid(integerField.isValid());
                }
            }
        });
        return integerField;
    }

    private static void indent(Control control, GridData masterLayoutData) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = masterLayoutData.horizontalIndent + 20;
        control.setLayoutData((Object)gridData);
    }

    private void createDependency(final Button master, String masterKey, final Control slave, boolean indent) {
        boolean masterState;
        if (indent) {
            ScalabilityPreferencePage.indent(slave, (GridData)master.getLayoutData());
        }
        slave.setEnabled(!(masterState = this.getPreferenceStore().getBoolean(masterKey)));
        if (masterState) {
            ((Button)slave).setSelection(masterState);
        }
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(!master.getSelection());
                if (master.getSelection()) {
                    ((Button)slave).setSelection(master.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        for (Button button : this.fCheckBoxes.keySet()) {
            String key = this.fCheckBoxes.get(button);
            prefs.setValue(key, button.getSelection());
        }
        prefs.setValue("scalability.numberOfLines", this.fLinesToTrigger.getIntValue());
        this.fSkipTrivialExpressions.store();
        this.fMaximumTrivialExpressions.store();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore prefs = this.getPreferenceStore();
        for (Button button : this.fCheckBoxes.keySet()) {
            String key = this.fCheckBoxes.get(button);
            button.setSelection(prefs.getDefaultBoolean(key));
        }
        for (SelectionListener selectionListener : this.fMasterSlaveListeners) {
            selectionListener.widgetSelected(null);
        }
        this.fLinesToTrigger.setStringValue(Integer.toString(prefs.getDefaultInt("scalability.numberOfLines")));
        this.fSkipTrivialExpressions.loadDefault();
        this.fMaximumTrivialExpressions.loadDefault();
        this.updateEnable();
    }
}

