/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IProjectSettingsWizardPage;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IProjectSettingsWizardPageStrategy;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ISettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.XMLUtils;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProjectSettingsImportStrategy
implements IProjectSettingsWizardPageStrategy {
    private static ErrorHandler ABORTING_ERROR_HANDER = new ErrorHandler(){

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    };

    @Override
    public String getMessage(IProjectSettingsWizardPageStrategy.MessageType type) {
        switch (type) {
            case TITLE: {
                return Messages.ProjectSettingsWizardPage_Import_title;
            }
            case MESSAGE: {
                return Messages.ProjectSettingsWizardPage_Import_message;
            }
            case CHECKBOX: {
                return Messages.ProjectSettingsWizardPage_Import_checkBox;
            }
            case FILE: {
                return Messages.ProjectSettingsWizardPage_Import_file;
            }
            case SETTINGS: {
                return Messages.ProjectSettingsWizardPage_Import_selectSettings;
            }
        }
        return null;
    }

    @Override
    public void pageCreated(IProjectSettingsWizardPage page) {
        page.setDisplayedSettingsProcessors(Collections.<ISettingsProcessor>emptyList());
    }

    @Override
    public void fileSelected(IProjectSettingsWizardPage page) {
        List<Object> pairs = Collections.emptyList();
        try {
            pairs = this.extractSectionsFromFile(page);
            page.setMessage(this.getMessage(IProjectSettingsWizardPageStrategy.MessageType.MESSAGE), 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            page.setMessage(Messages.ProjectSettingsWizardPage_Import_openError, 3);
        }
        catch (SettingsImportExportException settingsImportExportException) {
            page.setMessage(Messages.ProjectSettingsWizardPage_Import_parseError, 3);
        }
        ArrayList<ISettingsProcessor> importersToDisplay = new ArrayList<ISettingsProcessor>();
        for (ImporterSectionPair importerSectionPair : pairs) {
            importersToDisplay.add(importerSectionPair.importer);
        }
        page.setDisplayedSettingsProcessors(importersToDisplay);
    }

    @Override
    public boolean finish(IProjectSettingsWizardPage page) {
        ICConfigurationDescription config = page.getSelectedConfiguration();
        IProject project = config.getProjectDescription().getProject();
        ICProjectDescription writableDescription = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription writableConfig = writableDescription.getConfigurationById(config.getId());
        ICFolderDescription writableProjectRoot = writableConfig.getRootFolderDescription();
        List<ISettingsProcessor> selectedImporters = page.getSelectedSettingsProcessors();
        try {
            List<ImporterSectionPair> pairs = this.extractSectionsFromFile(page);
            for (ImporterSectionPair pair : pairs) {
                if (!selectedImporters.contains(pair.importer)) continue;
                pair.importer.readSectionXML(writableProjectRoot, pair.section);
            }
        }
        catch (FileNotFoundException e) {
            CUIPlugin.log(e);
            page.showErrorDialog(Messages.ProjectSettingsImportStrategy_fileOpenError, Messages.ProjectSettingsImportStrategy_couldNotOpen);
            return false;
        }
        catch (SettingsImportExportException e) {
            CUIPlugin.log(e);
            page.showErrorDialog(Messages.ProjectSettingsImportStrategy_importError, Messages.ProjectSettingsImportStrategy_couldNotImport);
            return false;
        }
        try {
            CoreModel.getDefault().setProjectDescription(project, writableDescription);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            page.showErrorDialog(Messages.ProjectSettingsImportStrategy_importError, Messages.ProjectSettingsImportStrategy_saveError);
            return false;
        }
        return true;
    }

    private List<ImporterSectionPair> extractSectionsFromFile(IProjectSettingsWizardPage page) throws FileNotFoundException, SettingsImportExportException {
        String filePath = page.getDestinationFilePath();
        HashMap<String, ISettingsProcessor> importers = new HashMap<String, ISettingsProcessor>();
        for (ISettingsProcessor processor : page.getSettingsProcessors()) {
            importers.put(processor.getSectionName(), processor);
        }
        FileInputStream in = new FileInputStream(filePath);
        Document document = ProjectSettingsImportStrategy.parse(in);
        Element root = document.getDocumentElement();
        List<Element> sections = XMLUtils.extractChildElements(root, "section");
        ArrayList<ImporterSectionPair> pairs = new ArrayList<ImporterSectionPair>();
        for (Element section : sections) {
            ISettingsProcessor importer;
            String sectionName = section.getAttribute("name");
            if (sectionName == null || (importer = (ISettingsProcessor)importers.get(sectionName)) == null) continue;
            pairs.add(new ImporterSectionPair(importer, section));
        }
        return pairs;
    }

    private static Document parse(InputStream in) throws SettingsImportExportException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(ABORTING_ERROR_HANDER);
            InputSource input = new InputSource(in);
            Document doc = parser.parse(input);
            return doc;
        }
        catch (Exception e) {
            throw new SettingsImportExportException(e);
        }
    }

    private static class ImporterSectionPair {
        Element section;
        ISettingsProcessor importer;

        ImporterSectionPair(ISettingsProcessor importer, Element section) {
            this.importer = importer;
            this.section = section;
        }
    }
}

