/*
 * Decompiled with CFR 0.152.
 */
package markers_java;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class DegreeMarker {
    public static String EFDMarker = null;
    private IResource m_resource;
    private long m_id;
    private static Position m_position;
    private ITextEditor m_editor;

    public DegreeMarker(ICompilationUnit compilationUnit) {
        try {
            this.m_resource = compilationUnit.getUnderlyingResource();
            this.m_editor = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void markDegree(int start, int length, int level) {
        if (level < 20) {
            EFDMarker = "EFDMarker_1.Marker";
        } else if (level >= 20 && level <= 100) {
            EFDMarker = "EFDMarker_2.Marker";
        } else if (level > 100 && level <= 500) {
            EFDMarker = "EFDMarker_3.Marker";
        } else if (level > 500 && level <= 1500) {
            EFDMarker = "EFDMarker_4.Marker";
        } else if (level > 1500) {
            EFDMarker = "EFDMarker_5.Marker";
        }
        try {
            String comment = "EFD = " + level;
            IMarker marker = this.getMarker();
            m_position = new Position(start, length);
            marker.setAttribute("severity", 1);
            marker.setAttribute("charStart", start);
            marker.setAttribute("charEnd", start + length);
            marker.setAttribute("location", (Object)this.m_resource.getName());
            marker.setAttribute("message", (Object)comment);
            marker.setAttribute("priority", 2);
            DegreeMarker.addAnnotation(marker, this.m_editor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IMarker getMarker() throws CoreException {
        IMarker marker = this.m_resource.findMarker(this.m_id);
        if (marker != null) {
            return marker;
        }
        marker = this.m_resource.createMarker(EFDMarker);
        return marker;
    }

    public static void addAnnotation(IMarker marker, ITextEditor editor) {
        IDocumentProvider idp = editor.getDocumentProvider();
        IDocument document = idp.getDocument((Object)editor.getEditorInput());
        IAnnotationModel iamf = idp.getAnnotationModel((Object)editor.getEditorInput());
        SimpleMarkerAnnotation ma = new SimpleMarkerAnnotation(String.valueOf(EFDMarker) + ".MyAnnotation", marker);
        iamf.connect(document);
        iamf.addAnnotation((Annotation)ma, m_position);
        iamf.disconnect(document);
    }
}

