/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FilteredElements {
    private Set exactMatches;
    private Set partialMatches;

    public Set getExactMatches() {
        if (this.exactMatches == null) {
            return Collections.EMPTY_SET;
        }
        return this.exactMatches;
    }

    public Set getPartialMatches() {
        if (this.partialMatches == null) {
            return Collections.EMPTY_SET;
        }
        return this.partialMatches;
    }

    public boolean containsPartialMatch(String componentId) {
        if (this.partialMatches == null) {
            return false;
        }
        if (this.partialMatches.contains(componentId)) {
            return true;
        }
        Iterator iterator = this.partialMatches.iterator();
        while (iterator.hasNext()) {
            String partialMatch = (String)iterator.next();
            if (!componentId.startsWith(partialMatch)) continue;
            return true;
        }
        return false;
    }

    public boolean containsExactMatch(String key) {
        if (this.exactMatches == null) {
            return false;
        }
        return this.exactMatches.contains(key);
    }

    public void addPartialMatch(String componentid) {
        if (this.partialMatches == null) {
            this.partialMatches = new HashSet();
        }
        this.partialMatches.add(componentid);
    }

    public void addExactMatch(String match) {
        if (this.exactMatches == null) {
            this.exactMatches = new HashSet();
        }
        this.exactMatches.add(match);
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("==============================================================================").append(lineSeparator);
        this.printSet(buffer, this.exactMatches, "Exact matches:");
        this.printSet(buffer, this.partialMatches, "Partial matches:");
        buffer.append("==============================================================================").append(lineSeparator);
        return String.valueOf(buffer);
    }

    private void printSet(StringBuffer buffer, Set set, String title) {
        String lineSeparator = System.getProperty("line.separator");
        buffer.append(title).append(lineSeparator);
        if (set != null) {
            int max = set.size();
            Object[] allEntries = new String[max];
            set.toArray(allEntries);
            Arrays.sort(allEntries);
            int i = 0;
            while (i < max) {
                buffer.append((String)allEntries[i]).append(lineSeparator);
                ++i;
            }
            buffer.append(lineSeparator);
        }
    }

    public boolean isEmpty() {
        return !(this.exactMatches != null && !this.exactMatches.isEmpty() || this.partialMatches != null && !this.partialMatches.isEmpty());
    }
}

