/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalComma
extends CPPDependentEvaluation {
    private static final ICPPFunction[] NO_FUNCTIONS = new ICPPFunction[0];
    private final ICPPEvaluation[] fArguments;
    private ICPPFunction[] fOverloads;
    private IType fType;

    public EvalComma(ICPPEvaluation[] evals, IASTNode pointOfDefinition) {
        this(evals, EvalComma.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalComma(ICPPEvaluation[] evals, IBinding templateDefinition) {
        super(templateDefinition);
        this.fArguments = evals;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fType != null) {
            return this.fType instanceof TypeOfDependentExpression;
        }
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isTypeDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ICPPFunction[] getOverloads(IASTNode point) {
        if (this.fOverloads == null) {
            this.fOverloads = this.computeOverloads(point);
        }
        return this.fOverloads;
    }

    private ICPPFunction[] computeOverloads(IASTNode point) {
        if (this.fArguments.length < 2) {
            return NO_FUNCTIONS;
        }
        if (this.isTypeDependent()) {
            return NO_FUNCTIONS;
        }
        ICPPFunction[] overloads = new ICPPFunction[this.fArguments.length - 1];
        ICPPEvaluation e1 = this.fArguments[0];
        int i = 1;
        while (i < this.fArguments.length) {
            ICPPEvaluation e2 = this.fArguments[i];
            ICPPFunction overload = CPPSemantics.findOverloadedOperatorComma(point, this.getTemplateDefinitionScope(), e1, e2);
            if (overload == null) {
                e1 = e2;
            } else {
                overloads[i - 1] = overload;
                e1 = new EvalFixed(ExpressionTypes.typeFromFunctionCall(overload), ExpressionTypes.valueCategoryFromFunctionCall(overload), Value.UNKNOWN);
                if (e1.getTypeOrFunctionSet(point) instanceof ISemanticProblem) {
                    e1 = e2;
                }
            }
            ++i;
        }
        return overloads;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        ICPPFunction last;
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction[] overloads = this.getOverloads(point);
        if (overloads.length > 0 && (last = overloads[overloads.length - 1]) != null) {
            return ExpressionTypes.typeFromFunctionCall(last);
        }
        return this.fArguments[this.fArguments.length - 1].getTypeOrFunctionSet(point);
    }

    @Override
    public IValue getValue(IASTNode point) {
        ICPPFunction[] overloads = this.getOverloads(point);
        if (overloads.length > 0) {
            return Value.create(this);
        }
        return this.fArguments[this.fArguments.length - 1].getValue(point);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        ICPPFunction last;
        ICPPFunction[] overloads = this.getOverloads(point);
        if (overloads.length > 0 && (last = overloads[overloads.length - 1]) != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(last);
        }
        return this.fArguments[this.fArguments.length - 1].getValueCategory(point);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)4);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        ICPPEvaluation[] args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalComma(args, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].instantiate(tpMap, packOffset, within, maxdepth, point);
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalComma(args, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(parameterMap, maxdepth, point);
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalComma(args, this.getTemplateDefinition());
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

