/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class NodeWriter {
    protected Scribe scribe;
    protected ASTWriterVisitor visitor;
    protected NodeCommentMap commentMap;
    protected static final String COMMA_SPACE = ", ";
    protected static final String EQUALS = " = ";
    protected static final String SPACE_COLON_SPACE = " : ";
    protected static final String VAR_ARGS = "...";
    protected static final String COLON_COLON = "::";
    protected static final String COLON_SPACE = ": ";

    public NodeWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        this.scribe = scribe;
        this.visitor = visitor;
        this.commentMap = commentMap;
    }

    protected void writeNodeList(IASTNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            if (i + 1 < nodes.length) {
                this.scribe.print(COMMA_SPACE);
            }
            ++i;
        }
    }

    protected void visitNodeIfNotNull(IASTNode node) {
        if (node != null) {
            node.accept(this.visitor);
        }
    }

    protected void writeTrailingComments(IASTNode node) {
        this.writeTrailingComments(node, true);
    }

    protected void writeTrailingComments(IASTNode node, boolean newLine) {
        boolean first = true;
        for (IASTComment comment : this.getTrailingComments(node)) {
            if (!first) {
                this.scribe.newLine();
            }
            this.scribe.printSpace();
            this.scribe.print(comment.getComment());
            first = false;
        }
        if (newLine) {
            this.scribe.newLine();
        }
    }

    protected boolean hasTrailingComments(IASTNode node) {
        return !this.getTrailingComments(node).isEmpty();
    }

    private List<IASTComment> getTrailingComments(IASTNode node) {
        List<IASTComment> trailingComments = this.commentMap.getTrailingCommentsForNode(node);
        IASTNode originalNode = node.getOriginalNode();
        if (originalNode != node) {
            trailingComments.addAll(this.commentMap.getTrailingCommentsForNode(originalNode));
        }
        return trailingComments;
    }

    protected boolean hasFreestandingComments(IASTNode node) {
        return !this.getFreestandingComments(node).isEmpty();
    }

    private List<IASTComment> getFreestandingComments(IASTNode node) {
        List<IASTComment> freestandingComments = this.commentMap.getFreestandingCommentsForNode(node);
        IASTNode originalNode = node.getOriginalNode();
        if (originalNode != node) {
            freestandingComments.addAll(this.commentMap.getFreestandingCommentsForNode(originalNode));
        }
        return freestandingComments;
    }

    protected void writeFreestandingComments(IASTNode node) {
        for (IASTComment comment : this.getFreestandingComments(node)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
    }
}

