/*
 * 
 */
package Delegates;

import handler.AbstractRun;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import utils.MethodProfileData;
import utils.ProfileDataHolder;

// TODO: Auto-generated Javadoc
/**
 * The Class AbstractJDTCommentsV2Delegate.
 * 
 * @author Eyal Maderer
 * 
 *         <p>
 *         The Class AbstractJDTCommentsV2Delegate.
 *         <p>
 * 
 *         <p>
 *         This Abstract class is detecting the current Java project and passes
 *         it to the AbstractRun class, it always finds all the Java project.
 *         The delegates package Contains classes invoked by the user interface
 *         when a button is clicked from the menu. When creating the menu
 *         extension points each one of the commands where linked to one of the
 *         classes in this package accordingly. We have implemented an abstract
 *         base class called AbstractJDTCommentsV2Delegate.java override and
 *         call the base function passing the AbstractRun class they want to
 *         invoke. The abstract class is responsible to detect the requested
 *         class and package, to run the java interactive profiler and to parse
 *         the result. The last stage is to invoke the AbstractRun class that
 *         was passed from the child delegate class.
 *         <p>
 */
@SuppressWarnings("restriction")
public abstract class AbstractJDTCommentsV2Delegate implements IWorkbenchWindowActionDelegate 
{
	
	/** The Constant PROFILE_FILE. */
	private static final String PROFILE_FILE = "\\profile.txt";
	
	/** The Constant PROFILE_START. */
	private static final String PROFILE_START = "Count     Time    Pct  Location";
	
	/** The Constant PROFILE_LUNCHER. */
	private static final String PROFILE_LUNCHER = "JavaProfile.bat ";
	
	/** The window. */
	private IWorkbenchWindow window;

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window)
	{
		this.window = window; // cache the window object in which action delegate is operating
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {}

	/**
	 * Finds the current Java project and passes it to the AbstractRun class.
	 *
	 * @param action the action
	 * @param run the run
	 */
	public void run(IAction action, AbstractRun run)
	{
		ProfileDataHolder.getInstance().getMethods().clear();
		Shell shell = window.getShell();
		IJavaProject myJavaProject = null;
		String sClassName = "";
		String sPackage = "";

		if(!(window.getSelectionService().getSelection() instanceof TreeSelection))
		{
			shell = window.getShell();
			MessageDialog.openWarning(shell, "JDT Comments - Please choose a Java project", "Please stand on the selected" +
			" Java project in the explorer view and then select your action.");
			return;
		}

		//Here we are trying to locate the selected Java project
		TreeSelection selection = (TreeSelection) window.getSelectionService().getSelection();
		TreePath[] arrPath = selection.getPaths();
		TreePath path = arrPath[0];
		sClassName = path.getLastSegment().toString();
		sClassName = sClassName.substring(0, sClassName.indexOf("."));
		sPackage = path.getSegment(2).toString();
		sPackage = sPackage.substring(0, sPackage.indexOf(" "));
		myJavaProject = (JavaProject) path.getFirstSegment();
		String[] classPath = null;
		try 
		{
			classPath = JavaRuntime.computeDefaultRuntimeClassPath(myJavaProject);
		} 
		catch (CoreException e){
		}

	//	boolean bCritical = MessageDialog.openQuestion(shell, "JDT Comments", "Would you like to see comments only in critical functions?");
		
		//ProfileDataHolder.getInstance().setRunOnlyCriticalCode(bCritical);
		
		Runtime rt = Runtime.getRuntime();

		if(sPackage.contains("default"))
		{
			sPackage = "";
		}
		else
		{
			sPackage+=".";
		}
		if(sClassName.contains("]"))
		{
			sClassName = sClassName.substring(sClassName.indexOf("]")+1);
		}

		//runProfiler(shell, sClassName, sPackage, classPath, bCritical, rt);

		try 
		{
			run.execute((JavaProject) path.getFirstSegment());
		}
		catch (Throwable t) {	
		}

	}
	
	/**
	 * Run profiler.
	 *
	 * @param shell the shell
	 * @param sClassName the s class name
	 * @param sPackage the s package
	 * @param classPath the class path
	 * @param bCritical the b critical
	 * @param rt the rt
	 */
	private void runProfiler(Shell shell, String sClassName, String sPackage,
			String[] classPath, boolean bCritical, Runtime rt) 
	{
		try 
		{
			//Running the profiler
			Process pr = rt.exec(PROFILE_LUNCHER + "\"" + classPath[0]+ "\"" + " " + sPackage + sClassName);

			BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));

			String line=null;

			while((line=input.readLine()) != null) 
			{
				System.out.println(line);
			}
			readDataFile(classPath[0]);

		} 
		catch (IOException e)
		{
			MessageDialog.openWarning(shell, "JDT Comments", "Problem has occoured trying to run the Java profile");		
		}
	}

	/**
	 * Read data file.
	 *
	 * @param classPath the class path
	 */
	private void readDataFile(String classPath)
	{
		try {
		    BufferedReader in = new BufferedReader(new FileReader(classPath + PROFILE_FILE));
		    String str;
		    while ((str = in.readLine()) != null && !str.trim().equals(PROFILE_START))
		    {
		    	System.out.println(str);
		    }
		    while ((str = in.readLine()) != null && !str.trim().equals(PROFILE_START))
		    {
		    	System.out.println(str);
		    }
		    str = in.readLine();
		    while((str = in.readLine()) != null && !str.isEmpty())
		    {
		    	System.out.println(str);
		    	String []arr = StringConverter.asArray(str);
		    	MethodProfileData data = new MethodProfileData();
		    	data.setCount(Integer.valueOf(arr[0]));
		    	data.setTime(Float.valueOf(arr[1]));
		    	data.setPct(Float.valueOf(arr[2]));
		    	String sPackage = arr[3].substring(0, arr[3].indexOf("."));
		    	arr[3] = arr[3].substring(arr[3].indexOf(".") + 1);
		    	String sClass = arr[3].substring(0, arr[3].indexOf(":"));
		    	arr[3] = arr[3].substring(arr[3].indexOf(":") + 1);
		    	String sFunc = arr[3].substring(0, arr[3].indexOf("("));
		    	arr[3] = arr[3].substring(arr[3].indexOf("(") + 1);
		    	data.setPackage(sPackage);
		    	data.setClassName(sClass);
		    	data.setFunction(sFunc);
		    	ProfileDataHolder.getInstance().addMethod(data);
		    }
		    in.close();
		} catch (IOException e) {
		}

	}

}
