/*
 * 
 */
package handler;

import jdtcomments.MarkerCreator;
import jdtcomments.ObjectInliningDetector;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;

// TODO: Auto-generated Javadoc
/**
 * 
 * This is an abstract class for the command run. each subclass of this class is
 * a type of command
 * 
 */

@SuppressWarnings("restriction")
public abstract class AbstractRun extends AbstractHandler 
{

	/**
	 * Execute.
	 *
	 * @param javaProject the java project
	 * @return the object
	 * @throws ExecutionException the execution exception
	 */
	public Object execute(JavaProject javaProject) throws ExecutionException
	{
		try {
			// get package fragments list
			IPackageFragment[] fragments = javaProject.getPackageFragments();
			// rotate over all fragments
			for (int i = 0; i < fragments.length; i++) {
				ICompilationUnit[] units = fragments[i].getCompilationUnits();
				// rotate over all compilation units
				for (int j = 0; j < units.length; j++) {
					// check if this is a java file
					String name = units[j].getElementName();
					if (name.endsWith(".java")) {
						// analyze the unit
						analyzeUnit(units[j]);
					}
				}
			}
		} catch (JavaModelException e) {
			// Throw java model exception - could not get package fragments
			// list
			e.printStackTrace();
		}

		ObjectInliningDetector.reset();
		return null;
	}

	/**
	 * Analyzes of the supplied compilation unit.
	 *
	 * @param compilationUnit the compilation unit
	 */
	protected void analyzeUnit(ICompilationUnit compilationUnit)
	{
		//Clear all the previous markers
		try 
		{
			compilationUnit.getUnderlyingResource().deleteMarkers(MarkerCreator.JDTCommentsMarker, true, 0);
			compilationUnit.getUnderlyingResource().deleteMarkers(MarkerCreator.JDTCommentsBookMark, true, 0);

		}
		catch (CoreException e)
		{
			//Do nothing
		}
		ASTParser parser = ASTParser.newParser(AST.JLS3);
		parser.setKind(ASTParser.K_COMPILATION_UNIT);
		parser.setSource(compilationUnit); // set source
		parser.setResolveBindings(true); // we need bindings later on
		// create a new compilation unit
		CompilationUnit comUnit = (CompilationUnit) parser.createAST(null /* IProgressMonitor */); // parse
		analyzeUnitSpecific(compilationUnit, comUnit);
	}
	
	/**
	 * Every Inherited class should implement this to create the derector spesific
	 * for her needs.
	 *
	 * @param compilationUnit the compilation unit
	 * @param comUnit the com unit
	 */
	abstract protected void analyzeUnitSpecific(ICompilationUnit compilationUnit, CompilationUnit comUnit);

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.AbstractHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		// TODO Auto-generated method stub
		return null;
	}
	



}
