/**
 * @author Isaeed Mohanna
 * Jul 17, 2009 2009
 * 4:20:28 AM
 */
package handler;

import jdtcomments.*;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;

// TODO: Auto-generated Javadoc
/**
 * This class extended the abstract run class and is used to run all analysis
 * at the same time.
 */
public class RunAll extends AbstractRun {

	// Over Ridden Function
	/* (non-Javadoc)
	 * @see handler.AbstractRun#analyzeUnit(org.eclipse.jdt.core.ICompilationUnit)
	 */
	@Override
	protected void analyzeUnitSpecific(ICompilationUnit compilationUnit,CompilationUnit comUnit) 
	{
		// create a new InitArrayDetector and process the compilation unit
		InitArrayDetector initArrayDetector = new InitArrayDetector();
		initArrayDetector.process(comUnit, compilationUnit);

		//Create a new Algebraic Simplification Detector
		AlgebraicSimplificationDetector algebricDetector = new AlgebraicSimplificationDetector();
		algebricDetector.process(comUnit, compilationUnit);
		
		//Create a new Class Splitting  Detector
		StructSplittingReorderingDetector structSplittingReorderingDetector = new StructSplittingReorderingDetector();
		structSplittingReorderingDetector.process(comUnit, compilationUnit);
		
		//Create a new Common sub expression detector
		CommonSubExpressionDetector commonDetector = new CommonSubExpressionDetector();
		commonDetector.process(comUnit, compilationUnit);
		
		//Create a new Constant propagation Detector
		ConstantPropagationDetector constDetector = new ConstantPropagationDetector();
		constDetector.process(comUnit, compilationUnit);
		
		//Create a new Copy Propagation Detector
		CopyPropagationDetector copyDetector = new CopyPropagationDetector();
		copyDetector.process(comUnit, compilationUnit);
		
		//Create a new DependencyFree detector
		DependencyFreeDetector dependencyDetector = new DependencyFreeDetector();
		dependencyDetector.process(comUnit, compilationUnit);
		
		//Create a new FunctionSpecialization detector
		FunctionSpecializationDetector functionSpecializationDetector = new FunctionSpecializationDetector();
		functionSpecializationDetector.process(comUnit, compilationUnit);
		
		// Create new Synchronized Lock granularity detector and process the
		// compilation unit
		SynchronizedLockGranularityDetector
		synchronizedLockGranularityDetector = new
		SynchronizedLockGranularityDetector();
		synchronizedLockGranularityDetector.process(comUnit,
				compilationUnit);
		
		//Create a new LoopDistribution detector
		LoopDistributionDetector distributionDetector = new LoopDistributionDetector();
		distributionDetector.process(comUnit, compilationUnit);
		
		// create a new Invariant Code detector and process the compilation unit
		InvariantCodeDetector invariantCodeDetector = new
		InvariantCodeDetector();
		invariantCodeDetector.process(comUnit, compilationUnit);

		//Create a new LoopPeeling detector
		LoopPeelingDetector peelingDetector = new LoopPeelingDetector();
		peelingDetector.process(comUnit, compilationUnit);
		
		// create a new Memory Misuse detector and process the compilation unit
		MemoryMisuseDetector memoryMisuseDetector = new
		MemoryMisuseDetector();
		memoryMisuseDetector.process(comUnit, compilationUnit);

		// Create a new Object inlining detector 
		ObjectInliningDetector objectInliningDet = new ObjectInliningDetector();
		objectInliningDet.process(comUnit, compilationUnit);
		
		//Create a new object splitting detector
		ObjectSplittingDetector splittingDetector = new ObjectSplittingDetector();
		splittingDetector.process(comUnit, compilationUnit);
		
		// Create a new Reduction Clause detector 
		ReductionClauseDetector reductionClauseDetector = new ReductionClauseDetector();
		reductionClauseDetector.process(comUnit, compilationUnit);
		
		// Create a new Shared Read Lock detector
		SharedReadLockDetector sharedReadLockDetector = new SharedReadLockDetector();
		sharedReadLockDetector.process(comUnit, compilationUnit);
		
		// Create a new Shared Read Lock detector
		SingleExpressionDetector singleExpressionDetector = new SingleExpressionDetector();
		singleExpressionDetector.process(comUnit, compilationUnit);
		
		//Create a new strength reduction Detector
		StrengthReductionDetector strengthDetector = new StrengthReductionDetector();
		strengthDetector.process(comUnit, compilationUnit);
		
		// create a new Synchronized Invariant Code detector and process the
		// compilation unit
		SynchronizedBlockInvariantCodeDetector
		synchronizedBlockInvariantCodeDetector = new
		SynchronizedBlockInvariantCodeDetector();
		synchronizedBlockInvariantCodeDetector.process(comUnit,
				compilationUnit);
		
		// create a new Temporary objects detector and process the compilation
		// unit
		TemporaryObjectsDetector temporaryObjectsDetector = new
		TemporaryObjectsDetector();
		temporaryObjectsDetector.process(comUnit, compilationUnit);
	}
}
