/*
 * 
 */
package jdtcomments;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;

import utils.ObjectMarkerLocation;
import utils.CommentTypes;


// TODO: Auto-generated Javadoc
/**
 * The Class AlgebraicSimplificationDetector.
 * 
 * @author Eyal Maderer
 * 
 *       <p>  The Class AlgebraicSimplificationDetector.<p>
 * <p>
 *         In our implementation of AlgebraicSimplificationDetector.java we
 *         extended our base comment detector. The implementation of this
 *         comment is very easy, we just need to find all the Infix Expressions
 *         in the code and when we do, we need to check if one of the operands
 *         of this expression is zero, if so, we need to check the operators
 *         type and supply the suitable comment.
 * <p>
 */
public class AlgebraicSimplificationDetector extends BaseCommentDetector 
{

	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarkerSpecific(int, int)
	 */
	protected void placeProblemMarkerSpecific(int position, int length) 
	{
		getMarker().placeProblem(position, length, CommentTypes.ALGEBRIC_SIMLIFICATION);
	}

	/**
	 * Place problem marker.
	 *
	 * @param position the position
	 * @param length the length
	 * @param marker the marker
	 * @param additionalComment the additional comment
	 */
	protected void placeProblemMarker(int position, int length, MarkerCreator marker, String additionalComment) 
	{
		if(isInsideCriticalFunction())
		{
			marker.placeProblem(position, length, CommentTypes.ALGEBRIC_SIMLIFICATION, additionalComment);
		}
	}

	
	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#visit(org.eclipse.jdt.core.dom.InfixExpression)
	 */
	@Override
	public boolean visit(InfixExpression node)
	{
		boolean flag = false; 
		Expression left = node.getLeftOperand();
		Expression right = node.getRightOperand();
		String comment = "";
		if(left.getNodeType() == ASTNode.NUMBER_LITERAL && left.toString().equalsIgnoreCase("0"))
		{
			if(node.getOperator().toString().equalsIgnoreCase("*")
					||node.getOperator().toString().equalsIgnoreCase("/"))
			{
				flag=true;
				comment = "0";
			}
			if(node.getOperator().toString().equalsIgnoreCase("+") 
					|| node.getOperator().toString().equalsIgnoreCase("-"))
					
			{
				flag=true;
				comment = right.toString();
			}
			if(flag==true){
				ObjectMarkerLocation classLocation = new ObjectMarkerLocation(node.toString(), node.getStartPosition(),node.getLength(), getMarker());
				placeProblemMarker(classLocation.getStartLocation(), classLocation.getLength(), classLocation.getMarker(), comment);
			}
			return true;
		}
		if(right.getNodeType() == ASTNode.NUMBER_LITERAL && right.toString().equalsIgnoreCase("0"))
		{
			if(node.getOperator().toString().equalsIgnoreCase("*")
					||node.getOperator().toString().equalsIgnoreCase("/"))
			{
				flag=true;
				comment = "0";
			}
			if(node.getOperator().toString().equalsIgnoreCase("+") 
					|| node.getOperator().toString().equalsIgnoreCase("-"))
			{
				flag=true;
				comment = left.toString();
			}
			
			if(flag==true){
				ObjectMarkerLocation classLocation = new ObjectMarkerLocation(node.toString(), node.getStartPosition(),node.getLength(), getMarker());
				placeProblemMarker(classLocation.getStartLocation(), classLocation.getLength(), classLocation.getMarker(), comment);
			}
			return true;
		}
		return true;
	}

}
