package jdtcomments;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.WhileStatement;


import utils.CommentTypes;
import utils.ObjectMarkerLocation;

/**.
 /**
 * The Class ObjectInliningDetector.
 * 
 * @author Mouen Rizik & Morad Habiballah
 * 
 *         
 *          The Class FunctionSpecializationDetector.
 *        
 *          In our implementation of FunctionSpecializationDetector.java we extended our base comment detector,
 *          The implementation of function specialization detector is to go over all the Assignment and the if statements 
 *          and function invocation .
 *          we will specialized reduced function by extracting condition statement to be applied prior to function invocation
 *          we will consider 3 situations of comparing: a Global variable with parameter  , a Constant variable with parameter, 
 *          a Parameter variable with parameter
 *          Furthermore we will check if there is any function invocation that contain Global or Constant variable.
 *          Finally we will check if we have an assignment between parameter and Constant or Global
 *          
 *         	
 *         
 */


public class FunctionSpecializationDetector extends BaseCommentDetector {
	

	boolean _isInsideMethodDeclaration = false,isAssignment =false,isMethodInvocation =false;
	boolean isInsideDeclaretion=false, _isInsideWhileStatement =false, _isInsideForStatement=false, _isInsideIfStatement=false;	
	
	List <SingleVariableDeclaration> parlist;
	int i =0,count=0,linefunc=0,x=0,invocation_lines=0,_isInsideIfStatementcount=0,siz=0,func_size=0,isAssigment=0;		
	String[] spex,tmpstring,lpex,lspex,sspex,constant,sepex,Spname, nfunc;
	String comment="",comment1="",comment2,comment3="",comment7="",FuncName1="",splitPart ="",ss ;	
	String lines_Cfunc="",Spc_funclines="",name_func,methodname="",TypeDeclareParameters="";	
	 List<String> TypeDeclarePar = new ArrayList<String>();
	 List<String> VarFragment = new ArrayList<String>(); //local variable in function
	 List<String> Parfunc = new ArrayList<String>(); //Parameters of function
	 List<String> NameFunc = new ArrayList<String>(); //function declaration name ....NOT USED
	 List<String> CallFunc = new ArrayList<String>(); //function invocation name

	 List<String> lines_Fcalling = new ArrayList<String>();//function invocation lines
     List<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
     List<MethodInvocation> methods1 = new ArrayList<MethodInvocation>(); 
     static int coun=0,countER=0;	 
     ObjectMarkerLocation classLocation22;
     List<ObjectMarkerLocation> Lclasslocation=new ArrayList<ObjectMarkerLocation>();
     

	// ============================= Overridden functions

	/* Add a problem marker and highlight the text
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarker(int, int)
	 */
	/**
	 * Place problem marker specific.
	 *
	 * @param position position to place the marker
	 * @param length length of code to highlight
	 */
	@Override
	protected void placeProblemMarkerSpecific(int position, int length)
	{
		// Place Marker
		getMarker().placeProblem(position, length, CommentTypes.FUNCTION_SPECIALIZATION);		
	}

	
	
	/**
	 * we will get over all the functions names and the parameters and save it in a list
	 */
	public boolean visit(MethodDeclaration node) 
	{
	
		String tmp=node.toString().split("\n")[0],tmpstr;
		func_size=tmp.length();
        tmpstr=tmp.substring(0, tmp.indexOf("("));
        int c=tmpstr.lastIndexOf(" ");
        NameFunc.add(tmpstr.substring(c)); //all function names in list
        name_func=tmpstr.substring(c); //function name
		parlist = node.parameters(); //function parameters 
		comment="";
		comment7="";		
		VarFragment.clear();
		//TypeDeclarePar.clear();
		//Parfunc.clear();
		//TypeDeclareParameters="";
		return super.visit(node);
	}	
	

	
	/**
	 * 
	 * we will go over all the method invocation and we will mark whose contain global variable or constant variable 
	 */
	public boolean visit(MethodInvocation node)
	{		
		
		int FunSize=node.toString().indexOf("("),ArgSize=node.arguments().size();//Function invocation length , number of arguments
		int i=0,j=0;
		String arg="",var="";//we save the constant value in arg and the Parameters will save it in var
		boolean FlocalVariable=true; // check if is it a Local variab le
		for(i=0;i<ArgSize;i++)
		{
		 j=0;FlocalVariable=true;
		 while(j<VarFragment.size())
		    {
			  if(node.arguments().toArray()[i].toString().equalsIgnoreCase(VarFragment.get(j))) // varFragmet is a list which contain all the local variable
				{
				  FlocalVariable=false;
				 break;
				}
			  j++;
			}
		
		 if(FlocalVariable==true)	
		    {
			   arg+="_"+node.arguments().toArray()[i].toString();	
			}
		 else
			{					
			   var+=node.arguments().toArray()[i].toString()+"  ";			       
			}				
		}				
		 x = getCompilationUnit().getLineNumber(node.getStartPosition());	 // x will contain the line number of the function invocation 
		 boolean flag=true;
			if(node.toString().substring(0, FunSize).contains(".")==false){
		
				lines_Fcalling.add(String.valueOf(x));//function invocation lines in list			
				CallFunc.add(node.toString().substring(0, FunSize));//all function invocation name
				flag=false;
			}
			if(node.toString().substring(0, FunSize).contains(".")==true)
			{
				int h=0,ind=node.toString().indexOf(".");
				String st=node.toString().substring(ind+1,FunSize);
				while(h<NameFunc.size())
				{
				if(st.equalsIgnoreCase(NameFunc.get(h).substring(1)))
					{
					lines_Fcalling.add(String.valueOf(x));					
					CallFunc.add(st);
					flag=false;
					comment1="Replace your function with :"+st+arg+"("+var+") \n"+" Line Number :"+x;
					break;
				}
				h++;
				}
								
			}
			if(flag==false)
			{
				comment1="Replace your function with :"+node.toString().substring(0, FunSize)+arg+"("+var+") \n"+" Line Number :"+x;
				//comment=c;
				 classLocation22 = new ObjectMarkerLocation(node.toString(), node.getStartPosition(),node.getLength(), getMarker());
				 Lclasslocation.add(classLocation22);
				 if(arg.isEmpty()==false)
				 {
				 placeProblemMarker(classLocation22.getStartLocation(), classLocation22.getLength(), classLocation22.getMarker(), comment1);
			}}
		isMethodInvocation=true;
		return super.visit(node);
	}
	
		public boolean visit(Assignment node)
	{	
			//isAssigment++;
		isAssignment=false;isMethodInvocation=false;TypeDeclareParameters="";
		int count=parlist.size();
		for(Iterator<SingleVariableDeclaration> it=parlist.iterator();it.hasNext();)
		{
			String fName = it.next().toString();
			TypeDeclarePar.add(fName);
			String[] sParts = fName.split(" ");
			Parfunc.add(sParts[1].toString()); // function parameter list
			TypeDeclareParameters+=fName+" "; // save for example : int x int y
			if(sParts.length<2) continue;
		}
		//String TypeDeclareParameters="";
		/*for(Iterator<SingleVariableDeclaration> it=parlist.iterator();it.hasNext();)
		{
			String fName = it.next().toString();
			String[] sParts = fName.split(" ");
			//Fpar+=sParts[1]+";"; //parameters
			Parfunc.add(sParts[1].toString()); // function parameter list
			LeftHandSideAssignment+=fName+" "; // save for example : int x int y
			if(sParts.length<2) continue;
		}*/
		
		if(isConstantValue(node.getRightHandSide()))
		{
			String  LeftAssignment = node.getLeftHandSide().toString();
			for(Iterator<SingleVariableDeclaration> it=parlist.iterator();it.hasNext();)
				{
					String fullName = it.next().toString();
					//LeftHandSideAssignment+=fullName+" ";
					String[] splitParts = fullName.split(" ");
					if(splitParts.length<2) continue;
					if(LeftAssignment.equals(splitParts[1]))
					{
					if(node.getParent().getParent().getParent().getParent().getParent().getLength()==node.getRoot().getLength())
						{						
							String [] AssignmentfunctionName = node.getParent().getParent().getParent().toString().split("\n");
							int AssignmentSize = AssignmentfunctionName[0].length();							
							String[] msd=TypeDeclareParameters.split(splitParts[0]+" "+splitParts[1]);
							if(count==1)
							{
								comment1="Replace your function with :"+ name_func+"_"+node.getRightHandSide().toString()+"(void)";
							}
							else
							{
							if(msd.length==1)
							{
								comment1="Replace your function with :"+name_func+"_"+node.getRightHandSide().toString()+"("+msd[0]+")";	
							}	
							else
							{
						    	if(msd[0].isEmpty())
								{
								    comment1="Replace your function with :"+name_func+"_"+node.getRightHandSide().toString()+"("+msd[1]+")";
								}
								else
								{
									comment1="Replace your function with :"+name_func+"_"+node.getRightHandSide().toString()+"("+msd[0]+msd[1]+")";
								}
							}
						}
							 x = getCompilationUnit().getLineNumber(node.getStartPosition());

					comment3=comment1 +" \n Line Number : "+x+"\n ";
					ObjectMarkerLocation classLocation3 = new ObjectMarkerLocation(node.getParent().getParent().getParent().toString(), node.getParent().getParent().getParent().getStartPosition(),AssignmentSize+1, getMarker());
					placeProblemMarker(classLocation3.getStartLocation(), classLocation3.getLength(), classLocation3.getMarker(), comment3);
					}
				}
			}
		}
		return super.visit(node);
	}
		public boolean endvisit(Assignment node) 
		{
			TypeDeclarePar.clear();
			Parfunc.clear();
			TypeDeclareParameters="";
			return super.visit(node);
		}
	
	 public boolean visit(ForStatement node)
	   {
		   _isInsideForStatement=true;
		   return super.visit(node);
	   }
	 
   public boolean visit(WhileStatement node)
   {
	   _isInsideWhileStatement=true;
	   return super.visit(node);
   }
 

   public boolean visit(VariableDeclarationFragment node)
   {	
	 VarFragment.add(node.getName().toString());	 
	return true;
   }
   
  	
 /**
  * we will get over all the if statements which is not in invariant code and check if the statement is one of : comparing Global with parameter or
  * Constant with parameter or parameter with parameter , and the output will be a table of Line number , condition type , calling site and our optimization code
  *    
  */
   public boolean visit(IfStatement node)
	{
	   
		int j=0,count;
		i=0 ;		
		TypeDeclareParameters="";
		 _isInsideIfStatementcount++;

      if(_isInsideWhileStatement == false && _isInsideForStatement==false && isAssignment==false) 
      {	   
   	   
   	  // a loop which save the parameters of the function
    	  for(Iterator<SingleVariableDeclaration> it=parlist.iterator();it.hasNext();)
  		{
  			String fName = it.next().toString();
  			TypeDeclarePar.add(fName);
  			String[] sParts = fName.split(" ");
  			Parfunc.add(sParts[1].toString()); // function parameter list
  			TypeDeclareParameters+=fName+" "; // save for example : int x int y
  			if(sParts.length<2) continue;
  		}
							
				i=0;count=0;
				String lhs="";
				String leftE="";
				String VarFunc="";				
				boolean isLeftParameter=false,isRightParameter=false,isLocalVariable=false,isParameter=false,NonParameterCondition=true;	
				
					lhs=node.getExpression().toString();
					i++;				
					if(lhs.contains("==")) spex = lhs.split(" ==");    	   
					if(lhs.contains("<=")) spex = lhs.split(" <=");
                    if(	lhs.contains(">=")) spex = lhs.split(" >=");
   	                if(lhs.contains("<"))   spex = lhs.split(" <");
                   if(lhs.contains(">"))    spex = lhs.split(" >");			
	               leftE=spex[1].substring(spex[1].indexOf(" ")+1);	               
	               for(j=0;j<Parfunc.size();j++)
		              {
			            if(leftE.equals(Parfunc.get(j)))  isLeftParameter=true;			         
			            if(spex[0].equals(Parfunc.get(j)))  isRightParameter=true;
			           
			           
		              }
	               if(isRightParameter==true&& isLeftParameter==true)	// check if it a Parameter situation // this line mean the two side are parameters
	               {
	            	   isParameter=true;
	            	   comment2="Parameter";
	               }
	               else
	               {
	            	   if(isLeftParameter==true)
	            		   					leftE=spex[0];
	               }
	               if(isLeftParameter==false && isRightParameter==false)
	            	   									NonParameterCondition=false;
	            
                  for(j=0;j<VarFragment.size();j++) // check if it a non Local situation which mean Global OR constant
	               {
		             if(leftE.equals(VarFragment.get(j)))
		            {
		            	 isLocalVariable=true;
			           break;
		            }
	              }     
	              
	            VarFunc+="_"+leftE;
	            if(NonParameterCondition==true)
	            {
            
               if(isParameter==false)
               {
               	if(isLocalVariable==false)	
               	{
               	if(isConstantValues(leftE))		// check if constant value
               	comment2="  Constant";
               	if(isConstantValues(leftE)==false)     // if it is not a constant nor parameter then it will be the global situation         		
               		comment2=" Global";
               	
               	}
               }
               if(isParameter==true||(isParameter==false && isLocalVariable==false)) // parameter with global or constant

            	   
            	   
            	   
            	   if(_isInsideIfStatementcount==1) // to be sure that we are not in a complex if 
	              {				
	               			
			           // String[] msd=TypeDeclareParameters.split(tmpstring[0]+" "+tmpstring[1]);//new Parameters without extrbale condinainal
			        	count=parlist.size();
						
					
						 x = getCompilationUnit().getLineNumber(node.getStartPosition());

						
						 if( count==1)
							{
								comment3 ="\n"+"Check if the statment \n "+" if("+node.getExpression().toString()+
								           ") \n is true then call the new function : "+name_func+VarFunc+" ( void )"
										+"\n"+" \n"+node.getThenStatement().toString()+
							" \n else call the orginal function :  \n "+name_func+"("+TypeDeclareParameters+")\n";										                        
							}
							else
							{
								comment3 ="\n"+"Check if the statment \n "+" if("
							             +node.getExpression().toString()+
							             ") \n is true then call the new function : "+name_func+VarFunc+" ( "+TypeDeclareParameters+" ) \n  "
							       		+ " \n "+
							            node.getThenStatement().toString()+" \n else call the orginal function :  \n "
							           +name_func+" ( "+TypeDeclareParameters+" ) \n";	
							}
						
							
							int h1=0;
							Spc_funclines="";
							while(h1<CallFunc.size())
							{
								if(CallFunc.get(h1).equalsIgnoreCase(name_func.substring(1))) // check if the same name of the function
								{
									Spc_funclines+=lines_Fcalling.get(h1)+" ";
									classLocation22=Lclasslocation.get(h1);
									placeProblemMarker(classLocation22.getStartLocation(), classLocation22.getLength(), classLocation22.getMarker(), comment1);
									
								}
								h1++;
							}				
							
							
						   if(!Spc_funclines.isEmpty())
						   {
							
						  String[]comm=comment3.split("\n");
						  comment3="";
						  h1=0;
						  while(h1<comm.length)
						  {
							 comment3+="                                                                                                                                "+comm[h1].toString()+"\n";
							 h1++;
						  }
						    comment+="     "+x +"                               "   +comment2+"                       "+Spc_funclines+"                            \n"+
						            
						            comment3+"\n"+
						            "------------------------------------------------------------------------------------------------------------------- \n";
						    comment7=comment;
						   }
						   int h11=0;
						   while(h11<Lclasslocation.size())
						   {
							      	h11++;
						   }
						
	                	ObjectMarkerLocation classLocation = new ObjectMarkerLocation(node.getParent().getParent().toString(), node.getParent().getParent().getStartPosition(),func_size+1, getMarker());
						placeProblemMarker(classLocation.getStartLocation(), classLocation.getLength(), classLocation.getMarker(), comment7);
		        
			}}
		}
		return super.visit(node);
		}

   public void endVisit(IfStatement node)
   {
	   _isInsideIfStatement=false;
	   _isInsideIfStatementcount--;
	   TypeDeclarePar.clear();
		Parfunc.clear();
		TypeDeclareParameters="";
   }
	private boolean isConstantValues(String leftE) {
		char[] s=leftE.toCharArray();
		int counte=0;
		
					if(leftE.indexOf('"')==0)
					{
						return true;
					}
					for(int i=0;i<s.length;i++)
					{
						if(s[i]=='0'||s[i]=='1'||s[i]=='2'||s[i]=='3'||s[i]=='4'||s[i]=='5'||s[i]=='6'||s[i]=='7'||s[i]=='8'||s[i]=='9'||s[i]=='.')
						{
							counte++;
						}
					}
					if(counte==s.length)
					{
						return true;
					}
				
		return false;
	}

	protected void placeProblemMarker(int position, int length, MarkerCreator marker, String additionalComment) 
	{
		if(isInsideCriticalFunction())
		{
			marker.placeProblem(position, length, CommentTypes.FUNCTION_SPECIALIZATION, additionalComment);
			
		}
	}
	private boolean isConstantValue(Expression exp)
	{
		if (exp == null) 
		{
		return false;
	    }
		if (exp instanceof NumberLiteral || exp instanceof StringLiteral
		|| exp instanceof BooleanLiteral || exp instanceof NullLiteral
		|| exp instanceof CharacterLiteral) 
		{
		return true;
		} 
		return false;
	}
    
 

}
