package jdtcomments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import utils.CommentTypes;

public class LoopDistributionDetector extends BaseCommentDetector 
{
	
	int _loopCounter = 0;
	/** A list of all loop iterator. */
	ArrayList<String> _loopIterator = new ArrayList<String>();
	/** Holds a set of invariant variables inside the current block, it is filled upon first entrance to a loop. */
	List<Expression> tmp = new ArrayList<Expression>();
	List<String> l_variables = new ArrayList<String>(); // Holds the left side variables
	List<String> r_variables = new ArrayList<String>(); // Holds the right side variables
	Map<String,List<String>> non_d_rows = new HashMap<String,List<String>>();	
	List<String> non_d_variables = new ArrayList<String>(); /*non dependent variables*/
	List<String> tmp1 = new ArrayList<String>();
	List<String> for_updaters = new ArrayList<String>();
	
	
	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarkerSpecific(int, int)
	 */
	protected void placeProblemMarkerSpecific(int position, int length) 
	{
		getMarker().placeProblem11(position, length, CommentTypes.LOOP_DISTRIBUTION,non_d_rows);
	}
	
	/**
	 * Place problem marker.
	 *
	 * @param position the position
	 * @param length the length
	 * @param marker the marker
	 */
	protected void placeProblemMarker(int position, int length, MarkerCreator marker) 
	{
		if(isInsideCriticalFunction())
		{
			marker.placeProblem(position, length, CommentTypes.LOOP_DISTRIBUTION);
		}
	}


	/*
	 * Handles the entrance to a for statement tree (non-Javadoc)
	 * 
	 * @seeorg.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.
	 * ForStatement)
	 */
	@Override
	public boolean visit(Assignment node){
		Expression expNodeL = (Expression)(node.getLeftHandSide());
		Expression expNodeR = (Expression)(node.getRightHandSide());
		String test1,test2;
		ArrayAccess expr;
		List<String> tmpV=new ArrayList<String>();
		// check if the left side is an array access get the array name
		if(node.getLeftHandSide() instanceof ArrayAccess)
		{
			expr = (ArrayAccess)node.getLeftHandSide();
			expNodeL = expr.getArray();
		}
		// check if the right side is an array access get the array name
		if(node.getRightHandSide() instanceof ArrayAccess)
		{
			expr = (ArrayAccess)node.getRightHandSide();
			expNodeR = expr.getArray();
		}
		// get the variable name as string
		test1 = expNodeL.toString();
		// add the left variable name to the set
		l_variables.add(test1);
		tmpV.add(test1);
		tmp.add(expNodeL);	
		test2 = expNodeR.toString();
		/* check the type of the variable , if it's complicated then it
		 *  will be decomposed using the addInfix() function 
		 */
		if(expNodeR instanceof SimpleName){
			r_variables.add(test2);
			tmpV.add(test2);
			tmp.add(expNodeR);
		}else if(expNodeR instanceof InfixExpression){
			InfixExpression exp = (InfixExpression)expNodeR;
			addInfix(exp,tmpV);
		}
		tmp1.clear();
		tmp1.addAll(l_variables);
		tmp1.retainAll(r_variables);
		non_d_rows.put(node.toString(), tmpV);
		super.visit(node);
		return true;
		
		
	}
	
	/*
	 * This Function works recursively , it works on decomposing infix expressions 
	 * into simple ones , by calling itself recursively for each infix sub expression
	 */
	public void addInfix(Expression exp,List<String> tmpV){
		if (exp instanceof InfixExpression) {
			InfixExpression infixExpression = (InfixExpression) exp;
			Expression expNodeL = infixExpression.getLeftOperand();
			Expression expNodeR = infixExpression.getRightOperand();
			ArrayAccess expr;
			// check if the left side is an array access get the array name
			if(infixExpression.getLeftOperand() instanceof ArrayAccess)
			{
				expr = (ArrayAccess)infixExpression.getLeftOperand();
				expNodeL = expr.getArray();
			}
			// check if the right side is an array access get the array name
			if(infixExpression.getRightOperand() instanceof ArrayAccess)
			{
				expr = (ArrayAccess)infixExpression.getRightOperand();
				expNodeR = expr.getArray();
			}
			/*
			 * recursively calls on the left and right sub expressions until
			 * we reach the basic ones
			 */
			addInfix(expNodeL,tmpV);
			addInfix(expNodeR,tmpV);
				// if left and right side of the infix expression are invariant
				// then we check the extended operands
			List temp = infixExpression.extendedOperands();
			/*
			 * moving the infix expression sub-parts into list , so every
			 * sub expression can be handled apart
			 */
			for (Iterator iterator = temp.iterator(); iterator.hasNext();) {
					Expression curExp = (Expression) iterator.next();
					addInfix(curExp,tmpV);
				}
			}
		/*
		 * this is the most basic case , simplename expression , here
		 * the expression will be added into the right variables list
		 * because infix expressions can appears only on the right side
		 */
		if (exp instanceof SimpleName) {
			Expression curExp = (Expression) exp;
			String test3 = curExp.toString();
			r_variables.add(test3);
			tmpV.add(test3);
			tmp.add(curExp);
		}
	}
	
	
	/*
	 * (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#visit(org.eclipse.jdt.core.dom.InfixExpression)
	 * 
	 * this function called automatically by the compiler when an infix expression read
	 */
	public boolean visit(InfixExpression node){
		Expression left = node.getLeftOperand();
		Expression right = node.getRightOperand();
		String test3 = left.toString();
		ArrayAccess expr;
		// check if the left side is an array access get the array name
		if(node.getLeftOperand() instanceof ArrayAccess)
		{
			expr = (ArrayAccess)node.getLeftOperand();
			left = expr.getArray();
			test3 = left.toString();
		}
		// check if the right side is an array access get the array name
		if(node.getRightOperand() instanceof ArrayAccess)
		{
			expr = (ArrayAccess)node.getRightOperand();
			right = expr.getArray();
		}
		r_variables.add(test3);
		tmp.add(left);
		test3 = right.toString();
		r_variables.add(test3);
		tmp.add(right);
		tmp1.clear();
		tmp1.addAll(l_variables);
		tmp1.retainAll(r_variables);
		return true;
	}
	
	
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.MethodInvocation)
	 * called when a function invocation appears
	 */
	public boolean visit(MethodInvocation node)
	{
		for (Iterator iterator = node.arguments().iterator(); iterator.hasNext();) {
			r_variables.add(iterator.next().toString());

		}
		
		return true;
	}
	
	
	
	
	public boolean visit(PrefixExpression node)
	{
		Expression expr = node.getOperand(); 
		String test3 = expr.toString();
		/*make sure the prefix is ++ or --*/
		if((node.getOperator() != PrefixExpression.Operator.INCREMENT) || (node.getOperator() != PrefixExpression.Operator.DECREMENT))
			return true;
		/*
		 * add a prefix variable into both sides lists
		 */
		r_variables.add(test3);
		l_variables.add(test3);
		r_variables.removeAll(for_updaters);
		l_variables.removeAll(for_updaters);
		tmp.add(expr);	
		tmp1.clear();
		tmp1.addAll(l_variables);
		tmp1.retainAll(r_variables);
		return true;
	}
	
	
	
	
	public boolean visit(PostfixExpression node)
	{
		Expression expr = node.getOperand(); 
		String test3 = expr.toString();
		r_variables.add(test3);
		l_variables.add(test3);
		r_variables.removeAll(for_updaters);
		l_variables.removeAll(for_updaters);
		tmp.add(expr);
		
		tmp1.clear();
		tmp1.addAll(l_variables);
		tmp1.retainAll(r_variables);
		return true;
	}
	

	
	public boolean visit(VariableDeclarationFragment node){
		l_variables.add(node.getName().toString());
		return true;
	}

	
	
	
	public boolean visit(ForStatement node)
	{
		_loopCounter++;
		char c=0;
		String cc = "";
		if(node.updaters().get(0) instanceof PostfixExpression)
		{
			c = node.updaters().toString().charAt(1);	//assumption: only 1 updater.
														//otherwise should iterate through node.updaters(),
														//convert all of them to Strings,
														//take the 1st char of each one,
														//and add all of them to for_updaters
														
			//also, assuming the updater is 1 char.
			//otherwise enable these instead: 
			/*cc = node.updaters().toString();
			cc = cc.substring(1, cc.length()-4);*/
		}
		else if(node.updaters().get(0) instanceof PrefixExpression)
		{
			c = node.updaters().toString().charAt(3);
		}
		String ch = Character.toString(c);
		/* check the loop deep */
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			for_updaters.clear();
			non_d_rows.clear();
		}
		for_updaters.add(ch);
		/*for_updaters.add(cc);*/ /*ENABLE FOR MORE-THAN-1-CHAR VARIABLES*/
		return true;
	}

	
	public void endVisit(ForStatement node)
	{
		int start = node.getStartPosition();
		int end = 3; /*length of the word "for"*/
		//forExp = (Expression)node.getExpression();
		if(tmp1.isEmpty() && tmp1.size()>1)
		{
			/*ObjectMarkerLocation classLoaction = new ObjectMarkerLocation(forExp.toString(), start,end, getMarker());
			getObjectsLocations().add(classLoaction);*/
			placeProblemMarkerSpecific(start,end);
		}else{
			for (Iterator iterator = tmp1.iterator(); iterator.hasNext();) {
				String st=iterator.next().toString();
				Iterator<Map.Entry<String,List<String>>> iter = non_d_rows.entrySet().iterator();
				while (iter.hasNext()) {
				    Map.Entry<String,List<String>> entry = iter.next();
				    if(entry.getValue().contains(st) == true){
				        iter.remove();
				    }
				}
			}
			if(non_d_rows.isEmpty()==false && non_d_rows.size()>1 ){
				placeProblemMarkerSpecific(start,end);
			}
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			for_updaters.clear();
			non_d_rows.clear();
		}
	}
	
	public boolean visit(WhileStatement node)
	{
		_loopCounter++;
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			non_d_rows.clear();
		}
		return true;
	}
	
	public void endVisit(WhileStatement node)
	{
		int start = node.getStartPosition();
		int end = 5; /*length of the word "while"*/
		//whileExp = (Statement)node.getBody();
		if(tmp1.isEmpty() && tmp1.size()>1)
		{
			placeProblemMarkerSpecific(start,end);
		}else{
			for (Iterator iterator = tmp1.iterator(); iterator.hasNext();) {
				String st=iterator.next().toString();
				Iterator<Map.Entry<String,List<String>>> iter = non_d_rows.entrySet().iterator();
				while (iter.hasNext()) {
				    Map.Entry<String,List<String>> entry = iter.next();
				    if(entry.getValue().contains(st) == true){
				        iter.remove();
				    }
				}
			}
			if(non_d_rows.isEmpty()==false && non_d_rows.size()>1){
				placeProblemMarkerSpecific(start,end);
			}
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			non_d_rows.clear();
		}
	}
	
	public boolean visit(DoStatement node)
	{
		_loopCounter++;
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			non_d_rows.clear();
		}
		return true;
	}
	
	
	
	public void endVisit(DoStatement node)
	{
		int start = node.getStartPosition();
		int end = 2; /*length of the word "do"*/
		if(tmp1.isEmpty() && tmp1.size()>1)
		{
			placeProblemMarkerSpecific(start,end);
		}else{
			for (Iterator iterator = tmp1.iterator(); iterator.hasNext();) {
				String st=iterator.next().toString();
				Iterator<Map.Entry<String,List<String>>> iter = non_d_rows.entrySet().iterator();
				while (iter.hasNext()) {
				    Map.Entry<String,List<String>> entry = iter.next();
				    if(entry.getValue().contains(st) == true){
				        iter.remove();
				    }
				}
			}
			if(non_d_rows.isEmpty()==false && non_d_rows.size()>1){
				placeProblemMarkerSpecific(start,end);
			}
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			non_d_rows.clear();
		}
	}

}
