/**
 * @author Isaeed Mohanna
 * May 20, 2009 2009
 * 12:35:32 PM
 */
package jdtcomments;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;


import utils.CommentMessages;

// TODO: Auto-generated Javadoc
/**
 * This Class is Responsible for creation of the comments on a compilation unit.
 * Basically this is a wrapper for the general marker creator and only creates
 * problem markers with warning severity
 * 
 */
public class MarkerCreator 
{
	//====================================== Final Public fields
	/** The name of the JDT Comments Marker. */
	public final static String JDTCommentsMarker = "JDTCommentsV2.JDTCommentsMarkerV2";
	
	/** The Constant JDTCommentsBookMark. */
	public final static String JDTCommentsBookMark = "JDTCommentsV2.JDTCommentsMarkerV3";

	// ====================================== Private Data Members
	/*
	 * Hold reference to the marker
	 */
	/** The _resource. */
	private IResource _resource;
	
	/** Holds id of created marker. */
	private long _id;

	// ====================================== Constructor
	/**
	 * Default Constructor.
	 *
	 * @param compilationUnit Reference to the wanted compilation unit
	 */
	public MarkerCreator(ICompilationUnit compilationUnit) {
		
		try {
			// Initialize the Creator with the required recourses from the
			// compilation unit
			_resource = compilationUnit.getUnderlyingResource();
			
		} catch (JavaModelException e) {
			// Error getting Resource from compilation unit
			e.printStackTrace();
		}
	}

	// ====================================== Public Methods
	/**
	 * Adds a marker in the file at the given position from and highlights the text from start to end.
	 *
	 * @param start of text highlight
	 * @param length the length
	 * @param commentType Type of message
	 * @param additionalComment the additional comment
	 */
	public void placeProblem(int start, int length, int commentType, String additionalComment)
	{
		// create a marker inside the compilation unit
		try 
		{
			IMarker marker = getMarker();
			marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_WARNING);
			marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_HIGH);
			marker.setAttribute(IMarker.CHAR_START, start);
			marker.setAttribute(IMarker.CHAR_END, start + length);
			marker.setAttribute(IMarker.LOCATION, _resource.getName());
			marker.setAttribute(IMarker.MESSAGE, CommentMessages.getCommentMessage(commentType) + additionalComment);
			
		} catch (CoreException e) {
			// Error creating marker
			e.printStackTrace();
		}
	}
	
	public void placeProblem1(int start, int length, int commentType, Map<String, List<String>> nonDRows)
	{
		List<String> l= new ArrayList<String>();
		Iterator<Map.Entry<String,List<String>>> iter = nonDRows.entrySet().iterator();
		while (iter.hasNext()) {
		    Map.Entry<String,List<String>> entry = iter.next();
		    l.add(entry.getKey().toString() + " ");
		}
		String st= "\n You Can Separate These Lines Into separate loops : \n" + l.toString();
		// create a marker inside the compilation unit
		try 
		{
			IMarker marker = getMarker();
		
			marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_WARNING);
			marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_HIGH);
			marker.setAttribute(IMarker.CHAR_START, start);
			marker.setAttribute(IMarker.CHAR_END, start + length);
			marker.setAttribute(IMarker.LOCATION, _resource.getName());
			marker.setAttribute(IMarker.MESSAGE, CommentMessages.getCommentMessage(commentType) + st);
			
		} catch (CoreException e) {
			// Error creating marker
			e.printStackTrace();
		}
	}
	
	/**
	 * Place problem.
	 *
	 * @param start the start
	 * @param length the length
	 * @param commentType the comment type
	 */
	public void placeProblem(int start, int length, int commentType)
	{
		placeProblem(start, length, commentType, "");
	}
	
	public void placeProblem11(int start, int length, int commentType,Map<String, java.util.List<String>> nonDRows)
	{
		placeProblem1(start, length, commentType, nonDRows);
	}
	
	
	// ====================================== Private Method

	/**
	 * The method looks if the marker has been already created under this
	 * resource if so then it uses it otherwise it creates a new one.
	 *
	 * @return the marker
	 * @throws CoreException the core exception
	 */
	private IMarker getMarker() throws CoreException
	{
		// search for the marker if it was already created
		IMarker marker = _resource.findMarker(_id);
		if (marker != null)
		{
			return marker;
		}

		return _resource.createMarker(JDTCommentsMarker);

	}
	
	/**
	 * Place bookmark.
	 *
	 * @param start the start
	 * @param length the length
	 * @param commentType the comment type
	 * @param additionalComment the additional comment
	 */
	public void placeBookmark(int start, int length, int commentType, String additionalComment)
	{
		try 
		{
			IMarker marker = _resource.createMarker(JDTCommentsBookMark);
			marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_WARNING);
			marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_LOW);
			marker.setAttribute(IMarker.CHAR_START, start);
			marker.setAttribute(IMarker.CHAR_END, start + length);
			marker.setAttribute(IMarker.LOCATION, _resource.getName());
			marker.setAttribute(IMarker.MESSAGE, CommentMessages.getCommentMessage(commentType) + additionalComment);
			
		} catch (CoreException e) {
			// Error creating marker
			e.printStackTrace();
		}
	}

	public void placeProblem_R_C(int start, int end, int commentType, List<String> arr) {
		placeProblem(start, end, commentType, arr.toString());
		
	}


	public void placeProblem_S_E(int start, int length,int commentType, String str) {
		placeProblem(start, length, commentType, str);
		
	}

}
