/*
 * 
 */
package jdtcomments;

import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

import utils.CommentTypes;
import utils.MethodProfileData;
import utils.ProfileDataHolder;

// TODO: Auto-generated Javadoc
/**
 * The Class ObjectSplittingDetector.
 * 
 * @author Eyal Maderer
 * 
 *         <p>
 *         The Class ObjectSplittingDetector.
 *         <p>
 * 
 *         <p>
 *         In our implementation of ObjectSplittingDetector.Java we extended
 *         our base comment detector. The implementation of this comment for
 *         Java programs is quite hard and we had to make an assumption that
 *         every access to a classs field is made with a get method. (I.e.
 *         getX() for the field x). This assumption is very realistic when
 *         talking about proper object oriented programming. From the first Java
 *         analysis we have made with the help of the Java interactive profiler
 *         we have a MethodData class for each of the methods in the program
 *         and by thru this class we know for each method how many times she was
 *         called. We than go over all the return statements in the program and
 *         check if the variable returned in this method is a local field, if so
 *         with the help of the MethodData class of this method we calculate
 *         id this method is called relatively much more than other get methods
 *         of this class, if so this means that the field returned in this
 *         method can be split from his class in order to create a new class for
 *         this field.
 *         <p>
 */
public class ObjectSplittingDetector extends BaseCommentDetector 
{

	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarkerSpecific(int, int)
	 */
	@Override
	protected void placeProblemMarkerSpecific(int position, int length)
	{
		getMarker().placeProblem(position, length, CommentTypes.OBJECT_SPLITTING);
		
	}
	
	/**
	 * Place problem marker.
	 *
	 * @param position the position
	 * @param length the length
	 * @param additionalCommant the additional commant
	 */
	protected void placeProblemMarker(int position, int length, String additionalCommant) 
	{
		if(isInsideCriticalFunction())
		{
			getMarker().placeProblem(position, length, CommentTypes.OBJECT_SPLITTING, additionalCommant);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.ReturnStatement)
	 */
	@Override
	public boolean visit(ReturnStatement node)
	{
		MethodProfileData methodData = null;
		
		try
		{
			Block block = (Block) node.getParent();
			MethodDeclaration method = (MethodDeclaration) block.getParent();
			String sPackage = null;
			String sFunction = method.getName().toString();
			TypeDeclaration parent = (TypeDeclaration) method.getParent();
			String sClass = parent.getName().toString();
			CompilationUnit unit = (CompilationUnit) parent.getParent();
			try
			{
				sPackage = unit.getPackage().toString();
				sPackage = sPackage.substring(sPackage.indexOf("package") + 8);
				sPackage = sPackage.substring(0, sPackage.length()-2);
			}
			catch (Exception e)
			{
				sPackage = "";
			}
			for(MethodProfileData data:ProfileDataHolder.getInstance().getCriticalMethods())
			{
				if(sPackage.trim().equalsIgnoreCase(data.getPackage()) && sClass.trim().equalsIgnoreCase(data.getClassName())
						&& sFunction.trim().equalsIgnoreCase(data.getFunction()))
				{
					methodData = data;
				}
			}
		}
		catch (Exception e)
		{
			return true;
		}
		if(null != node.getExpression() && (node.getExpression() instanceof SimpleName))
		{
			boolean bPlaceMarker = true;
			SimpleName member = (SimpleName) node.getExpression();
			for(VariableDeclarationFragment var:getMembers())
			{
				if(member.toString().equalsIgnoreCase(var.getName().toString()))
				{
					if(null != methodData)
					{
						for(MethodProfileData data:ProfileDataHolder.getInstance().getCriticalMethods())
						{
							if(data != methodData && methodData.getClassName().equalsIgnoreCase(data.getClassName()) && methodData.getPackage().equalsIgnoreCase(data.getPackage())
									&& data.getCount() > methodData.getCount())
							{
								bPlaceMarker = false;
							}
						}
						if(bPlaceMarker)
						{
							placeProblemMarker(var.getStartPosition(), var.getLength(), getComment(var, methodData.getCount()));
						}
					}
				}
			}
		}
		return true;
	}

	/**
	 * Gets the comment.
	 *
	 * @param var the var
	 * @param count the count
	 * @return the comment
	 */
	private String getComment(VariableDeclarationFragment var, int count) 
	{
		return "This field was accessed " + count + " times from outside this class\n" + "you should consider splitting this class \n" +
				"and create a new class that contains only this variable";
	}

}
