package jdtcomments;

import java.util.ArrayList;

import java.util.List;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import utils.CommentTypes;

/*
 * Some loops that have dependences can be still run in
 * Paralyzed mode.
 * OpenMP framework can still support such
 * reduction clause to calculate reduced sums.
 * 
 * by : Fadi Matar & Alaa Masalha
 *  
 */



public class ReductionClauseDetector extends BaseCommentDetector 
{
	
	int _loopCounter = 0;
	
	/** A list of all loop iterator. */
	ArrayList<String> _loopIterator = new ArrayList<String>();
	
	/** Holds a set of invariant variables inside the current block, it is filled upon first entrance to a loop. */
	List<Expression> tmp = new ArrayList<Expression>();
	List<String> l_variables = new ArrayList<String>();// Holds the left side variables
	List<String> r_variables = new ArrayList<String>();// Holds the right side variables
	List<String> tmp1 = new ArrayList<String>();
	List<String> for_updaters = new ArrayList<String>();

	
	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarkerSpecific(int, int)
	 */
	protected void placeProblemMarkerSpecific(int position, int length) 
	{
		getMarker().placeProblem_R_C(position, length, CommentTypes.REDUCTION_CLAUSE, tmp1);
	}
	
	/**
	 * Place problem marker.
	 *
	 * @param position the position
	 * @param length the length
	 * @param marker the marker
	 */
	protected void placeProblemMarker(int position, int length, MarkerCreator marker) 
	{
		if(isInsideCriticalFunction())
		{
			marker.placeProblem(position, length, CommentTypes.REDUCTION_CLAUSE);
		}
	}

	

	/*
	 * Handles the entrance to a for statement tree (non-Javadoc)
	 * 
	 * @seeorg.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.
	 * ForStatement)
	 */
	@Override
	public boolean visit(Assignment node){
		if(node.getOperator()== Assignment.Operator.ASSIGN)
			return true;
		Expression expNodeL = (Expression)(node.getLeftHandSide());
		String test1;
		ArrayAccess expr;
		// check if the left side is an array access get the array name
		if(node.getLeftHandSide() instanceof ArrayAccess)
		{
			expr = (ArrayAccess)node.getLeftHandSide();
			expNodeL = expr.getArray();
		}
		test1 = expNodeL.toString();
		l_variables.add(test1);
		r_variables.add(test1);
		tmp.add(expNodeL);	
		tmp1.clear();
		tmp1.addAll(l_variables);
		tmp1.retainAll(r_variables);
		super.visit(node);
		return true;				
	}
	

	public boolean visit(ForStatement node)
	{
		_loopCounter++;
		char c=0;
		String cc = "";
		String ch = Character.toString(c);
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			for_updaters.clear();
		}
		for_updaters.add(ch);
		/*for_updaters.add(cc);*/ /*ENABLE FOR MORE-THAN-1-CHAR VARIABLES*/
		return true;
	}

	public void endVisit(ForStatement node)
	{
		int start = node.getStartPosition();
		int end = 3; /*length of the word "for"*/
		//forExp = (Expression)node.getExpression();
		if(!(tmp1.isEmpty()))
		{
			/*ObjectMarkerLocation classLoaction = new ObjectMarkerLocation(forExp.toString(), start,end, getMarker());
			getObjectsLocations().add(classLoaction);*/
			placeProblemMarkerSpecific(start,end);
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			for_updaters.clear();
		}
	}
	
	public boolean visit(WhileStatement node)
	{
		_loopCounter++;
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
		}
		return true;
	}
	
	public void endVisit(WhileStatement node)
	{
		int start = node.getStartPosition();
		int end = 5; /*length of the word "while"*/
		if(!(tmp1.isEmpty()))
		{
			placeProblemMarkerSpecific(start,end);
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
		}
	}
	
	public boolean visit(DoStatement node)
	{
		_loopCounter++;
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
		}
		return true;
	}
	
	public void endVisit(DoStatement node)
	{
		int start = node.getStartPosition();
		int end = 2; /*length of the word "do"*/
		if(!(tmp1.isEmpty()))
		{
			placeProblemMarkerSpecific(start,end);
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
		}
	}

	
	
}
