package jdtcomments;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import utils.CommentTypes;

/*
 * Single Expression class
 * Single Expression is about finding loops which have only
 * single expression. Almost Every loop that has one
 * expression can be paralyzed using OpenMP pragmas.
 * 
 * by : Fadi Matar & Alaa Masalha
 * 
 */


public class SingleExpressionDetector extends BaseCommentDetector 
{	
	int _loopCounter = 0;	
	/** A list of all loop iterator. */
	ArrayList<String> _loopIterator = new ArrayList<String>();
	/** Holds a set of invariant variables inside the current block, it is filled upon first entrance to a loop. */
	List<Expression> tmp = new ArrayList<Expression>();
	List<String> l_variables = new ArrayList<String>();
	List<String> r_variables = new ArrayList<String>();
	List<String> tmp1 = new ArrayList<String>();
	List<String> tmp2 = new ArrayList<String>();
	List<String> tmp3 = new ArrayList<String>();
	List<String> for_updaters = new ArrayList<String>();

	
	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarkerSpecific(int, int)
	 */
	protected void placeProblemMarkerSpecific(int position, int length) 
	{
		getMarker().placeProblem(position, length, CommentTypes.SINGLE_EXPRESSION);
	}
	protected void placeProblemMarkerSpecific(int position, int length,String str) 
	{
		getMarker().placeProblem_S_E(position, length, CommentTypes.SINGLE_EXPRESSION, str);
	}
	
	/**
	 * Place problem marker.
	 *
	 * @param position the position
	 * @param length the length
	 * @param marker the marker
	 */
	protected void placeProblemMarker(int position, int length, MarkerCreator marker) 
	{
		if(isInsideCriticalFunction())
		{
			marker.placeProblem(position, length, CommentTypes.SINGLE_EXPRESSION);
		}
	}

	public boolean visit(ForStatement node)
	{
		/*
		 * get the loop body and convert it to string
		 */
		String tmpBody =node.getBody().toString();
		int counter = 0;
		/*
		 * count the number of lines in the loop body
		 * every end of line detected by the ; character
		 */
		for( int i=0; i<tmpBody.length(); i++ ) {
		    if( tmpBody.charAt(i) == ';' ) {
		        counter++;
		    } 
		}
		/*
		 * check if the body contains if condition or other loop , 
		 * because these don't contain the ; sign
		 */
		if(tmpBody.contains("if")==true || tmpBody.contains("while")==true || tmpBody.contains("do")==true || tmpBody.contains("for")==true){
			if(counter==1)
				return true;
			else if(counter==0)
				counter++;
		}
		if(counter!=1)
			return true;
		_loopCounter++;
		char c=0;
		String ch = Character.toString(c);	
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			for_updaters.clear();
		}
		tmp1.add(node.toString());
		return true;
	}

	public void endVisit(ForStatement node)
	{
		int start = node.getStartPosition();
		int end = 3; /*length of the word "for"*/
		if(!(tmp1.isEmpty()))
		{
			placeProblemMarkerSpecific(start,end,"for");
			//placeProblemMarkerSpecific(start,end);
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp1.clear();
			tmp.clear();
			for_updaters.clear();
		}
		tmp1.clear();
	}
	
	public boolean visit(WhileStatement node)
	{
		/*
		 * get the loop body and convert it to string
		 */
		String tmpBody =node.getBody().toString();
		int counter = 0;
		/*
		 * count the number of lines in the loop body
		 * every end of line detected by the ; character
		 */
		for( int i=0; i<tmpBody.length(); i++ ) {
		    if( tmpBody.charAt(i) == ';' ) {
		        counter++;
		    } 
		}
		/*
		 * check if the body contains if condition or other loop , 
		 * because these don't contain the ; sign
		 */
		if(tmpBody.contains("if")==true || tmpBody.contains("while")==true || tmpBody.contains("do")==true || tmpBody.contains("for")==true){
			if(counter==1)
				return true;
			else if(counter==0)
				counter++;
		}
		if(counter!=1)
			return true;
		_loopCounter++;
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp2.clear();
			tmp.clear();
		}
		tmp2.add(node.toString());
		return true;
	}
	
	public void endVisit(WhileStatement node)
	{
		int start = node.getStartPosition();
		int end = 5; /*length of the word "while"*/
		if(!(tmp2.isEmpty()))
		{
			placeProblemMarkerSpecific(start,end,"while");
			//placeProblemMarkerSpecific(start,end);
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp2.clear();
			tmp.clear();
		}
		tmp2.clear();
	}
	
	public boolean visit(DoStatement node)
	{
		/*
		 * get the loop body and convert it to string
		 */
		String tmpBody =node.getBody().toString();
		int counter = 0;
		/*
		 * count the number of lines in the loop body
		 * every end of line detected by the ; character
		 */
		for( int i=0; i<tmpBody.length(); i++ ) {
		    if( tmpBody.charAt(i) == ';' ) {
		        counter++;
		    } 
		}
		/*
		 * check if the body contains if condition or other loop , 
		 * because these don't contain the ; sign
		 */
		if(tmpBody.contains("if")==true || tmpBody.contains("while")==true || tmpBody.contains("do")==true || tmpBody.contains("for")==true){
			if(counter==1)
				return true;
			else if(counter==0)
				counter++;
		}
		if(counter!=1)
			return true;
		_loopCounter++;
		if(_loopCounter == 1)
		{
			r_variables.clear();
			l_variables.clear();
			tmp3.clear();
			tmp.clear();
		}
		tmp3.add(node.toString());
		return true;
	}
	
	public void endVisit(DoStatement node)
	{
		int start = node.getStartPosition();
		int end = 2; /*length of the word "do"*/
		if(!(tmp3.isEmpty()))
		{
			placeProblemMarkerSpecific(start,end,"while");
			//placeProblemMarkerSpecific(start,end);
		}
		_loopCounter--;
		if(_loopCounter==0)
		{
			r_variables.clear();
			l_variables.clear();
			tmp3.clear();
			tmp.clear();
		}
		tmp3.clear();
	}

}
