package jdtcomments;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ASTNode;
import utils.CommentTypes;

public class StructSplittingReorderingDetector extends BaseCommentDetector 
{
	
	int _loopCounter = 0;
	int max=0;
	int m_start=0,m_end=0;
	int co=0;
	int for_iters = 1;
	boolean in_for = false;
	String props = "";
	/** A list of all loop iterator. */
	ArrayList<String> _loopIterator = new ArrayList<String>();
	int class_position = 0;
	int class_end = 0;
	String topClass="";
	/** Holds a set of invariant variables inside the current block, it is filled upon first entrance to a loop. */
	Map<String,Integer> struct_counter = new HashMap<String,Integer>();
	/*Expression forExp;
	Statement whileExp;
	Statement doExp;*/
	/* (non-Javadoc)
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarkerSpecific(int, int)
	 */
	protected void placeProblemMarkerSpecific(int position, int length) 
	{
		getMarker().placeProblem(position, length, CommentTypes.STRUCT_SPLITTING_REORDERING, props);
	}
	
	/**
	 * Place problem marker.
	 *
	 * @param position the position
	 * @param length the length
	 * @param marker the marker
	 */
	protected void placeProblemMarker(int position, int length, MarkerCreator marker) 
	{
		if(isInsideCriticalFunction())
		{
			marker.placeProblem(position, length, CommentTypes.STRUCT_SPLITTING_REORDERING);
		}
	}

	
	
	public boolean visit(QualifiedName node)
	{
		
		if(struct_counter.containsKey(topClass + "." + node.getName().toString()) == false) {
			struct_counter.put(topClass + "." + node.getName().toString(),for_iters);
		}
		else{
				struct_counter.put(topClass + "." + node.getName().toString(), 
						struct_counter.get(topClass + "." + node.getName().toString())+for_iters);
		}
		return true;
	}

	public void endVisit(QualifiedName node)
	{
		String st="";
		
		Iterator<Map.Entry<String,Integer>> iter = struct_counter.entrySet().iterator();
		while (iter.hasNext()) {
		    Map.Entry<String,Integer> entry = iter.next();
		    if(entry.getValue() > max){
		    	max = entry.getValue();
		    	st = entry.getKey().toString();
				m_start = node.getStartPosition();
				m_end = st.length();
		    }
				
		}
	}
	

	public boolean visit(CompilationUnit  node)
	{

		return true;
	}

	public void endVisit(CompilationUnit  node)
	{
		String st="";
		int nums=1;
		String modified = "";
		boolean flag = false;
		int sum = 0;
		double ratio = 0.0;
		Iterator<Map.Entry<String,Integer>> iter = struct_counter.entrySet().iterator();
		while (iter.hasNext()) {
		    Map.Entry<String,Integer> entry = iter.next();
		    sum += entry.getValue();
		    if(entry.getValue() > max){
		    	max = entry.getValue();
		    	st = entry.getKey();
				m_start = node.getStartPosition();
				m_end = st.length();
		    }
		}
		Iterator<Map.Entry<String,Integer>> iter1 = struct_counter.entrySet().iterator();
		while (iter1.hasNext()) {
		    Map.Entry<String,Integer> entry = iter1.next();
		    //struct_counter.put(entry.getKey(), entry.getValue()/sum);
		    ratio = (double)entry.getValue()/sum;
		    if(ratio >= 0.4)
		    {
		    	modified = entry.getKey().toString();
		    	int until = modified.indexOf(".");
		    	modified = modified.substring(until+1);
		    	props += nums + ") " + modified + "\n";
		    	nums++;
		    }
		    else flag = true;
		}
		if(flag)
			placeProblemMarkerSpecific(class_position,class_end);
		props = "";
	}
	
	public boolean visit(TypeDeclaration  node){
		co++;
		topClass=node.getName().toString();
		return true;
	}
	public void endVisit(TypeDeclaration  node){
		if(co == 2){
			class_position = node.getName().getStartPosition();
			class_end = node.getName().getLength();
			co++;
		}
	}
	
	public boolean visit(ForStatement  node){
		in_for = true;
		InfixExpression test = (InfixExpression)node.getExpression();
		for_iters = Integer.parseInt(test.getRightOperand().toString());
		return true;
	}
	
	public void endVisit(ForStatement node){
		for_iters=1;
	}

	public boolean visit(WhileStatement  node){
		in_for = true;
		InfixExpression test = (InfixExpression)node.getExpression();
		for_iters = Integer.parseInt(test.getRightOperand().toString());
		return true;
	}
	
	public void endVisit(WhileStatement node){
		for_iters=1;
	}
	
}
