/**
 * @author Isaeed Mohanna
 * May 30, 2009 2009
 * 2:56:35 AM
 */
package jdtcomments;

import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;

import utils.CommentTypes;


// TODO: Auto-generated Javadoc
/**
 * This class detects temporary objects in the source code.
 */
public class TemporaryObjectsDetector extends BaseCommentDetector {

	
	// ============================= Overridden functions
	
	/* Add a problem marker and highlight the text
	 * @see jdtcomments.BaseCommentDetector#placeProblemMarker(int, int)
	 */
	/**
	 * Place problem marker specific.
	 *
	 * @param position position to place the marker
	 * @param length length of code to highlight
	 */
	@Override
	protected void placeProblemMarkerSpecific(int position, int length) {
		// Place Marker
		getMarker().placeProblem(position, length, CommentTypes.TEMPORARY_OBJETS);
		
	}
	
		
	// ============================= Overridden Visitors
	// Class Creation Node

	/* Visits class creation node and checks for the parent.(non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.ClassInstanceCreation)
	 */
	@Override
	public boolean visit(ClassInstanceCreation node) {
		// check if parent is method invocation
		if(node.getParent() instanceof MethodInvocation){
			// add marker
			placeProblemMarker(node.getStartPosition(),node.getLength());
			
		}
		// check if parent is and expression
		if(node.getParent() instanceof ExpressionStatement)
		{
			// add marker
			placeProblemMarker(node.getStartPosition(),node.getLength());
		}
		
		return super.visit(node);
	}	

}
