/**
 * @author Isaeed Mohanna
 * Jul 17, 2009 2009
 * 1:32:45 AM
 */
package utils;

import java.util.ArrayList;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

// TODO: Auto-generated Javadoc
/**
 * This class is used to find the list of all variables declared inside the
 * block i.e. the synchronized block local variables
 * 
 */
public class BlockVariablesDetector extends ASTVisitor {

	// ===================== Private data members
	/** Container for holding the variables. */
	ArrayList<String> _variables = new ArrayList<String>();

	// ===================== Overridden function
	// Variable declaration fragment

	/*
	 * Indicates a declaration of a variable
	 * 
	 * @seeorg.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.
	 * VariableDeclarationFragment)
	 */
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.VariableDeclarationFragment)
	 */
	@Override
	public boolean visit(VariableDeclarationFragment node) {

		// add the name of the declared variable to the variables list
		SimpleName name = node.getName();
		_variables.add(name.getIdentifier());
		return super.visit(node);
	}

	// ===================== Getters
	/**
	 * used to get the array list of block variables inside the block.
	 *
	 * @return the _variables
	 */
	public ArrayList<String> getVariables() {
		return _variables;
	}

}
