/**
 * @author Isaeed Mohanna
 * Jun 18, 2009 2009
 * 8:12:34 AM
 */
package utils;

import java.util.ArrayList;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;

// TODO: Auto-generated Javadoc
/**
 * This class detects all variables inside a block that is assigned to a value
 * i.e. it stops over all assignment, and ++ expressions inside the block and
 * saves all variable names all variables are saved in a an array that can be
 * retrieved.
 * 
 */
public class BlockVariantVariablesDetector extends ASTVisitor {

	// ===================== Private data members
	/** Container for holding the variables. */
	ArrayList<String> _variables = new ArrayList<String>();

	// ===================== Overridden function
	// ================ Assignment statement
	/*
	 * add the left side of the assignment to the variables map
	 * 
	 * @see
	 * org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.Assignment
	 * )
	 */
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.Assignment)
	 */
	@Override
	public boolean visit(Assignment node) {
		// take the left hand side
		findVariantVariables(node.getLeftHandSide());

		return super.visit(node);
	}

	// ======================= Post fix
	/*
	 * And variables that their value is updated using the post fix command
	 * 
	 * @seeorg.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.
	 * PostfixExpression)
	 */
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.PostfixExpression)
	 */
	@Override
	public boolean visit(PostfixExpression node) {
		// add variables to list
		findVariantVariables(node.getOperand());
		return super.visit(node);
	}

	// ======================= Post fix
	/*
	 * Add variables that there value is updated using the pre fix command
	 * 
	 * @seeorg.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.
	 * PrefixExpression)
	 */
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.dom.ASTVisitor#visit(org.eclipse.jdt.core.dom.PrefixExpression)
	 */
	@Override
	public boolean visit(PrefixExpression node) {
		// add variables to list
		findVariantVariables(node.getOperand());
		return super.visit(node);
	}

	// ===================== Getters

	/**
	 * used to get the array list of modified variables inside the block.
	 *
	 * @return the _variables
	 */
	public ArrayList<String> get_variables() {
		return _variables;
	}

	// ===================== private function
	/**
	 * add all variant variables to the loop. it checks the type of the left
	 * hand side assignment and adds it to the map accordingly
	 * 
	 * @param exp
	 *            left side hand of assignment
	 */
	private void findVariantVariables(Expression exp) {
		// check if this is a simple variable
		if (exp instanceof SimpleName) {
			SimpleName sName = (SimpleName) exp;
			// add variable name to array
			_variables.add(sName.getIdentifier());
		}
		// check if array access then add it to the array list
		if (exp instanceof ArrayAccess) {
			ArrayAccess arr = (ArrayAccess) exp;
			_variables.add(arr.toString());
		}
	}

}
