/**
 * @authors Isaeed Mohanna , Alaa Masalha , Fadi Matar
 * Last update: 09/2014
 **/

package utils;

// TODO: Auto-generated Javadoc
/**
 * Returns the comments message according to there type.
 */
public class CommentMessages {

	// ====================================== Public Static Methods
	/**
	 * Gets the comment message.
	 *
	 * @param commentType the comment type
	 * @return the comment message
	 */
	public static String getCommentMessage(int commentType) {
		// switch case for comments types
		switch (commentType) {

			case CommentTypes.TEMPORARY_OBJETS:
				return "Explicit temporary object creation";
			case CommentTypes.INEFFICIENT_CODING:
				return "Inefficient coding practice - use Arrays.fill instead of manual intialization";
			case CommentTypes.INVARIANT_CODE_WITH_LOOPS:
				return "Invariant Code within Loops";
			case CommentTypes.MEMORY_MISUSE:
				return "Memory Misuse - memory allocation inside functions";
			case CommentTypes.INVARIANT_CODE_WITH_SYNCHRONIZED:
				return "Invariant code inside synchronized block";
			case CommentTypes.REDUCE_LOCK_GRANULARITY:
				return "Reduce the lock granularity by locking only the array/struct cell instead of the whole array/struct";
			case CommentTypes.USE_NON_EXCLUSIVE_LOCK:
				return "Use shared read lock instead of an exclusive lock";
			case CommentTypes.POSSIBLE_INVARIANTCODE:
				return "Possible invariant call - check if the method body is invariant";
			case CommentTypes.OBJECT_INLINING:
				return "Object inlining is recomended";
			case CommentTypes.COMMON_SUB_EXPRESSION:
				return "This expression is found inside the loop more the once \n you can replace it for example with variable = ";
			case CommentTypes.COPY_PROPAGATION:
				return "This assigment expression does nothing you can remove it";
			case CommentTypes.ALGEBRIC_SIMLIFICATION:
				return "Algebric simplification is recommended \n You can replace this expression with - ";
			case CommentTypes.CONSTANT_PROPAGATION:
				return "Constant propagation is recommended \n You can replace this variable with - ";
			case CommentTypes.STRENGTH_REDUCTION:
				return "Strength reduction is recommended \n";
			case CommentTypes.OBJECT_SPLITTING:
				return "Object splitting is recommended \n";
			case CommentTypes.CRITICAL_METHOD:
				return "This method is one of the three most critical methods in your code -\n";				
			case CommentTypes.DEPENDENCY_FREE:
				return "Dependency Free" +
						"\n\nYou can add //omp" +
						"\n\nExample:" +
						"\n\nBefore:" +
						"\nfor(i=0;i<10;i++){...}" +
						"\n\nAfter:" +
						"\n//omp parallel for" +
						"\nfor(i=0;i<10;i++){...}"+
						"\n\n_-_-_-_-_-_-_-_-_-_-_-_-_"+
						"\n\nfor additional information on how to use OpenMP in Java, see:" +
						"\nhttp://www2.epcc.ed.ac.uk/computing/research_activities/jomp/index_1.html" +
						"\nor read the UserGuide"+
						"\n\n_-_-_-_-_-_-_-_-_-_-_-_-_"
						;
			case CommentTypes.REDUCTION_CLAUSE:
				return "Reduction Clause" +
						"\n\nYou can add //omp for paralization:\n"+
						"\n//omp parallel for reduction(<op>: <var>)" +
						"\n\nExample:" +
						"\n\nBefore:" +
						"\nfor(i=0;i<10;i++)" +
						"\n{" +
						"\n	a *= A[i];" +
						"\n}" +
						"\n\nAfter:" +
						"\n//omp parallel for reduction(*: a)" +
						"\nfor(i=0;i<10;i++)" +
						"\n{" +
						"\n	a *= A[i];" +
						"\n}" +
						"\nIn your case the variables are:\n";
			case CommentTypes.SINGLE_EXPRESSION:
				return "Single Expression" +
						"\n\nYou can add //omp for paralization:" +
						"\n\nFor Example:" +
						"\n\nBefore:" +
						"\nfor(int i=0; i<100; i++)" +
						"\n{" +
						"\n	array[i] = i;" +
						"\n}" +
						"\n\nAfter:" +
						"\n//omp parallel for" +
						"\nfor(int i=0; i<100; i++)" +
						"\n{" +
						"\n	array[i] = i;" +
						"\n}" +
						"\nIn your case you should add:" +
						"\n//omp parallel ";
			case CommentTypes.LOOP_DISTRIBUTION:
				return "Loop Distribution" +
						"\n\nThis loop can be distributed into two separate loops" +
						"\nThen You can add //omp" +
						"\n\nExample:" +
						"\n\nBefore:" +
						"\nfor(i=0;i<10;i++){" +
						"\narr[i]=i;" +
						"\nbrr[i]=arr[i];" +
						"\n}" +
						"\n\nAfter:" +
						"\n//omp parallel for" +
						"\nfor(i=0;i<10;i++){" +
						"\narr[i]=i;" +
						"\n}" +
						"\n\n//omp parallel for" +
						"\nfor(i=0;i<10;i++){" +
						"\nbrr[i]=arr[i];" +
						"\n}";
			case CommentTypes.LOOP_PEELING:
				return "Loop Peeling" +
						"\n\nYou can peel this loop, then add //omp" +
						"\n\nExample:" +
						"\n\nBefore:" +
						"\nint p=0;"+
						"\nfor(i=0;i<1000;i++){" +
						"\n	if(i<2)" +
						"\n		p=2*i;" +
						"\n	else p=i;"+
						"\n	arr[i]=p;" +
						"\n}" +
						"\n\nAfter:" +
						"\n" +
						"\narr[0] = 0;"+
						"\narr[1] = 2;"+
						"\n//omp parallel for" +
						"\nfor(i=2;i<1000;i++){" +
						"\n\tarr[i]=i;" +
						"\n\n_-_-_-_-_-_-_-_-_-_-_-_-_"+
						"\n\nfor additional information on how to use OpenMP in Java, see:" +
						"\nhttp://www2.epcc.ed.ac.uk/computing/research_activities/jomp/index_1.html" +
						"\nor read the UserGuide"+
						"\n\n_-_-_-_-_-_-_-_-_-_-_-_-_"
						;
			case CommentTypes.STRUCT_SPLITTING_REORDERING:
				return "CLASS SPLITTING/REORDERING" +
						"\n\nSome fields of this class are used more frequently than others." +
						"\nYou're adviced to do one of the following:" +
						"\n" +
						"1. reorder: move the suggested fields below to the beginning" +
						"\n   of the class" +
						"\n" +
						"2. split: split the class into 2 parts: one with the suggested"+
						"\n   fields, and one with the others\n"+
						"\nsuggested fields:\n";
			case CommentTypes.FUNCTION_SPECIALIZATION:
				return "A specialiced reduced function can be created by \n extracting condition statement "
					+  "to be applied prior to function invocation \n "
					+ "For Example:\n"
					+"public static void main(String[] args) { \n"
					+"  int i=7,j=6; \n  test1(i,6); \n } \n"
					+"public static test1(int x,int y){ \n"
					+"if(x>5)                                //extratable condition statement \n y=0; \n } \n"
					
					+ "can be choosed to the following :\n"
					+"public static void main(String[] args) { \n"
					+"  int i=7,j=6; \n  if(x>5) \n test1_specialize_5(y);} \n"
					
					+ "test1_specialize_5(int y) \n { \n "
					+ "y=0; \n } \n "
					+  "------------------------------------------------------------------------------------------------------------------- \n"
					+  "Line number        | Comment type             |  Calling site                              | Our optimization code\n"+
					"------------------------------------------------------------------------------------------------------------------- \n";
				default:
				return "Error: Couldnt Find Appropriate comment";
		}
	}
}
