/*
 * 
 */
package utils;

import jdtcomments.MarkerCreator;

// TODO: Auto-generated Javadoc
/**
 * * @author Eyal Maderer
 * 
 * <p>The Class ObjectMarkerLocation.<p>
 * 
 *<p> We use this class in cases we suspect that a certain place will be marked with some comment
 * but we are not sure yet if we will mark it so we have to remember 
 * this place and some details about it such as the class name, the comment we want to put and more.<p> 
 */

public class ObjectMarkerLocation 
{
	
	/** The m_i start location. */
	private int m_iStartLocation;
	
	/** The m_i length. */
	private int m_iLength;
	
	/** The m_s object name. */
	private String m_sObjectName;
	
	/** The m_mc marker. */
	private MarkerCreator m_mcMarker;
	
	/** The m_b marked. */
	private boolean m_bMarked = false;
	
	/** The m_s message. */
	private String m_sMessage = null;
	
	/** The m_s class declared name. */
	private String m_sClassDeclaredName = null;
	
	/** the block this object is in*. */
	private Integer m_iBlockCount = null;
	
	
	/**
	 * Instantiates a new object marker location.
	 *
	 * @param name the name
	 * @param startLocation the start location
	 * @param length the length
	 * @param marker the marker
	 */
	public ObjectMarkerLocation(String name, int startLocation, int length, MarkerCreator marker)
	{
		setObjectName(name);
		setLength(length);
		setStartLocation(startLocation);
		setMarker(marker);
	}

	/**
	 * Instantiates a new object marker location.
	 *
	 * @param name the name
	 * @param startPosition the start position
	 * @param length the length
	 * @param marker the marker
	 * @param message the message
	 */
	public ObjectMarkerLocation(String name, int startPosition, int length,MarkerCreator marker, String message)
	{
		this(name, startPosition, length, marker);
		setMessage(message);
	}

	/**
	 * Sets the start location.
	 *
	 * @param startLocation the new start location
	 */
	public void setStartLocation(int startLocation) 
	{
		m_iStartLocation = startLocation;
	}

	/**
	 * Gets the start location.
	 *
	 * @return the start location
	 */
	public int getStartLocation()
	{
		return m_iStartLocation;
	}

	/**
	 * Sets the length.
	 *
	 * @param length the new length
	 */
	public void setLength(int length) 
	{
		m_iLength = length;
	}

	/**
	 * Gets the length.
	 *
	 * @return the length
	 */
	public int getLength()
	{
		return m_iLength;
	}

	/**
	 * Sets the object name.
	 *
	 * @param objectName the new object name
	 */
	public void setObjectName(String objectName)
	{
		m_sObjectName = objectName;
	}

	/**
	 * Gets the object name.
	 *
	 * @return the object name
	 */
	public String getObjectName() 
	{
		return m_sObjectName;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		return getObjectName();
	}
	
	/**
	 * Equals.
	 *
	 * @param other the other
	 * @return true, if successful
	 */
	public boolean equals(ObjectMarkerLocation other)
	{
		return other.getObjectName().equals(getObjectName())&&other.getLength() == getLength() && other.getStartLocation() == getStartLocation();
	}

	/**
	 * Sets the marker.
	 *
	 * @param marker the new marker
	 */
	public void setMarker(MarkerCreator marker)
	{
		m_mcMarker = marker;
	}

	/**
	 * Gets the marker.
	 *
	 * @return the marker
	 */
	public MarkerCreator getMarker()
	{
		return m_mcMarker;
	}

	/**
	 * Sets the marked.
	 *
	 * @param m_bMarked the new marked
	 */
	public void setMarked(boolean m_bMarked)
	{
		this.m_bMarked = m_bMarked;
	}

	/**
	 * Checks if is marked.
	 *
	 * @return true, if is marked
	 */
	public boolean isMarked() 
	{
		return m_bMarked;
	}

	/**
	 * Sets the message.
	 *
	 * @param m_sMessage the new message
	 */
	public void setMessage(String m_sMessage) 
	{
		this.m_sMessage = m_sMessage;
	}

	/**
	 * Gets the message.
	 *
	 * @return the message
	 */
	public String getMessage() 
	{
		return m_sMessage;
	}

	/**
	 * Sets the class declared name.
	 *
	 * @param sClassDeclaredName the new class declared name
	 */
	public void setClassDeclaredName(String sClassDeclaredName) 
	{
		m_sClassDeclaredName = sClassDeclaredName;
	}

	/**
	 * Gets the class declared name.
	 *
	 * @return the class declared name
	 */
	public String getClassDeclaredName()
	{
		return m_sClassDeclaredName;
	}

	/**
	 * Sets the block count.
	 * 
	 * @param m_iBlockCount
	 *            the new block count
	 */
	public void setBlockCount(Integer m_iBlockCount) 
	{
		this.m_iBlockCount = m_iBlockCount;
	}

	/**
	 * Gets the block count.
	 * 
	 * @return the block count
	 */
	public Integer getBlockCount() 
	{
		return m_iBlockCount;
	}
}
