/*
 * 
 */
package utils;

import java.util.ArrayList;
import java.util.Collection;

// TODO: Auto-generated Javadoc
/**
 * The Class ProfileDataHolder.
 * 
 * @author Eyal Maderer
 * 
 *         <p>
 *         The Class ProfileDataHolder.
 *         <p>
 * 
 *         <p>
 *         We use The 'MethodProfileData' class in cases we suspect that a
 *         certain place will be marked with some comment but we are not sure
 *         yet if we will mark it so we have to remember this place and some
 *         details about it such as the class name, the comment we want to put
 *         and more. This class is a single tone class that holds all the
 *         'MethodProfileData' instances in the program, so it is easy to get an
 *         instance of 'MethodProfileData' from every where in the program
 *         <p>
 */

public class ProfileDataHolder
{

	/** The s_instance. */
	private static ProfileDataHolder s_instance = new ProfileDataHolder();

	/** The m_b run only critical code. */
	private boolean m_bRunOnlyCriticalCode = false;

	/** The m_col methods. */
	private Collection<MethodProfileData> m_colMethods = new ArrayList<MethodProfileData>();

	/**
	 * Instantiates a new profile data holder.
	 */
	private ProfileDataHolder()
	{
	}

	/**
	 * Gets the single instance of ProfileDataHolder.
	 *
	 * @return single instance of ProfileDataHolder
	 */
	public static ProfileDataHolder getInstance()
	{
		return s_instance;
	}

	/**
	 * Sets the run only critical code.
	 *
	 * @param bRunOnlyCriticalCode the new run only critical code
	 */
	public void setRunOnlyCriticalCode(boolean bRunOnlyCriticalCode)
	{
		m_bRunOnlyCriticalCode = bRunOnlyCriticalCode;
	}

	/**
	 * Checks if is run only critical code.
	 *
	 * @return true, if is run only critical code
	 */
	public boolean isRunOnlyCriticalCode() 
	{
		return m_bRunOnlyCriticalCode;
	}

	/**
	 * Adds the method.
	 *
	 * @param method the method
	 */
	public void addMethod(MethodProfileData method) 
	{
		getMethods().add(method);
	}

	/**
	 * Gets the methods.
	 *
	 * @return the methods
	 */
	public Collection<MethodProfileData> getMethods()
	{
		return m_colMethods;
	}

	/**
	 * Gets the critical methods.
	 *
	 * @return the critical methods
	 */
	public Collection<MethodProfileData> getCriticalMethods()
	{
		Collection<MethodProfileData> colCriticalMethods = new ArrayList<MethodProfileData>();
		int i = 0;
		for(MethodProfileData data:getMethods())
		{
			if(i<3)
			{
				colCriticalMethods.add(data);
				i++;
			}
		}
		return colCriticalMethods;
	}


}
