/**
 * 
 */
package comments;

import java.util.Arrays;

/**
 * Demonstrate the array initialization comment while printing the time taken to run the program
 *
 */
public class InitArrayWithTime {

	/**
	 * @param args
	 */
	public static void main(String[] args) 
	{
		long startTime, endTime;
		int[] arr = new int[10000000];
		
		// Not optimized
		startTime = System.currentTimeMillis();
		test1(arr);
		endTime = System.currentTimeMillis();
		System.out.println("Original Code Runtime is: " + (endTime-startTime) +" ms");
		
		// optimized code
		startTime = System.currentTimeMillis();

		test2(arr);
		
		endTime = System.currentTimeMillis();
		System.out.println("Optimized Code Runtime is: " + (endTime-startTime) +" ms");

	}

	private static void test2(int[] arr)
	{
		Arrays.fill(arr, 1000);
	}

	private static void test1(int[] arr)
	{
		for(int i = 0; i < arr.length; i++){
			
			arr[i] = 1000;
			
		}
	}

}
