/**
 * 
 */
package comments;

/**
 * This class has example of cases in which we can reduce the lock granularity
 * 
 */
public class ReduceLockGranularity {

	private final long l[];	

	public ReduceLockGranularity(int size) {
		l = new long[size];
	}
	
	
	// Case 1
	public synchronized void set(int idx, long val) {
		l[idx] = val;
	}
	
	// Case 2
	public void set(int idx,int val)
	{
		synchronized (this) {
			l[idx] = val;
		}
	}
	
	// Case 3
	public synchronized void set(long val) {
		for(int i=0;i<l.length;i++){
			l[i] = val;
		}
		
	}
	
	// Case 4
	public synchronized void setTwice(long val) {
		
		l[1] = val;
		for(int i=0;i<l.length;i++){
			l[i] = val;
		}
		
	}
	
	

}
