/**
 * 
 */
package comments;

import utils.MyString;

/**
 * Examples where an exclusive lock is used when a shared read lock could have
 * been used
 * 
 */
public class SharedReadLock {

	private static long l[];

	public static void main(String[] args) 
	{
		SharedReadLock lock = new SharedReadLock(10);
		lock.get(1);
		lock.get2(1);
		lock.get3(1);
		lock.get4(1);
	}

	public SharedReadLock(int size)
	{
		l = new long[size];
	}

	// Case 1
	public synchronized long get(int idx) {
		return l[idx];
	}

	// Case 2
	public synchronized long get2(int idx) {
		int i;
		MyString string;
		int[] k = new int[10];

		i = 7;
		string = new MyString("w");
		k[0] = 5;
		System.out.println(i + string.toString() + k[0]);
		return l[idx];
	}

	int i;
	MyString string;
	int[] k = new int[10];

	// Case 3
	public synchronized long get3(int idx) {

		i = 7;
		string = new MyString("w");
		k[0] = 5;
		System.out.println(i + string.toString() + k[0]);
		return l[idx];
	}

	// Case 4
	public long get4(int idx) {
		synchronized (this) {
			int i;
			MyString string;
			int[] k = new int[10];

			i = 7;
			string = new MyString("w");
			k[0] = 5;
			System.out.println(i + string.toString() + k[0]);
			return l[idx];
		}

	}
}
